/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard.i18n;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.mobility.project.ui.wizard.FileWizardIterator;
import org.netbeans.modules.mobility.project.ui.wizard.i18n.LocalizationSupportPanel;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class LocalizationSupportIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -1789843546389L;
    protected static final String JAVA_EXTENSION = "java";
    protected static LocalizationSupportIterator instance;
    protected transient int panelIndex = 0;
    protected transient WizardDescriptor.Panel[] panels;
    protected transient TemplateWizard wizardInstance;
    public static final String MESSAGE_BUNDLE_FILENAME = "MESSAGE_BUNDLE_FILENAME";
    public static final String MESSAGE_BUNDLE_RESOURCE_NAME_KEYWORD = "__MESSAGE_BUNDLE_RESOURCE_NAME__";
    public static final String DEFAULT_STRING_KEYWORD = "__DEFAULT_STRING__";
    public static final String DEFAULT_ERROR_KEYWORD = "__DEFAULT_ERROR__";

    public static synchronized LocalizationSupportIterator singleton() {
        if (instance == null) {
            instance = new LocalizationSupportIterator();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException, IllegalArgumentException {
        InputStreamReader isr = null;
        OutputStreamWriter osw = null;
        FileLock lock = null;
        this.wizardInstance = wiz;
        String msgFileName = (String)this.wizardInstance.getProperty(MESSAGE_BUNDLE_FILENAME);
        String msgResourceName = (String)this.wizardInstance.getProperty(MESSAGE_BUNDLE_RESOURCE_NAME_KEYWORD);
        String defString = (String)this.wizardInstance.getProperty(DEFAULT_STRING_KEYWORD);
        String defErrorMsg = (String)this.wizardInstance.getProperty(DEFAULT_ERROR_KEYWORD);
        HashSet<DataObject> aSet = new HashSet<DataObject>();
        DataObject javaDO = this.instantiateTemplate(wiz.getTemplate(), wiz.getTargetFolder(), wiz.getTargetName(), true);
        FileObject packageFO = wiz.getTemplate().getPrimaryFile().getParent();
        DataObject resourceTemplateDO = DataObject.find((FileObject)packageFO.getFileObject("LocalizationSupport", "properties"));
        DataObject resourceDO = this.instantiateTemplate(resourceTemplateDO, wiz.getTargetFolder(), msgFileName, false);
        aSet.add(javaDO);
        aSet.add(resourceDO);
        try {
            FileObject javaFO = javaDO.getPrimaryFile();
            isr = new InputStreamReader(javaFO.getInputStream());
            char[] buff = new char[40];
            StringBuffer sbf = new StringBuffer();
            int count = 0;
            while ((count = isr.read(buff)) >= 0) {
                sbf.append(buff, 0, count);
            }
            isr.close();
            isr = null;
            String s = sbf.toString();
            s = s.replaceAll(MESSAGE_BUNDLE_RESOURCE_NAME_KEYWORD, msgResourceName);
            s = s.replaceAll(DEFAULT_STRING_KEYWORD, defString);
            s = s.replaceAll(DEFAULT_ERROR_KEYWORD, defErrorMsg);
            lock = javaFO.lock();
            osw = new OutputStreamWriter(javaFO.getOutputStream(lock));
            osw.write(s);
        }
        finally {
            IOException ioex = null;
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException ioe) {
                ioex = ioe;
            }
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException ioe) {
                ioex = ioe;
            }
            if (lock != null) {
                lock.releaseLock();
            }
            if (ioex != null) {
                throw ioex;
            }
        }
        return aSet;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.panelIndex];
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void initialize(TemplateWizard wizard) {
        this.wizardInstance = wizard;
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new LocalizationSupportPanel()};
        }
        this.panelIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wizardInstance = null;
        this.panels = null;
        this.panelIndex = -1;
    }

    private DataObject instantiateTemplate(DataObject tpl, DataFolder target, String name, boolean isJava) throws IOException {
        if (name == null) {
            name = this.getDefaultName(tpl, target);
        }
        this.checkValidPackageName(target);
        if (isJava) {
            this.checkTargetName(name);
        }
        return tpl.createFromTemplate(target, name);
    }

    private boolean isValidPackageName(String s) {
        if ("".equals(s)) {
            return true;
        }
        return Utilities.isJavaIdentifier((String)s);
    }

    private void checkValidPackageName(DataFolder targetFolder) throws IllegalStateException {
        FileObject folder = targetFolder.getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        String msg = null;
        if (cp != null) {
            String fullTarget = cp.getResourceName(folder, '.', false);
            if (this.isValidPackageName(fullTarget)) {
                return;
            }
            msg = MessageFormat.format(LocalizationSupportIterator.getString("ERR_File_IllegalFolderName"), folder.getPath(), fullTarget);
        } else {
            msg = LocalizationSupportIterator.getString("ERR_File_NotInSourcePath");
        }
        throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(msg), 256, null, msg, null, null);
    }

    private boolean checkTargetName(String desiredName) {
        if (!Utilities.isJavaIdentifier((String)desiredName)) {
            String msg = MessageFormat.format(LocalizationSupportIterator.getString("ERR_File_IllegalTargetName"), desiredName);
            this.notifyError(msg);
            return false;
        }
        return true;
    }

    private void notifyError(String msg) {
        this.wizardInstance.putProperty("WizardPanel_errorMessage", (Object)msg);
        IllegalStateException ex = new IllegalStateException(msg);
        ErrorManager.getDefault().annotate((Throwable)ex, 256, null, msg, null, null);
        throw ex;
    }

    private String getDefaultName(DataObject template, DataFolder targetFolder) {
        String desiredName = FileUtil.findFreeFileName((FileObject)targetFolder.getPrimaryFile(), (String)template.getName(), (String)JAVA_EXTENSION);
        return desiredName;
    }

    static String getString(String key) {
        return NbBundle.getMessage(FileWizardIterator.class, (String)key);
    }

    static char getMnemonic(String key) {
        return LocalizationSupportIterator.getString(key).charAt(0);
    }

    private void updateStepsList() {
        JComponent component = (JComponent)this.current().getComponent();
        component.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(LocalizationSupportIterator.class, (String)"TITLE_File")});
        component.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.panelIndex));
    }
}

