/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.deployment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mobility.project.deployment.DeploymentPropertiesHandler;
import org.netbeans.modules.mobility.project.deployment.MobilityDeploymentProperties;
import org.netbeans.modules.mobility.project.deployment.NewInstanceDialog;
import org.netbeans.spi.mobility.deployment.DeploymentPlugin;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MobilityDeploymentManagerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private final ExplorerManager manager = new ExplorerManager();
    private final BeanTreeView btw = new BeanTreeView();
    private final MobilityDeploymentProperties props = new MobilityDeploymentProperties(new RequestProcessor("Mobility Deployment Dialog"));
    private final VisualPropertySupport vps = VisualPropertySupport.getDefault(this.props);
    private final String initialTypeName;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public static synchronized String manageDeployment(final String deploymentTypeDisplayName, final String instance) {
        final String[] instanceName = new String[1];
        Thread r1 = new Thread(){

            @Override
            public void run() {
                Lookup.Result deployments = Lookup.getDefault().lookup(new Lookup.Template(DeploymentPlugin.class));
                DeploymentPropertiesHandler.loadDeploymentProperties(deployments.allInstances());
                Thread r2 = new Thread(){

                    @Override
                    public void run() {
                        JButton closeButton = new JButton();
                        Mnemonics.setLocalizedText((AbstractButton)closeButton, (String)NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"LBL_closeButton"));
                        closeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"ACCESSIBLE_NAME_closeButton"));
                        closeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"ACCESSIBLE_DESCRIPTION_closeButton"));
                        MobilityDeploymentManagerPanel mdmp = new MobilityDeploymentManagerPanel(deploymentTypeDisplayName, instance);
                        DialogDescriptor desc = new DialogDescriptor((Object)mdmp, NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"Title_DeploymentManager"), true, new Object[]{closeButton}, DialogDescriptor.CLOSED_OPTION, 0, new HelpCtx(MobilityDeploymentManagerPanel.class), null);
                        desc.setClosingOptions(new Object[]{closeButton});
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        instanceName[0] = mdmp.getSelectedInstanceName();
                    }
                };
                SwingUtilities.invokeLater(r2);
                try {
                    r2.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        RequestProcessor.getDefault().post((Runnable)r1);
        try {
            r1.join();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return instanceName[0];
    }

    private MobilityDeploymentManagerPanel(String deploymentTypeDisplayName, String instanceName) {
        Node selInstance;
        this.initialTypeName = deploymentTypeDisplayName;
        this.initComponents();
        this.btw.setRootVisible(false);
        this.btw.setPopupAllowed(false);
        this.btw.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"MobilityDeploymentManager.jLabel1.text"));
        this.btw.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"MobilityDeploymentManager.jLabel1.text"));
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.jPanel1.add((Component)this.btw, "Center");
        Children.Array ch = new Children.Array(){

            protected Collection<Node> initCollection() {
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (DeploymentPlugin d : Lookup.getDefault().lookupAll(DeploymentPlugin.class)) {
                    if (d.getGlobalPropertyDefaultValues().size() <= 0) continue;
                    nodes.add((Node)new DeploymentTypeNode(d));
                }
                return nodes;
            }
        };
        this.manager.setRootContext((Node)new AbstractNode((Children)ch));
        Node selType = deploymentTypeDisplayName != null ? ch.findChild(deploymentTypeDisplayName) : null;
        Node node = selInstance = selType != null && instanceName != null ? selType.getChildren().findChild(instanceName) : null;
        if (selType != null || selInstance != null) {
            try {
                this.manager.setExploredContextAndSelection(selType, new Node[]{selInstance == null ? selType : selInstance});
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Point p = this.btw.getViewport().getViewPosition();
        if (p.x != 0) {
            p.setLocation(0, p.y);
            this.btw.getViewport().setViewPosition(p);
        }
    }

    public String getSelectedInstanceName() {
        if (this.initialTypeName == null) {
            return null;
        }
        Node[] n = this.manager.getSelectedNodes();
        return n.length != 1 || !this.initialTypeName.equals(n[0].getParentNode().getDisplayName()) ? null : n[0].getName();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor((Component)this.btw);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"MobilityDeploymentManager.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"ACCESSIBLE_NAME_jLabel1"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"ACCESSIBLE_DESCRIPTION_jLabel1"));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setMaximumSize(new Dimension(270, 350));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(350, 350));
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"MobilityDeploymentManager.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobilityDeploymentManagerPanel.this.createInstance(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 11, 0);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"ACCESSIBLE_NAME_jButton1"));
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"ACCESSIBLE_DESCRIPTION_jButton1"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"MobilityDeploymentManager.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobilityDeploymentManagerPanel.this.removeInstance(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 5, 11, 11);
        this.add((Component)this.jButton2, gridBagConstraints);
        this.jButton2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"ACCESSIBLE_NAME_jButton2"));
        this.jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"ACCESSIBLE_DESCRIPTION_jButton2"));
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 12, 1, 1));
        this.jPanel2.setPreferredSize(new Dimension(500, 350));
        this.jPanel2.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 0, 11);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"ACCESSIBLE_NAME_jPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"ACCESSIBLE_DESCRIPTION_jPanel"));
    }

    private void removeInstance(ActionEvent evt) {
        Node[] n = this.manager.getSelectedNodes();
        if (n.length == 1 && n[0].hasCustomizer()) {
            ((InstanceNode)n[0].getCookie(InstanceNode.class)).remove();
        }
    }

    private void createInstance(ActionEvent evt) {
        Node[] n = this.manager.getSelectedNodes();
        if (n.length == 1) {
            if (n[0].hasCustomizer()) {
                n[0] = n[0].getParentNode();
            }
            this.createNewInstance(((DeploymentTypeNode)n[0].getCookie(DeploymentTypeNode.class)).getPlugin());
        } else {
            this.createNewInstance(null);
        }
    }

    private void createNewInstance(DeploymentPlugin d) {
        DeploymentPlugin dp;
        NewInstanceDialog nid = new NewInstanceDialog(this.props, d);
        DialogDescriptor dd = new DialogDescriptor((Object)nid, NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"TitleNewInstance"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(NewInstanceDialog.class), null);
        nid.setDialogDescriptor(dd);
        nid.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"TitleNewInstance"));
        nid.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MobilityDeploymentManagerPanel.class, (String)"TitleNewInstance"));
        if (DialogDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)) && (dp = nid.getDeploymentPlugin()) != null) {
            String name = nid.getInstanceName();
            this.props.createInstance(dp.getDeploymentMethodName(), name);
            Node n = this.manager.getRootContext().getChildren().findChild(dp.getDeploymentMethodDisplayName());
            if (n != null) {
                try {
                    DeploymentTypeNode dtn = (DeploymentTypeNode)n.getCookie(DeploymentTypeNode.class);
                    dtn.refresh();
                    Node selInstance = n.getChildren().findChild(name);
                    this.manager.setExploredContextAndSelection(n, new Node[]{selInstance == null ? n : selInstance});
                }
                catch (PropertyVetoException pve) {
                    // empty catch block
                }
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Node[] n = this.manager.getSelectedNodes();
        this.jPanel2.removeAll();
        if (n.length == 1) {
            boolean instance = n[0].hasCustomizer();
            if (instance) {
                this.jPanel2.add(n[0].getCustomizer(), "Center");
            }
            this.jButton2.setEnabled(instance);
        } else {
            this.jButton2.setEnabled(false);
        }
        this.jPanel2.validate();
        this.jPanel2.repaint();
    }

    private Children.Array createChildren(DeploymentPlugin d) {
        final ArrayList<InstanceNode> ch = new ArrayList<InstanceNode>();
        for (String name : this.props.getInstanceList(d.getDeploymentMethodName())) {
            ch.add(new InstanceNode(d, name));
        }
        return new Children.Array(){

            protected Collection<Node> initCollection() {
                return ch;
            }
        };
    }

    private void registerSubcomponents(Component c, String prefix, Set propertyNames) {
        String prop = c.getName();
        if (prop != null && propertyNames.contains(prop)) {
            prop = prefix + prop;
            if (c instanceof JCheckBox) {
                this.vps.register((JCheckBox)c, prop);
            } else if (c instanceof JRadioButton) {
                this.vps.register((JRadioButton)c, prop);
            } else if (c instanceof JComboBox) {
                this.vps.register((JComboBox)c, null, prop);
            } else if (c instanceof JSlider) {
                this.vps.register((JSlider)c, prop);
            } else if (c instanceof JSpinner) {
                this.vps.register((JSpinner)c, prop);
            } else if (c instanceof JTextComponent) {
                this.vps.register((JTextComponent)c, prop);
            } else assert (false) : "Unknown component type for registration";
        }
        if (c instanceof Container) {
            for (Component sub : ((Container)c).getComponents()) {
                this.registerSubcomponents(sub, prefix, propertyNames);
            }
        }
    }

    private class InstanceNode
    extends AbstractNode
    implements Node.Cookie {
        private final DeploymentPlugin d;

        public InstanceNode(DeploymentPlugin d, String name) {
            super(Children.LEAF);
            this.getCookieSet().add((Node.Cookie)this);
            this.d = d;
            this.setName(name);
        }

        public DeploymentPlugin getPlugin() {
            return this.d;
        }

        public boolean hasCustomizer() {
            return true;
        }

        public Component getCustomizer() {
            Component c = this.d.createGlobalCustomizerPanel();
            MobilityDeploymentManagerPanel.this.registerSubcomponents(c, "deployments." + this.d.getDeploymentMethodName() + '.' + this.getName() + '.', this.d.getGlobalPropertyDefaultValues().keySet());
            return c;
        }

        public void remove() {
            MobilityDeploymentManagerPanel.this.props.removeInstance(this.d.getDeploymentMethodName(), this.getName());
            ((DeploymentTypeNode)this.getParentNode()).refresh();
        }
    }

    private class DeploymentTypeNode
    extends AbstractNode
    implements Node.Cookie {
        private final DeploymentPlugin d;

        public DeploymentTypeNode(DeploymentPlugin d) {
            super((Children)MobilityDeploymentManagerPanel.this.createChildren(d));
            this.d = d;
            this.getCookieSet().add((Node.Cookie)this);
            this.setName(d.getDeploymentMethodDisplayName());
            this.setIconBaseWithExtension("org/netbeans/modules/mobility/project/ui/resources/deploy.gif");
        }

        public void refresh() {
            this.setChildren((Children)MobilityDeploymentManagerPanel.this.createChildren(this.d));
        }

        public DeploymentPlugin getPlugin() {
            return this.d;
        }
    }
}

