/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.io.StringReader;
import java.util.ArrayList;
import org.netbeans.modules.db.sql.visualeditor.parser.ParseException;
import org.netbeans.modules.db.sql.visualeditor.parser.SQLParser;
import org.netbeans.modules.db.sql.visualeditor.querymodel.And;
import org.netbeans.modules.db.sql.visualeditor.querymodel.AndNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.GroupBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.GroupByNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTable;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTableNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Literal;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Or;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderByNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Predicate;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Query;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;
import org.netbeans.modules.db.sql.visualeditor.querymodel.TableNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Value;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Where;
import org.netbeans.modules.db.sql.visualeditor.querymodel.WhereNode;

public class SQLQueryFactory {
    public static Query parse(String query) throws ParseException {
        SQLParser parser = new SQLParser(new StringReader(query));
        return parser.SQLQuery();
    }

    public static Where createWhere(Expression expr) {
        return new WhereNode(expr);
    }

    public static Predicate createPredicate(Value val1, Value val2, String op) {
        return new Predicate(val1, val2, op);
    }

    public static Predicate createPredicate(Value val1, Object literal, String op) {
        Literal val2 = new Literal(literal);
        return new Predicate(val1, val2, op);
    }

    public static Predicate createPredicate(String[] rel) {
        return new Predicate(rel);
    }

    public static GroupBy createGroupBy(ArrayList columnList) {
        return new GroupByNode(columnList);
    }

    public static OrderBy createOrderBy() {
        return new OrderByNode();
    }

    public static Column createColumn(String tableSpec, String columnName) {
        return new ColumnNode(tableSpec, columnName);
    }

    public static Literal createLiteral(Object value) {
        return new Literal(value);
    }

    public static Table createTable(String tableName, String corrName, String schemaName) {
        return new TableNode(tableName, corrName, schemaName);
    }

    public static JoinTable createJoinTable(Table table) {
        return new JoinTableNode((TableNode)table);
    }

    public static And createAnd(Expression expr1, Expression expr2) {
        ArrayList<Expression> items = new ArrayList<Expression>();
        items.add(expr1);
        items.add(expr2);
        return new AndNode(items);
    }

    public static Or createOr(Expression expr1, Expression expr2) {
        ArrayList<Expression> items = new ArrayList<Expression>();
        items.add(expr1);
        items.add(expr2);
        return new OrNode(items);
    }
}

