/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.io.File;
import java.io.IOException;
import org.openide.util.NbBundle;

class DomainListEntry {
    private String hostPort;
    private File domainDir;
    private File location;

    public DomainListEntry(String hostPort, File domainDir, File location) {
        this.hostPort = hostPort;
        this.domainDir = domainDir;
        this.location = location;
    }

    public String toString() {
        String abbrevDomainDir = this.stripCommonPrefix(this.location, this.domainDir);
        return NbBundle.getMessage(DomainListEntry.class, (String)"LBL_domainListEntry", (Object[])new Object[]{this.hostPort, abbrevDomainDir});
    }

    File getDomainDir() {
        return this.domainDir;
    }

    private String stripCommonPrefix(File pattern, File value) {
        int i;
        String cpath2;
        String cpath1;
        try {
            cpath1 = pattern.getCanonicalPath();
            cpath2 = value.getCanonicalPath();
        }
        catch (IOException ioe) {
            return value.toString();
        }
        int len1 = cpath1.length();
        int len2 = cpath2.length();
        for (i = 0; i < len1 && i < len2 && cpath1.charAt(i) == cpath2.charAt(i); ++i) {
        }
        String prefix = "";
        if (i > 0) {
            prefix = "...";
        }
        return prefix + cpath2.substring(i);
    }
}

