/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.sun.api.Asenv;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.ide.j2ee.PlatformValidator;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainWizardIterator;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddInstanceVisualPlatformPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Profile;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class AddDomainPlatformPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private AddInstanceVisualPlatformPanel component;
    private WizardDescriptor wiz;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private PlatformValidator platformValidator;
    private String serverVersion = "";

    AddDomainPlatformPanel() {
    }

    public Component getComponent() {
        return this.getAIVPP();
    }

    private AddInstanceVisualPlatformPanel getAIVPP() {
        if (this.component == null) {
            File file = ServerLocationManager.getLatestPlatformLocation();
            File file2 = null;
            if (null == file || !file.exists()) {
                File file3;
                String string = System.getProperty("com.sun.aas.installRoot");
                if (null != string && string.length() > 0 && ServerLocationManager.isGoodAppServerLocation((File)(file3 = new File(string)))) {
                    file2 = file3;
                }
                if (null == file2) {
                    file2 = new File(this.guessDefaultInstall());
                }
            } else {
                file2 = file;
            }
            this.component = new AddInstanceVisualPlatformPanel(file2);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    private String guessDefaultInstall() {
        if (this.serverVersion.equals("SJS")) {
            if (Utilities.isWindows()) {
                return "C:\\Sun\\AppServer";
            }
            return System.getProperty("user.home") + File.separator + "SUNWappserver";
        }
        if (this.serverVersion.equals("SIP_V1")) {
            return System.getProperty("user.home") + File.separator + "sailfin";
        }
        return System.getProperty("user.home") + File.separator + "glassfish";
    }

    public HelpCtx getHelp() {
        return new HelpCtx("AS_RegServ_EnterPlatformDir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid() {
        Object object;
        double d;
        if (null == this.wiz) {
            return false;
        }
        this.wiz.putProperty("WizardPanel_errorMessage", null);
        this.wiz.putProperty("WizardPanel_infoMessage", null);
        String string = this.getAIVPP().getInstallLocation();
        if (string.startsWith("\\\\")) {
            this.setErrorMsg("Msg_NoAuthorityComponent");
            return false;
        }
        if (string.trim().length() < 1) {
            this.setInfoMsg("Msg_EnterSomeInstallPath");
            return false;
        }
        File file = new File(this.getAIVPP().getInstallLocation());
        if (!this.platformValidator.isGoodAppServerLocation(file) || !file.isAbsolute()) {
            Object object2 = this.getAIVPP().getSelectedType();
            if (object2 == AddDomainWizardIterator.REMOTE) {
                this.setErrorMsg("Msg_NeedValidInstallEvenForRemote");
                return false;
            } else {
                String string2 = NbBundle.getMessage(AddDomainPlatformPanel.class, (String)"Msg_InValidInstall");
                if (!this.serverVersion.equals("")) {
                    String string3 = this.platformValidator.getServerTypeName(this.serverVersion);
                    string2 = NbBundle.getMessage(AddDomainPlatformPanel.class, (String)"Msg_InValidInstallForServerType", (Object)string3);
                    if (file.isDirectory() && new File(file, "setup.xml").exists()) {
                        string2 = NbBundle.getMessage(AddDomainPlatformPanel.class, (String)"Msg_RunSetupBeforeRegistration");
                    }
                }
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)string2);
            }
            return false;
        }
        if (ServerLocationManager.isGlassFish((File)file) && (d = Double.parseDouble((String)(object = System.getProperty("java.class.version")))) < 49.0) {
            this.setErrorMsg("Msg_RequireJ2SE5");
            return false;
        }
        this.wiz.putProperty("platform_location", (Object)file);
        this.wiz.putProperty("username", (Object)"");
        this.wiz.putProperty("password", (Object)"");
        object = this.getAIVPP().getSelectedType();
        if (object == AddDomainWizardIterator.DEFAULT) {
            File[] fileArray = Util.getRegisterableDefaultDomains(file);
            if (fileArray.length == 0) {
                this.setErrorMsg("Msg_NoDefaultDomainsAvailable");
                return false;
            }
            this.wiz.putProperty("type", object);
            File file2 = this.getAIVPP().getDomainDir();
            if (null != file2) {
                String string4 = Util.rootOfUsableDomain(file2);
                if (null != string4) {
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)string4);
                    return false;
                }
                Util.fillDescriptorFromDomainXml(this.wiz, file2);
                String string5 = "admin";
                String string6 = null;
                File file3 = new File(System.getProperty("user.home") + "/.asadminprefs");
                if (file3.exists()) {
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(file3);
                        Properties properties = new Properties();
                        properties.load(fileInputStream);
                        Enumeration<?> enumeration = properties.propertyNames();
                        while (enumeration.hasMoreElements()) {
                            String string7 = (String)enumeration.nextElement();
                            if ("AS_ADMIN_USER".equals(string7)) {
                                string5 = properties.getProperty(string7);
                                continue;
                            }
                            if (!"AS_ADMIN_PASSWORD".equals(string7)) continue;
                            string6 = properties.getProperty(string7);
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    finally {
                        if (null != fileInputStream) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            }
                        }
                    }
                }
                this.wiz.putProperty("password", string6);
                this.wiz.putProperty("username", (Object)string5);
                return true;
            }
            this.setErrorMsg("Msg_NoDefaultDomainsAvailable");
            return false;
        }
        if (object == AddDomainWizardIterator.REMOTE) {
            this.wiz.putProperty("type", object);
            this.wiz.putProperty("install_location", (Object)"");
            this.wiz.putProperty("domain", (Object)"");
            return true;
        } else if (object == AddDomainWizardIterator.LOCAL) {
            this.wiz.putProperty("type", object);
            this.wiz.putProperty("install_location", (Object)"");
            this.wiz.putProperty("domain", (Object)"");
            return true;
        } else if (object == AddDomainWizardIterator.PERSONAL) {
            Asenv asenv;
            this.wiz.putProperty("type", object);
            this.wiz.putProperty("install_location", (Object)"");
            this.wiz.putProperty("domain", (Object)"");
            Profile profile = this.getAIVPP().getProfile();
            this.wiz.putProperty("profile", (Object)profile);
            if (profile == Profile.ENTERPRISE) {
                asenv = new Asenv(file);
                String string8 = asenv.get("AS_NSS_BIN");
                String string9 = asenv.get("AS_HADB");
                File file4 = new File(string8);
                File file5 = new File(string9);
                if (!(file4.exists() && file4.isDirectory() && file5.exists() && file5.isDirectory())) {
                    this.setErrorMsg("Msg_UnsupportedProfile");
                    return false;
                }
            }
            if (((Asenv)(asenv = Util.getRegisterableDefaultDomains(file))).length != 0) return true;
            this.setInfoMsg("Msg_NoDefaultDomainsAvailable");
            return true;
        } else {
            this.setErrorMsg("Msg_UnsupportedType");
            return false;
        }
    }

    private void setErrorMsg(String string) {
        this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainPlatformPanel.class, (String)string));
    }

    private void setInfoMsg(String string) {
        this.wiz.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddDomainPlatformPanel.class, (String)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    public void readSettings(Object object) {
        this.wiz = (WizardDescriptor)object;
        if (!this.serverVersion.equals("")) {
            this.platformValidator = new PlatformValidator(){

                @Override
                public boolean isGoodAppServerLocation(File file) {
                    return super.isDescriminatorPresent(file, AddDomainPlatformPanel.this.serverVersion);
                }
            };
        }
    }

    public void storeSettings(Object object) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (null != this.wiz) {
            this.wiz.putProperty("type", this.getAIVPP().getSelectedType());
            this.fireChangeEvent();
        }
    }

    public boolean isFinishPanel() {
        Object object = this.getAIVPP().getSelectedType();
        return object == AddDomainWizardIterator.DEFAULT;
    }

    public void setPlatformValidator(PlatformValidator platformValidator) {
        this.platformValidator = platformValidator;
    }

    public void setPlatformValidator(PlatformValidator platformValidator, String string) {
        this.platformValidator = platformValidator;
        this.serverVersion = string;
    }
}

