/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDescriptor {
    public static final TypeDescriptor NULL = new TypeDescriptor();
    private static final Map<Class<?>, TypeDescriptor> typeDescriptorCache = new HashMap();
    private Object value;
    private Class<?> type;
    private MethodParameter methodParameter;
    private Field field;
    private Annotation[] cachedFieldAnnotations;

    static {
        typeDescriptorCache.put(Boolean.TYPE, new TypeDescriptor(Boolean.TYPE));
        typeDescriptorCache.put(Boolean.class, new TypeDescriptor(Boolean.class));
        typeDescriptorCache.put(Byte.TYPE, new TypeDescriptor(Byte.TYPE));
        typeDescriptorCache.put(Byte.class, new TypeDescriptor(Byte.class));
        typeDescriptorCache.put(Character.TYPE, new TypeDescriptor(Character.TYPE));
        typeDescriptorCache.put(Character.class, new TypeDescriptor(Character.class));
        typeDescriptorCache.put(Double.TYPE, new TypeDescriptor(Double.TYPE));
        typeDescriptorCache.put(Double.class, new TypeDescriptor(Double.class));
        typeDescriptorCache.put(Float.TYPE, new TypeDescriptor(Float.TYPE));
        typeDescriptorCache.put(Float.class, new TypeDescriptor(Float.class));
        typeDescriptorCache.put(Integer.TYPE, new TypeDescriptor(Integer.TYPE));
        typeDescriptorCache.put(Integer.class, new TypeDescriptor(Integer.class));
        typeDescriptorCache.put(Long.TYPE, new TypeDescriptor(Long.TYPE));
        typeDescriptorCache.put(Long.class, new TypeDescriptor(Long.class));
        typeDescriptorCache.put(Short.TYPE, new TypeDescriptor(Short.TYPE));
        typeDescriptorCache.put(Short.class, new TypeDescriptor(Short.class));
        typeDescriptorCache.put(String.class, new TypeDescriptor(String.class));
    }

    public TypeDescriptor(MethodParameter methodParameter) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        this.methodParameter = methodParameter;
    }

    public TypeDescriptor(Field field) {
        Assert.notNull(field, "Field must not be null");
        this.field = field;
    }

    public TypeDescriptor(MethodParameter methodParameter, Class<?> type) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        this.methodParameter = methodParameter;
        this.type = type;
    }

    public TypeDescriptor(Field field, Class<?> type) {
        Assert.notNull(field, "Field must not be null");
        this.field = field;
        this.type = type;
    }

    private TypeDescriptor() {
    }

    private TypeDescriptor(Object value) {
        Assert.notNull(value, "Value must not be null");
        this.value = value;
        this.type = value.getClass();
    }

    private TypeDescriptor(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        this.type = type;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.field != null) {
            return this.field.getType();
        }
        if (this.methodParameter != null) {
            return this.methodParameter.getParameterType();
        }
        return null;
    }

    public Class<?> getObjectType() {
        Class<?> type = this.getType();
        return type != null ? ClassUtils.resolvePrimitiveIfNecessary(type) : type;
    }

    public String getName() {
        Class<?> type = this.getType();
        return type != null ? ClassUtils.getQualifiedName(type) : null;
    }

    public boolean isPrimitive() {
        Class<?> type = this.getType();
        return type != null && type.isPrimitive();
    }

    public boolean isArray() {
        Class<?> type = this.getType();
        return type != null && type.isArray();
    }

    public boolean isCollection() {
        return this.isTypeAssignableTo(Collection.class);
    }

    public Class<?> getElementType() {
        if (this.isArray()) {
            return this.getArrayComponentType();
        }
        if (this.isCollection()) {
            return this.getCollectionElementType();
        }
        return null;
    }

    public TypeDescriptor getElementTypeDescriptor() {
        return TypeDescriptor.valueOf(this.getElementType());
    }

    public TypeDescriptor forElementType(Class<?> elementType) {
        Assert.notNull(elementType, "Element type must not be null");
        if (this.getType().equals(elementType)) {
            return this;
        }
        if (this.methodParameter != null) {
            return new TypeDescriptor(this.methodParameter, elementType);
        }
        return new TypeDescriptor(this.field, elementType);
    }

    public boolean isMap() {
        return this.isTypeAssignableTo(Map.class);
    }

    public boolean isMapEntryTypeKnown() {
        return this.isMap() && this.getMapKeyType() != null && this.getMapValueType() != null;
    }

    public Class<?> getMapKeyType() {
        Object key;
        Map map;
        if (this.field != null) {
            return GenericCollectionTypeResolver.getMapKeyFieldType(this.field);
        }
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getMapKeyParameterType(this.methodParameter);
        }
        if (this.value instanceof Map && !(map = (Map)this.value).isEmpty() && (key = map.keySet().iterator().next()) != null) {
            return key.getClass();
        }
        if (this.type != null) {
            return GenericCollectionTypeResolver.getMapKeyType(this.type);
        }
        return null;
    }

    public Class<?> getMapValueType() {
        Object val;
        Map map;
        if (this.field != null) {
            return GenericCollectionTypeResolver.getMapValueFieldType(this.field);
        }
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getMapValueParameterType(this.methodParameter);
        }
        if (this.value instanceof Map && !(map = (Map)this.value).isEmpty() && (val = map.values().iterator().next()) != null) {
            return val.getClass();
        }
        if (this.type != null) {
            return GenericCollectionTypeResolver.getMapValueType(this.type);
        }
        return null;
    }

    public TypeDescriptor getMapKeyTypeDescriptor() {
        return TypeDescriptor.valueOf(this.getMapKeyType());
    }

    public TypeDescriptor getMapValueTypeDescriptor() {
        return TypeDescriptor.valueOf(this.getMapValueType());
    }

    public Annotation[] getAnnotations() {
        if (this.field != null) {
            if (this.cachedFieldAnnotations == null) {
                this.cachedFieldAnnotations = this.field.getAnnotations();
            }
            return this.cachedFieldAnnotations;
        }
        if (this.methodParameter != null) {
            if (this.methodParameter.getParameterIndex() < 0) {
                return this.methodParameter.getMethodAnnotations();
            }
            return this.methodParameter.getParameterAnnotations();
        }
        return new Annotation[0];
    }

    public Annotation getAnnotation(Class<? extends Annotation> annotationType) {
        Annotation[] annotationArray = this.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(annotationType)) {
                return annotation;
            }
            ++n2;
        }
        return null;
    }

    public boolean isAssignableTo(TypeDescriptor targetType) {
        Class<?> targetClass = targetType.getType();
        if (!this.isTypeAssignableTo(targetClass)) {
            return false;
        }
        if (targetClass != null) {
            if (Collection.class.isAssignableFrom(targetClass)) {
                Class<?> sourceElementType;
                Class<?> elementType = targetType.getCollectionElementType();
                if (!(elementType == null || (sourceElementType = this.getCollectionElementType()) != null && elementType.isAssignableFrom(sourceElementType))) {
                    return false;
                }
            } else if (Map.class.isAssignableFrom(targetClass)) {
                Class<?> sourceValueType;
                Class<?> sourceKeyType;
                Class<?> keyType = targetType.getMapKeyType();
                if (!(keyType == null || (sourceKeyType = this.getMapKeyType()) != null && keyType.isAssignableFrom(sourceKeyType))) {
                    return false;
                }
                Class<?> valueType = targetType.getMapValueType();
                if (!(valueType == null || (sourceValueType = this.getMapValueType()) != null && valueType.isAssignableFrom(sourceValueType))) {
                    return false;
                }
            }
        }
        return true;
    }

    public String asString() {
        StringBuffer stringValue = new StringBuffer();
        if (this.isArray()) {
            stringValue.append(this.getArrayComponentType().getName()).append("[]");
        } else {
            Class<?> clazz = this.getType();
            if (clazz == null) {
                return "null";
            }
            stringValue.append(clazz.getName());
            if (this.isCollection()) {
                Class<?> collectionType = this.getCollectionElementType();
                if (collectionType != null) {
                    stringValue.append("<").append(collectionType.getName()).append(">");
                }
            } else if (this.isMap()) {
                Class<?> keyType = this.getMapKeyType();
                Class<?> valType = this.getMapValueType();
                if (keyType != null && valType != null) {
                    stringValue.append("<").append(keyType.getName()).append(",");
                    stringValue.append(valType).append(">");
                }
            }
        }
        return stringValue.toString();
    }

    public String toString() {
        Annotation[] anns;
        if (this == NULL) {
            return "[TypeDescriptor.NULL]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[TypeDescriptor ");
        Annotation[] annotationArray = anns = this.getAnnotations();
        int n = anns.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            builder.append("@").append(ann.annotationType().getName()).append(' ');
            ++n2;
        }
        builder.append(ClassUtils.getQualifiedName(this.getType()));
        builder.append("]");
        return builder.toString();
    }

    private Class<?> getArrayComponentType() {
        return this.getType().getComponentType();
    }

    private Class<?> getCollectionElementType() {
        Object elem;
        Collection coll;
        if (this.field != null) {
            return GenericCollectionTypeResolver.getCollectionFieldType(this.field);
        }
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getCollectionParameterType(this.methodParameter);
        }
        if (this.value instanceof Collection && !(coll = (Collection)this.value).isEmpty() && (elem = coll.iterator().next()) != null) {
            return elem.getClass();
        }
        if (this.type != null) {
            return GenericCollectionTypeResolver.getCollectionType(this.type);
        }
        return null;
    }

    private boolean isTypeAssignableTo(Class<?> clazz) {
        Class<?> type = this.getType();
        return type != null && (clazz == null || ClassUtils.isAssignable(clazz, type));
    }

    public static TypeDescriptor valueOf(Class<?> type) {
        if (type == null) {
            return NULL;
        }
        TypeDescriptor desc = typeDescriptorCache.get(type);
        return desc != null ? desc : new TypeDescriptor(type);
    }

    public static TypeDescriptor forObject(Object object) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof Collection || object instanceof Map) {
            return new TypeDescriptor(object);
        }
        return TypeDescriptor.valueOf(object.getClass());
    }
}

