/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.maven.codegen.NewProfilePanel;
import org.netbeans.modules.maven.model.pom.Activation;
import org.netbeans.modules.maven.model.pom.ActivationFile;
import org.netbeans.modules.maven.model.pom.ActivationOS;
import org.netbeans.modules.maven.model.pom.ActivationProperty;
import org.netbeans.modules.maven.model.pom.BuildBase;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyManagement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginManagement;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Node;

public class ProfileGenerator
implements CodeGenerator {
    private POMModel model;
    private JTextComponent component;

    private ProfileGenerator(POMModel model, JTextComponent component) {
        this.model = model;
        this.component = component;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ProfileGenerator.class, (String)"NAME_Profile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        try {
            this.model.sync();
        }
        catch (IOException ex) {
            Logger.getLogger(ProfileGenerator.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", ex);
        }
        if (!this.model.getState().equals((Object)Model.State.VALID)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProfileGenerator.class, (String)"MSG_Cannot_Parse"));
            return;
        }
        NewProfilePanel panel = new NewProfilePanel(this.model);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ProfileGenerator.class, (String)"TIT_Add_profile"));
        panel.attachDialogDisplayer(dd);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == DialogDescriptor.OK_OPTION) {
            String id = panel.getProfileId();
            Profile prof = this.model.getProject().findProfileById(id);
            boolean pomPackaging = "pom".equals(this.model.getProject().getPackaging());
            if (prof == null) {
                try {
                    this.model.startTransaction();
                    prof = this.model.getFactory().createProfile();
                    prof.setId(id);
                    if (panel.generateDependencies()) {
                        Dependency dep = this.model.getFactory().createDependency();
                        dep.setGroupId("foo");
                        dep.setArtifactId("bar");
                        dep.setVersion("1.0");
                        if (pomPackaging) {
                            DependencyManagement dm = this.model.getFactory().createDependencyManagement();
                            prof.setDependencyManagement(dm);
                            dm.addDependency(dep);
                        } else {
                            prof.addDependency(dep);
                        }
                    }
                    if (panel.generatePlugins()) {
                        BuildBase base = this.model.getFactory().createBuildBase();
                        prof.setBuildBase(base);
                        Plugin plug = this.model.getFactory().createPlugin();
                        plug.setGroupId("foo");
                        plug.setArtifactId("bar");
                        plug.setVersion("1.0");
                        if (pomPackaging) {
                            PluginManagement pm = this.model.getFactory().createPluginManagement();
                            base.setPluginManagement(pm);
                            pm.addPlugin(plug);
                        } else {
                            base.addPlugin(plug);
                        }
                    }
                    if (panel.isActivation()) {
                        Activation act = this.model.getFactory().createActivation();
                        prof.setActivation(act);
                        if (panel.isActiovationByProperty()) {
                            ActivationProperty prop = this.model.getFactory().createActivationProperty();
                            act.setActivationProperty(prop);
                            prop.setName("foo");
                            prop.setValue("bar");
                        }
                        if (panel.isActiovationByFile()) {
                            ActivationFile file = this.model.getFactory().createActivationFile();
                            act.setActivationFile(file);
                            file.setExists("${basedir}/foo.bar");
                        }
                        if (panel.isActiovationByOS()) {
                            ActivationOS os = this.model.getFactory().createActivationOS();
                            if (Utilities.isMac()) {
                                os.setFamily("MacOS");
                            } else if (Utilities.isUnix()) {
                                os.setFamily("Linux");
                            } else {
                                os.setFamily("Windows");
                            }
                            act.setActivationOS(os);
                        }
                    }
                    this.model.getProject().addProfile(prof);
                }
                finally {
                    this.model.endTransaction();
                }
                int pos = prof.getModel().getAccess().findPosition((Node)prof.getPeer());
                this.component.setCaretPosition(pos);
            }
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<ProfileGenerator> toRet = new ArrayList<ProfileGenerator>();
            POMModel model = (POMModel)context.lookup(POMModel.class);
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            if (model != null) {
                toRet.add(new ProfileGenerator(model, component));
            }
            return toRet;
        }
    }
}

