/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.spi.datafilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;

public class CollectedObjectsFilter
implements DataFilter {
    private final List<String> selectedObjectsList;
    private final List<String> hiddenObjectsList;
    private final Pattern selectedPattern = Pattern.compile(".*\\+\\[([^\\[\\]]*)\\].*");
    private final Pattern hiddenPattern = Pattern.compile(".*-\\[([^\\[\\]]*)\\].*");

    protected CollectedObjectsFilter(String filterSpec) {
        this.selectedObjectsList = this.extractList(this.selectedPattern, filterSpec);
        this.hiddenObjectsList = this.extractList(this.hiddenPattern, filterSpec);
    }

    public Collection<String> hiddenObjects() {
        return new ArrayList<String>(this.hiddenObjectsList);
    }

    public Collection<String> selectedObjects() {
        return new ArrayList<String>(this.selectedObjectsList);
    }

    private List<String> extractList(Pattern pattern, String filterSpec) {
        Matcher m = pattern.matcher(filterSpec);
        if (m.matches()) {
            String list = m.group(1);
            return Arrays.asList(list.split(","));
        }
        return Collections.emptyList();
    }
}

