/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.lineinfo.impl;

import java.io.File;
import org.netbeans.modules.dlight.management.remote.spi.PathMapper;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.FunctionStatistic;
import org.netbeans.modules.dlight.perfan.storage.impl.PerfanDataStorage;
import org.netbeans.modules.dlight.perfan.util.Computable;
import org.netbeans.modules.dlight.perfan.util.TasksCachedProcessor;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;

public final class SSSourceFileInfoSupport {
    private final PerfanDataStorage storage;
    private final TasksCachedProcessor<SourceFileInfoFetchTaskParams, SourceFileInfoProvider.SourceFileInfo> sourceLineInfoCachedProvider = new TasksCachedProcessor<SourceFileInfoFetchTaskParams, SourceFileInfoProvider.SourceFileInfo>(new SourceFileInfoFetchTask(), false);

    private SSSourceFileInfoSupport(PerfanDataStorage storage) {
        this.storage = storage;
    }

    public static SSSourceFileInfoSupport getSourceFileInfoSupportFor(PerfanDataStorage storage) {
        return new SSSourceFileInfoSupport(storage);
    }

    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(FunctionCallImpl functionCall, PathMapper pathMapper) {
        SourceFileInfoProvider.SourceFileInfo result = null;
        try {
            SourceFileInfoFetchTaskParams params = new SourceFileInfoFetchTaskParams(functionCall, this.storage, pathMapper);
            result = this.sourceLineInfoCachedProvider.compute(params);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        return result;
    }

    public static final class SourceFileInfoFetchTask
    implements Computable<SourceFileInfoFetchTaskParams, SourceFileInfoProvider.SourceFileInfo> {
        @Override
        public SourceFileInfoProvider.SourceFileInfo compute(SourceFileInfoFetchTaskParams params) throws InterruptedException {
            SourceFileInfoProvider.SourceFileInfo result = null;
            String sourceFile = null;
            int line = -1;
            sourceFile = params.functionCall.getSourceFile();
            line = (int)params.functionCall.getOffset();
            if (!"(unknown)".equals(sourceFile)) {
                FunctionStatistic fStatistics;
                if (!(sourceFile != null && line >= 0 && sourceFile.startsWith("/") || (fStatistics = params.storage.getFunctionStatistic(params.functionCall)) == null)) {
                    String localFile;
                    sourceFile = fStatistics.getSourceFile();
                    int n = line = line < 0 ? fStatistics.getSrcFileLine() : line;
                    if (sourceFile != null && params.pathMapper != null && !"(unknown)".equals(sourceFile) && (localFile = params.pathMapper.getLocalPath(sourceFile)) != null) {
                        File localFileFile = new File(localFile);
                        sourceFile = localFileFile.exists() ? localFileFile.getAbsolutePath() : null;
                    }
                }
                result = new SourceFileInfoProvider.SourceFileInfo((CharSequence)sourceFile, line, 0);
                params.functionCall.setSourceFileInfo(result);
            }
            return result;
        }
    }

    public static final class SourceFileInfoFetchTaskParams {
        public final FunctionCallImpl functionCall;
        public final PerfanDataStorage storage;
        public final PathMapper pathMapper;

        SourceFileInfoFetchTaskParams(FunctionCallImpl functionCall, PerfanDataStorage storage, PathMapper pathMapper) {
            this.functionCall = functionCall;
            this.storage = storage;
            this.pathMapper = pathMapper;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SourceFileInfoFetchTaskParams)) {
                return false;
            }
            SourceFileInfoFetchTaskParams that = (SourceFileInfoFetchTaskParams)obj;
            if (this.functionCall.getFunctionRefID() != that.functionCall.getFunctionRefID() || !this.storage.equals(that.storage)) {
                return false;
            }
            if (this.pathMapper == null) {
                if (that.pathMapper != null) {
                    return false;
                }
            } else {
                if (that.pathMapper == null) {
                    return false;
                }
                if (!this.pathMapper.equals(that.pathMapper)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int hash = 3;
            hash = (int)((long)(17 * hash) + this.functionCall.getFunctionRefID());
            hash = 17 * hash + (this.storage != null ? this.storage.hashCode() : 0);
            hash = 17 * hash + (this.pathMapper != null ? this.pathMapper.hashCode() : 0);
            return hash;
        }
    }
}

