/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.phpmodule;

import java.io.File;
import java.util.regex.Pattern;
import org.netbeans.modules.php.api.phpmodule.PhpOptions;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class PhpInterpreter
extends PhpProgram {
    public static final Pattern[] LINE_PATTERNS = new Pattern[]{Pattern.compile(".+\\s+in\\s+(.+)\\s+on\\s+line\\s+(\\d+)"), Pattern.compile(".+\\(\\)\\s+(.+):(\\d+)")};

    PhpInterpreter(String command) {
        super(command);
    }

    public static PhpInterpreter getDefault() throws PhpProgram.InvalidPhpProgramException {
        String command = ((PhpOptions)Lookup.getDefault().lookup(PhpOptions.class)).getPhpInterpreter();
        String error = PhpInterpreter.validate(command);
        if (error != null) {
            throw new PhpProgram.InvalidPhpProgramException(error);
        }
        return new PhpInterpreter(command);
    }

    public static PhpInterpreter getCustom(String command) throws PhpProgram.InvalidPhpProgramException {
        String error = PhpInterpreter.validate(command);
        if (error != null) {
            throw new PhpProgram.InvalidPhpProgramException(error);
        }
        return new PhpInterpreter(command);
    }

    @Override
    public String validate() {
        if (!StringUtils.hasText(this.getProgram())) {
            return NbBundle.getMessage(PhpInterpreter.class, (String)"MSG_NoPhpInterpreter");
        }
        File file = new File(this.getProgram());
        if (!file.isAbsolute()) {
            return NbBundle.getMessage(PhpInterpreter.class, (String)"MSG_PhpInterpreterNotAbsolutePath");
        }
        if (!file.isFile()) {
            return NbBundle.getMessage(PhpInterpreter.class, (String)"MSG_PhpInterpreterNotFile");
        }
        if (!file.canRead()) {
            return NbBundle.getMessage(PhpInterpreter.class, (String)"MSG_PhpInterpreterCannotRead");
        }
        return null;
    }

    public static String validate(String command) {
        return new PhpInterpreter(command).validate();
    }
}

