/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.layout;

import java.util.Date;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Widget;

public class ConnectionWrapperLayout
implements Layout {
    private ConnectionWidget connectionWidget;
    private Layout connectionWidgetLayout;
    private LabelWidget label;
    private static final Logger LOGGER = Logger.getLogger(ConnectionWrapperLayout.class.toString());

    public ConnectionWrapperLayout(ConnectionWidget connectionWidget, LabelWidget label) {
        this.connectionWidget = connectionWidget;
        this.connectionWidgetLayout = connectionWidget.getLayout();
        this.label = label;
    }

    public void layout(Widget widget) {
        this.connectionWidgetLayout.layout(widget);
        ConnectionWrapperLayout.resetLabelConstraint(this.connectionWidget, this.label);
    }

    public boolean requiresJustification(Widget widget) {
        return this.connectionWidgetLayout.requiresJustification(widget);
    }

    public void justify(Widget widget) {
        this.connectionWidgetLayout.justify(widget);
    }

    private static final void resetLabelConstraint(ConnectionWidget connectionWidget, LabelWidget label) {
        assert (connectionWidget != null);
        if (label != null) {
            connectionWidget.removeConstraint((Widget)label);
            connectionWidget.removeChild((Widget)label);
            Anchor sourceAnchor = connectionWidget.getSourceAnchor();
            Anchor.Entry sourceAnchorEntry = connectionWidget.getSourceAnchorEntry();
            assert (sourceAnchor != null);
            assert (sourceAnchorEntry != null);
            if (sourceAnchor != null && sourceAnchorEntry != null) {
                EnumSet directions = sourceAnchor.compute(sourceAnchorEntry).getDirections();
                if (directions.contains(Anchor.Direction.TOP)) {
                    label.setOrientation(LabelWidget.Orientation.ROTATE_90);
                    connectionWidget.setConstraint((Widget)label, LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT, 10);
                } else if (directions.contains(Anchor.Direction.BOTTOM)) {
                    label.setOrientation(LabelWidget.Orientation.ROTATE_90);
                    connectionWidget.setConstraint((Widget)label, LayoutFactory.ConnectionWidgetLayoutAlignment.BOTTOM_RIGHT, 10);
                } else if (directions.contains(Anchor.Direction.RIGHT)) {
                    connectionWidget.setConstraint((Widget)label, LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_RIGHT, 10);
                    label.setOrientation(LabelWidget.Orientation.NORMAL);
                } else {
                    connectionWidget.setConstraint((Widget)label, LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_LEFT, 10);
                    label.setOrientation(LabelWidget.Orientation.NORMAL);
                }
            } else {
                LogRecord record = new LogRecord(Level.FINE, "Problems Reseting Label Constraint");
                record.setSourceClassName("ConnectionWrapperLayout");
                record.setSourceMethodName("resetLabelConstraint");
                record.setParameters(new Object[]{connectionWidget, label, new Date()});
                LOGGER.log(record);
                connectionWidget.setConstraint((Widget)label, LayoutFactory.ConnectionWidgetLayoutAlignment.TOP_LEFT, 10);
                label.setOrientation(LabelWidget.Orientation.NORMAL);
            }
            connectionWidget.addChild((Widget)label);
        }
    }
}

