/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.spi.project.support.rake;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.api.project.rake.RakeArtifact;
import org.netbeans.modules.ruby.modules.project.rake.RakeBasedProjectFactorySingleton;
import org.netbeans.modules.ruby.modules.project.rake.UserQuestionHandler;
import org.netbeans.modules.ruby.spi.project.support.rake.AuxiliaryPropertiesImpl;
import org.netbeans.modules.ruby.spi.project.support.rake.ExtensibleMetadataProviderImpl;
import org.netbeans.modules.ruby.spi.project.support.rake.ProjectProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.ProjectXmlSavedHook;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyUtils;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeBasedProjectType;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectEvent;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectListener;
import org.netbeans.modules.ruby.spi.project.support.rake.SharabilityQueryImpl;
import org.netbeans.modules.ruby.spi.project.support.rake.SimpleRakeArtifact;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class RakeProjectHelper {
    public static final String PROJECT_PROPERTIES_PATH = "nbproject/project.properties";
    public static final String PRIVATE_PROPERTIES_PATH = "nbproject/private/private.properties";
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PRIVATE_XML_PATH = "nbproject/private/private.xml";
    static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    static final String PRIVATE_NS = "http://www.netbeans.org/ns/project-private/1";
    private static final RequestProcessor RP;
    private final FileObject dir;
    private final ProjectState state;
    private final RakeBasedProjectType type;
    private Document projectXml;
    private Document privateXml;
    private final Set<String> modifiedMetadataPaths = new HashSet<String>();
    private final List<RakeProjectListener> listeners = new ArrayList<RakeProjectListener>();
    private final ProjectProperties properties;
    private final FileChangeListener fileListener;
    private boolean writingXML = false;
    private ProjectXmlSavedHook pendingHook;
    private int pendingHookCount;
    static boolean QUIETLY_SWALLOW_XML_LOAD_ERRORS;
    private static final DocumentBuilder db;

    private RakeProjectHelper(FileObject dir, Document projectXml, ProjectState state, RakeBasedProjectType type) {
        this.dir = dir;
        assert (dir != null && FileUtil.toFile((FileObject)dir) != null);
        this.state = state;
        assert (state != null);
        this.type = type;
        assert (type != null);
        this.projectXml = projectXml;
        assert (projectXml != null);
        this.properties = new ProjectProperties(this);
        this.fileListener = new FileListener();
        FileUtil.addFileChangeListener((FileChangeListener)this.fileListener, (File)this.resolveFile(PROJECT_XML_PATH));
        FileUtil.addFileChangeListener((FileChangeListener)this.fileListener, (File)this.resolveFile(PRIVATE_XML_PATH));
    }

    RakeBasedProjectType getType() {
        return this.type;
    }

    private Document getConfigurationXml(boolean shared) {
        Document xml;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        Document document = xml = shared ? this.projectXml : this.privateXml;
        if (xml == null) {
            String path = shared ? PROJECT_XML_PATH : PRIVATE_XML_PATH;
            xml = this.loadXml(path);
            if (xml == null) {
                String element = shared ? "project" : "project-private";
                String ns = shared ? PROJECT_NS : PRIVATE_NS;
                xml = XMLUtil.createDocument((String)element, (String)ns, null, null);
                if (shared) {
                    Element typeEl = xml.createElementNS(PROJECT_NS, "type");
                    typeEl.appendChild(xml.createTextNode(this.getType().getType()));
                    xml.getDocumentElement().appendChild(typeEl);
                    xml.getDocumentElement().appendChild(xml.createElementNS(PROJECT_NS, "configuration"));
                }
            }
            if (shared) {
                this.projectXml = xml;
            } else {
                this.privateXml = xml;
            }
        }
        assert (xml != null);
        return xml;
    }

    private Document loadXml(String path) {
        block8: {
            assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
            assert (Thread.holdsLock(this.modifiedMetadataPaths));
            FileObject xml = this.dir.getFileObject(path);
            if (xml == null || !xml.isData()) {
                return null;
            }
            File f = FileUtil.toFile((FileObject)xml);
            assert (f != null);
            try {
                return XMLUtil.parse((InputSource)new InputSource(f.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
            }
            catch (IOException e) {
                if (!QUIETLY_SWALLOW_XML_LOAD_ERRORS) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            catch (SAXException e) {
                if (QUIETLY_SWALLOW_XML_LOAD_ERRORS) break block8;
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock saveXml(final Document doc, final String path) throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        assert (!this.writingXML);
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        final FileLock[] _lock = new FileLock[1];
        this.writingXML = true;
        try {
            this.dir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XMLUtil.write((Document)doc, (OutputStream)baos, (String)"UTF-8");
                    final byte[] data = baos.toByteArray();
                    final FileObject xml = FileUtil.createData((FileObject)RakeProjectHelper.this.dir, (String)path);
                    try {
                        _lock[0] = xml.lock();
                        OutputStream os = xml.getOutputStream(_lock[0]);
                        try {
                            os.write(data);
                        }
                        finally {
                            os.close();
                        }
                    }
                    catch (UserQuestionException uqe) {
                        RakeProjectHelper.this.needPendingHook();
                        UserQuestionHandler.handle(uqe, new UserQuestionHandler.Callback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void accepted() {
                                assert (!RakeProjectHelper.this.writingXML);
                                RakeProjectHelper.this.writingXML = true;
                                try {
                                    FileLock lock = xml.lock();
                                    try {
                                        OutputStream os = xml.getOutputStream(lock);
                                        try {
                                            os.write(data);
                                        }
                                        finally {
                                            os.close();
                                        }
                                    }
                                    finally {
                                        lock.releaseLock();
                                    }
                                    RakeProjectHelper.this.maybeCallPendingHook();
                                }
                                catch (IOException e) {
                                    ErrorManager.getDefault().notify((Throwable)e);
                                    this.reload();
                                }
                                finally {
                                    RakeProjectHelper.this.writingXML = false;
                                }
                            }

                            @Override
                            public void denied() {
                                this.reload();
                            }

                            @Override
                            public void error(IOException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                                this.reload();
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            private void reload() {
                                if (path.equals(RakeProjectHelper.PROJECT_XML_PATH)) {
                                    Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                                    synchronized (set) {
                                        RakeProjectHelper.this.projectXml = null;
                                    }
                                }
                                assert (path.equals(RakeProjectHelper.PRIVATE_XML_PATH)) : path;
                                Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                                synchronized (set) {
                                    RakeProjectHelper.this.privateXml = null;
                                }
                                RakeProjectHelper.this.fireExternalChange(path);
                                RakeProjectHelper.this.cancelPendingHook();
                            }
                        });
                    }
                }
            });
        }
        finally {
            this.writingXML = false;
        }
        return _lock[0];
    }

    private Element getConfigurationDataRoot(boolean shared) {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        Document doc = this.getConfigurationXml(shared);
        if (shared) {
            Element project = doc.getDocumentElement();
            Element config = XMLUtil.findElement((Element)project, (String)"configuration", (String)PROJECT_NS);
            assert (config != null);
            return config;
        }
        return doc.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRakeProjectListener(RakeProjectListener listener) {
        List<RakeProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRakeProjectListener(RakeProjectListener listener) {
        List<RakeProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    void fireExternalChange(final String path) {
        Mutex.Action<Void> action = new Mutex.Action<Void>(){

            public Void run() {
                RakeProjectHelper.this.fireChange(path, false);
                return null;
            }
        };
        if (ProjectManager.mutex().isWriteAccess()) {
            ProjectManager.mutex().readAccess((Mutex.Action)action);
        } else if (ProjectManager.mutex().isReadAccess()) {
            action.run();
        } else {
            RP.post(new Runnable((Mutex.Action)action){
                final /* synthetic */ Mutex.Action val$action;
                {
                    this.val$action = action;
                }

                @Override
                public void run() {
                    ProjectManager.mutex().readAccess(this.val$action);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(String path, boolean expected) {
        RakeProjectListener[] _listeners;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        List<RakeProjectListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return;
            }
            _listeners = this.listeners.toArray(new RakeProjectListener[this.listeners.size()]);
        }
        final RakeProjectEvent ev = new RakeProjectEvent(this, path, expected);
        final boolean xml = path.equals(PROJECT_XML_PATH) || path.equals(PRIVATE_XML_PATH);
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                for (int i = 0; i < _listeners.length; ++i) {
                    try {
                        if (xml) {
                            _listeners[i].configurationXmlChanged(ev);
                            continue;
                        }
                        _listeners[i].propertiesChanged(ev);
                        continue;
                    }
                    catch (RuntimeException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifying(String path) {
        assert (ProjectManager.mutex().isWriteAccess());
        this.state.markModified();
        Set<String> set = this.modifiedMetadataPaths;
        synchronized (set) {
            this.modifiedMetadataPaths.add(path);
        }
        this.fireChange(path, true);
    }

    public FileObject getProjectDirectory() {
        return this.dir;
    }

    public void notifyDeleted() {
        this.state.notifyDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markModified() {
        assert (ProjectManager.mutex().isWriteAccess());
        this.state.markModified();
        Set<String> set = this.modifiedMetadataPaths;
        synchronized (set) {
            this.modifiedMetadataPaths.add(PROJECT_XML_PATH);
        }
    }

    boolean isProjectXmlModified() {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        return this.modifiedMetadataPaths.contains(PROJECT_XML_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        HashSet<FileLock> locks = new HashSet<FileLock>();
        try {
            Set<String> set = this.modifiedMetadataPaths;
            synchronized (set) {
                assert (!this.modifiedMetadataPaths.isEmpty());
                assert (this.pendingHook == null);
                if (this.modifiedMetadataPaths.contains(PROJECT_XML_PATH)) {
                    Project p = RakeBasedProjectFactorySingleton.getProjectFor(this);
                    this.pendingHook = (ProjectXmlSavedHook)p.getLookup().lookup(ProjectXmlSavedHook.class);
                }
                Iterator<String> it = this.modifiedMetadataPaths.iterator();
                while (it.hasNext()) {
                    String path = it.next();
                    if (path.equals(PROJECT_XML_PATH)) {
                        assert (this.projectXml != null);
                        locks.add(this.saveXml(this.projectXml, path));
                    } else if (path.equals(PRIVATE_XML_PATH)) {
                        assert (this.privateXml != null);
                        locks.add(this.saveXml(this.privateXml, path));
                    } else {
                        locks.add(this.properties.write(path));
                    }
                    it.remove();
                }
                if (this.pendingHook != null && this.pendingHookCount == 0) {
                    try {
                        this.pendingHook.projectXmlSaved();
                    }
                    catch (IOException e) {
                        this.modifiedMetadataPaths.add(PROJECT_XML_PATH);
                        throw e;
                    }
                }
            }
        }
        finally {
            locks.remove(null);
            for (FileLock lock : locks) {
                lock.releaseLock();
            }
            if (this.pendingHookCount == 0) {
                this.pendingHook = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeCallPendingHook() {
        assert (this.pendingHookCount > 0);
        --this.pendingHookCount;
        if (this.pendingHookCount == 0 && this.pendingHook != null) {
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws IOException {
                        RakeProjectHelper.this.pendingHook.projectXmlSaved();
                        return null;
                    }
                });
            }
            catch (MutexException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            finally {
                this.pendingHook = null;
            }
        }
    }

    void cancelPendingHook() {
        assert (this.pendingHookCount > 0);
        --this.pendingHookCount;
        if (this.pendingHookCount == 0) {
            this.pendingHook = null;
        }
    }

    void needPendingHook() {
        ++this.pendingHookCount;
    }

    public EditableProperties getProperties(final String path) {
        if (path.equals(PROJECT_XML_PATH) || path.equals(PRIVATE_XML_PATH)) {
            throw new IllegalArgumentException("Attempt to load properties from a project XML file");
        }
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            public EditableProperties run() {
                return RakeProjectHelper.this.properties.getProperties(path);
            }
        });
    }

    public void putProperties(final String path, final EditableProperties props) {
        if (path.equals(PROJECT_XML_PATH) || path.equals(PRIVATE_XML_PATH)) {
            throw new IllegalArgumentException("Attempt to store properties from a project XML file");
        }
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                if (RakeProjectHelper.this.properties.putProperties(path, props)) {
                    RakeProjectHelper.this.modifying(path);
                }
                return null;
            }
        });
    }

    public PropertyProvider getPropertyProvider(final String path) {
        if (path.equals(PROJECT_XML_PATH) || path.equals(PRIVATE_XML_PATH)) {
            throw new IllegalArgumentException("Attempt to store properties from a project XML file");
        }
        return (PropertyProvider)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<PropertyProvider>(){

            public PropertyProvider run() {
                return RakeProjectHelper.this.properties.getPropertyProvider(path);
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean shared) {
        final String name = this.type.getPrimaryConfigurationDataElementName(shared);
        assert (name.indexOf(58) == -1);
        final String namespace = this.type.getPrimaryConfigurationDataElementNamespace(shared);
        assert (namespace != null && namespace.length() > 0);
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Element run() {
                Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element el = RakeProjectHelper.this.getConfigurationFragment(name, namespace, shared);
                    if (el != null) {
                        return el;
                    }
                    return RakeProjectHelper.cloneSafely(RakeProjectHelper.this.getConfigurationXml(shared).createElementNS(namespace, name));
                }
            }
        });
    }

    public void putPrimaryConfigurationData(Element data, boolean shared) throws IllegalArgumentException {
        String name = this.type.getPrimaryConfigurationDataElementName(shared);
        assert (name.indexOf(58) == -1);
        String namespace = this.type.getPrimaryConfigurationDataElementNamespace(shared);
        assert (namespace != null && namespace.length() > 0);
        if (!name.equals(data.getLocalName()) || !namespace.equals(data.getNamespaceURI())) {
            throw new IllegalArgumentException("Wrong name/namespace: expected {" + namespace + "}" + name + " but was {" + data.getNamespaceURI() + "}" + data.getLocalName());
        }
        this.putConfigurationFragment(data, shared);
    }

    Element getConfigurationFragment(final String elementName, final String namespace, final boolean shared) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Element run() {
                Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element root = RakeProjectHelper.this.getConfigurationDataRoot(shared);
                    Element data = XMLUtil.findElement((Element)root, (String)elementName, (String)namespace);
                    if (data != null) {
                        return RakeProjectHelper.cloneSafely(data);
                    }
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element cloneSafely(Element el) {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            Document dummy = db.newDocument();
            return (Element)dummy.importNode(el, true);
        }
    }

    void putConfigurationFragment(final Element fragment, final boolean shared) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element root = RakeProjectHelper.this.getConfigurationDataRoot(shared);
                    Element existing = XMLUtil.findElement((Element)root, (String)fragment.getLocalName(), (String)fragment.getNamespaceURI());
                    if (existing != null) {
                        root.removeChild(existing);
                    }
                    Node ref = null;
                    NodeList list = root.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        Node node = list.item(i);
                        if (node.getNodeType() != 1) continue;
                        int comparison = node.getNodeName().compareTo(fragment.getNodeName());
                        if (comparison == 0) {
                            comparison = node.getNamespaceURI().compareTo(fragment.getNamespaceURI());
                        }
                        if (comparison <= 0) continue;
                        ref = node;
                        break;
                    }
                    root.insertBefore(root.getOwnerDocument().importNode(fragment, true), ref);
                    RakeProjectHelper.this.modifying(shared ? RakeProjectHelper.PROJECT_XML_PATH : RakeProjectHelper.PRIVATE_XML_PATH);
                }
                return null;
            }
        });
    }

    boolean removeConfigurationFragment(final String elementName, final String namespace, final boolean shared) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element root = RakeProjectHelper.this.getConfigurationDataRoot(shared);
                    Element data = XMLUtil.findElement((Element)root, (String)elementName, (String)namespace);
                    if (data != null) {
                        root.removeChild(data);
                        RakeProjectHelper.this.modifying(shared ? RakeProjectHelper.PROJECT_XML_PATH : RakeProjectHelper.PRIVATE_XML_PATH);
                        return true;
                    }
                    return false;
                }
            }
        });
    }

    public AuxiliaryConfiguration createAuxiliaryConfiguration() {
        return new ExtensibleMetadataProviderImpl(this);
    }

    public AuxiliaryProperties createAuxiliaryProperties() {
        return new AuxiliaryPropertiesImpl(this);
    }

    public CacheDirectoryProvider createCacheDirectoryProvider() {
        return new ExtensibleMetadataProviderImpl(this);
    }

    public RakeArtifact createSimpleRakeArtifact(String type, String locationProperty, PropertyEvaluator eval, String targetName, String cleanTargetName) {
        return new SimpleRakeArtifact(this, type, locationProperty, eval, targetName, cleanTargetName);
    }

    public SharabilityQueryImplementation createSharabilityQuery(PropertyEvaluator eval, String[] sourceRoots, String[] buildDirectories) {
        String[] includes = new String[sourceRoots.length + 1];
        System.arraycopy(sourceRoots, 0, includes, 0, sourceRoots.length);
        includes[sourceRoots.length] = "";
        String[] excludes = new String[buildDirectories.length + 1];
        System.arraycopy(buildDirectories, 0, excludes, 0, buildDirectories.length);
        excludes[buildDirectories.length] = "nbproject/private";
        return new SharabilityQueryImpl(this, eval, includes, excludes);
    }

    public PropertyProvider getStockPropertyPreprovider() {
        return this.properties.getStockPropertyPreprovider();
    }

    public PropertyEvaluator getStandardPropertyEvaluator() {
        return this.properties.getStandardPropertyEvaluator();
    }

    public File resolveFile(String filename) {
        if (filename == null) {
            throw new NullPointerException("Attempted to pass a null filename to resolveFile");
        }
        return PropertyUtils.resolveFile(FileUtil.toFile((FileObject)this.dir), filename);
    }

    public FileObject resolveFileObject(String filename) {
        if (filename == null) {
            throw new NullPointerException("Must pass a non-null filename");
        }
        return PropertyUtils.resolveFileObject(this.dir, filename);
    }

    public String resolvePath(String path) {
        if (path == null) {
            throw new NullPointerException("Must pass a non-null path");
        }
        return PropertyUtils.resolvePath(FileUtil.toFile((FileObject)this.dir), path);
    }

    public String toString() {
        return "RakeProjectHelper[" + this.getProjectDirectory() + "]";
    }

    static {
        RakeBasedProjectFactorySingleton.HELPER_CALLBACK = new RakeBasedProjectFactorySingleton.RakeProjectHelperCallback(){

            @Override
            public RakeProjectHelper createHelper(FileObject dir, Document projectXml, ProjectState state, RakeBasedProjectType type) {
                return new RakeProjectHelper(dir, projectXml, state, type);
            }

            @Override
            public void save(RakeProjectHelper helper) throws IOException {
                helper.save();
            }
        };
        RP = new RequestProcessor("RakeProjectHelper.RP");
        QUIETLY_SWALLOW_XML_LOAD_ERRORS = false;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private final class FileListener
    implements FileChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void change(FileEvent fe) {
            String path;
            if (RakeProjectHelper.this.writingXML) {
                return;
            }
            File f = FileUtil.toFile((FileObject)fe.getFile());
            Set set = RakeProjectHelper.this.modifiedMetadataPaths;
            synchronized (set) {
                if (f.equals(RakeProjectHelper.this.resolveFile(RakeProjectHelper.PROJECT_XML_PATH))) {
                    if (RakeProjectHelper.this.modifiedMetadataPaths.contains(RakeProjectHelper.PROJECT_XML_PATH)) {
                        return;
                    }
                    path = RakeProjectHelper.PROJECT_XML_PATH;
                    RakeProjectHelper.this.projectXml = null;
                } else if (f.equals(RakeProjectHelper.this.resolveFile(RakeProjectHelper.PRIVATE_XML_PATH))) {
                    if (RakeProjectHelper.this.modifiedMetadataPaths.contains(RakeProjectHelper.PRIVATE_XML_PATH)) {
                        return;
                    }
                    path = RakeProjectHelper.PRIVATE_XML_PATH;
                    RakeProjectHelper.this.privateXml = null;
                } else {
                    throw new AssertionError((Object)("Unexpected file change in " + f));
                }
            }
            RakeProjectHelper.this.fireExternalChange(path);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.change(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.change(fe);
        }

        public void fileChanged(FileEvent fe) {
            this.change(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.change(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.change((FileEvent)fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

