/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.xml.catalog.CatalogPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.cookies.ViewCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class CatalogAction
extends CallableSystemAction {
    private Reference<Dialog> dialogWRef = new WeakReference<Object>(null);

    public CatalogAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        Dialog dialog = this.dialogWRef.get();
        if (dialog == null || !dialog.isShowing()) {
            CatalogPanel cp = new CatalogPanel();
            JButton closeButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)closeButton, (String)NbBundle.getMessage(CatalogAction.class, (String)"BTN_CatalogPanel_CloseButton"));
            JButton openInEditor = new JButton();
            openInEditor.setEnabled(false);
            OpenInEditorListener l = new OpenInEditorListener(cp, openInEditor);
            openInEditor.addActionListener(l);
            cp.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)l);
            Mnemonics.setLocalizedText((AbstractButton)openInEditor, (String)NbBundle.getMessage(CatalogAction.class, (String)"BTN_CatalogPanel_OpenInEditorButton"));
            DialogDescriptor dd = new DialogDescriptor((Object)cp, NbBundle.getMessage(CatalogAction.class, (String)"LBL_CatalogPanel_Title"), false, new Object[]{openInEditor, closeButton}, (Object)closeButton, 0, null, null);
            dd.setClosingOptions(null);
            dd.setHelpCtx(null);
            dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            this.dialogWRef = new WeakReference<Dialog>(dialog);
        } else {
            dialog.toFront();
        }
    }

    protected boolean asynchronous() {
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(CatalogAction.class, (String)"LBL_CatalogAction_Name");
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(CatalogAction.class, (String)"HINT_CatalogAction"));
    }

    private static Set<Node> getNodes2Open(Node[] nodes) {
        HashSet<Node> nodes2open = new HashSet<Node>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].isLeaf()) {
                nodes2open.add(nodes[i]);
                continue;
            }
            nodes2open.addAll(CatalogAction.getNodes2Open(nodes[i].getChildren().getNodes(true)));
        }
        return nodes2open;
    }

    private static class OpenInEditorListener
    implements ActionListener,
    PropertyChangeListener {
        CatalogPanel cp;
        JButton b;

        public OpenInEditorListener(CatalogPanel panel, JButton button) {
            this.cp = panel;
            this.b = button;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Node[] nodes = this.cp.getExplorerManager().getSelectedNodes();
            assert (nodes != null && nodes.length > 0) : "Selected templates cannot be null or empty.";
            Set nodes2open = CatalogAction.getNodes2Open(nodes);
            assert (!nodes2open.isEmpty()) : "Selected templates to open cannot by empty for nodes " + Arrays.asList(nodes);
            for (Node n : nodes2open) {
                ViewCookie vc = (ViewCookie)n.getLookup().lookup(ViewCookie.class);
                if (vc != null) {
                    vc.view();
                    continue;
                }
                assert (false) : "Node " + n + " has to have a VewCookie.";
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] nodes = (Node[])evt.getNewValue();
                boolean res = nodes != null;
                for (int i = 0; res && i < nodes.length; ++i) {
                    Node n = nodes[i];
                    ViewCookie vc = (ViewCookie)n.getLookup().lookup(ViewCookie.class);
                    res = vc != null;
                }
                this.b.setEnabled(res);
            }
        }
    }
}

