/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.general.Bitmask;
import org.netbeans.modules.vmd.midp.components.items.ItemLayouts;
import org.netbeans.modules.vmd.midp.propertyeditors.Bundle;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorLayout
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private CustomEditorConstraints customEditor;
    private JRadioButton radioButton;
    private TypeID parentTypeID;
    private ItemLayouts layouts;
    private int bitMask;
    private HashMap<Integer, Bitmask.BitmaskItem> bits;

    private PropertyEditorLayout(TypeID parentTypeID) {
        super(NbBundle.getMessage(PropertyEditorLayout.class, (String)"LBL_LAYOUT_STR_UCLABEL"));
        this.parentTypeID = parentTypeID;
        this.initMap();
    }

    public static final PropertyEditorLayout createInstance() {
        return new PropertyEditorLayout(null);
    }

    public static final PropertyEditorLayout createInstance(TypeID parentTypeID) {
        return new PropertyEditorLayout(parentTypeID);
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.parentTypeID = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorLayout.class, (String)"LBL_LAYOUT_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorLayout.class, (String)"ACSN_LAYOUT_STR"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorLayout.class, (String)"ACSD_LAYOUT_STR"));
        this.customEditor = new CustomEditorConstraints();
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    private void combineMaskWithGuiName(Integer value, Bitmask.BitmaskItem bitmaskItem) {
        this.bits.put(value, bitmaskItem);
    }

    void initMap() {
        this.bits = new HashMap();
        this.layouts = new ItemLayouts(0);
        this.combineMaskWithGuiName(0, this.layouts.getBitmaskItem(0));
        this.combineMaskWithGuiName(16384, this.layouts.getBitmaskItem(16384));
        this.combineMaskWithGuiName(1, this.layouts.getBitmaskItem(1));
        this.combineMaskWithGuiName(2, this.layouts.getBitmaskItem(2));
        this.combineMaskWithGuiName(3, this.layouts.getBitmaskItem(3));
        this.combineMaskWithGuiName(16, this.layouts.getBitmaskItem(16));
        this.combineMaskWithGuiName(32, this.layouts.getBitmaskItem(32));
        this.combineMaskWithGuiName(48, this.layouts.getBitmaskItem(48));
        this.combineMaskWithGuiName(256, this.layouts.getBitmaskItem(256));
        this.combineMaskWithGuiName(512, this.layouts.getBitmaskItem(512));
        this.combineMaskWithGuiName(1024, this.layouts.getBitmaskItem(1024));
        this.combineMaskWithGuiName(2048, this.layouts.getBitmaskItem(2048));
        this.combineMaskWithGuiName(4096, this.layouts.getBitmaskItem(4096));
        this.combineMaskWithGuiName(8192, this.layouts.getBitmaskItem(8192));
    }

    @Override
    public Component getCustomEditor() {
        assert (EventQueue.isDispatchThread());
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return true;
    }

    @Override
    public String getAsText() {
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        this.setConstant(MidpTypes.getInteger((PropertyValue)super.getValue()));
        return this.getBitmaskAsText();
    }

    @Override
    public void setTextForPropertyValue(String text) {
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue value) {
        if (this.isCurrentValueANull() || value == null) {
            this.customEditor.setValue(0);
        } else {
            this.customEditor.setValue(MidpTypes.getInteger(value));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue() {
        super.setValue((Object)MidpTypes.createIntegerValue(this.customEditor.getBitMask()));
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue();
        }
    }

    @Override
    public Boolean canEditAsText() {
        return false;
    }

    @Override
    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.canWrite();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent _component = (DesignComponent)this.component.get();
            final DesignComponent[] parent = new DesignComponent[1];
            _component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    parent[0] = _component.getParentComponent();
                }
            });
            if (parent[0] != null && this.parentTypeID.equals((Object)parent[0].getType())) {
                return false;
            }
        }
        return true;
    }

    private void setConstant(int bitmask) {
        this.layouts.setBitmask(bitmask);
        this.bitMask = bitmask;
    }

    public String getBitmaskAsText() {
        if (this.layouts.getBitmask() == 0) {
            return this.layouts.getBitmaskItem(this.layouts.getBitmask()).getName();
        }
        if (this.layouts.getBitmask() == 16384) {
            return this.layouts.getBitmaskItem(this.layouts.getBitmask()).getName();
        }
        int bitmaskRadioButton1 = 0;
        int bitmaskRadioButton2 = 0;
        StringBuffer bitmaskAsTextCheckBoxes = new StringBuffer();
        StringBuffer bitmaskAsTextRadioButton1 = new StringBuffer();
        StringBuffer bitmaskAsTextRadioButton2 = new StringBuffer();
        StringBuffer separator = new StringBuffer(" | ");
        for (Integer intValue : this.bits.keySet()) {
            if (this.layouts.isSet(this.bits.get(intValue)) && this.bits.get(intValue).getAffectedBits() < 16 && bitmaskRadioButton1 < this.bits.get(intValue).getAffectedBits()) {
                bitmaskRadioButton1 = this.bits.get(intValue).getAffectedBits();
                bitmaskAsTextRadioButton1 = new StringBuffer(this.bits.get(intValue).getName());
                bitmaskAsTextRadioButton1.append(separator);
                continue;
            }
            if (this.layouts.isSet(this.bits.get(intValue)) && this.bits.get(intValue).getAffectedBits() >= 16 && bitmaskRadioButton2 < this.bits.get(intValue).getAffectedBits()) {
                bitmaskRadioButton2 = this.bits.get(intValue).getAffectedBits();
                bitmaskAsTextRadioButton2 = new StringBuffer(this.bits.get(intValue).getName());
                bitmaskAsTextRadioButton2.append(separator);
                continue;
            }
            if (!this.layouts.isSet(this.bits.get(intValue)) || this.bits.get(intValue).getAffectedBits() == 0 || this.bits.get(intValue).getAffectedBits() < 48) continue;
            bitmaskAsTextCheckBoxes.append(this.bits.get(intValue).getName());
            bitmaskAsTextCheckBoxes.append(separator);
        }
        bitmaskAsTextRadioButton1.append(bitmaskAsTextRadioButton2.append(bitmaskAsTextCheckBoxes));
        bitmaskAsTextRadioButton1.deleteCharAt(bitmaskAsTextRadioButton1.lastIndexOf(separator.toString().trim()));
        return bitmaskAsTextRadioButton1.toString();
    }

    private final class CustomEditorConstraints
    extends JPanel
    implements ItemListener {
        private JPanel generalPanel;
        private JPanel horizontalAlignmentPanel;
        private JPanel verticalAlignmentPanel;
        private JPanel newlinePanel;
        private JPanel shrinkPanel;
        private JPanel expandPanel;
        private JCheckBox defaultCheckBox;
        private JRadioButton horizontalAlignmentNoneCheckBox;
        private JRadioButton verticalAlignmentNoneCheckBox;
        private List<JToggleButton> guiItems;

        CustomEditorConstraints() {
            this.initComponents();
            this.setLayoutDefault(this.defaultCheckBox.isSelected());
        }

        void cleanUp() {
            PropertyEditorLayout.this.layouts = null;
            if (PropertyEditorLayout.this.bits != null) {
                PropertyEditorLayout.this.bits.clear();
                PropertyEditorLayout.this.bits = null;
            }
            this.generalPanel = null;
            this.horizontalAlignmentPanel = null;
            this.verticalAlignmentPanel = null;
            this.newlinePanel = null;
            this.shrinkPanel = null;
            this.expandPanel = null;
            this.defaultCheckBox = null;
            this.horizontalAlignmentNoneCheckBox = null;
            this.verticalAlignmentNoneCheckBox = null;
            this.removeAll();
        }

        void initComponents() {
            this.guiItems = new ArrayList<JToggleButton>();
            this.setLayout(new GridLayout(6, 1));
            this.generalPanel = new JPanel();
            this.generalPanel.setLayout(new GridLayout(1, 2));
            this.generalPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_GENERAL")));
            this.defaultCheckBox = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_GEN_DEFAULT"));
            this.defaultCheckBox.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_GEN_DEFAULT"));
            this.integrateGuiItem(this.defaultCheckBox, PropertyEditorLayout.this.layouts.getBitmaskItem(0));
            this.defaultCheckBox.setSelected(PropertyEditorLayout.this.layouts.getBitmask() == 0);
            this.guiItems.add(this.defaultCheckBox);
            this.generalPanel.add(this.defaultCheckBox);
            this.defaultCheckBox.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_GEN_DEFAULT"));
            this.defaultCheckBox.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_GEN_DEFAULT"));
            JToggleButton guiItem = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_GEN_MIDP2"));
            guiItem.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_GEN_MIDP2"));
            this.integrateGuiItem(guiItem, PropertyEditorLayout.this.layouts.getBitmaskItem(16384));
            this.guiItems.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_GEN_MIDP2"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSN_ITEMLAYOUTPE_GEN_MIDP2"));
            this.generalPanel.add(guiItem);
            this.add(this.generalPanel);
            this.horizontalAlignmentPanel = new JPanel();
            this.horizontalAlignmentPanel.setLayout(new GridLayout(1, 4));
            this.horizontalAlignmentPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_HORIZONTAL")));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.horizontalAlignmentNoneCheckBox = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_HOR_NONE"));
            this.horizontalAlignmentNoneCheckBox.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_HOR_NONE"));
            buttonGroup.add(this.horizontalAlignmentNoneCheckBox);
            this.horizontalAlignmentPanel.add(this.horizontalAlignmentNoneCheckBox);
            this.horizontalAlignmentNoneCheckBox.setSelected(true);
            this.horizontalAlignmentNoneCheckBox.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_HOR_NONE"));
            this.horizontalAlignmentNoneCheckBox.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_HOR_NONE"));
            guiItem = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_HOR_LEFT"));
            guiItem.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_HOR_LEFT"));
            buttonGroup.add(guiItem);
            this.integrateGuiItem(guiItem, PropertyEditorLayout.this.layouts.getBitmaskItem(1));
            this.guiItems.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_HOR_LEFT"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_HOR_LEFT"));
            this.horizontalAlignmentPanel.add(guiItem);
            JRadioButton centerButton = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_HOR_CENTER"));
            centerButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_HOR_CENTER"));
            buttonGroup.add(centerButton);
            this.guiItems.add(centerButton);
            centerButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_HOR_CENTER"));
            centerButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_HOR_CENTER"));
            this.horizontalAlignmentPanel.add(centerButton);
            guiItem = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_HOR_RIGHT"));
            guiItem.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_HOR_RIGHT"));
            buttonGroup.add(guiItem);
            this.integrateGuiItem(guiItem, PropertyEditorLayout.this.layouts.getBitmaskItem(2));
            this.guiItems.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_HOR_RIGHT"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_HOR_RIGHT"));
            this.horizontalAlignmentPanel.add(guiItem);
            this.integrateGuiItem(centerButton, PropertyEditorLayout.this.layouts.getBitmaskItem(3));
            this.add(this.horizontalAlignmentPanel);
            this.verticalAlignmentPanel = new JPanel();
            this.verticalAlignmentPanel.setLayout(new GridLayout(1, 4));
            this.verticalAlignmentPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_VERTICAL")));
            buttonGroup = new ButtonGroup();
            this.verticalAlignmentNoneCheckBox = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_VER_NONE"));
            this.verticalAlignmentNoneCheckBox.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_VER_NONE"));
            this.verticalAlignmentNoneCheckBox.setSelected(true);
            buttonGroup.add(this.verticalAlignmentNoneCheckBox);
            this.verticalAlignmentPanel.add(this.verticalAlignmentNoneCheckBox);
            this.verticalAlignmentNoneCheckBox.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_VER_NONE"));
            this.verticalAlignmentNoneCheckBox.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_VER_NONE"));
            guiItem = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_VER_TOP"));
            guiItem.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_VER_TOP"));
            buttonGroup.add(guiItem);
            this.integrateGuiItem(guiItem, PropertyEditorLayout.this.layouts.getBitmaskItem(16));
            this.guiItems.add(guiItem);
            this.verticalAlignmentPanel.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_VER_TOP"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_VER_TOP"));
            centerButton = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_VER_CENTER"));
            centerButton.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_VER_CENTER"));
            buttonGroup.add(centerButton);
            this.guiItems.add(centerButton);
            centerButton.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_VER_CENTER"));
            centerButton.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_VER_CENTER"));
            this.verticalAlignmentPanel.add(centerButton);
            guiItem = new JRadioButton(Bundle.getMessage("LBL_ITEMLAYOUTPE_VER_BOTTOM"));
            guiItem.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_VER_BOTTOM"));
            buttonGroup.add(guiItem);
            this.integrateGuiItem(guiItem, PropertyEditorLayout.this.layouts.getBitmaskItem(32));
            this.guiItems.add(guiItem);
            this.verticalAlignmentPanel.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_VER_BOTTOM"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_VER_BOTTOM"));
            this.integrateGuiItem(centerButton, PropertyEditorLayout.this.layouts.getBitmaskItem(48));
            this.add(this.verticalAlignmentPanel);
            this.newlinePanel = new JPanel();
            this.newlinePanel.setLayout(new GridLayout(1, 2));
            this.newlinePanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_NEWLINE")));
            guiItem = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_NL_BEFORE"));
            guiItem.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_NL_BEFORE"));
            this.integrateGuiItem(guiItem, PropertyEditorLayout.this.layouts.getBitmaskItem(256));
            this.guiItems.add(guiItem);
            this.newlinePanel.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_NEWLINE"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_NEWLINE"));
            guiItem = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_NL_AFTER"));
            guiItem.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_NL_AFTER"));
            this.integrateGuiItem(guiItem, PropertyEditorLayout.this.layouts.getBitmaskItem(512));
            this.guiItems.add(guiItem);
            this.newlinePanel.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_NL_AFTER"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_NL_AFTER"));
            this.add(this.newlinePanel);
            this.shrinkPanel = new JPanel();
            this.shrinkPanel.setLayout(new GridLayout(1, 2));
            this.shrinkPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_SHRINK")));
            guiItem = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_SH_HORIZONTAL"));
            guiItem.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_SH_HORIZONTAL"));
            this.integrateGuiItem(guiItem, PropertyEditorLayout.this.layouts.getBitmaskItem(1024));
            this.guiItems.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_SH_HORIZONTAL"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_SH_HORIZONTAL"));
            this.shrinkPanel.add(guiItem);
            guiItem = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_SH_VERTICAL"));
            guiItem.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_SH_VERTICAL"));
            this.integrateGuiItem(guiItem, PropertyEditorLayout.this.layouts.getBitmaskItem(2048));
            this.guiItems.add(guiItem);
            this.shrinkPanel.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_SH_VERTICAL"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_SH_VERTICAL"));
            this.add(this.shrinkPanel);
            this.expandPanel = new JPanel();
            this.expandPanel.setLayout(new GridLayout(1, 2));
            this.expandPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_ITEMLAYOUTPE_EXPAND")));
            guiItem = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_EX_HORIZONTAL"));
            guiItem.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_EX_HORIZONTAL"));
            this.integrateGuiItem(guiItem, PropertyEditorLayout.this.layouts.getBitmaskItem(4096));
            this.guiItems.add(guiItem);
            this.expandPanel.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_EX_HORIZONTAL"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_EX_HORIZONTAL"));
            guiItem = new JCheckBox(Bundle.getMessage("LBL_ITEMLAYOUTPE_EX_VERTICAL"));
            guiItem.setMnemonic(Bundle.getChar("MNM_ITEMLAYOUTPE_EX_VERTICAL"));
            this.integrateGuiItem(guiItem, PropertyEditorLayout.this.layouts.getBitmaskItem(8192));
            this.guiItems.add(guiItem);
            this.expandPanel.add(guiItem);
            guiItem.getAccessibleContext().setAccessibleName(Bundle.getMessage("ACSN_ITEMLAYOUTPE_EX_VERTICAL"));
            guiItem.getAccessibleContext().setAccessibleDescription(Bundle.getMessage("ACSD_ITEMLAYOUTPE_EX_VERTICAL"));
            this.add(this.expandPanel);
            for (JToggleButton button : this.guiItems) {
                button.addItemListener(this);
            }
        }

        private void integrateGuiItem(JToggleButton guiItem, Bitmask.BitmaskItem bitmaskItem) {
            guiItem.setSelected(PropertyEditorLayout.this.layouts.isSet(bitmaskItem));
            guiItem.setName(Integer.toString(bitmaskItem.getAffectedBits()));
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ItemSelectable component = e.getItemSelectable();
            if (!(component instanceof JToggleButton)) {
                return;
            }
            JToggleButton tButton = (JToggleButton)component;
            String value = tButton.getName();
            if (value.equals(this.defaultCheckBox.getName())) {
                boolean selected = e.getStateChange() == 1;
                this.setLayoutDefault(selected);
                int newBitmask = 0;
                if (!selected) {
                    newBitmask = this.getComponentsBitmask().getBitmask();
                }
                PropertyEditorLayout.this.bitMask = newBitmask;
            } else {
                Bitmask.BitmaskItem bitmaskItem = (Bitmask.BitmaskItem)PropertyEditorLayout.this.bits.get(new Integer(String.valueOf(value)));
                assert (bitmaskItem != null);
                boolean state = e.getStateChange() == 1;
                PropertyEditorLayout.this.bitMask = PropertyEditorLayout.this.layouts.addToBitmask(bitmaskItem, state);
            }
        }

        private void setLayoutDefault(boolean layoutDefault) {
            boolean nonDefault = !layoutDefault;
            for (Integer value : PropertyEditorLayout.this.bits.keySet()) {
                for (JToggleButton tButton : this.guiItems) {
                    if (!tButton.getName().equals(Integer.toString(value))) continue;
                    tButton.setEnabled(nonDefault);
                }
            }
            this.defaultCheckBox.setEnabled(true);
            this.horizontalAlignmentNoneCheckBox.setEnabled(nonDefault);
            this.verticalAlignmentNoneCheckBox.setEnabled(nonDefault);
        }

        private ItemLayouts getComponentsBitmask() {
            ItemLayouts _layouts = new ItemLayouts(0);
            for (JToggleButton button : this.guiItems) {
                if (!button.isSelected()) continue;
                _layouts.addToBitmask((Bitmask.BitmaskItem)PropertyEditorLayout.this.bits.get(Integer.valueOf(button.getName())), true);
            }
            return _layouts;
        }

        public void setValue(int value) {
            if (value == 0) {
                this.defaultCheckBox.setSelected(true);
                this.itemStateChanged(new ItemEvent(this.defaultCheckBox, 701, null, 1));
            } else {
                PropertyEditorLayout.this.setConstant(value);
            }
        }

        public int getBitMask() {
            return PropertyEditorLayout.this.bitMask;
        }
    }
}

