/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.ScaleActionFactory;

public final class ScaleYActionFactory
extends ScaleActionFactory {
    private static final ActionMouseCursor SCALE_N_MOUSE_CURSOR = new ActionMouseCursor(8, 2);
    private static final ActionMouseCursor SCALE_S_MOUSE_CURSOR = new ActionMouseCursor(9, 2);

    public ScaleYActionFactory(SceneManager sceneMgr) {
        super(sceneMgr);
    }

    @Override
    public synchronized ComposerAction startAction(AWTEvent e, boolean isOutsideEvent) {
        MouseEvent me;
        SVGObject selObj;
        if (!isOutsideEvent && !this.m_sceneMgr.isReadOnly() && e.getID() == 501 && (selObj = this.getObjectToScaleAt(me = (MouseEvent)e)) != null) {
            return new ScaleYAction(this, selObj, me);
        }
        return null;
    }

    @Override
    public ActionMouseCursor getMouseCursor(MouseEvent evt, boolean isOutsideEvent) {
        SVGObject selObj = this.getSelectedObject();
        if (!isOutsideEvent && selObj != null) {
            if (this.isNScalePoint(selObj, evt)) {
                return SCALE_N_MOUSE_CURSOR;
            }
            if (this.isSScalePoint(selObj, evt)) {
                return SCALE_S_MOUSE_CURSOR;
            }
        }
        return null;
    }

    private SVGObject getObjectToScaleAt(MouseEvent me) {
        SVGObject selObj = this.getSelectedObject();
        if (selObj != null && (this.isNScalePoint(selObj, me) || this.isSScalePoint(selObj, me))) {
            return selObj;
        }
        return null;
    }

    private boolean isNScalePoint(SVGObject selObj, MouseEvent me) {
        return selObj.getOutline().isAtScaleNHandlePoint(me.getX(), me.getY());
    }

    private boolean isSScalePoint(SVGObject selObj, MouseEvent me) {
        return selObj.getOutline().isAtScaleSHandlePoint(me.getX(), me.getY());
    }

    private static class ScaleYAction
    extends ScaleActionFactory.ScaleAction {
        public ScaleYAction(ComposerActionFactory factory, SVGObject selected, MouseEvent me) {
            super(factory, selected, me);
        }

        @Override
        public boolean consumeEvent(AWTEvent evt, boolean isOutsideEvent) {
            if (!isOutsideEvent && evt.getID() == 506) {
                MouseEvent me = (MouseEvent)evt;
                Rectangle bBox = this.m_scaled.getScreenBBox();
                this.m_scaled.scale(1.0f, this.calculateScaleY(me.getY()), this.m_scalePtIdx);
                bBox.add(this.m_scaled.getScreenBBox());
                this.m_factory.getSceneManager().getScreenManager().repaint(bBox, 5);
            } else if (evt.getID() == 502) {
                this.actionCompleted();
                this.m_scaled.commitChanges();
            }
            return false;
        }

        @Override
        public ActionMouseCursor getMouseCursor(boolean isOutsideEvent) {
            return isOutsideEvent ? null : SCALE_N_MOUSE_CURSOR;
        }
    }
}

