/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.NBPluginParameterExpressionEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class PluginPropertyUtils {
    private static List<String> LIFECYCLE_PLUGINS = Arrays.asList("maven-compiler-plugin", "maven-surefire-plugin", "maven-ear-plugin", "maven-jar-plugin", "maven-war-plugin", "maven-resources-plugin");
    private static final String CONFIGURATION_EL = "configuration";

    private PluginPropertyUtils() {
    }

    public static String getPluginProperty(Project prj, String groupId, String artifactId, String property, String goal) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, property, goal);
    }

    public static String getPluginProperty(MavenProject prj, String groupId, String artifactId, String property, String goal) {
        return PluginPropertyUtils.getPluginPropertyImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, property, goal);
    }

    private static String getPluginPropertyImpl(MavenProject prj, NBPluginParameterExpressionEvaluator eval, String groupId, String artifactId, String property, String goal) {
        Plugin plug;
        String toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Object obj : prj.getBuildPlugins()) {
            plug = (Plugin)obj;
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getExecutions() != null && goal != null) {
                Object obj2;
                PluginExecution exe;
                Iterator i$ = plug.getExecutions().iterator();
                while (i$.hasNext() && (!(exe = (PluginExecution)(obj2 = i$.next())).getGoals().contains(goal) && !("default-" + goal).equals(exe.getId()) || (toRet = PluginPropertyUtils.checkConfiguration(eval, exe.getConfiguration(), property)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkConfiguration(eval, plug.getConfiguration(), property);
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Object obj : prj.getPluginManagement().getPlugins()) {
                plug = (Plugin)obj;
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkConfiguration(eval, plug.getConfiguration(), property);
                break;
            }
        }
        return toRet;
    }

    public static String getReportPluginProperty(Project prj, String groupId, String artifactId, String property, String report) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getReportPluginPropertyImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, property, report);
    }

    public static String getReportPluginProperty(MavenProject prj, String groupId, String artifactId, String property, String report) {
        return PluginPropertyUtils.getReportPluginPropertyImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, property, report);
    }

    private static String getReportPluginPropertyImpl(MavenProject prj, NBPluginParameterExpressionEvaluator eval, String groupId, String artifactId, String property, String report) {
        String toRet = null;
        if (prj.getReportPlugins() == null) {
            return toRet;
        }
        for (Object obj : prj.getReportPlugins()) {
            ReportPlugin plug = (ReportPlugin)obj;
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getReportSets() != null) {
                Object obj2;
                ReportSet exe;
                Iterator i$ = plug.getReportSets().iterator();
                while (i$.hasNext() && (!(exe = (ReportSet)(obj2 = i$.next())).getReports().contains(report) || (toRet = PluginPropertyUtils.checkConfiguration(eval, exe.getConfiguration(), property)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkConfiguration(eval, plug.getConfiguration(), property);
        }
        return toRet;
    }

    public static String getPluginVersion(MavenProject prj, String groupId, String artifactId) {
        Plugin plug;
        String toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Object obj : prj.getBuildPlugins()) {
            plug = (Plugin)obj;
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            toRet = plug.getVersion();
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Object obj : prj.getPluginManagement().getPlugins()) {
                plug = (Plugin)obj;
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = plug.getVersion();
                break;
            }
        }
        return toRet;
    }

    private static String checkConfiguration(NBPluginParameterExpressionEvaluator eval, Object conf, String property) {
        Xpp3Dom dom;
        Xpp3Dom source;
        if (conf != null && conf instanceof Xpp3Dom && (source = (dom = (Xpp3Dom)conf).getChild(property)) != null) {
            try {
                Object evaluated = eval.evaluate(source.getValue().trim());
                return evaluated != null ? "" + evaluated : source.getValue().trim();
            }
            catch (ExpressionEvaluationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return source.getValue().trim();
            }
        }
        return null;
    }

    public static String[] getPluginPropertyList(Project prj, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyListImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    public static String[] getPluginPropertyList(MavenProject prj, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        return PluginPropertyUtils.getPluginPropertyListImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    private static String[] getPluginPropertyListImpl(MavenProject prj, NBPluginParameterExpressionEvaluator eval, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        Plugin plug;
        String[] toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Object obj : prj.getBuildPlugins()) {
            plug = (Plugin)obj;
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getExecutions() != null && goal != null) {
                Object obj2;
                PluginExecution exe;
                Iterator i$ = plug.getExecutions().iterator();
                while (i$.hasNext() && (!(exe = (PluginExecution)(obj2 = i$.next())).getGoals().contains(goal) && !("default-" + goal).equals(exe.getId()) || (toRet = PluginPropertyUtils.checkListConfiguration(eval, exe.getConfiguration(), multiproperty, singleproperty)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Object obj : prj.getPluginManagement().getPlugins()) {
                plug = (Plugin)obj;
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
                break;
            }
        }
        return toRet;
    }

    public static String[] getReportPluginPropertyList(Project prj, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getReportPluginPropertyListImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    public static String[] getReportPluginPropertyList(MavenProject prj, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        return PluginPropertyUtils.getReportPluginPropertyListImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, multiproperty, singleproperty, goal);
    }

    private static String[] getReportPluginPropertyListImpl(MavenProject prj, NBPluginParameterExpressionEvaluator eval, String groupId, String artifactId, String multiproperty, String singleproperty, String goal) {
        ReportPlugin plug;
        String[] toRet = null;
        if (prj.getReportPlugins() == null) {
            return toRet;
        }
        for (Object obj : prj.getReportPlugins()) {
            plug = (ReportPlugin)obj;
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getReportSets() != null) {
                Object obj2;
                ReportSet exe;
                Iterator i$ = plug.getReportSets().iterator();
                while (i$.hasNext() && (!(exe = (ReportSet)(obj2 = i$.next())).getReports().contains(goal) || (toRet = PluginPropertyUtils.checkListConfiguration(eval, exe.getConfiguration(), multiproperty, singleproperty)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
        }
        if (toRet == null && prj.getPluginManagement() != null) {
            for (Object obj : prj.getPluginManagement().getPlugins()) {
                plug = (Plugin)obj;
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkListConfiguration(eval, plug.getConfiguration(), multiproperty, singleproperty);
                break;
            }
        }
        return toRet;
    }

    private static String[] checkListConfiguration(NBPluginParameterExpressionEvaluator eval, Object conf, String multiproperty, String singleproperty) {
        Xpp3Dom dom;
        Xpp3Dom source;
        if (conf != null && conf instanceof Xpp3Dom && (source = (dom = (Xpp3Dom)conf).getChild(multiproperty)) != null) {
            Xpp3Dom[] childs;
            ArrayList<String> toRet = new ArrayList<String>();
            for (Xpp3Dom ch : childs = source.getChildren(singleproperty)) {
                try {
                    Object evaluated = eval.evaluate(ch.getValue().trim());
                    toRet.add(evaluated != null ? "" + evaluated : ch.getValue().trim());
                }
                catch (ExpressionEvaluationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return toRet.toArray(new String[toRet.size()]);
        }
        return null;
    }

    public static Properties getPluginPropertyParameter(Project prj, String groupId, String artifactId, String propertyParameter, String goal) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        assert (project != null) : "Requires a maven project instance";
        return PluginPropertyUtils.getPluginPropertyParameterImpl(project.getOriginalMavenProject(), PluginPropertyUtils.createEvaluator(project), groupId, artifactId, propertyParameter, goal);
    }

    public static Properties getPluginPropertyParameter(MavenProject prj, String groupId, String artifactId, String propertyParameter, String goal) {
        return PluginPropertyUtils.getPluginPropertyParameterImpl(prj, PluginPropertyUtils.createEvaluator(prj), groupId, artifactId, propertyParameter, goal);
    }

    private static Properties getPluginPropertyParameterImpl(MavenProject prj, NBPluginParameterExpressionEvaluator eval, String groupId, String artifactId, String propertyParameter, String goal) {
        Plugin plug;
        Properties toRet = null;
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Object obj : prj.getBuildPlugins()) {
            plug = (Plugin)obj;
            if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
            if (plug.getExecutions() != null && goal != null) {
                Object obj2;
                PluginExecution exe;
                Iterator i$ = plug.getExecutions().iterator();
                while (i$.hasNext() && (!(exe = (PluginExecution)(obj2 = i$.next())).getGoals().contains(goal) && !("default-" + goal).equals(exe.getId()) || (toRet = PluginPropertyUtils.checkPropertiesConfiguration(eval, exe.getConfiguration(), propertyParameter)) == null)) {
                }
            }
            if (toRet != null) continue;
            toRet = PluginPropertyUtils.checkPropertiesConfiguration(eval, plug.getConfiguration(), propertyParameter);
        }
        if (toRet == null && LIFECYCLE_PLUGINS.contains(artifactId) && prj.getPluginManagement() != null) {
            for (Object obj : prj.getPluginManagement().getPlugins()) {
                plug = (Plugin)obj;
                if (!artifactId.equals(plug.getArtifactId()) || !groupId.equals(plug.getGroupId())) continue;
                toRet = PluginPropertyUtils.checkPropertiesConfiguration(eval, plug.getConfiguration(), propertyParameter);
                break;
            }
        }
        return toRet;
    }

    private static Properties checkPropertiesConfiguration(NBPluginParameterExpressionEvaluator eval, Object conf, String propertyParameter) {
        Xpp3Dom dom;
        Xpp3Dom source;
        if (conf != null && conf instanceof Xpp3Dom && (source = (dom = (Xpp3Dom)conf).getChild(propertyParameter)) != null) {
            Xpp3Dom[] childs;
            Properties toRet = new Properties();
            for (Xpp3Dom ch : childs = source.getChildren()) {
                try {
                    String val = ch.getValue();
                    if (val == null) {
                        if (ch.getChildCount() != 2) continue;
                        Xpp3Dom nameDom = ch.getChild("name");
                        Xpp3Dom valueDom = ch.getChild("value");
                        if (nameDom == null || valueDom == null) continue;
                        String name = nameDom.getValue();
                        String value = valueDom.getValue();
                        Object evaluated = eval.evaluate(value);
                        if (name == null || value == null) continue;
                        toRet.put(name, evaluated != null ? "" + evaluated : value);
                        continue;
                    }
                    Object evaluated = eval.evaluate(val.trim());
                    toRet.put(ch.getName(), evaluated != null ? "" + evaluated : ch.getValue().trim());
                }
                catch (ExpressionEvaluationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return toRet;
        }
        return null;
    }

    @Deprecated
    public static Dependency checkModelDependency(Model mdl, String groupId, String artifactId, boolean add) {
        DependencyManagement mng;
        List deps = mdl.getDependencies();
        Dependency ret = null;
        Dependency managed = null;
        if (deps != null) {
            for (Dependency d : deps) {
                if (!groupId.equalsIgnoreCase(d.getGroupId()) || !artifactId.equalsIgnoreCase(d.getArtifactId())) continue;
                ret = d;
                break;
            }
        }
        if ((ret == null || ret.getVersion() == null) && (mng = mdl.getDependencyManagement()) != null && (deps = mng.getDependencies()) != null) {
            for (Dependency d : deps) {
                if (!groupId.equalsIgnoreCase(d.getGroupId()) || !artifactId.equalsIgnoreCase(d.getArtifactId())) continue;
                managed = d;
                break;
            }
        }
        if (add && ret == null) {
            ret = new Dependency();
            ret.setGroupId(groupId);
            ret.setArtifactId(artifactId);
            mdl.addDependency(ret);
        }
        return managed == null ? ret : managed;
    }

    @Deprecated
    public static boolean hasModelDependency(Model mdl, String groupid, String artifactid) {
        return PluginPropertyUtils.checkModelDependency(mdl, groupid, artifactid, false) != null;
    }

    @Deprecated
    public static Repository checkModelRepository(MavenProject project, Model mdl, String url, boolean add) {
        if (url.contains("http://repo1.maven.org/maven2")) {
            return null;
        }
        for (Object rr : mdl.getRepositories()) {
            Repository r = (Repository)rr;
            if (!url.equals(r.getUrl())) continue;
            return null;
        }
        List reps = project.getRepositories();
        Repository prjret = null;
        Repository ret = null;
        if (reps != null) {
            for (Repository re : reps) {
                if (!url.equals(re.getUrl())) continue;
                prjret = re;
                break;
            }
        }
        if (prjret != null && (reps = mdl.getRepositories()) != null) {
            for (Repository re : reps) {
                if (!re.getId().equals(prjret.getId())) continue;
                ret = re;
                break;
            }
        }
        if (add && ret == null && prjret == null) {
            ret = new Repository();
            ret.setUrl(url);
            ret.setId(url);
            mdl.addRepository(ret);
        }
        return ret;
    }

    @Deprecated
    public static boolean hasModelRepository(MavenProject project, Model mdl, String url) {
        return PluginPropertyUtils.checkModelRepository(project, mdl, url, false) != null;
    }

    @Deprecated
    public static void checkSourceLevel(ModelHandle handle, String sourceLevel) {
        ModelUtils.checkSourceLevel(handle, sourceLevel);
    }

    @Deprecated
    public static void checkEncoding(ModelHandle handle, String enc) {
        ModelUtils.checkEncoding(handle, enc);
    }

    private static NBPluginParameterExpressionEvaluator createEvaluator(NbMavenProjectImpl prj) {
        Settings ss = EmbedderFactory.getProjectEmbedder().getSettings();
        ss.setLocalRepository(EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir());
        return new NBPluginParameterExpressionEvaluator(prj.getOriginalMavenProject(), ss, prj.createSystemPropsForPropertyExpressions());
    }

    private static NBPluginParameterExpressionEvaluator createEvaluator(MavenProject prj) {
        NbMavenProjectImpl project;
        Project p;
        FileObject bsd = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)prj.getBasedir()));
        Properties props = new Properties();
        if (bsd != null && (p = FileOwnerQuery.getOwner((FileObject)bsd)) != null && (project = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class)) != null) {
            props = project.createSystemPropsForPropertyExpressions();
        }
        Settings ss = EmbedderFactory.getProjectEmbedder().getSettings();
        ss.setLocalRepository(EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir());
        return new NBPluginParameterExpressionEvaluator(prj, ss, props);
    }
}

