/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.netbeans.modules.bugtracking.vcs.FormatPanel;
import org.netbeans.modules.bugtracking.vcs.HookPanel;
import org.netbeans.modules.bugtracking.vcs.HookUtils;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.netbeans.modules.versioning.hooks.SvnHook;
import org.netbeans.modules.versioning.hooks.SvnHookContext;
import org.openide.util.NbBundle;

public class SvnHookImpl
extends SvnHook {
    private static final String[] SUPPORT_ISSUE_INFO_VARIABLES = new String[]{"id", "summary"};
    private static final String[] SUPPORT_REVISION_VARIABLES = new String[]{"revision", "author", "date", "message"};
    private HookPanel panel;
    private final String name = NbBundle.getMessage(SvnHookImpl.class, (String)"LBL_VCSHook");
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.vcshooks.SvnHook");
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public SvnHookContext beforeCommit(SvnHookContext context) throws IOException {
        Repository selectedRepository = this.getSelectedRepository();
        if (context.getFiles().length == 0) {
            if (selectedRepository != null) {
                BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.MAIN_OR_SINGLE_PROJECT, selectedRepository);
            }
            LOG.warning("calling svn beforeCommit for zero files");
            return null;
        }
        if (selectedRepository != null) {
            BugtrackingOwnerSupport.getInstance().setFirmAssociations(context.getFiles(), selectedRepository);
        }
        File file = context.getFiles()[0];
        LOG.log(Level.FINE, "svn beforeCommit start for {0}", file);
        String msg = context.getMessage();
        ArrayList logEntries = null;
        if (this.isLinkSelected()) {
            VCSHooksConfig.Format format = VCSHooksConfig.getInstance().getSvnIssueInfoTemplate();
            String formatString = format.getFormat();
            formatString = HookUtils.prepareFormatString(formatString, SUPPORT_ISSUE_INFO_VARIABLES);
            Issue issue = this.getIssue();
            if (issue == null) {
                LOG.log(Level.FINE, " no issue set for {0}", file);
                return null;
            }
            String issueInfo = new MessageFormat(formatString).format(new Object[]{issue.getID(), issue.getSummary()}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " svn commit hook issue info ''{0}''", issueInfo);
            msg = format.isAbove() ? issueInfo + "\n" + msg : msg + "\n" + issueInfo;
            logEntries = new ArrayList();
        }
        return new SvnHookContext(context.getFiles(), msg, logEntries);
    }

    public void afterCommit(SvnHookContext context) {
        if (this.panel == null) {
            LOG.fine("no settings for afterCommit");
            return;
        }
        if (context.getFiles().length == 0) {
            LOG.warning("calling svn afterCommit for zero files");
            return;
        }
        File file = context.getFiles()[0];
        LOG.log(Level.FINE, "svn afterCommit start for {0}", file);
        Issue issue = this.getIssue();
        if (issue == null) {
            LOG.log(Level.FINE, " no issue set for {0}", file);
            return;
        }
        VCSHooksConfig.getInstance().setSvnResolve(this.isResolveSelected());
        VCSHooksConfig.getInstance().setSvnLink(this.isLinkSelected());
        if (!this.isLinkSelected() && !this.isResolveSelected()) {
            LOG.log(Level.FINER, " nothing to do in svn afterCommit for {0}", file);
            return;
        }
        String msg = null;
        if (this.isLinkSelected()) {
            List entries = context.getLogEntries();
            assert (entries.size() > 0);
            SvnHookContext.LogEntry logEntry = (SvnHookContext.LogEntry)entries.get(0);
            String author = logEntry.getAuthor();
            String revisions = this.getRevisions(entries);
            Date date = logEntry.getDate();
            String message = logEntry.getMessage();
            String formatString = VCSHooksConfig.getInstance().getSvnRevisionTemplate().getFormat();
            formatString = HookUtils.prepareFormatString(formatString, SUPPORT_REVISION_VARIABLES);
            msg = new MessageFormat(formatString).format(new Object[]{revisions, author, date != null ? CC_DATE_FORMAT.format(date) : "", message}, new StringBuffer(), (FieldPosition)null).toString();
        }
        if (this.isLinkSelected() || this.isResolveSelected()) {
            LOG.log(Level.FINER, " svn commit hook message ''{0}'', resolved {1}", new Object[]{msg, this.isResolveSelected()});
            issue.addComment(msg, this.isResolveSelected());
            issue.open();
        }
        LOG.log(Level.FINE, "svn commit hook end for {0}", file);
        VCSHooksConfig.logHookUsage("SVN", this.getSelectedRepository());
    }

    public JPanel createComponent(SvnHookContext context) {
        File referenceFile;
        LOG.finer("SvnHookImpl.createComponent()");
        if (context.getFiles().length == 0) {
            referenceFile = null;
            LOG.warning("creating svn hook component for zero files");
        } else {
            referenceFile = context.getFiles()[0];
        }
        this.panel = new HookPanel(VCSHooksConfig.getInstance().getSvnLink(), VCSHooksConfig.getInstance().getSvnResolve(), false);
        if (referenceFile != null) {
            RepositoryComboSupport.setup((JComponent)((Object)this.panel), (JComboBox)this.panel.repositoryComboBox, (File)referenceFile);
        } else {
            RepositoryComboSupport.setup((JComponent)((Object)this.panel), (JComboBox)this.panel.repositoryComboBox, (boolean)false);
        }
        this.panel.commitRadioButton.setVisible(false);
        this.panel.pushRadioButton.setVisible(false);
        this.panel.changeFormatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnHookImpl.this.onShowFormat();
            }
        });
        return this.panel;
    }

    public String getDisplayName() {
        return this.name;
    }

    private String getRevisions(List<SvnHookContext.LogEntry> entries) {
        StringBuilder sb = new StringBuilder();
        Iterator<SvnHookContext.LogEntry> it = entries.iterator();
        while (it.hasNext()) {
            SvnHookContext.LogEntry logEntry = it.next();
            sb.append(logEntry.getRevision());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private void onShowFormat() {
        FormatPanel p = new FormatPanel(VCSHooksConfig.getInstance().getSvnRevisionTemplate(), VCSHooksConfig.getDefaultSvnRevisionTemplate(), SUPPORT_REVISION_VARIABLES, VCSHooksConfig.getInstance().getSvnIssueInfoTemplate(), VCSHooksConfig.getDefaultIssueInfoTemplate(), SUPPORT_ISSUE_INFO_VARIABLES);
        if (BugtrackingUtil.show((JPanel)p, (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_FormatTitle"), (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_OK"))) {
            VCSHooksConfig.getInstance().setSvnRevisionTemplate(p.getIssueFormat());
            VCSHooksConfig.getInstance().setSvnIssueInfoTemplate(p.getCommitFormat());
        }
    }

    private boolean isLinkSelected() {
        return this.panel != null && this.panel.linkCheckBox.isSelected();
    }

    private boolean isResolveSelected() {
        return this.panel != null && this.panel.resolveCheckBox.isSelected();
    }

    private Repository getSelectedRepository() {
        return this.panel != null ? this.panel.getSelectedRepository() : null;
    }

    private Issue getIssue() {
        return this.panel != null ? this.panel.getIssue() : null;
    }
}

