/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.maven.lifecycle.LifecycleBindingLoader;
import org.apache.maven.lifecycle.LifecycleLoaderException;
import org.apache.maven.lifecycle.LifecycleSpecificationException;
import org.apache.maven.lifecycle.LifecycleUtils;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.io.xpp3.LifecycleBindingsXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ClassLoaderXmlBindingLoader
implements LifecycleBindingLoader {
    private String path;

    public ClassLoaderXmlBindingLoader() {
    }

    public ClassLoaderXmlBindingLoader(String path) {
        this.path = path;
    }

    public LifecycleBindings getBindings() throws LifecycleLoaderException, LifecycleSpecificationException {
        LifecycleBindings bindings;
        InputStreamReader reader;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(this.getPath());
        if (url == null) {
            throw new LifecycleLoaderException("Classpath resource: " + this.getPath() + " could not be found.");
        }
        try {
            reader = new InputStreamReader(url.openStream());
        }
        catch (IOException e) {
            throw new LifecycleLoaderException("Failed to open stream for classpath resource: " + this.getPath() + ". Reason: " + e.getMessage(), e);
        }
        try {
            bindings = new LifecycleBindingsXpp3Reader().read(reader);
        }
        catch (IOException e) {
            throw new LifecycleLoaderException("Classpath resource: " + this.getPath() + " could not be read. Reason: " + e.getMessage(), e);
        }
        catch (XmlPullParserException e) {
            throw new LifecycleLoaderException("Classpath resource: " + this.getPath() + " could not be parsed. Reason: " + e.getMessage(), e);
        }
        LifecycleUtils.setOrigin(bindings, url.toExternalForm());
        return bindings;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

