/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.SyntaxParserContext;
import org.netbeans.editor.ext.html.parser.SyntaxParserResult;

public final class SyntaxParser {
    private final LanguagePath languagePath;
    private final TokenHierarchy hi;
    private List<SyntaxElement> EMPTY_ELEMENTS_LIST = Collections.emptyList();
    private List<SyntaxElement> parsedElements;
    private final SyntaxElement SHARED_TEXT_ELEMENT = new SyntaxElement.SharedTextElement();
    protected CharSequence parserSource;
    private static final int S_INIT = 0;
    private static final int S_TAG_OPEN_SYMBOL = 1;
    private static final int S_TAG = 2;
    private static final int S_TAG_ATTR = 3;
    private static final int S_TAG_VALUE = 4;
    private static final int S_COMMENT = 5;
    private static final int S_DECLARATION = 6;
    private static final int S_DOCTYPE_DECLARATION = 7;
    private static final int S_DOCTYPE_AFTER_ROOT_ELEMENT = 8;
    private static final int S_DOCTYPE_PUBLIC_ID = 9;
    private static final int S_DOCTYPE_FILE = 10;
    private static final int S_TEXT = 11;
    private static final int S_TAG_AFTER_NAME = 12;
    private int state;
    private int start;
    private TokenSequence ts;
    private Token<HTMLTokenId> token;
    private List<SyntaxElement> elements;
    private boolean openTag = true;
    private String tagName = null;
    private TokenInfo attrib = null;
    private ArrayList<TokenInfo> attr_keys = null;
    private ArrayList<List<TokenInfo>> attr_values = null;
    private String root_element;
    private String doctype_public_id;
    private String doctype_file;

    public static SyntaxParserResult parse(SyntaxParserContext context) {
        assert (context != null);
        context.setElements(context.getSourceText().length() == 0 ? Collections.EMPTY_LIST : new SyntaxParser(context.getSourceText()).parseDocument());
        return new SyntaxParserResult(context);
    }

    private SyntaxParser(CharSequence source) {
        this.parserSource = source;
        this.parsedElements = this.EMPTY_ELEMENTS_LIST;
        this.languagePath = LanguagePath.get((Language)HTMLTokenId.language());
        this.hi = TokenHierarchy.create((CharSequence)source, (Language)HTMLTokenId.language());
    }

    public List<SyntaxElement> elements() {
        return this.parsedElements;
    }

    private void error() {
        this.elements.add(new SyntaxElement.Error(this.parserSource, this.start, this.ts.offset() + this.ts.token().length() - this.start));
    }

    private void text() {
        this.elements.add(this.SHARED_TEXT_ELEMENT);
    }

    private void entityReference() {
        this.elements.add(new SyntaxElement.EntityReference(this.parserSource, this.start, this.ts.offset() + this.ts.token().length() - this.start));
    }

    private void comment() {
        this.elements.add(new SyntaxElement.Comment(this.parserSource, this.start, this.ts.offset() + this.ts.token().length() - this.start));
    }

    private void declaration() {
        this.elements.add(new SyntaxElement.Declaration(this.parserSource, this.start, this.ts.offset() + this.ts.token().length() - this.start, this.root_element, this.doctype_public_id, this.doctype_file));
    }

    private void tag(boolean emptyTag) {
        ArrayList<SyntaxElement.TagAttribute> attributes = new ArrayList<SyntaxElement.TagAttribute>();
        for (int i = 0; i < this.attr_keys.size(); ++i) {
            TokenInfo key = this.attr_keys.get(i);
            List<TokenInfo> values = this.attr_values.get(i);
            StringBuffer joinedValue = new StringBuffer();
            if (values == null) {
                SyntaxElement.TagAttribute ta = new SyntaxElement.TagAttribute(((Object)key.token.text()).toString().intern(), joinedValue.toString().intern(), key.offset, key.offset + key.token.length(), 0);
                attributes.add(ta);
                continue;
            }
            for (TokenInfo t : values) {
                joinedValue.append(t.token.text());
            }
            TokenInfo firstValuePart = values.get(0);
            TokenInfo lastValuePart = values.get(values.size() - 1);
            SyntaxElement.TagAttribute ta = new SyntaxElement.TagAttribute(((Object)key.token.text()).toString().intern(), joinedValue.toString().intern(), key.offset, firstValuePart.offset, lastValuePart.offset + lastValuePart.token.length() - firstValuePart.offset);
            attributes.add(ta);
        }
        this.elements.add(new SyntaxElement.Tag(this.parserSource, this.start, this.ts.offset() + this.ts.token().length() - this.start, this.tagName.intern(), attributes.isEmpty() ? null : attributes, this.openTag, emptyTag));
        this.tagName = null;
        this.attrib = null;
        this.attr_keys = new ArrayList();
        this.attr_values = new ArrayList();
    }

    private void tag_with_error() {
        this.backup(1);
        this.tag(false);
        this.state = 0;
        this.start = -1;
    }

    private void reset() {
        this.backup(1);
        this.error();
        this.state = 0;
        this.start = -1;
    }

    private void backup(int tokens) {
        for (int i = 0; i < tokens; ++i) {
            this.ts.movePrevious();
            this.token = this.ts.token();
        }
    }

    private List<SyntaxElement> parseDocument() {
        this.elements = new ArrayList<SyntaxElement>();
        List sequences = this.hi.tokenSequenceList(this.languagePath, 0, Integer.MAX_VALUE);
        this.state = 0;
        this.start = -1;
        this.attr_keys = new ArrayList();
        this.attr_values = new ArrayList();
        Iterator i$ = sequences.iterator();
        while (i$.hasNext()) {
            TokenSequence _ts;
            this.ts = _ts = (TokenSequence)i$.next();
            while (this.ts.moveNext()) {
                this.token = this.ts.token();
                HTMLTokenId id = (HTMLTokenId)this.token.id();
                block0 : switch (this.state) {
                    case 0: {
                        switch (id) {
                            case CHARACTER: {
                                this.start = this.ts.offset();
                                this.entityReference();
                                this.state = 0;
                                this.start = -1;
                                break block0;
                            }
                            case TAG_OPEN_SYMBOL: {
                                this.start = this.ts.offset();
                                this.state = 1;
                                break block0;
                            }
                            case BLOCK_COMMENT: {
                                this.start = this.ts.offset();
                                this.state = 5;
                                break block0;
                            }
                            case DECLARATION: {
                                this.start = this.ts.offset();
                                if (((Object)this.token.text()).toString().equals("<!DOCTYPE")) {
                                    this.root_element = null;
                                    this.doctype_public_id = null;
                                    this.doctype_file = null;
                                    this.state = 7;
                                    break block0;
                                }
                                this.state = 6;
                                break block0;
                            }
                        }
                        this.start = this.ts.offset();
                        this.state = 11;
                        break;
                    }
                    case 11: {
                        switch (id) {
                            case TEXT: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.text();
                        this.state = 0;
                        this.start = -1;
                        break;
                    }
                    case 1: {
                        switch (id) {
                            case TAG_OPEN: {
                                this.state = 12;
                                this.openTag = true;
                                this.tagName = ((Object)this.token.text()).toString();
                                break block0;
                            }
                            case TAG_CLOSE: {
                                this.state = 12;
                                this.openTag = false;
                                this.tagName = ((Object)this.token.text()).toString();
                                break block0;
                            }
                        }
                        this.reset();
                        break;
                    }
                    case 12: {
                        this.backup(1);
                        this.state = 2;
                        break;
                    }
                    case 2: {
                        switch (id) {
                            case WS: 
                            case EOL: 
                            case ERROR: {
                                break block0;
                            }
                            case ARGUMENT: {
                                this.state = 3;
                                this.attrib = this.tokenInfo();
                                break block0;
                            }
                            case TAG_CLOSE_SYMBOL: {
                                boolean emptyTag = "/>".equals(((Object)this.token.text()).toString());
                                this.tag(emptyTag);
                                this.state = 0;
                                this.start = -1;
                                break block0;
                            }
                        }
                        this.tag_with_error();
                        break;
                    }
                    case 3: {
                        switch (id) {
                            case WS: 
                            case OPERATOR: {
                                break block0;
                            }
                            case VALUE: 
                            case VALUE_JAVASCRIPT: 
                            case VALUE_CSS: {
                                this.backup(1);
                                this.state = 4;
                                break block0;
                            }
                            case ARGUMENT: 
                            case TAG_CLOSE_SYMBOL: {
                                this.attr_keys.add(this.attrib);
                                this.attr_values.add(null);
                                this.state = 2;
                                this.backup(1);
                                break block0;
                            }
                        }
                        this.tag_with_error();
                        break;
                    }
                    case 4: {
                        switch (id) {
                            case VALUE: 
                            case VALUE_JAVASCRIPT: 
                            case VALUE_CSS: {
                                int index = this.attr_keys.indexOf(this.attrib);
                                if (index == -1) {
                                    ArrayList<TokenInfo> values = new ArrayList<TokenInfo>();
                                    values.add(this.tokenInfo());
                                    this.attr_keys.add(this.attrib);
                                    this.attr_values.add(values);
                                    break block0;
                                }
                                this.attr_values.get(index).add(this.tokenInfo());
                                break block0;
                            }
                            case ERROR: {
                                this.tag_with_error();
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.state = 2;
                        break;
                    }
                    case 5: {
                        switch (id) {
                            case BLOCK_COMMENT: 
                            case WS: 
                            case EOL: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.comment();
                        this.state = 0;
                        this.start = -1;
                        break;
                    }
                    case 6: {
                        switch (id) {
                            case DECLARATION: 
                            case WS: 
                            case EOL: 
                            case SGML_COMMENT: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.declaration();
                        this.state = 0;
                        this.start = -1;
                        break;
                    }
                    case 7: {
                        switch (id) {
                            case DECLARATION: {
                                this.root_element = ((Object)this.token.text()).toString();
                                this.state = 8;
                                break block0;
                            }
                            case WS: 
                            case EOL: 
                            case SGML_COMMENT: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.declaration();
                        this.state = 0;
                        this.start = -1;
                        break;
                    }
                    case 8: {
                        switch (id) {
                            case DECLARATION: {
                                if (((Object)this.token.text()).toString().equals("PUBLIC")) {
                                    this.doctype_public_id = new String();
                                    this.state = 9;
                                    break block0;
                                }
                                if (((Object)this.token.text()).toString().equals("SYSTEM")) {
                                    this.state = 10;
                                    this.doctype_file = new String();
                                    break block0;
                                }
                                this.backup(1);
                                this.declaration();
                                this.state = 0;
                                this.start = -1;
                                break block0;
                            }
                            case WS: 
                            case EOL: 
                            case SGML_COMMENT: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.declaration();
                        this.state = 0;
                        this.start = -1;
                        break;
                    }
                    case 9: {
                        switch (id) {
                            case DECLARATION: 
                            case WS: {
                                String tokenText = ((Object)this.token.text()).toString();
                                if (tokenText.startsWith("\"")) {
                                    tokenText = tokenText.substring(1);
                                }
                                if (tokenText.endsWith("\"")) {
                                    tokenText = tokenText.substring(0, tokenText.length() - 1);
                                    this.doctype_public_id = this.doctype_public_id + tokenText;
                                    this.doctype_public_id = this.doctype_public_id.trim();
                                    this.state = 10;
                                    break block0;
                                }
                                this.doctype_public_id = this.doctype_public_id + tokenText;
                                break block0;
                            }
                            case EOL: 
                            case SGML_COMMENT: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.declaration();
                        this.state = 0;
                        this.start = -1;
                        break;
                    }
                    case 10: {
                        switch (id) {
                            case DECLARATION: {
                                this.doctype_file = ((Object)this.token.text()).toString();
                                this.state = 6;
                                break block0;
                            }
                            case WS: 
                            case EOL: 
                            case SGML_COMMENT: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.declaration();
                        this.state = 0;
                        this.start = -1;
                    }
                }
            }
        }
        if (this.state != 0) {
            switch (this.state) {
                case 5: {
                    this.comment();
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.declaration();
                    break;
                }
                case 11: {
                    this.text();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.tag(false);
                    break;
                }
                case 12: {
                    this.tag(false);
                    break;
                }
                default: {
                    this.error();
                }
            }
        }
        return this.elements;
    }

    private TokenInfo tokenInfo() {
        return new TokenInfo(this.ts.offset(), this.token);
    }

    private static final class TokenInfo {
        public int offset;
        public Token token;

        public TokenInfo(int offset, Token token) {
            this.offset = offset;
            this.token = token;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TokenInfo other = (TokenInfo)obj;
            if (this.offset != other.offset) {
                return false;
            }
            return this.token == other.token || this.token != null && this.token.equals((Object)other.token);
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + this.offset;
            hash = 37 * hash + (this.token != null ? this.token.hashCode() : 0);
            return hash;
        }
    }

    public static enum Behaviour {
        DISABLE_STRUCTURE_CHECKS,
        DISABLE_ATTRIBUTES_CHECKS;

    }
}

