/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import org.ini4j.Config;
import org.ini4j.IniSource;
import org.ini4j.InvalidIniFormatException;
import org.ini4j.OptionHandler;
import org.ini4j.spi.EscapeTool;

public abstract class AbstractParser {
    private final String _comments;
    private Config _config = Config.getGlobal();
    private final String _operators;

    protected AbstractParser(String operators, String comments) {
        this._operators = operators;
        this._comments = comments;
    }

    public void setConfig(Config value) {
        this._config = value;
    }

    protected Config getConfig() {
        return this._config;
    }

    protected int indexOfOperator(String line) {
        int idx = -1;
        char[] arr$ = this._operators.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char c = arr$[i$];
            int index = line.indexOf(c);
            if (index < 0 || idx != -1 && index >= idx) continue;
            idx = index;
        }
        return idx;
    }

    protected void parseError(String line, int lineNumber) throws InvalidIniFormatException {
        throw new InvalidIniFormatException("parse error (at line: " + lineNumber + "): " + line);
    }

    protected void parseOptionLine(String line, OptionHandler handler, int lineNumber) throws InvalidIniFormatException {
        int idx = this.indexOfOperator(line);
        String name = null;
        String value = null;
        if (idx < 0) {
            if (this.getConfig().isEmptyOption()) {
                name = line;
            } else {
                this.parseError(line, lineNumber);
            }
        } else {
            name = this.unescape(line.substring(0, idx)).trim();
            value = this.unescape(line.substring(idx + 1)).trim();
        }
        if (name.length() == 0) {
            this.parseError(line, lineNumber);
        }
        if (this.getConfig().isLowerCaseOption()) {
            name = name.toLowerCase(Locale.getDefault());
        }
        handler.handleOption(name, value);
    }

    protected String unescape(String line) {
        return this.getConfig().isEscape() ? EscapeTool.getInstance().unescape(line) : line;
    }

    IniSource newIniSource(InputStream input) {
        return new IniSource(input, this.getConfig().isInclude(), this._comments);
    }

    IniSource newIniSource(Reader input) {
        return new IniSource(input, this.getConfig().isInclude(), this._comments);
    }

    IniSource newIniSource(URL input) throws IOException {
        return new IniSource(input, this.getConfig().isInclude(), this._comments);
    }
}

