/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.tools.ant.BuildException;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.WebdavException;
import org.apache.webdav.lib.methods.CopyMethod;
import org.apache.webdav.lib.methods.LockMethod;
import org.apache.webdav.lib.methods.MkcolMethod;
import org.apache.webdav.lib.methods.MoveMethod;
import org.apache.webdav.lib.methods.PropFindMethod;
import org.apache.webdav.lib.methods.UnlockMethod;
import org.apache.webdav.lib.properties.ResourceTypeProperty;

public class Utils {
    public static final String DAV_NAMESPACE = "DAV:";
    public static final PropertyName DISPLAYNAME = new PropertyName("DAV:", "displayname");
    public static final PropertyName GETLASTMODIFIED = new PropertyName("DAV:", "getlastmodified");
    public static final DateFormat GETLASTMODIFIED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy kk:mm:ss z", Locale.US);
    public static final PropertyName RESOURCETYPE = new PropertyName("DAV:", "resourcetype");

    public static Property findProperty(PropFindMethod propFind, PropertyName name, String path) {
        Enumeration e = propFind.getResponseProperties(path);
        Property p = Utils.findProperty(e, name);
        if (p == null && path.endsWith("/")) {
            e = propFind.getResponseProperties(path.substring(0, path.length() - 1));
            p = Utils.findProperty(e, name);
        }
        return p;
    }

    public static Property findProperty(Enumeration e, PropertyName name) {
        while (e.hasMoreElements()) {
            Property p = (Property)e.nextElement();
            if (!p.getNamespaceURI().equals(name.getNamespaceURI()) || !p.getLocalName().equals(name.getLocalName())) continue;
            return p;
        }
        return null;
    }

    public static boolean resourceExists(HttpClient client, HttpURL httpURL) throws IOException, HttpException {
        HeadMethod head = new HeadMethod(httpURL.getURI());
        head.setFollowRedirects(true);
        int status = client.executeMethod((HttpMethod)head);
        switch (status) {
            case 200: {
                return true;
            }
            case 404: {
                return false;
            }
        }
        HttpException ex = new HttpException();
        ex.setReasonCode(status);
        ex.setReason(head.getStatusText());
        throw ex;
    }

    public static boolean collectionExists(HttpClient client, HttpURL httpURL) throws IOException, HttpException {
        Vector<PropertyName> props = new Vector<PropertyName>(1);
        props.add(RESOURCETYPE);
        PropFindMethod propFind = new PropFindMethod(httpURL.getURI(), 0, 0);
        propFind.setFollowRedirects(true);
        propFind.setPropertyNames(props.elements());
        int status = client.executeMethod((HttpMethod)propFind);
        switch (status) {
            case 207: {
                Property p = Utils.findProperty(propFind, RESOURCETYPE, httpURL.getPath());
                if (p instanceof ResourceTypeProperty) {
                    return ((ResourceTypeProperty)p).isCollection();
                }
                throw new WebdavException("PROPFFIND does not return resourcetype");
            }
            case 404: {
                return false;
            }
        }
        HttpException ex = new HttpException();
        ex.setReasonCode(status);
        ex.setReason(propFind.getStatusText());
        throw ex;
    }

    public static long getLastModified(HttpClient client, HttpURL url) throws IOException, HttpException {
        Vector<PropertyName> props = new Vector<PropertyName>(1);
        props.add(GETLASTMODIFIED);
        PropFindMethod propFind = new PropFindMethod(url.getURI(), 0);
        propFind.setPropertyNames(props.elements());
        propFind.setFollowRedirects(true);
        int status = client.executeMethod((HttpMethod)propFind);
        switch (status) {
            case 207: {
                Property p = Utils.findProperty(propFind, GETLASTMODIFIED, url.getPath());
                if (p != null) {
                    try {
                        Date d = GETLASTMODIFIED_FORMAT.parse(p.getPropertyAsString());
                        return d.getTime();
                    }
                    catch (ParseException e) {
                        throw new HttpException("Invalid lastmodified property: " + p.getPropertyAsString());
                    }
                }
                throw new HttpException("PROPFIND does not return lastmodified.");
            }
        }
        HttpException ex = new HttpException();
        ex.setReasonCode(status);
        ex.setReason(propFind.getStatusText());
        throw ex;
    }

    public static boolean assureExistingCollection(HttpClient client, HttpURL httpURL, String lockToken) throws IOException, HttpException {
        boolean created;
        HttpURL parent;
        String path = httpURL.getPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        Stack<String> toBeCreated = new Stack<String>();
        while (!path.equals("/") && !Utils.collectionExists(client, parent = Utils.createHttpURL(httpURL, path))) {
            toBeCreated.push(path);
            path = path.substring(0, path.lastIndexOf("/", path.length() - 2) + 1);
        }
        boolean bl = created = !toBeCreated.empty();
        while (!toBeCreated.empty()) {
            HttpURL newColl = Utils.createHttpURL(httpURL, (String)toBeCreated.pop());
            MkcolMethod mkcol = new MkcolMethod(newColl.getURI());
            mkcol.setFollowRedirects(true);
            Utils.generateIfHeader((HttpMethod)mkcol, lockToken);
            int status = client.executeMethod((HttpMethod)mkcol);
            if (status == 201) continue;
            HttpException ex = new HttpException("Can't create collection " + newColl);
            ex.setReasonCode(status);
            ex.setReason(mkcol.getStatusText());
            throw ex;
        }
        return created;
    }

    public static void putFile(HttpClient client, HttpURL url, InputStream is, String contentType, String lockToken) throws IOException, HttpException {
        PutMethod put = new PutMethod(url.getURI());
        Utils.generateIfHeader((HttpMethod)put, lockToken);
        put.setRequestHeader("Content-Type", contentType);
        put.setRequestBody(is);
        put.setFollowRedirects(true);
        int status = client.executeMethod((HttpMethod)put);
        switch (status) {
            case 200: 
            case 201: 
            case 204: {
                return;
            }
        }
        HttpException ex = new HttpException();
        ex.setReason(put.getStatusText());
        ex.setReasonCode(status);
        throw ex;
    }

    public static InputStream getFile(HttpClient client, HttpURL url) throws IOException, HttpException {
        GetMethod get = new GetMethod(url.toString());
        get.setFollowRedirects(true);
        int status = client.executeMethod((HttpMethod)get);
        switch (status) {
            case 200: {
                return get.getResponseBodyAsStream();
            }
        }
        HttpException ex = new HttpException();
        ex.setReason(get.getStatusText());
        ex.setReasonCode(status);
        throw ex;
    }

    public static void generateIfHeader(HttpMethod method, String lockToken) {
        if (lockToken != null) {
            Header ifHeader = new Header();
            ifHeader.setName("If");
            ifHeader.setValue("(<" + lockToken + ">)");
            method.addRequestHeader(ifHeader);
        }
    }

    public static String lockResource(HttpClient client, HttpURL url, String ownerInfo, int depth, int timeout) throws IOException, HttpException {
        LockMethod lock = new LockMethod(url.getURI());
        lock.setDepth(depth);
        lock.setTimeout(timeout);
        lock.setOwner(ownerInfo);
        lock.setFollowRedirects(true);
        int status = client.executeMethod((HttpMethod)lock);
        if (status == 200) {
            Header header = lock.getResponseHeader("Lock-Token");
            if (header != null) {
                String l = header.getValue();
                return l.substring(1, l.length() - 1);
            }
            String l = lock.getLockToken();
            if (l != null) {
                return l;
            }
            throw new WebdavException("LOCK does not provide a lock token.");
        }
        if (status == 207) {
            throw Utils.makeBuildException("Can't lock", lock.getResponses());
        }
        throw Utils.makeBuildException("Can't lock", status, lock.getStatusText());
    }

    public static void unlockResource(HttpClient client, HttpURL url, String lockToken) throws IOException, HttpException {
        UnlockMethod unlock = new UnlockMethod(url.getURI(), lockToken);
        unlock.setFollowRedirects(true);
        int status = client.executeMethod((HttpMethod)unlock);
        switch (status) {
            case 200: 
            case 204: {
                return;
            }
        }
        HttpException ex = new HttpException();
        ex.setReasonCode(status);
        ex.setReason(unlock.getStatusText());
        throw ex;
    }

    public static void copyResource(HttpClient client, HttpURL url, String destination, int depth, boolean overwrite) throws IOException, HttpException {
        CopyMethod copy = new CopyMethod(url.getURI(), destination, overwrite, depth);
        copy.setFollowRedirects(true);
        int status = client.executeMethod((HttpMethod)copy);
        switch (status) {
            case 200: 
            case 201: 
            case 204: {
                return;
            }
        }
        HttpException ex = new HttpException();
        ex.setReasonCode(status);
        ex.setReason(copy.getStatusText());
        throw ex;
    }

    public static void moveResource(HttpClient client, HttpURL url, String destination, boolean overwrite) throws IOException, HttpException {
        MoveMethod move = new MoveMethod(url.getURI(), destination, overwrite);
        move.setFollowRedirects(true);
        int status = client.executeMethod((HttpMethod)move);
        switch (status) {
            case 200: 
            case 201: 
            case 204: {
                return;
            }
        }
        HttpException ex = new HttpException();
        ex.setReasonCode(status);
        ex.setReason(move.getStatusText());
        throw ex;
    }

    public static BuildException makeBuildException(String msg, Exception e) {
        if (e instanceof HttpException) {
            HttpException he = (HttpException)e;
            return new BuildException(msg + " " + e.getMessage() + " (" + (he.getReason() != null ? he.getReason() : HttpStatus.getStatusText((int)he.getReasonCode())) + ")");
        }
        return new BuildException(msg + " (" + e.toString() + ")", (Throwable)e);
    }

    public static BuildException makeBuildException(String msg, int status) {
        return new BuildException(msg + " (" + HttpStatus.getStatusText((int)status) + ")");
    }

    public static BuildException makeBuildException(String msg, int status, String statusText) {
        return new BuildException(msg + " (" + status + ", " + statusText + ")");
    }

    public static BuildException makeBuildException(String msg, Enumeration enumOfResponseEntities) {
        StringBuffer b = new StringBuffer();
        b.append(msg).append("\n");
        while (enumOfResponseEntities.hasMoreElements()) {
            ResponseEntity e = (ResponseEntity)enumOfResponseEntities.nextElement();
            b.append(e.getHref()).append(" ").append(HttpStatus.getStatusText((int)e.getStatusCode())).append("\n");
        }
        return new BuildException(b.toString());
    }

    public static HttpURL createHttpURL(HttpURL base, String relative) throws URIException {
        if (base instanceof HttpsURL) {
            return new HttpsURL((HttpsURL)base, relative);
        }
        return new HttpURL(base, relative);
    }

    public static HttpURL createHttpURL(String url) throws URIException {
        if (url.startsWith("https://")) {
            return new HttpsURL(url);
        }
        return new HttpURL(url);
    }
}

