/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.windows.OutputListener;

public final class OutputProcessor {
    public static final Logger LOGGER = Logger.getLogger(OutputListener.class.getName());

    public static boolean open(final FileObject fo, final int lineno) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OutputProcessor.open(fo, lineno);
                }
            });
            return true;
        }
        try {
            OpenCookie oc;
            StyledDocument doc;
            DataObject od = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
            LineCookie lc = (LineCookie)od.getCookie(LineCookie.class);
            if (ec != null && lc != null && (doc = ec.openDocument()) != null) {
                int line = lineno;
                if (line < 1) {
                    line = 1;
                }
                try {
                    Line.Set lines = lc.getLineSet();
                    Line l = lines.getCurrent(line - 1);
                    if (l != null) {
                        l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        return true;
                    }
                }
                catch (IndexOutOfBoundsException ioobe) {
                    // empty catch block
                }
            }
            if ((oc = (OpenCookie)od.getCookie(OpenCookie.class)) != null) {
                oc.open();
                return true;
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return false;
    }
}

