/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class ExecutionUtils {
    private static final Logger LOGGER = Logger.getLogger(ExecutionUtils.class.getName());
    private static final Pattern[] LOCATION_RECOGNIZER_PATTERNS = new Pattern[]{RubyLineConvertorFactory.RAILS_RECOGNIZER, RubyLineConvertorFactory.RUBY_COMPILER_WIN_MY, RubyLineConvertorFactory.JRUBY_COMPILER, RubyLineConvertorFactory.RUBY_COMPILER, RubyLineConvertorFactory.RUBY_COMPILER_WIN};
    private static final boolean SYNC_RUBY_STDIO = System.getProperty("ruby.no.sync-stdio") == null;
    private static final boolean SKIP_KCODE = Boolean.getBoolean("ruby.no.kcode");
    private static final boolean LAUNCH_JRUBY_SCRIPT = System.getProperty("ruby.use.jruby.script") != null;

    private ExecutionUtils() {
    }

    public static boolean launchJRubyScript() {
        return LAUNCH_JRUBY_SCRIPT;
    }

    public static List<? extends String> getRubyArgs(RubyPlatform platform) {
        RubyExecutionDescriptor desc = new RubyExecutionDescriptor(platform);
        return ExecutionUtils.getRubyArgs(platform.getHome().getAbsolutePath(), platform.getInterpreterFile().getName(), desc, null);
    }

    static List<? extends String> getRubyArgs(String rubyHome, String cmdName, RubyExecutionDescriptor descriptor, String charsetName) {
        int dot;
        ArrayList<String> argvList = new ArrayList<String>();
        if (!ExecutionUtils.launchJRubyScript() && cmdName.startsWith("jruby")) {
            String[] jvmArgs;
            String javaHome = ExecutionUtils.getJavaHome();
            argvList.add(javaHome + File.separator + "bin" + File.separator + "java");
            argvList.add("-Xverify:none");
            argvList.add("-da");
            String javaMemory = "-Xmx512m";
            String javaStack = "-Xss1024k";
            String jvmMode = "-client";
            String[] stringArray = jvmArgs = descriptor == null ? null : descriptor.getJVMArguments();
            if (jvmArgs != null) {
                for (String arg : jvmArgs) {
                    if (arg.contains("-Xmx")) {
                        javaMemory = null;
                    }
                    if (arg.contains("-Xss")) {
                        javaStack = null;
                    }
                    if ("-client".equals(arg) || "-server".equals(arg)) {
                        jvmMode = null;
                    }
                    argvList.add(arg);
                }
            }
            if (jvmMode != null) {
                argvList.add(1, jvmMode);
            }
            if (javaMemory != null) {
                argvList.add(javaMemory);
            }
            if (javaStack != null) {
                argvList.add(javaStack);
            }
            argvList.add("-classpath");
            File rubyHomeDir = null;
            try {
                rubyHomeDir = new File(rubyHome);
                rubyHomeDir = rubyHomeDir.getCanonicalFile();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            if (!rubyHomeDir.isDirectory()) {
                throw new IllegalArgumentException(rubyHomeDir.getAbsolutePath() + " does not exist.");
            }
            File jrubyLib = new File(rubyHomeDir, "lib");
            if (!jrubyLib.isDirectory()) {
                throw new AssertionError((Object)('\"' + jrubyLib.getAbsolutePath() + "\" exists (\"" + descriptor.getCmd() + "\" is not valid JRuby executable?)"));
            }
            argvList.add(ExecutionUtils.computeJRubyClassPath(descriptor == null ? null : descriptor.getClassPath(), jrubyLib));
            argvList.add("-Djruby.base=" + rubyHomeDir);
            argvList.add("-Djruby.home=" + rubyHomeDir);
            argvList.add("-Djruby.lib=" + jrubyLib);
            if (Utilities.isWindows()) {
                argvList.add("-Djruby.shell=\"cmd.exe\"");
                argvList.add("-Djruby.script=jruby.bat");
            } else {
                argvList.add("-Djruby.shell=/bin/sh");
                argvList.add("-Djruby.script=jruby");
            }
            argvList.add("org.jruby.Main");
        }
        if (!SKIP_KCODE && cmdName.startsWith("ruby")) {
            Charset charset;
            FileObject fo;
            String cs = charsetName;
            if (cs == null && (fo = descriptor.getFileObject()) != null && (charset = FileEncodingQuery.getEncoding((FileObject)fo)) != null) {
                cs = charset.name();
            }
            if (cs != null && cs.equals("UTF-8")) {
                argvList.add("-Ku");
            }
        }
        if (SYNC_RUBY_STDIO && cmdName.startsWith("ruby") && ((dot = cmdName.indexOf(46)) == -1 || dot == 4 || dot == 5)) {
            InstalledFileLocator locator = InstalledFileLocator.getDefault();
            File f = locator.locate("modules/org-netbeans-modules-ruby-project.jar", null, false);
            if (f == null) {
                throw new RuntimeException("Can't find cluster");
            }
            f = new File(f.getParentFile().getParentFile().getAbsolutePath() + File.separator + "sync-stdio.rb");
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            argvList.add("-r" + f.getAbsolutePath());
        }
        return argvList;
    }

    public static String getExtraClassPath(String extraCp) {
        if (extraCp != null && File.pathSeparatorChar != ':') {
            StringBuilder p = new StringBuilder();
            int pathOffset = 0;
            for (int i = 0; i < extraCp.length(); ++i) {
                char c = extraCp.charAt(i);
                if (c == ':' && pathOffset != 1) {
                    p.append(File.pathSeparatorChar);
                    pathOffset = 0;
                    continue;
                }
                ++pathOffset;
                p.append(c);
            }
            return p.toString();
        }
        return extraCp;
    }

    static String computeJRubyClassPath(String extraCp, File jrubyLib) {
        File[] libs;
        StringBuilder cp = new StringBuilder();
        for (File lib : libs = jrubyLib.listFiles()) {
            if (!lib.getName().endsWith(".jar")) continue;
            if (cp.length() > 0) {
                cp.append(File.pathSeparatorChar);
            }
            cp.append(lib.getAbsolutePath());
        }
        if ((extraCp = ExecutionUtils.getExtraClassPath(extraCp)) == null) {
            extraCp = System.getenv("JRUBY_EXTRA_CLASSPATH");
        }
        if (extraCp != null) {
            if (cp.length() > 0) {
                cp.append(File.pathSeparatorChar);
            }
            cp.append(extraCp);
        }
        return Utilities.isWindows() ? "\"" + cp.toString() + "\"" : cp.toString();
    }

    public static void setupProcessEnvironment(Map<String, String> env, String pwd, boolean appendJdkToPath) {
        String currentPath;
        String path = pwd;
        if (!Utilities.isWindows()) {
            path = path.replace(" ", "\\ ");
        }
        String pathName = "PATH";
        if (Utilities.isWindows()) {
            pathName = "Path";
            for (String key : env.keySet()) {
                if (!"PATH".equals(key.toUpperCase())) continue;
                pathName = key;
                break;
            }
        }
        if ((currentPath = env.get(pathName)) == null) {
            currentPath = "";
        }
        currentPath = path + File.pathSeparator + currentPath;
        if (appendJdkToPath) {
            String jdkHome = System.getProperty("jruby.java.home");
            if (jdkHome == null) {
                jdkHome = System.getProperty("jdk.home");
            }
            String jdkBin = jdkHome + File.separator + "bin";
            if (!Utilities.isWindows()) {
                jdkBin = jdkBin.replace(" ", "\\ ");
            }
            currentPath = currentPath + File.pathSeparator + jdkBin;
        }
        env.put(pathName, currentPath);
    }

    public static String getJavaHome() {
        String javaHome = System.getProperty("jruby.java.home");
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
        }
        return javaHome;
    }

    public static void logProcess(ProcessBuilder pb) {
        if (LOGGER.isLoggable(Level.FINE)) {
            File dir = pb.directory();
            String basedir = dir == null ? "" : "(basedir: " + dir.getAbsolutePath() + ") ";
            LOGGER.fine("Running: " + basedir + '\"' + ExecutionUtils.getProcessAsString(pb.command()) + '\"');
            LOGGER.fine("Environment: " + pb.environment());
        }
    }

    private static String getProcessAsString(List<? extends String> process) {
        StringBuilder sb = new StringBuilder();
        for (String string : process) {
            sb.append(string).append(' ');
        }
        return sb.toString().trim();
    }

    public static ThreadFactory namedThreadFactory(String namePrefix) {
        return new NamedThreadFactory(namePrefix);
    }

    public static FileLocation getLocation(String line) {
        boolean fileGroup = true;
        int lineGroup = 2;
        if (line.length() > 400) {
            return null;
        }
        for (Pattern pattern : LOCATION_RECOGNIZER_PATTERNS) {
            Matcher match = pattern.matcher(line);
            if (!match.matches()) continue;
            String file = null;
            int lineno = -1;
            file = match.group(1);
            if (file.startsWith("\"")) {
                file = file.substring(1);
            }
            if (file.startsWith("./")) {
                file = file.substring(2);
            }
            if (!RubyLineConvertorFactory.EXT_RE.matcher(file).matches() && !new File(file).isFile()) {
                return null;
            }
            String linenoStr = match.group(2);
            try {
                lineno = Integer.parseInt(linenoStr);
            }
            catch (NumberFormatException nfe) {
                Exceptions.printStackTrace((Throwable)nfe);
                lineno = 0;
            }
            return new FileLocation(file, lineno);
        }
        return null;
    }

    public static final class FileLocation {
        public final String file;
        public final int line;

        public FileLocation(String file, int line) {
            this.file = file;
            this.line = line;
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadFactory delegate;
        private final String namePrefix;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public NamedThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            this.delegate = Executors.defaultThreadFactory();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread result = this.delegate.newThread(r);
            result.setName(this.namePrefix + "-" + this.threadNumber.getAndIncrement());
            return result;
        }
    }
}

