/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.LinkedHashSet;
import java.util.List;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.ReturnNode;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RDocAnalyzer;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyMethodTypeInferencer;
import org.netbeans.modules.ruby.RubyPredefinedVariable;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeAnalyzer;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.options.TypeInferenceSettings;

public final class RubyTypeInferencer {
    private final ContextKnowledge knowledge;
    private RubyTypeAnalyzer analyzer;
    private final boolean fast;

    public static RubyTypeInferencer create(ContextKnowledge knowledge) {
        return new RubyTypeInferencer(knowledge, true);
    }

    public static RubyTypeInferencer create(ContextKnowledge knowledge, boolean fast) {
        return new RubyTypeInferencer(knowledge, fast);
    }

    private RubyTypeInferencer(ContextKnowledge knowledge, boolean fast) {
        assert (knowledge != null) : "need ContextKnowledge for RubyTypeAnalyzer";
        this.knowledge = knowledge;
        this.fast = fast;
        this.analyzer = new RubyTypeAnalyzer(knowledge, this);
    }

    public RubyType inferType(String symbol) {
        String n;
        this.analyzer.analyze();
        RubyType type = this.knowledge.getType(symbol);
        if (type == null || !type.isKnown()) {
            type = this.knowledge.getType(RubyTypeInferencer.getLocalVarPath(new AstPath(this.knowledge.getRoot(), this.knowledge.getTarget()), symbol));
        }
        if (!type.isKnown() && "t".equals(symbol) && this.knowledge.getRoot().getNodeType() == NodeType.DEFSNODE && ("up".equals(n = AstUtilities.getName(this.knowledge.getRoot())) || "down".equals(n))) {
            return RubyType.create("ActiveRecord::ConnectionAdapters::TableDefinition");
        }
        if (type.isKnown()) {
            for (String realType : type.getRealTypes()) {
                if (!realType.startsWith("Array<")) continue;
                return RubyType.ARRAY;
            }
        }
        return type;
    }

    static String getLocalVarPath(Node root, Node target, String currentMethod) {
        String varName = AstUtilities.getName(target);
        if (currentMethod != null) {
            return currentMethod + "/" + varName;
        }
        return RubyTypeInferencer.getLocalVarPath(new AstPath(root, target), varName);
    }

    private static String getLocalVarPath(AstPath path, String varName) {
        MethodDefNode methodNode = AstUtilities.findMethod(path);
        if (methodNode != null) {
            return AstUtilities.getName((Node)methodNode) + "/" + varName;
        }
        return varName;
    }

    RubyType inferTypesOfRHS(Node node) {
        return this.inferTypesOfRHS(node, null);
    }

    RubyType inferTypesOfRHS(Node node, String currentMethod) {
        List children = node.childNodes();
        if (children.size() != 1) {
            return RubyType.unknown();
        }
        return this.inferType((Node)children.get(0), currentMethod);
    }

    RubyType inferType(Node node) {
        return this.inferType(node, null);
    }

    private RubyType inferType(Node node, String currentMethod) {
        RubyType type = this.knowledge.getType(node);
        if (type != null) {
            return type;
        }
        if (!this.knowledge.wasAnalyzed()) {
            this.analyzer.analyze();
        }
        switch (node.getNodeType()) {
            case LOCALVARNODE: {
                type = this.knowledge.getType(RubyTypeInferencer.getLocalVarPath(this.knowledge.getRoot(), node, currentMethod));
                break;
            }
            case GLOBALVARNODE: {
                RubyType preDefType;
                String name = AstUtilities.getName(node);
                type = this.knowledge.getType(name);
                if (type.isKnown() || (preDefType = RubyPredefinedVariable.getType(name)) == null) break;
                type = preDefType;
                break;
            }
            case DVARNODE: 
            case INSTVARNODE: 
            case CLASSVARNODE: {
                type = this.knowledge.getType(AstUtilities.getName(node));
                break;
            }
            case CONSTNODE: {
                String fqn = AstUtilities.getFqnName(this.knowledge.getRoot(), node);
                type = this.knowledge.getType(fqn);
                break;
            }
            case COLON2NODE: {
                type = this.knowledge.getType(AstUtilities.getFqn((Colon2Node)node));
                break;
            }
            case RETURNNODE: {
                ReturnNode retNode = (ReturnNode)node;
                type = this.inferType(retNode.getValueNode(), currentMethod);
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                MethodDefNode methodDefNode = (MethodDefNode)node;
                currentMethod = methodDefNode.getName();
                type = this.inferMethodNode(methodDefNode);
                break;
            }
            case ITERNODE: {
                type = this.inferIterNode((IterNode)node, currentMethod);
                break;
            }
            case SELFNODE: {
                type = this.inferSelf(node);
                break;
            }
            case SUPERNODE: 
            case ZSUPERNODE: {
                type = this.inferSuperNode(node);
            }
        }
        if (type == null && AstUtilities.isCall(node)) {
            type = RubyMethodTypeInferencer.inferTypeFor(node, this.knowledge, this.fast);
        }
        if (type == null) {
            type = RubyTypeInferencer.getTypeForLiteral(node);
        }
        this.knowledge.setType(node, type);
        return type;
    }

    private RubyType inferSuperNode(Node node) {
        RubyIndex index;
        RubyType selfType = this.inferSelf(node);
        if (selfType == null || !selfType.isKnown()) {
            return RubyType.unknown();
        }
        MethodDefNode methodDefNode = AstUtilities.findMethod(new AstPath(this.knowledge.getRoot(), node));
        if (methodDefNode != null && TypeInferenceSettings.getDefault().getMethodTypeInference() && (index = this.knowledge.getIndex()) != null) {
            RubyType resultType = new RubyType();
            for (String each : selfType.getRealTypes()) {
                IndexedMethod method = index.getSuperMethod(each, methodDefNode.getName(), true);
                if (method == null) continue;
                resultType.append(method.getType());
            }
            return resultType;
        }
        return RubyType.unknown();
    }

    private RubyType inferSelf(Node node) {
        Node root = this.knowledge.getRoot();
        AstPath path = new AstPath(root, node);
        IScopingNode clazz = AstUtilities.findClassOrModule(path);
        if (clazz == null) {
            return null;
        }
        return RubyType.create(AstUtilities.getClassOrModuleName(clazz));
    }

    private RubyType inferIterNode(IterNode iterNode, String currentMethod) {
        Node body = iterNode.getBodyNode();
        RubyType result = new RubyType();
        if (body != null) {
            LinkedHashSet exits = new LinkedHashSet();
            AstUtilities.findExitPoints(body, exits);
            for (Node exit : exits) {
                result.append(this.inferType(exit, currentMethod));
            }
        }
        return result;
    }

    private RubyType inferMethodNode(MethodDefNode methodDefNode) {
        RubyType type;
        List<String> rdocs;
        String name = methodDefNode.getName();
        RubyType fastType = RubyMethodTypeInferencer.fastCheckType(name);
        if (fastType == null && RubyMethodTypeInferencer.returnsReceiver(name)) {
            fastType = this.inferSelf((Node)methodDefNode);
        }
        if (fastType != null) {
            return fastType;
        }
        if (TypeInferenceSettings.getDefault().getRdocTypeInference() && (rdocs = AstUtilities.gatherDocumentation(this.knowledge.getParserResult().getSnapshot(), (Node)methodDefNode)) != null && (type = RDocAnalyzer.collectTypesFromComment(rdocs)) != null && type.isKnown()) {
            return type;
        }
        RubyType result = new RubyType();
        LinkedHashSet exits = new LinkedHashSet();
        AstUtilities.findExitPoints(methodDefNode, exits);
        for (Node exit : exits) {
            if (AstUtilities.isRaiseCall(exit)) continue;
            result.append(this.inferType(exit, name));
        }
        return result;
    }

    static RubyType getTypeForLiteral(Node node) {
        switch (node.getNodeType()) {
            case ARRAYNODE: 
            case ZARRAYNODE: {
                return RubyType.ARRAY;
            }
            case DEFINEDNODE: 
            case STRNODE: 
            case DSTRNODE: 
            case XSTRNODE: 
            case DXSTRNODE: {
                return RubyType.STRING;
            }
            case FIXNUMNODE: {
                return RubyType.FIXNUM;
            }
            case BIGNUMNODE: {
                return RubyType.BIGNUM;
            }
            case HASHNODE: {
                return RubyType.HASH;
            }
            case REGEXPNODE: 
            case DREGEXPNODE: {
                return RubyType.REGEXP;
            }
            case SYMBOLNODE: 
            case DSYMBOLNODE: {
                return RubyType.SYMBOL;
            }
            case FLOATNODE: {
                return RubyType.FLOAT;
            }
            case NILNODE: {
                if (node.isInvisible()) break;
                return RubyType.NIL_CLASS;
            }
            case SCLASSNODE: 
            case UNDEFNODE: 
            case UNTILNODE: {
                return RubyType.NIL_CLASS;
            }
            case NOTNODE: {
                return RubyType.BOOLEAN;
            }
            case TRUENODE: {
                return RubyType.TRUE_CLASS;
            }
            case FALSENODE: {
                return RubyType.FALSE_CLASS;
            }
            case DOTNODE: {
                return RubyType.RANGE;
            }
            case BACKREFNODE: 
            case NTHREFNODE: {
                return new RubyType(RubyType.STRING, RubyType.NIL_CLASS);
            }
        }
        return RubyType.unknown();
    }

    public String toString() {
        return "RubyTypeAnalyzer[knowledge:" + this.knowledge + ']';
    }
}

