/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.BackRefNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassVarAsgnNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DVarNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.NthRefNode;
import org.jrubyparser.ast.ReturnNode;
import org.jrubyparser.ast.SelfNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.VCallNode;
import org.jrubyparser.ast.YieldNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.filesystems.FileObject;

public class RubyOccurrencesFinder
extends OccurrencesFinder {
    private boolean cancelled;
    private int caretPosition;
    private Map<OffsetRange, ColoringAttributes> occurrences;
    private FileObject file;
    private Node root;
    private boolean ignoreAlias;

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.occurrences;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final synchronized void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run(Parser.Result info, SchedulerEvent event) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        currentFile = RubyUtils.getFileObject(info);
        if (currentFile != this.file) {
            this.occurrences = null;
            this.file = currentFile;
        }
        if ((rpr = AstUtilities.getParseResult(info)) == null) {
            return;
        }
        this.root = rpr.getRootNode();
        if (this.root == null) {
            return;
        }
        highlights = new HashMap<OffsetRange, ColoringAttributes>(100);
        astOffset = AstUtilities.getAstOffset(info, this.caretPosition);
        if (astOffset == -1) {
            return;
        }
        path = new AstPath(this.root, astOffset);
        closest = path.leaf();
        if (closest == null) {
            return;
        }
        blankRange = rpr.getSanitizedRange();
        if (blankRange.containsInclusive(astOffset)) {
            closest = null;
        }
        if (closest != null) {
            doc = RubyUtils.getDocument(info);
            if (doc == null) {
                return;
            }
            try {
                doc.readLock();
                length = doc.getLength();
                astRange = AstUtilities.getRange(closest);
                lexRange = LexUtilities.getLexerOffsets(info, astRange);
                lexStartPos = lexRange.getStart();
                lexEndPos = lexRange.getEnd();
                if (lexStartPos > length) {
                    lexStartPos = length;
                }
                if (lexEndPos > length) {
                    lexEndPos = length;
                }
                if (lexStartPos != -1 && lexEndPos != -1 && Utilities.getRowStart((BaseDocument)doc, (int)lexStartPos) != Utilities.getRowStart((BaseDocument)doc, (int)lexEndPos)) {
                    token = LexUtilities.getToken(doc, this.caretPosition);
                    if (token != null && token.id() != RubyTokenId.LINE_COMMENT && closest instanceof MethodDefNode && Utilities.getRowStart((BaseDocument)doc, (int)lexStartPos) == Utilities.getRowStart((BaseDocument)doc, (int)this.caretPosition)) {
                        this.highlightExits((MethodDefNode)closest, highlights, info);
                    }
                    if (!(closest instanceof LocalAsgnNode || closest instanceof FCallNode || closest instanceof DAsgnNode || closest instanceof InstAsgnNode || closest instanceof ClassVarDeclNode || closest instanceof ClassVarAsgnNode || closest instanceof GlobalAsgnNode || closest instanceof ConstDeclNode)) {
                        closest = null;
                    }
                }
            }
            catch (BadLocationException ble) {
            }
            finally {
                doc.readUnlock();
            }
        }
        if (closest != null) {
            if (closest instanceof LocalVarNode || closest instanceof LocalAsgnNode) {
                name = ((INameNode)closest).getName();
                method = AstUtilities.findLocalScope(closest, path);
                this.highlightLocal(method, name, highlights);
            } else if (closest instanceof DAsgnNode) {
                name = ((INameNode)closest).getName();
                applicableBlocks = AstUtilities.getApplicableBlocks(path, true);
                for (Node block : applicableBlocks) {
                    this.highlightDynamnic(block, name, highlights);
                }
            } else if (closest instanceof DVarNode) {
                name = ((DVarNode)closest).getName();
                applicableBlocks = AstUtilities.getApplicableBlocks(path, true);
                for (Node block : applicableBlocks) {
                    this.highlightDynamnic(block, name, highlights);
                }
            } else if (closest instanceof InstAsgnNode) {
                name = ((INameNode)closest).getName();
                this.highlightInstance(this.root, name, highlights);
            } else if (closest instanceof InstVarNode) {
                this.highlightInstance(this.root, ((INameNode)closest).getName(), highlights);
            } else if (closest instanceof ClassVarDeclNode || closest instanceof ClassVarAsgnNode) {
                name = ((INameNode)closest).getName();
                this.highlightClassVar(this.root, name, highlights);
            } else if (closest instanceof ClassVarNode) {
                this.highlightClassVar(this.root, ((ClassVarNode)closest).getName(), highlights);
            } else if (closest instanceof GlobalVarNode) {
                name = ((GlobalVarNode)closest).getName();
                this.highlightGlobal(this.root, name, highlights);
            } else if (closest instanceof BackRefNode) {
                name = "" + ((BackRefNode)closest).getType();
                this.highlightGlobal(this.root, name, highlights);
            } else if (closest instanceof NthRefNode) {
                name = "" + ((NthRefNode)closest).getMatchNumber();
                this.highlightGlobal(this.root, name, highlights);
            } else if (closest instanceof GlobalAsgnNode) {
                name = ((INameNode)closest).getName();
                this.highlightGlobal(this.root, name, highlights);
            } else if (closest instanceof FCallNode || closest instanceof VCallNode || closest instanceof CallNode) {
                name = ((INameNode)closest).getName();
                if ("raise".equals(name) || "fail".equals(name)) {
                    def = AstUtilities.findMethod(path);
                    if (def instanceof MethodDefNode) {
                        this.highlightExits(def, highlights, info);
                    }
                } else {
                    callArity = Arity.getCallArity(closest);
                    defArities = new ArrayList<Arity>();
                    this.findDefArities(defArities, this.root, name, callArity);
                    noMatchingDefs = defArities.isEmpty();
                    if (noMatchingDefs) {
                        defArities.add(callArity);
                    }
                    if (!name.equals("[]")) {
                        this.highlightMethod(this.root, name, defArities, highlights);
                    }
                    if (closest instanceof CallNode && ((CallNode)closest).getReceiverNode() instanceof SelfNode && noMatchingDefs && callArity.getMinArgs() == 0 && callArity.getMaxArgs() == 0) {
                        this.highlightInstance(this.root, "@" + name, highlights);
                    }
                }
            } else if (closest instanceof YieldNode || closest instanceof ReturnNode) {
                def = AstUtilities.findMethod(path);
                if (def instanceof MethodDefNode) {
                    this.highlightExits(def, highlights, info);
                }
            } else if (closest instanceof MethodDefNode) {
                range = AstUtilities.getFunctionNameRange(this.root);
                if (range.containsInclusive(astOffset)) {
                    name = ((MethodDefNode)closest).getName();
                    this.highlightMethod(this.root, name, Collections.singletonList(Arity.getDefArity(closest)), highlights);
                }
            } else if (closest instanceof Colon2Node) {
                highlights.put(AstUtilities.getRange(closest), ColoringAttributes.MARK_OCCURRENCES);
                this.highlightClass(this.root, ((INameNode)closest).getName(), highlights);
            } else if (closest instanceof ConstNode || closest instanceof ConstDeclNode) {
                this.highlightClass(this.root, ((INameNode)closest).getName(), highlights);
            } else if (closest instanceof SymbolNode) {
                name = ((INameNode)closest).getName();
                this.highlightInstance(this.root, "@" + name, highlights);
                this.highlightClassVar(this.root, "@@" + name, highlights);
                this.highlightMethod(this.root, name, Collections.singletonList(Arity.UNKNOWN), highlights);
                this.highlightClass(this.root, name, highlights);
            } else if (closest instanceof AliasNode) {
                an = (AliasNode)closest;
                newName = AstUtilities.getNameOrValue(an.getNewName());
                if (newName != null) {
                    newLength = newName.length();
                    aliasPos = an.getPosition().getStartOffset();
                    name = null;
                    if (astOffset > aliasPos + 6) {
                        if (astOffset > aliasPos + 6 + newLength) {
                            range = AstUtilities.getAliasOldRange(an);
                            highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
                            name = AstUtilities.getNameOrValue(an.getOldName());
                        } else {
                            range = AstUtilities.getAliasNewRange(an);
                            highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
                            name = AstUtilities.getNameOrValue(an.getNewName());
                        }
                    }
                    if (name != null) {
                        count = highlights.size();
                        method = AstUtilities.findLocalScope(closest, path);
                        this.ignoreAlias = true;
                        try {
                            this.highlightLocal(method, name, highlights);
                            if (highlights.size() != count) ** GOTO lbl200
                            applicableBlocks = AstUtilities.getApplicableBlocks(path, true);
                            for (Node block : applicableBlocks) {
                                this.highlightDynamnic(block, name, highlights);
                            }
                            if (highlights.size() != count) ** GOTO lbl200
                            this.highlightMethod(this.root, name, Collections.singletonList(Arity.UNKNOWN), highlights);
                            if (highlights.size() != count) ** GOTO lbl200
                            this.highlightInstance(this.root, name, highlights);
                            if (highlights.size() != count) ** GOTO lbl200
                            this.highlightGlobal(this.root, name, highlights);
                            if (highlights.size() != count) ** GOTO lbl200
                            this.highlightClass(this.root, name, highlights);
                            if (highlights.size() != count) ** GOTO lbl200
                            this.highlightClassVar(this.root, name, highlights);
                        }
                        finally {
                            this.ignoreAlias = false;
                        }
                    }
                }
            } else if (closest instanceof ArgumentNode) {
                name = ((ArgumentNode)closest).getName();
                parent = path.leafParent();
                if (parent != null) {
                    if (parent instanceof MethodDefNode) {
                        this.highlightExits((MethodDefNode)parent, highlights, info);
                    } else {
                        method = AstUtilities.findLocalScope(closest, path);
                        this.highlightLocal(method, name, highlights);
                    }
                }
            }
        }
lbl200:
        // 34 sources

        if (this.isCancelled()) {
            return;
        }
        if (highlights.size() > 0) {
            translated = new HashMap<OffsetRange, V>(2 * highlights.size());
            for (Map.Entry<K, V> entry : highlights.entrySet()) {
                range = LexUtilities.getLexerOffsets(info, (OffsetRange)entry.getKey());
                if (range == OffsetRange.NONE) continue;
                translated.put(range, entry.getValue());
            }
            highlights = translated;
            this.occurrences = highlights;
        } else {
            this.occurrences = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highlightExits(MethodDefNode node, Map<OffsetRange, ColoringAttributes> highlights, Parser.Result info) {
        BaseDocument doc = RubyUtils.getDocument(info);
        if (doc == null) {
            return;
        }
        try {
            doc.readLock();
            HashSet exits = new HashSet();
            AstUtilities.findExitPoints(node, exits);
            for (Node exit : exits) {
                if (exit.isInvisible()) continue;
                this.highlightExitPoint(exit, highlights, info);
            }
        }
        finally {
            doc.readUnlock();
        }
    }

    private void highlightExitPoint(Node node, Map<OffsetRange, ColoringAttributes> highlights, Parser.Result info) {
        if (node.getNodeType() == NodeType.RETURNNODE) {
            OffsetRange astRange = AstUtilities.getRange(node);
            BaseDocument doc = RubyUtils.getDocument(info);
            if (doc != null) {
                try {
                    int endLineStart;
                    int lineStart;
                    OffsetRange lexRange = LexUtilities.getLexerOffsets(info, astRange);
                    if (lexRange != OffsetRange.NONE && (lineStart = Utilities.getRowStart((BaseDocument)doc, (int)lexRange.getStart())) != (endLineStart = Utilities.getRowStart((BaseDocument)doc, (int)lexRange.getEnd()))) {
                        lexRange = new OffsetRange(lexRange.getStart(), Utilities.getRowEnd((BaseDocument)doc, (int)lexRange.getStart()));
                        astRange = AstUtilities.getAstOffsets(info, lexRange);
                    }
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
                highlights.put(astRange, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node.getNodeType() == NodeType.YIELDNODE) {
            OffsetRange range = AstUtilities.getRange(node);
            highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
        } else if (node instanceof FCallNode && (this.getFunctionName(node).equals("fail") || this.getFunctionName(node).equals("raise"))) {
            OffsetRange range = AstUtilities.getCallRange(node);
            highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
        } else {
            try {
                SourcePosition pos = node.getPosition();
                OffsetRange lexRange = LexUtilities.getLexerOffsets(info, new OffsetRange(pos.getStartOffset(), pos.getEndOffset()));
                if (lexRange != OffsetRange.NONE) {
                    BaseDocument doc = RubyUtils.getDocument(info);
                    if (Utilities.getRowStart((BaseDocument)doc, (int)lexRange.getStart()) != Utilities.getRowStart((BaseDocument)doc, (int)lexRange.getEnd())) {
                        int begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)lexRange.getStart());
                        int end = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)lexRange.getStart());
                        if (begin != -1 && end != -1) {
                            OffsetRange range = new OffsetRange(begin, end + 1);
                            highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
                        }
                    } else {
                        OffsetRange range = AstUtilities.getRangeIncludeNil(node);
                        highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
                    }
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
    }

    private void highlightLocal(Node node, String name, Map<OffsetRange, ColoringAttributes> highlights) {
        ArgsNode an;
        OffsetRange range;
        if (node instanceof LocalVarNode) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof LocalAsgnNode) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getLValueRange((AssignableNode)((LocalAsgnNode)node));
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof ArgsNode) {
            OffsetRange range2;
            ArgumentNode bn;
            an = (ArgsNode)node;
            if (an.getRequiredCount() > 0) {
                List args = an.childNodes();
                for (Node arg : args) {
                    if (!(arg instanceof ListNode)) continue;
                    List args2 = arg.childNodes();
                    for (Node arg2 : args2) {
                        OffsetRange range3;
                        if (arg2 instanceof ArgumentNode) {
                            if (!((ArgumentNode)arg2).getName().equals(name)) continue;
                            range3 = AstUtilities.getRange(arg2);
                            highlights.put(range3, ColoringAttributes.MARK_OCCURRENCES);
                            continue;
                        }
                        if (!(arg2 instanceof LocalAsgnNode) || !((LocalAsgnNode)arg2).getName().equals(name)) continue;
                        range3 = AstUtilities.getNameRange(arg2);
                        highlights.put(range3, ColoringAttributes.MARK_OCCURRENCES);
                    }
                }
            }
            if (an.getRest() != null && (bn = an.getRest()).getName().equals(name)) {
                range2 = AstUtilities.getRange((Node)bn);
                highlights.put(range2, ColoringAttributes.MARK_OCCURRENCES);
            }
            if (an.getBlock() != null && (bn = an.getBlock()).getName().equals(name)) {
                range2 = AstUtilities.getRange((Node)bn);
                highlights.put(range2, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            an = (AliasNode)node;
            RubyOccurrencesFinder.handleAliasNode((AliasNode)an, name, highlights);
        } else if (node instanceof SymbolNode && ((INameNode)node).getName().equals(name)) {
            range = AstUtilities.getRange(node);
            highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.highlightLocal(child, name, highlights);
        }
    }

    private void highlightDynamnic(Node node, String name, Map<OffsetRange, ColoringAttributes> highlights) {
        switch (node.getNodeType()) {
            case DVARNODE: {
                if (!((DVarNode)node).getName().equals(name)) break;
                OffsetRange range = AstUtilities.getRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
                break;
            }
            case DASGNNODE: {
                if (!((INameNode)node).getName().equals(name)) break;
                OffsetRange range = AstUtilities.getLValueRange((AssignableNode)((DAsgnNode)node));
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
                break;
            }
            case ALIASNODE: {
                if (this.ignoreAlias) break;
                AliasNode an = (AliasNode)node;
                RubyOccurrencesFinder.handleAliasNode(an, name, highlights);
            }
        }
        List list = node.childNodes();
        block8: for (Node child : list) {
            if (child.isInvisible()) continue;
            switch (child.getNodeType()) {
                case ITERNODE: 
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    continue block8;
                }
            }
            this.highlightDynamnic(child, name, highlights);
        }
    }

    private static void handleAliasNode(AliasNode alias, String name, Map<OffsetRange, ColoringAttributes> highlights) {
        String oldName = AstUtilities.getNameOrValue(alias.getOldName());
        String newName = AstUtilities.getNameOrValue(alias.getNewName());
        if (name.equals(newName)) {
            OffsetRange range = AstUtilities.getAliasNewRange(alias);
            highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
        } else if (name.equals(oldName)) {
            OffsetRange range = AstUtilities.getAliasOldRange(alias);
            highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
        }
    }

    private void highlightInstance(Node node, String name, Map<OffsetRange, ColoringAttributes> highlights) {
        String methodName;
        MethodDefNode method;
        CallNode callNode;
        Node receiver;
        OffsetRange range;
        if (node instanceof InstVarNode) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof InstAsgnNode) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getLValueRange((AssignableNode)((InstAsgnNode)node));
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            RubyOccurrencesFinder.handleAliasNode((AliasNode)node, name, highlights);
        } else if (AstUtilities.isAttr(node)) {
            SymbolNode[] symbols = AstUtilities.getAttrSymbols(node);
            for (int i = 0; i < symbols.length; ++i) {
                if (!name.equals("@" + symbols[i].getName())) continue;
                OffsetRange range2 = AstUtilities.getRange((Node)symbols[i]);
                highlights.put(range2, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof SymbolNode) {
            if (("@" + ((INameNode)node).getName()).equals(name)) {
                range = AstUtilities.getRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof CallNode && (receiver = (callNode = (CallNode)node).getReceiverNode()) != null && receiver instanceof SelfNode && (method = AstUtilities.findMethod(this.root, methodName = name.startsWith("@") ? name.substring(1) : name, Arity.getCallArity((Node)callNode))) == null && methodName.equals(callNode.getName())) {
            OffsetRange range3 = AstUtilities.getRange((Node)callNode);
            highlights.put(range3, ColoringAttributes.MARK_OCCURRENCES);
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.highlightInstance(child, name, highlights);
        }
    }

    private void highlightClassVar(Node node, String name, Map<OffsetRange, ColoringAttributes> highlights) {
        OffsetRange range;
        if (node instanceof ClassVarNode) {
            if (((ClassVarNode)node).getName().equals(name)) {
                range = AstUtilities.getRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof ClassVarDeclNode) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getLValueRange((AssignableNode)((ClassVarDeclNode)node));
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof ClassVarAsgnNode) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getLValueRange((AssignableNode)((ClassVarAsgnNode)node));
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            RubyOccurrencesFinder.handleAliasNode((AliasNode)node, name, highlights);
        } else if (node instanceof SymbolNode && ("@@" + ((INameNode)node).getName()).equals(name)) {
            range = AstUtilities.getRange(node);
            highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.highlightClassVar(child, name, highlights);
        }
    }

    private void highlightGlobal(Node node, String name, Map<OffsetRange, ColoringAttributes> highlights) {
        OffsetRange range;
        if (node instanceof GlobalVarNode) {
            if (((GlobalVarNode)node).getName().equals(name)) {
                range = AstUtilities.getRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof BackRefNode) {
            if (("" + ((BackRefNode)node).getType() + "").equals(name)) {
                range = AstUtilities.getRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof NthRefNode) {
            if (("" + ((NthRefNode)node).getMatchNumber()).equals(name)) {
                range = AstUtilities.getRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof GlobalAsgnNode) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getLValueRange((AssignableNode)((GlobalAsgnNode)node));
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            AliasNode an = (AliasNode)node;
            RubyOccurrencesFinder.handleAliasNode(an, name, highlights);
        } else if (node instanceof SymbolNode && ("$" + ((INameNode)node).getName()).equals(name)) {
            range = AstUtilities.getRange(node);
            highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.highlightGlobal(child, name, highlights);
        }
    }

    private void highlightMethod(Node node, String name, List<Arity> arities, Map<OffsetRange, ColoringAttributes> highlights) {
        OffsetRange range;
        if (node instanceof MethodDefNode && ((MethodDefNode)node).getName().equals(name)) {
            Arity defArity = Arity.getDefArity(node);
            for (Arity arity : arities) {
                if (!Arity.matches(arity, defArity)) continue;
                range = AstUtilities.getFunctionNameRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
                break;
            }
        } else if ((node instanceof FCallNode || node instanceof CallNode || node instanceof VCallNode) && ((INameNode)node).getName().equals(name)) {
            Arity callArity = Arity.getCallArity(node);
            for (Arity arity : arities) {
                if (!Arity.matches(callArity, arity)) continue;
                range = AstUtilities.getCallRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            AliasNode an = (AliasNode)node;
            RubyOccurrencesFinder.handleAliasNode(an, name, highlights);
        } else if (node instanceof SymbolNode && ((INameNode)node).getName().equals(name)) {
            OffsetRange range2 = AstUtilities.getRange(node);
            highlights.put(range2, ColoringAttributes.MARK_OCCURRENCES);
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.highlightMethod(child, name, arities, highlights);
        }
    }

    private void findDefArities(List<Arity> defArities, Node node, String name, Arity callArity) {
        Arity defArity;
        if (node instanceof MethodDefNode && ((MethodDefNode)node).getName().equals(name) && Arity.matches(callArity, defArity = Arity.getDefArity(node))) {
            defArities.add(defArity);
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.findDefArities(defArities, child, name, callArity);
        }
    }

    private void highlightClass(Node node, String name, Map<OffsetRange, ColoringAttributes> highlights) {
        OffsetRange range;
        if (node instanceof ConstNode) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof ConstDeclNode) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getLValueRange((AssignableNode)((ConstDeclNode)node));
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (node instanceof Colon2Node) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getRange(node);
                highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            AliasNode an = (AliasNode)node;
            RubyOccurrencesFinder.handleAliasNode(an, name, highlights);
        } else if (node instanceof SymbolNode && ((INameNode)node).getName().equals(name)) {
            range = AstUtilities.getRange(node);
            highlights.put(range, ColoringAttributes.MARK_OCCURRENCES);
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.highlightClass(child, name, highlights);
        }
    }

    public void setCaretPosition(int position) {
        this.caretPosition = position;
    }

    private String getFunctionName(Node node) {
        return ((FCallNode)node).getName();
    }

    public int getPriority() {
        return 200;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }
}

