/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.ImageIcon;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.elements.ClassElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.elements.IndexedVariable;
import org.netbeans.modules.ruby.elements.KeywordElement;
import org.openide.util.ImageUtilities;

class RubyCompletionItem
extends DefaultCompletionProposal {
    private static final boolean FORCE_COMPLETION_SPACES = Boolean.getBoolean("ruby.complete.spaces");
    protected final CompletionRequest request;
    protected final Element element;
    protected boolean symbol;

    RubyCompletionItem(Element element, int anchorOffset, CompletionRequest request) {
        this.element = element;
        this.anchorOffset = anchorOffset;
        this.request = request;
    }

    public String getName() {
        return this.element.getName();
    }

    public void setSymbol(boolean symbol) {
        this.symbol = symbol;
    }

    public String getInsertPrefix() {
        if (this.symbol) {
            return ":" + this.getName();
        }
        return this.getName();
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        IndexedVariable idx;
        String in;
        if (this.element.getKind() == ElementKind.GLOBAL && this.element instanceof IndexedVariable && (in = (idx = (IndexedVariable)this.element).getIn()) != null) {
            formatter.appendText(in);
            return formatter.getText();
        }
        return null;
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public String toString() {
        String cls = ((Object)((Object)this)).getClass().getName();
        cls = cls.substring(cls.lastIndexOf(46) + 1);
        return cls + "(" + this.getKind() + "): " + this.getName();
    }

    public String[] getParamListDelimiters() {
        return new String[]{"(", ")"};
    }

    private static boolean forceCompletionSpaces() {
        return FORCE_COMPLETION_SPACES;
    }

    static class VirtualFinderMethodItem
    extends MethodItem {
        private final String prefix;

        public VirtualFinderMethodItem(IndexedMethod element, int anchorOffset, CompletionRequest request, String prefix) {
            super(element, anchorOffset, request);
            this.prefix = prefix;
        }

        @Override
        protected boolean skipHashes() {
            return true;
        }

        @Override
        protected String getInsertSuffix() {
            return "";
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            boolean emphasize;
            ElementKind kind = this.getKind();
            boolean bl = emphasize = !this.method.isInherited();
            if (emphasize) {
                formatter.emphasis(true);
            }
            formatter.name(kind, true);
            formatter.appendText(this.prefix + "...");
            formatter.name(kind, false);
            if (emphasize) {
                formatter.emphasis(false);
            }
            return formatter.getText();
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            if (this.method.isTopLevel() && this.method.getRequire() != null) {
                formatter.appendText(this.method.getRequire());
                return formatter.getText();
            }
            String in = this.method.getIn();
            if (in != null) {
                formatter.appendText(in);
                return formatter.getText();
            }
            return null;
        }

        @Override
        public String getInsertPrefix() {
            return this.prefix;
        }
    }

    static class FinderMethodItem
    extends MethodItem {
        public FinderMethodItem(IndexedMethod element, int anchorOffset, CompletionRequest request) {
            super(element, anchorOffset, request);
        }

        @Override
        protected boolean skipHashes() {
            return true;
        }
    }

    static class MethodItem
    extends RubyCompletionItem {
        protected final IndexedMethod method;

        MethodItem(IndexedMethod element, int anchorOffset, CompletionRequest request) {
            super(element, anchorOffset, request);
            this.method = element;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            List<String> parameters;
            boolean emphasize;
            ElementKind kind = this.getKind();
            boolean bl = emphasize = !this.method.isInherited();
            if (emphasize) {
                formatter.emphasis(true);
            }
            formatter.name(kind, true);
            formatter.appendText(this.getName());
            formatter.name(kind, false);
            if (emphasize) {
                formatter.emphasis(false);
            }
            if ((parameters = this.method.getParameters()) != null && !parameters.isEmpty()) {
                formatter.appendHtml("(");
                Iterator it = parameters.iterator();
                while (it.hasNext()) {
                    formatter.parameters(true);
                    formatter.appendText((String)it.next());
                    formatter.parameters(false);
                    if (!it.hasNext()) continue;
                    formatter.appendText(", ");
                }
                formatter.appendHtml(")");
            }
            if (this.method.hasBlock() && !this.method.isBlockOptional()) {
                formatter.appendText(" { }");
            }
            return formatter.getText();
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            if (this.method.isTopLevel() && this.method.getRequire() != null) {
                formatter.appendText(this.method.getRequire());
                return formatter.getText();
            }
            String in = this.method.getIn();
            if (in != null) {
                formatter.appendText(in);
                return formatter.getText();
            }
            return null;
        }

        public String getCustomInsertTemplate() {
            String endDelimiter;
            String startDelimiter;
            boolean hasHashArgs;
            int paramCount;
            String insertPrefix = this.getInsertPrefix();
            List<String> params = this.method.getParameters();
            boolean hasBlock = false;
            int printArgs = paramCount = params.size();
            boolean bl = hasHashArgs = this.method.getEncodedAttributes() != null && this.method.getEncodedAttributes().indexOf("=>") != -1;
            if (paramCount > 0 && params.get(paramCount - 1).startsWith("&")) {
                hasBlock = true;
                --printArgs;
                startDelimiter = "(";
                endDelimiter = ")";
            } else if (this.method.hasBlock()) {
                hasBlock = true;
                if (paramCount > 0) {
                    startDelimiter = "(";
                    endDelimiter = ")";
                } else {
                    startDelimiter = "";
                    endDelimiter = "";
                }
            } else {
                String[] delimiters = this.getParamListDelimiters();
                assert (delimiters.length == 2);
                startDelimiter = delimiters[0];
                endDelimiter = delimiters[1];
                if (printArgs == 0) {
                    startDelimiter = "";
                    endDelimiter = "";
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(insertPrefix);
            if (hasHashArgs && this.skipHashes()) {
                sb.append(this.getInsertSuffix());
                return sb.toString();
            }
            sb.append(startDelimiter);
            int id = 1;
            for (int i = 0; i < printArgs; ++i) {
                String paramDesc = params.get(i);
                sb.append("${");
                sb.append("ruby-cc-");
                sb.append(Integer.toString(id++));
                sb.append(" default=\"");
                sb.append(paramDesc);
                sb.append("\"");
                sb.append("}");
                if (i >= printArgs - 1) continue;
                sb.append(", ");
            }
            sb.append(endDelimiter);
            if (hasBlock) {
                int yieldNameEnd;
                int yieldNameBegin;
                String[] blockArgs = null;
                String attrs = this.method.getEncodedAttributes();
                if (attrs != null && (yieldNameBegin = attrs.indexOf(59)) != -1 && (yieldNameEnd = attrs.indexOf(59, yieldNameBegin + 1)) != -1) {
                    blockArgs = attrs.substring(yieldNameBegin + 1, yieldNameEnd).split(",");
                }
                sb.append(" { |");
                if (blockArgs != null && blockArgs.length > 0) {
                    for (int i = 0; i < blockArgs.length; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        void arg = blockArgs[i];
                        sb.append("${unusedlocal defaults=\"");
                        sb.append((String)arg);
                        sb.append("\"}");
                    }
                } else {
                    sb.append("${unusedlocal defaults=\"i,e\"}");
                }
                sb.append("| ${");
                sb.append("ruby-cc-");
                sb.append(Integer.toString(id++));
                sb.append(" default=\"\"} }${cursor}");
            } else {
                sb.append("${cursor}");
            }
            return sb.toString();
        }

        protected boolean skipHashes() {
            return true;
        }

        protected String getInsertSuffix() {
            return " ";
        }

        @Override
        public String[] getParamListDelimiters() {
            List<String> comments;
            String n = this.getName();
            String in = this.element.getIn();
            if ("Module".equals(in)) {
                if (n.startsWith("attr_")) {
                    return new String[]{" :", " "};
                }
                if (n.equals("include") || n.equals("import")) {
                    return new String[]{" ", " "};
                }
                if (n.equals("include_package")) {
                    return new String[]{" '", "'"};
                }
            } else if ("Kernel".equals(in)) {
                if (n.equals("require")) {
                    return new String[]{" '", "'"};
                }
                if (n.equals("p")) {
                    return new String[]{" ", " "};
                }
            } else if ("Object".equals(in) && n.equals("include_class")) {
                return new String[]{" '", "'"};
            }
            if (RubyCompletionItem.forceCompletionSpaces()) {
                boolean ambiguous = false;
                AstPath path = this.request.path;
                if (path != null) {
                    ListIterator<Node> it = path.leafToRoot();
                    while (it.hasNext()) {
                        Node node = (Node)it.next();
                        if (!AstUtilities.isCall(node) || node == this.request.target) continue;
                        ambiguous = true;
                        break;
                    }
                }
                if (ambiguous) {
                    return new String[]{"(", ")"};
                }
                return new String[]{" ", " "};
            }
            if (this.element instanceof IndexedElement && (comments = RubyCodeCompleter.getComments(null, this.element)) != null && !comments.isEmpty()) {
                String name = this.getName();
                boolean spaces = false;
                boolean parens = false;
                for (String line : comments) {
                    int index;
                    if (!line.startsWith("#  ")) continue;
                    int i = 0;
                    int length = line.length();
                    while ((index = line.indexOf(name, i)) != -1) {
                        i = index += name.length();
                        if (index >= length) continue;
                        char c = line.charAt(index);
                        if (c == ' ') {
                            spaces = true;
                            continue;
                        }
                        if (c != '(') continue;
                        parens = true;
                    }
                }
                if (!parens && spaces) {
                    return new String[]{" ", " "};
                }
            }
            return super.getParamListDelimiters();
        }

        @Override
        public ElementKind getKind() {
            if (this.method.getMethodType() == IndexedMethod.MethodType.ATTRIBUTE) {
                return ElementKind.ATTRIBUTE;
            }
            return this.element.getKind();
        }
    }

    static class DbItem
    extends RubyCompletionItem {
        private final String name;
        private final String type;

        DbItem(Element element, String name, String type, int anchorOffset, CompletionRequest request) {
            super(element, anchorOffset, request);
            this.name = name;
            this.type = type;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.emphasis(true);
            formatter.name(ElementKind.DB, true);
            formatter.appendText(this.getName());
            formatter.name(ElementKind.DB, false);
            formatter.emphasis(false);
            return formatter.getText();
        }

        @Override
        public String getInsertPrefix() {
            return this.name;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            formatter.appendText(this.type);
            return formatter.getText();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.DB;
        }

        @Override
        public ImageIcon getIcon() {
            return null;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isSmart() {
            return true;
        }
    }

    static class CallItem
    extends MethodItem {
        private final IndexedMethod method;
        private final int index;

        CallItem(IndexedMethod method, int parameterIndex, int anchorOffset, CompletionRequest request) {
            super(method, anchorOffset, request);
            this.method = method;
            this.index = parameterIndex;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CALL;
        }

        @Override
        public String getInsertPrefix() {
            return "";
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            ElementKind kind = this.getKind();
            formatter.name(kind, true);
            formatter.appendText(this.getName());
            List<String> parameters = this.method.getParameters();
            if (parameters != null && !parameters.isEmpty()) {
                formatter.appendHtml("(");
                if (this.index > 0 && this.index < parameters.size()) {
                    formatter.appendText("... , ");
                }
                formatter.active(true);
                formatter.appendText(parameters.get(Math.min(parameters.size() - 1, this.index)));
                formatter.active(false);
                if (this.index < parameters.size() - 1) {
                    formatter.appendText(", ...");
                }
                formatter.appendHtml(")");
            }
            if (this.method.hasBlock() && !this.method.isBlockOptional()) {
                formatter.appendText(" { }");
            }
            formatter.name(kind, false);
            return formatter.getText();
        }

        public boolean isSmart() {
            return true;
        }

        public List<String> getInsertParams() {
            return null;
        }

        @Override
        public String getCustomInsertTemplate() {
            return null;
        }
    }

    static class ParameterItem
    extends RubyCompletionItem {
        private static ImageIcon symbolIcon;
        private static final String CONSTANT_ICON = "org/netbeans/modules/ruby/symbol.png";
        private final String name;
        private final String desc;
        private final String insert;

        ParameterItem(Element element, String name, String symbol, String insert, int anchorOffset, CompletionRequest request) {
            super(element, anchorOffset, request);
            this.name = name;
            this.desc = symbol;
            this.insert = insert;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            if (this.desc != null) {
                formatter.appendText(this.desc);
                return formatter.getText();
            }
            return null;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PARAMETER;
        }

        @Override
        public ImageIcon getIcon() {
            if (symbolIcon == null) {
                symbolIcon = ImageUtilities.loadImageIcon((String)CONSTANT_ICON, (boolean)false);
            }
            return symbolIcon;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getInsertPrefix() {
            return this.insert;
        }
    }

    static class FieldItem
    extends RubyCompletionItem {
        private final String forcedPrefix;

        FieldItem(Element element, int anchorOffset, CompletionRequest request) {
            this(element, anchorOffset, request, null);
        }

        FieldItem(Element element, int anchorOffset, CompletionRequest request, String forcedPrefix) {
            super(element, anchorOffset, request);
            this.forcedPrefix = forcedPrefix;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            if (this.element instanceof IndexedField) {
                boolean emphasize;
                IndexedField field = (IndexedField)this.element;
                boolean bl = emphasize = !field.isInherited();
                if (emphasize) {
                    formatter.emphasis(true);
                }
                formatter.name(ElementKind.FIELD, true);
                formatter.appendText(this.getName());
                formatter.name(ElementKind.FIELD, false);
                if (emphasize) {
                    formatter.emphasis(false);
                }
                return formatter.getText();
            }
            return super.getLhsHtml(formatter);
        }

        @Override
        public String getInsertPrefix() {
            if (this.forcedPrefix != null) {
                return this.forcedPrefix + this.getName();
            }
            String name = this.element.getModifiers().contains(Modifier.STATIC) ? "@@" + this.getName() : "@" + this.getName();
            if (this.symbol) {
                name = ":" + name;
            }
            return name;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            IndexedField idx;
            String in;
            if (this.element instanceof IndexedField && (in = (idx = (IndexedField)this.element).getIn()) != null) {
                formatter.appendText(in);
                return formatter.getText();
            }
            return null;
        }
    }

    static class ClassItem
    extends RubyCompletionItem {
        ClassItem(Element element, int anchorOffset, CompletionRequest request) {
            super(element, anchorOffset, request);
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            String in = ((ClassElement)this.element).getIn();
            if (in == null) {
                return null;
            }
            formatter.appendText(in);
            return formatter.getText();
        }
    }

    static class KeywordItem
    extends RubyCompletionItem {
        private static ImageIcon keywordIcon;
        private static final String RUBY_KEYWORD = "org/netbeans/modules/ruby/jruby.png";
        private final String keyword;
        private final String description;

        KeywordItem(String keyword, String description, int anchorOffset, CompletionRequest request) {
            super(null, anchorOffset, request);
            this.keyword = keyword;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            return null;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            ElementKind kind = this.getKind();
            formatter.name(kind, true);
            formatter.appendText(this.keyword);
            formatter.appendText(" ");
            formatter.name(kind, false);
            if (this.description != null) {
                formatter.appendHtml(this.description);
            }
            return formatter.getText();
        }

        @Override
        public ImageIcon getIcon() {
            if (keywordIcon == null) {
                keywordIcon = ImageUtilities.loadImageIcon((String)RUBY_KEYWORD, (boolean)false);
            }
            return keywordIcon;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return new KeywordElement(this.keyword);
        }
    }
}

