/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.awt.Color;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.ClassElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.MethodElement;
import org.netbeans.modules.ruby.lexer.RubyCommentTokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.spi.lexer.LanguageProvider;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

class RDocFormatter {
    private boolean inVerbatim;
    private boolean inBulletedList;
    private boolean inLabelledList;
    private boolean inNumberedList;
    private boolean inStopDoc;
    private boolean inCallSeq;
    private List<String> code;
    private boolean firstVerbatim = true;
    private String seqName;
    private boolean wroteSignature = false;
    private final Set<String> callSeqLines = new HashSet<String>();
    private boolean noComment;
    private final StringBuilder sb = new StringBuilder(500);

    public void setSeqName(String seqName) {
        this.seqName = seqName;
    }

    public boolean wroteSignature() {
        return this.wroteSignature;
    }

    public void appendLine(String text) {
        if (text.equals("#--")) {
            this.noComment = true;
            return;
        }
        if (text.equals("#++")) {
            this.noComment = false;
            return;
        }
        if (text.startsWith("#:arg:") || text.startsWith("#:return:=>")) {
            return;
        }
        if (this.noComment) {
            return;
        }
        if (text.startsWith("# ")) {
            text = text.substring(2);
        } else if (text.equals("#")) {
            text = "";
        } else if (text.startsWith("#") && Character.isLetter(text.charAt(1))) {
            text = text.substring(1);
        }
        if (text.trim().endsWith("call-seq:")) {
            this.inCallSeq = true;
            this.sb.append("\n<hr>\n");
            return;
        }
        if (text.trim().length() == 0 && this.inCallSeq) {
            this.inCallSeq = false;
        }
        this.process(text);
    }

    private void process(String text) {
        if (text.indexOf(":stopdoc") != -1) {
            this.inStopDoc = true;
            return;
        }
        if (text.indexOf(":startdoc") != -1) {
            this.inStopDoc = false;
        }
        if (this.inStopDoc) {
            return;
        }
        if (this.inCallSeq) {
            this.callSeqLines.add(text);
        }
        if (text.length() == 0) {
            this.finishSection();
            int n = this.sb.length();
            if (this.sb.length() > 1 && this.sb.charAt(this.sb.length() - 1) == '\n' && (GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</pre>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</h1>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</h2>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</h3>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</h4>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</h5>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</ul>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</ol>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"</table>\n") || GsfUtilities.endsWith((StringBuilder)this.sb, (String)"<hr>\n"))) {
                return;
            }
            if (this.sb.length() > 0) {
                if (n <= 4 || !GsfUtilities.endsWith((StringBuilder)this.sb, (String)"<br>")) {
                    this.sb.append("<br>");
                }
                this.sb.append("<br>");
            }
            return;
        }
        if (text.startsWith("* ") || text.startsWith("- ")) {
            if (!this.inBulletedList) {
                this.sb.append("<ul>\n");
                this.inBulletedList = true;
            }
            this.sb.append("<li>");
            this.appendTokenized(text.substring(text.indexOf(32) + 1));
            return;
        }
        if (text.matches("^[0-9]+\\.\\s*( .*)?")) {
            if (!this.inNumberedList) {
                this.sb.append("<ol>\n");
                this.inNumberedList = true;
            }
            this.sb.append("<li value=\"");
            Matcher m = Pattern.compile("^([0-9]+)\\.\\s*( .*)?").matcher(text);
            if (m.matches()) {
                this.sb.append(m.group(1));
            }
            this.sb.append("\">");
            int index = text.indexOf(32);
            if (index != -1) {
                this.appendTokenized(text.substring(index + 1));
            }
            return;
        }
        if (text.matches("^\\[[\\S]+\\]\\s*( .+)?")) {
            if (!this.inLabelledList) {
                this.sb.append("<table>\n");
                this.inLabelledList = true;
            } else {
                this.sb.append("</td></tr>\n");
            }
            this.sb.append("<tr><td valign=\"top\">");
            int index = text.indexOf("]");
            this.appendTokenized(text.substring(1, index));
            this.sb.append("</td><td>");
            this.appendTokenized(text.substring(index + 1));
            return;
        }
        if (text.matches("^[\\S]+::\\s*( .*)?")) {
            if (!this.inLabelledList) {
                this.sb.append("<table>\n");
                this.inLabelledList = true;
            } else {
                this.sb.append("</td></tr>\n");
            }
            this.sb.append("<tr><td valign=\"top\">");
            int index = text.indexOf("::");
            this.appendTokenized(text.substring(0, index));
            this.sb.append("</td><td>");
            this.appendTokenized(text.substring(index + 2));
            return;
        }
        if (!this.inBulletedList && !this.inNumberedList && !this.inLabelledList && text.length() > 0 && Character.isWhitespace(text.charAt(0))) {
            if (!this.inVerbatim) {
                if (GsfUtilities.endsWith((StringBuilder)this.sb, (String)"<br>")) {
                    this.sb.setLength(this.sb.length() - 4);
                }
                this.inVerbatim = true;
                this.code = new ArrayList<String>();
            }
            this.appendTokenized(text);
            return;
        }
        if (text.startsWith("=")) {
            int i;
            for (i = 0; i < text.length() && text.charAt(i) == '='; ++i) {
            }
            if (i <= 6) {
                if (GsfUtilities.endsWith((StringBuilder)this.sb, (String)"<br>")) {
                    this.sb.setLength(this.sb.length() - 4);
                }
                this.sb.append("<h");
                this.sb.append(Integer.toString(i));
                this.sb.append(">");
                this.sb.append(text.substring(i));
                this.sb.append("</h");
                this.sb.append(Integer.toString(i));
                this.sb.append(">\n");
                return;
            }
            this.appendTokenized(text);
            return;
        }
        if (text.startsWith("#---") || text.startsWith("---")) {
            int i;
            int n = text.length();
            for (i = 1; i < n && text.charAt(i) == '-'; ++i) {
            }
            if (i == n) {
                this.sb.append("<hr>\n");
                return;
            }
            this.appendTokenized(text);
            return;
        }
        if (text.startsWith("####")) {
            int i;
            int n = text.length();
            for (i = 1; i < n && text.charAt(i) == '#'; ++i) {
            }
            if (i == n) {
                this.sb.append("<hr>\n");
                return;
            }
        } else if (this.inVerbatim) {
            this.finishSection();
        }
        this.appendTokenized(text);
    }

    private void appendTokenized(String text) {
        if (this.inVerbatim) {
            this.code.add(text);
            return;
        }
        this.firstVerbatim = false;
        this.appendTokenized(this.sb, text);
        if (this.inVerbatim) {
            this.sb.append("<br>");
        } else {
            this.sb.append(" ");
        }
    }

    private void appendTokenized(StringBuilder sb, String text) {
        TokenHierarchy hi = TokenHierarchy.create((CharSequence)text, RubyCommentTokenId.language());
        TokenSequence ts = hi.tokenSequence();
        int offset = 0;
        ts.move(offset);
        if (ts.moveNext()) {
            do {
                char c;
                String s;
                Token t;
                if ((t = ts.token()).id() == RubyCommentTokenId.COMMENT_TEXT || t.id() == RubyCommentTokenId.COMMENT_TODO) {
                    try {
                        s = ((Object)t.text()).toString();
                        s = XMLUtil.toElementContent((String)s);
                        if (s.indexOf("---") != -1) {
                            s = s.replace("---", "&#8212;");
                        }
                        sb.append(s);
                    }
                    catch (CharConversionException cce) {
                        Exceptions.printStackTrace((Throwable)cce);
                    }
                    continue;
                }
                if (t.id() == RubyCommentTokenId.COMMENT_HTMLTAG) {
                    s = ((Object)t.text()).toString();
                    c = s.charAt(0);
                    if (c == '+') {
                        sb.append("<tt>");
                        sb.append(s.substring(1, s.length() - 1));
                        sb.append("</tt>");
                        continue;
                    }
                    sb.append(s);
                    continue;
                }
                if (t.id() == RubyCommentTokenId.COMMENT_LINK) {
                    s = ((Object)t.text()).toString();
                    sb.append("<a href=\"");
                    sb.append(s);
                    sb.append("\">");
                    if (s.startsWith("#")) {
                        s = s.substring(1);
                    }
                    sb.append(s);
                    sb.append("</a>");
                    continue;
                }
                if (t.id() == RubyCommentTokenId.COMMENT_ITALIC) {
                    sb.append("<i>");
                    s = ((Object)t.text()).toString();
                    c = s.charAt(0);
                    if (c == '_') {
                        sb.append(s.substring(1, s.length() - 1));
                    } else {
                        sb.append(t.text());
                    }
                    sb.append("</i>");
                    continue;
                }
                if (t.id() == RubyCommentTokenId.COMMENT_BOLD) {
                    sb.append("<b>");
                    s = ((Object)t.text()).toString();
                    c = s.charAt(0);
                    if (c == '*') {
                        sb.append(s.substring(1, s.length() - 1));
                    } else {
                        sb.append(t.text());
                    }
                    sb.append("</b>");
                    continue;
                }
                if (t.id() != RubyCommentTokenId.COMMENT_RDOC) continue;
            } while (ts.moveNext());
        }
    }

    private void finishSection() {
        if (this.inVerbatim) {
            boolean addHr = false;
            if (this.code != null && this.code.size() > 0) {
                if (this.formatAsRuby(this.code)) {
                    String html = this.getRubyHtml(this.code);
                    if (html != null) {
                        this.sb.append(html);
                    } else {
                        this.sb.append("<pre>\n");
                        for (String s : this.code) {
                            try {
                                this.sb.append(XMLUtil.toElementContent((String)s));
                            }
                            catch (CharConversionException cce) {
                                Exceptions.printStackTrace((Throwable)cce);
                            }
                            this.sb.append("<br>");
                        }
                        this.sb.append("</pre>\n");
                    }
                } else {
                    this.sb.append("<pre>\n");
                    if (this.isCallSeq(this.code)) {
                        String html = this.getCallSeqHtml(this.code);
                        this.sb.append(html);
                        addHr = true;
                        this.wroteSignature = true;
                    } else {
                        for (String s : this.code) {
                            this.appendTokenized(this.sb, s);
                            this.sb.append("<br>");
                        }
                    }
                    this.sb.append("</pre>\n");
                }
                this.code = null;
            }
            if (addHr) {
                this.sb.append("<hr>\n");
            }
            this.inVerbatim = false;
            this.firstVerbatim = false;
        }
        if (this.inBulletedList) {
            this.sb.append("</ul>\n");
            this.inBulletedList = false;
        }
        if (this.inNumberedList) {
            this.sb.append("</ol>\n");
            this.inBulletedList = false;
        }
        if (this.inLabelledList) {
            this.sb.append("</td></tr>\n</table>\n");
            this.inLabelledList = false;
        }
    }

    public String toHtml() {
        this.finishSection();
        return this.sb.toString();
    }

    private String getRubyHtml(List<String> source) {
        StringBuilder ruby = new StringBuilder(500);
        for (String s : source) {
            ruby.append(s);
            ruby.append("\n");
        }
        Language language = RubyTokenId.language();
        String mimeType = "text/x-ruby";
        if (ruby.indexOf(" <%") != -1) {
            LanguageProvider provider;
            mimeType = "application/x-httpd-eruby";
            Collection providers = Lookup.getDefault().lookupAll(LanguageProvider.class);
            Iterator i$ = providers.iterator();
            while (i$.hasNext() && (language = (provider = (LanguageProvider)i$.next()).findLanguage(mimeType)) == null) {
            }
            if (language == null) {
                mimeType = "text/x-ruby";
                language = RubyTokenId.language();
            }
        } else if (source.get(0).trim().startsWith("<")) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(1500);
        boolean errors = this.appendSequence(buffer, ruby.toString(), language, mimeType, true);
        return errors ? null : buffer.toString();
    }

    private boolean appendSequence(StringBuilder sb, String text, Language<?> language, String mimeType, boolean addPre) {
        MimePath mimePath = MimePath.parse((String)mimeType);
        Lookup lookup = MimeLookup.getLookup((MimePath)mimePath);
        FontColorSettings fcs = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        if (addPre) {
            Color bg;
            sb.append("<pre style=\"");
            AttributeSet attribs = fcs.getTokenFontColors("default");
            Color fg = (Color)attribs.getAttribute(StyleConstants.Foreground);
            if (fg != null) {
                sb.append("color:");
                sb.append(RDocFormatter.getHtmlColor(fg));
                sb.append(";");
            }
            if ((bg = (Color)attribs.getAttribute(StyleConstants.Background)) != null && bg.getRed() < 128) {
                sb.append("background:");
                sb.append(RDocFormatter.getHtmlColor(bg));
            }
            sb.append("\">\n");
        }
        TokenHierarchy hi = TokenHierarchy.create((CharSequence)text, language);
        TokenSequence ts = hi.tokenSequence();
        int offset = 0;
        ts.move(offset);
        if (ts.moveNext()) {
            do {
                Boolean b;
                Color bg;
                TokenSequence embedded;
                Token t = ts.token();
                String tokenText = ((Object)t.text()).toString();
                String category = t.id().name();
                String primaryCategory = t.id().primaryCategory();
                if ("error".equals(primaryCategory)) {
                    return true;
                }
                AttributeSet attribs = fcs.getTokenFontColors(category);
                String escapedText = tokenText;
                try {
                    escapedText = XMLUtil.toElementContent((String)tokenText);
                }
                catch (CharConversionException cce) {
                    Exceptions.printStackTrace((Throwable)cce);
                }
                if (attribs == null) {
                    category = primaryCategory;
                    attribs = fcs.getTokenFontColors(category);
                }
                if ((embedded = ts.embedded()) != null) {
                    String embeddedMimeType = MimePath.parse((String)embedded.languagePath().mimePath()).getPath();
                    bg = null;
                    Color fg = null;
                    if (attribs != null) {
                        bg = (Color)attribs.getAttribute(StyleConstants.Background);
                        fg = (Color)attribs.getAttribute(StyleConstants.Foreground);
                        if (fg != null || bg != null) {
                            sb.append("<span style=\"");
                            if (bg != null) {
                                sb.append("background:");
                                sb.append(RDocFormatter.getHtmlColor(bg));
                                sb.append(";");
                            }
                            if (fg != null) {
                                sb.append("color:");
                                sb.append(RDocFormatter.getHtmlColor(fg));
                            }
                            sb.append("\">");
                        }
                    }
                    this.appendSequence(sb, tokenText, embedded.language(), embeddedMimeType, false);
                    if (fg == null && bg == null) continue;
                    sb.append("</span>");
                    continue;
                }
                if (attribs == null) {
                    sb.append(escapedText);
                    continue;
                }
                if (escapedText.indexOf(10) != -1) {
                    escapedText = escapedText.replace("\n", "<br>");
                }
                if (t.id() == RubyTokenId.WHITESPACE) {
                    sb.append(escapedText);
                    continue;
                }
                sb.append("<span style=\"");
                Color fg = (Color)attribs.getAttribute(StyleConstants.Foreground);
                if (fg != null) {
                    sb.append("color:");
                    sb.append(RDocFormatter.getHtmlColor(fg));
                    sb.append(";");
                }
                if ((bg = (Color)attribs.getAttribute(StyleConstants.Background)) != null) {
                    sb.append("background:");
                    sb.append(RDocFormatter.getHtmlColor(bg));
                    sb.append(";");
                }
                if ((b = (Boolean)attribs.getAttribute(StyleConstants.Bold)) != null && b.booleanValue()) {
                    sb.append("font-weight:bold;");
                }
                if ((b = (Boolean)attribs.getAttribute(StyleConstants.Italic)) != null && b.booleanValue()) {
                    sb.append("font-style:italic;");
                }
                sb.append("\">");
                sb.append(escapedText);
                sb.append("</span>");
            } while (ts.moveNext());
        }
        if (addPre) {
            sb.append("</pre>\n");
        }
        return false;
    }

    private String getCallSeqHtml(List<String> code) {
        StringBuilder callSeqSb = new StringBuilder();
        int min = Integer.MAX_VALUE;
        block2: for (String s : code) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == ' ') continue;
                if (i >= min) continue block2;
                min = i;
                continue block2;
            }
        }
        if (min == Integer.MAX_VALUE) {
            min = 0;
        }
        for (String s : code) {
            if (min > 0 && s.length() >= min) {
                s = s.substring(min);
            }
            if (this.seqName != null) {
                char c;
                int index = s.indexOf(this.seqName);
                if (index != -1 && s.length() > index + this.seqName.length() && (c = s.charAt(index + this.seqName.length())) != ' ' && c != '(' && c != '{' && c != '[') {
                    index = -1;
                }
                if (index != -1) {
                    String lhs = s.substring(0, index);
                    String rhs = "";
                    if (s.length() > index + this.seqName.length()) {
                        rhs = s.substring(index + this.seqName.length());
                    }
                    try {
                        callSeqSb.append(XMLUtil.toElementContent((String)lhs));
                        callSeqSb.append("<b>");
                        callSeqSb.append(XMLUtil.toElementContent((String)this.seqName));
                        callSeqSb.append("</b>");
                        callSeqSb.append(XMLUtil.toElementContent((String)rhs));
                        callSeqSb.append("<br>");
                    }
                    catch (CharConversionException cce) {
                        Exceptions.printStackTrace((Throwable)cce);
                    }
                    continue;
                }
            }
            this.appendTokenized(callSeqSb, s);
            callSeqSb.append("<br>");
        }
        return callSeqSb.toString();
    }

    public String getSignature(Element element) {
        StringBuilder signature = new StringBuilder();
        signature.append("<pre>");
        if (element instanceof MethodElement) {
            MethodElement executable = (MethodElement)element;
            if (element.getIn() != null) {
                String in = element.getIn();
                signature.append("<i>");
                signature.append(in);
                signature.append("</i>");
                signature.append("<br>");
            }
            signature.append("<b>");
            signature.append(element.getName());
            signature.append("</b>");
            List<String> parameters = executable.getParameters();
            if (parameters != null && parameters.size() > 0) {
                signature.append("(");
                signature.append("<font color=\"#808080\">");
                Iterator it = parameters.iterator();
                while (it.hasNext()) {
                    String ve = (String)it.next();
                    signature.append(ve);
                    if (!it.hasNext()) continue;
                    signature.append(", ");
                }
                signature.append("</font>");
                signature.append(")");
            }
        } else if (element instanceof ClassElement) {
            ClassElement clz = (ClassElement)element;
            String name = element.getName();
            String fqn = clz.getFqn();
            if (fqn != null && !name.equals(fqn)) {
                signature.append("<i>");
                signature.append(fqn);
                signature.append("</i>");
                signature.append("<br>");
            }
            signature.append("<b>");
            signature.append(name);
            signature.append("</b>");
        } else {
            signature.append(element.getName());
        }
        RubyType type = this.getElementType(element);
        if (type != null && type.isKnown()) {
            signature.append("<br>");
            signature.append("<i>");
            signature.append(NbBundle.getMessage(RDocFormatter.class, (String)"InferredType"));
            signature.append(" ");
            signature.append(type.asString(", ", " " + NbBundle.getMessage(RDocFormatter.class, (String)"Or") + " "));
            signature.append("</i>");
        }
        signature.append("</pre>\n");
        return signature.toString();
    }

    private RubyType getElementType(Element element) {
        if (element instanceof MethodElement && "new".equals(element.getName())) {
            return RubyType.unknown();
        }
        return element.getType();
    }

    private static String getHtmlColor(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        StringBuffer result = new StringBuffer();
        result.append('#');
        String rs = Integer.toHexString(r);
        String gs = Integer.toHexString(g);
        String bs = Integer.toHexString(b);
        if (r < 16) {
            result.append('0');
        }
        result.append(rs);
        if (g < 16) {
            result.append('0');
        }
        result.append(gs);
        if (b < 16) {
            result.append('0');
        }
        result.append(bs);
        return result.toString();
    }

    private boolean isCallSeq(List<String> source) {
        String first;
        if (this.callSeqLines.containsAll(source)) {
            return true;
        }
        return this.firstVerbatim && ((first = source.get(0)).indexOf("=>") != -1 || first.indexOf("->") != -1);
    }

    private boolean formatAsRuby(List<String> source) {
        if (this.isCallSeq(source)) {
            return false;
        }
        for (String s : source) {
            if (s.indexOf("---") != -1) {
                return false;
            }
            if (s.indexOf(" | ") == -1) continue;
            return false;
        }
        return true;
    }
}

