/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.form.layoutdesign.LayoutAligner;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDragger;
import org.netbeans.modules.form.layoutdesign.LayoutEvent;
import org.netbeans.modules.form.layoutdesign.LayoutFeeder;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutOperations;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutTestUtils;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.netbeans.modules.form.layoutdesign.VisualMapper;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;

public class LayoutDesigner
implements LayoutConstants {
    private LayoutModel layoutModel;
    private VisualMapper visualMapper;
    private LayoutDragger dragger;
    private LayoutOperations operations;
    private Listener modelListener;
    private boolean imposeSize = true;
    private boolean optimizeStructure = true;
    private boolean visualStateUpToDate;
    private Image linkBadgeBoth = null;
    private Image linkBadgeHorizontal = null;
    private Image linkBadgeVertical = null;
    private static final int BOTH_DIMENSIONS = 2;
    private int[] cursorPos = new int[]{0, 0};
    static final String TEST_SWITCH = "netbeans.form.layout_test";
    public List<String> testCode = new ArrayList<String>();
    private List<String> testCode0 = new ArrayList<String>();
    private List<String> beforeMove = new ArrayList<String>();
    private List<String> move1 = new ArrayList<String>();
    private List<String> move2 = new ArrayList<String>();
    private boolean isMoving = false;
    private int modelCounter = -1;
    private Point lastMovePoint = new Point(0, 0);

    public LayoutDesigner(LayoutModel layoutModel, VisualMapper visualMapper) {
        this.layoutModel = layoutModel;
        this.visualMapper = visualMapper;
        this.operations = new LayoutOperations(layoutModel, visualMapper);
        this.modelListener = new Listener();
        this.modelListener.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCurrentState() {
        if (this.logTestCode()) {
            this.testCode.add("// > UPDATE CURRENT STATE");
        }
        Object object = this.layoutModel.getChangeMark();
        boolean bl = this.imposeSize || this.optimizeStructure;
        HashSet<LayoutComponent> hashSet = bl ? new HashSet<LayoutComponent>() : null;
        try {
            if (bl) {
                this.modelListener.deactivate();
                this.destroyRedundantGroups(hashSet);
                this.operations.mergeAdjacentGaps(hashSet);
            }
            this.updatePositions(hashSet);
        }
        finally {
            if (bl) {
                this.modelListener.activate();
            }
        }
        if (bl) {
            this.optimizeStructure = false;
            this.imposeSize = false;
            if (hashSet != null) {
                for (LayoutComponent layoutComponent : hashSet) {
                    this.visualMapper.rebuildLayout(layoutComponent.getId());
                }
                this.updatePositions(null);
            }
        }
        if (this.logTestCode()) {
            this.testCode.add("ld.updateCurrentState();");
            this.testCode.add("// < UPDATE CURRENT STATE");
        }
        this.visualStateUpToDate = true;
        return !object.equals(this.layoutModel.getChangeMark());
    }

    public void externalSizeChangeHappened() {
        this.imposeSize = true;
        this.visualStateUpToDate = false;
        if (this.logTestCode()) {
            this.testCode.add("ld.externalSizeChangeHappened();");
        }
    }

    void requireStructureOptimization() {
        this.optimizeStructure = true;
        this.visualStateUpToDate = false;
        Iterator iterator = this.layoutModel.getAllComponents();
        while (iterator.hasNext()) {
            LayoutComponent layoutComponent = (LayoutComponent)iterator.next();
            if (!layoutComponent.isLayoutContainer()) continue;
            LayoutInterval[] layoutIntervalArray = this.getActiveLayoutRoots(layoutComponent);
            for (int i = 0; i < 2; ++i) {
                LayoutDesigner.cleanDesignAttrs(layoutIntervalArray[i]);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void updatePositions(Set<LayoutComponent> set) {
        Iterator iterator = this.layoutModel.getAllComponents();
        while (iterator.hasNext()) {
            int n;
            Object object;
            LayoutComponent layoutComponent = (LayoutComponent)iterator.next();
            if (!layoutComponent.isLayoutContainer()) continue;
            if (this.optimizeStructure || this.imposeSize) {
                if (!this.imposeCurrentContainerSize(layoutComponent, null, false)) continue;
                set.add(layoutComponent);
                if (this.optimizeStructure) {
                    for (LayoutInterval[] layoutIntervalArray : layoutComponent.getLayoutRoots()) {
                        for (int i = 0; i < 2; ++i) {
                            this.optimizeGaps(layoutIntervalArray[i], i, true);
                            this.destroyRedundantGroups(layoutIntervalArray[i]);
                        }
                    }
                }
                object = this.getActiveLayoutRoots(layoutComponent);
                for (int i = 0; i < 2; ++i) {
                    this.updateDesignModifications(object[i], i);
                }
                continue;
            }
            object = this.visualMapper.getContainerInterior(layoutComponent.getId());
            if (object == null) continue;
            layoutComponent.setCurrentInterior((Rectangle)object);
            for (LayoutInterval[] layoutIntervalArray : layoutComponent.getSubcomponents()) {
                object = this.visualMapper.getComponentBounds(layoutIntervalArray.getId());
                n = this.visualMapper.getBaselinePosition(layoutIntervalArray.getId(), object.width, object.height);
                layoutIntervalArray.setCurrentBounds((Rectangle)object, n);
            }
            for (LayoutInterval[] layoutIntervalArray : layoutComponent.getLayoutRoots()) {
                for (n = 0; n < 2; ++n) {
                    this.updateLayoutStructure(layoutIntervalArray[n], n, false);
                }
            }
        }
    }

    void updateLayoutStructure(LayoutInterval layoutInterval, int n, boolean bl) {
        LayoutRegion layoutRegion = layoutInterval.getCurrentSpace();
        boolean bl2 = layoutInterval.getGroupAlignment() == 3;
        boolean bl3 = true;
        boolean bl4 = false;
        int n2 = 0;
        boolean bl5 = false;
        Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            int n3;
            LayoutInterval layoutInterval2 = iterator.next();
            if (layoutInterval2.isEmptySpace()) {
                int n4;
                if (!layoutInterval.isSequential()) {
                    assert (layoutInterval.getParent() == null);
                    if (bl && layoutRegion.isSet(n)) {
                        this.imposeCurrentGapSize(layoutInterval2, layoutRegion.size(n), n);
                    }
                } else if (bl3 || !iterator.hasNext()) {
                    int n5 = layoutInterval2.getMinimumSize(true);
                    n3 = layoutInterval2.getPreferredSize(true);
                    n4 = layoutInterval2.getMaximumSize(true);
                    if (!(n5 != n3 && n5 != -2 || n3 != n4 && n4 != -2 || n3 == -1)) {
                        if (bl3) {
                            n2 = n3;
                        } else {
                            layoutRegion.reshape(n, 1, n3);
                        }
                    } else {
                        LayoutConstants layoutConstants;
                        int n6 = Integer.MIN_VALUE;
                        LayoutInterval layoutInterval3 = LayoutInterval.getNeighbor(layoutInterval2, 102, bl3 ? 0 : 1);
                        if (layoutInterval3 == null) {
                            layoutConstants = LayoutInterval.getRoot(layoutInterval).getCurrentSpace();
                            if (bl3) {
                                bl4 = true;
                                n2 = -((LayoutRegion)layoutConstants).positions[n][0];
                            } else {
                                n6 = ((LayoutRegion)layoutConstants).positions[n][1] - layoutRegion.positions[n][1];
                                layoutRegion.reshape(n, 1, n6);
                            }
                        } else if (layoutInterval3.isEmptySpace()) {
                            int n7;
                            LayoutConstants layoutConstants2 = layoutConstants = layoutInterval.getParent();
                            int n8 = n7 = bl3 ? 0 : 1;
                            while (layoutConstants != null && LayoutInterval.isAlignedAtBorder(layoutInterval, (LayoutInterval)layoutConstants, n7)) {
                                layoutConstants2 = layoutConstants;
                                layoutConstants = ((LayoutInterval)layoutConstants).getParent();
                            }
                            LayoutInterval layoutInterval4 = LayoutUtils.getOutermostComponent((LayoutInterval)layoutConstants2, n, n7);
                            LayoutRegion layoutRegion2 = layoutInterval4.getCurrentSpace();
                            if (bl3) {
                                bl4 = true;
                                n2 = -layoutRegion2.positions[n][0];
                            } else {
                                n6 = layoutRegion2.positions[n][1] - layoutRegion.positions[n][1];
                                layoutRegion.reshape(n, 1, n6);
                            }
                        } else if (bl3) {
                            bl4 = true;
                            layoutConstants = layoutInterval3.getCurrentSpace();
                            n2 = -((LayoutRegion)layoutConstants).positions[n][1];
                        } else {
                            int n9;
                            layoutConstants = layoutInterval3.getCurrentSpace();
                            if (!layoutInterval3.isComponent()) {
                                ((LayoutRegion)layoutConstants).reset();
                                this.updateLayoutStructure(layoutInterval3, n, bl);
                                bl5 = true;
                            }
                            if ((n9 = ((LayoutRegion)layoutConstants).positions[n][0]) != Integer.MIN_VALUE) {
                                n6 = n9 - layoutRegion.positions[n][1];
                                layoutRegion.reshape(n, 1, n6);
                            }
                        }
                        if (bl && n6 != Integer.MIN_VALUE) {
                            this.imposeCurrentGapSize(layoutInterval2, n6, n);
                        }
                    }
                } else if (bl) {
                    LayoutInterval layoutInterval5 = LayoutInterval.getDirectNeighbor(layoutInterval2, 1, false);
                    assert (!layoutInterval5.isEmptySpace());
                    LayoutRegion layoutRegion3 = layoutInterval5.getCurrentSpace();
                    if (!layoutInterval5.isComponent()) {
                        layoutRegion3.reset();
                        this.updateLayoutStructure(layoutInterval5, n, bl);
                        bl5 = true;
                    }
                    n4 = LayoutRegion.distance(layoutRegion, layoutRegion3, n, 1, 0);
                    this.imposeCurrentGapSize(layoutInterval2, n4, n);
                }
                bl3 = false;
                continue;
            }
            LayoutRegion layoutRegion4 = layoutInterval2.getCurrentSpace();
            if (bl5) {
                bl5 = false;
            } else if (layoutInterval2.isGroup()) {
                assert (layoutInterval2.getSubIntervalCount() > 0);
                layoutRegion4.reset();
                this.updateLayoutStructure(layoutInterval2, n, bl);
            }
            layoutRegion.expand(layoutRegion4);
            if (bl2 && layoutInterval2.isComponent() && (n3 = layoutRegion4.positions[n][3]) != Integer.MIN_VALUE) {
                layoutRegion.positions[n][3] = n3;
                bl2 = false;
            }
            if (bl4) {
                n2 += layoutRegion.positions[n][0];
                bl4 = false;
                if (bl) {
                    this.imposeCurrentGapSize(layoutInterval.getSubInterval(0), n2, n);
                }
            }
            bl3 = false;
        }
        if (n2 != 0) {
            layoutRegion.reshape(n, 0, -n2);
        }
    }

    public void dumpTestcode(DataObject dataObject) {
        LayoutTestUtils.dumpTestcode(this.testCode, dataObject, this.getModelCounter());
        this.testCode = new ArrayList<String>();
        this.testCode0 = new ArrayList<String>();
        this.beforeMove = new ArrayList<String>();
        this.move1 = new ArrayList<String>();
        this.move2 = new ArrayList<String>();
        this.isMoving = false;
    }

    public List<String> getDraggableComponents(List<String> list) {
        LayoutComponent layoutComponent = null;
        List<String> list2 = null;
        int n = -1;
        for (String string : list) {
            LayoutComponent layoutComponent2 = this.layoutModel.getLayoutComponent(string);
            if (layoutComponent2 == null || layoutComponent2.getParent() == null) continue;
            if (layoutComponent == null) {
                layoutComponent = layoutComponent2.getParent();
            } else if (layoutComponent2.getParent() != layoutComponent) {
                return Collections.emptyList();
            }
            int n2 = layoutComponent.getLayoutRootsIndex(layoutComponent2.getLayoutInterval(0));
            assert (n2 >= 0);
            if (n2 < n) continue;
            if (n < 0) {
                list2 = new ArrayList<String>(list.size());
            } else if (n2 > n) {
                list2.clear();
            }
            n = n2;
            list2.add(string);
        }
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        return list2;
    }

    public boolean isUnplacedComponent(String string) {
        LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(string);
        if (layoutComponent != null) {
            LayoutComponent layoutComponent2 = layoutComponent.getParent();
            return layoutComponent2 != null && layoutComponent.getParentRoots()[0] != layoutComponent2.getDefaultLayoutRoot(0);
        }
        return false;
    }

    public void startAdding(LayoutComponent[] layoutComponentArray, Rectangle[] rectangleArray, Point point, String string) {
        if (this.logTestCode()) {
            this.testCode.add("// > START ADDING");
        }
        this.prepareDragger(layoutComponentArray, rectangleArray, point, LayoutDragger.ALL_EDGES);
        if (this.logTestCode()) {
            this.testCode.add("{");
            LayoutTestUtils.writeLayoutComponentArray(this.testCode, "comps", "lc");
            LayoutTestUtils.writeRectangleArray(this.testCode, "bounds", rectangleArray);
            LayoutTestUtils.writeString(this.testCode, "defaultContId", string);
            this.testCode.add("Point hotspot = new Point(" + new Double(point.getX()).intValue() + "," + new Double(point.getY()).intValue() + ");");
            this.testCode.add("ld.startAdding(comps, bounds, hotspot, defaultContId);");
            this.testCode.add("}");
        }
        if (string != null) {
            this.setDragTarget(this.layoutModel.getLayoutComponent(string), layoutComponentArray, false);
        }
        if (this.logTestCode()) {
            this.testCode.add("// < START ADDING");
        }
    }

    public void startMoving(String[] stringArray, Rectangle[] rectangleArray, Point point) {
        if (this.logTestCode()) {
            this.testCode.add("// > START MOVING");
        }
        LayoutComponent[] layoutComponentArray = new LayoutComponent[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            layoutComponentArray[i] = this.layoutModel.getLayoutComponent(stringArray[i]);
        }
        this.prepareDragger(layoutComponentArray, rectangleArray, point, LayoutDragger.ALL_EDGES);
        if (this.logTestCode()) {
            this.testCode.add("{");
            LayoutTestUtils.writeStringArray(this.testCode, "compIds", stringArray);
            LayoutTestUtils.writeRectangleArray(this.testCode, "bounds", rectangleArray);
            this.testCode.add("Point hotspot = new Point(" + new Double(point.getX()).intValue() + "," + new Double(point.getY()).intValue() + ");");
            this.testCode.add("ld.startMoving(compIds, bounds, hotspot);");
            this.testCode.add("}");
        }
        this.setDragTarget(layoutComponentArray[0].getParent(), layoutComponentArray, false);
        if (this.logTestCode()) {
            this.testCode.add("// < START MOVING");
        }
    }

    public void startResizing(String[] stringArray, Rectangle[] rectangleArray, Point point, int[] nArray, boolean bl) {
        if (this.logTestCode()) {
            this.testCode.add("// > START RESIZING");
        }
        LayoutComponent[] layoutComponentArray = new LayoutComponent[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            layoutComponentArray[i] = this.layoutModel.getLayoutComponent(stringArray[i]);
        }
        int[] nArray2 = new int[2];
        for (int i = 0; i < 2; ++i) {
            nArray2[i] = nArray[i] == 0 || nArray[i] == 1 ? nArray[i] : Integer.MIN_VALUE;
        }
        this.prepareDragger(layoutComponentArray, rectangleArray, point, nArray2);
        if (this.logTestCode()) {
            this.testCode.add("{");
            LayoutTestUtils.writeStringArray(this.testCode, "compIds", stringArray);
            LayoutTestUtils.writeRectangleArray(this.testCode, "bounds", rectangleArray);
            this.testCode.add("Point hotspot = new Point(" + new Double(point.getX()).intValue() + "," + new Double(point.getY()).intValue() + ");");
            LayoutTestUtils.writeIntArray(this.testCode, "resizeEdges", nArray);
            this.testCode.add("boolean inLayout = " + bl + ";");
            this.testCode.add("ld.startResizing(compIds, bounds, hotspot, resizeEdges, inLayout);");
            this.testCode.add("}");
        }
        if (bl) {
            this.setDragTarget(layoutComponentArray[0].getParent(), layoutComponentArray, true);
        } else {
            this.setDragTarget(null, null, true);
        }
        if (this.logTestCode()) {
            this.testCode.add("// < START RESIZING");
        }
    }

    private void prepareDragger(LayoutComponent[] layoutComponentArray, Rectangle[] rectangleArray, Point point, int[] nArray) {
        if (layoutComponentArray.length != rectangleArray.length) {
            throw new IllegalArgumentException();
        }
        LayoutRegion[] layoutRegionArray = new LayoutRegion[rectangleArray.length];
        for (int i = 0; i < rectangleArray.length; ++i) {
            int n = this.visualMapper.getBaselinePosition(layoutComponentArray[i].getId(), rectangleArray[i].width, rectangleArray[i].height);
            int n2 = n > 0 ? rectangleArray[i].y + n : Integer.MIN_VALUE;
            layoutRegionArray[i] = new LayoutRegion();
            layoutRegionArray[i].set(rectangleArray[i], n2);
        }
        this.dragger = new LayoutDragger(layoutComponentArray, layoutRegionArray, new int[]{point.x, point.y}, nArray, this.visualMapper);
    }

    public void move(Point point, String string, boolean bl, boolean bl2, Rectangle[] rectangleArray) {
        int n;
        int n2 = point != null ? point.x : 0;
        int n3 = n = point != null ? point.y : 0;
        if (this.logTestCode()) {
            if (!this.isMoving) {
                this.isMoving = true;
                this.beforeMove = new ArrayList<String>();
                this.beforeMove.addAll(this.testCode);
                this.testCode = new ArrayList<String>();
                this.lastMovePoint = new Point(0, 0);
            }
            if (n2 != this.lastMovePoint.x || n != this.lastMovePoint.y) {
                this.lastMovePoint = new Point(n2, n);
                this.move1 = this.move2;
                this.testCode0 = this.testCode;
            }
            this.move2 = new ArrayList<String>();
            this.move2.add("// > MOVE");
            this.testCode = new ArrayList<String>();
        }
        if (!this.visualStateUpToDate || this.dragger == null) {
            return;
        }
        if (!(this.dragger.isResizing() || bl2 && this.dragger.getTargetContainer() != null)) {
            this.setDragTarget(this.layoutModel.getLayoutComponent(string), this.dragger.getMovingComponents(), false);
        }
        this.cursorPos[0] = point.x;
        this.cursorPos[1] = point.y;
        this.dragger.move(this.cursorPos, bl, bl2);
        point.x = this.cursorPos[0];
        point.y = this.cursorPos[1];
        if (rectangleArray != null) {
            LayoutRegion[] layoutRegionArray = this.dragger.getMovingBounds();
            for (int i = 0; i < layoutRegionArray.length; ++i) {
                layoutRegionArray[i].toRectangle(rectangleArray[i]);
            }
        }
        if (this.logTestCode()) {
            this.move2.add("{");
            this.move2.add("Point p = new Point(" + n2 + "," + n + ");");
            LayoutTestUtils.writeString(this.move2, "containerId", string);
            this.move2.add("boolean autoPositioning = " + bl + ";");
            this.move2.add("boolean lockDimension = " + bl2 + ";");
            LayoutTestUtils.writeRectangleArray(this.move2, "bounds", rectangleArray);
            this.move2.add("ld.move(p, containerId, autoPositioning, lockDimension, bounds);");
            this.move2.add("}");
            this.move2.add("// < MOVE");
        }
    }

    private void setDragTarget(LayoutComponent layoutComponent, LayoutComponent[] layoutComponentArray, boolean bl) {
        LayoutComponent layoutComponent2 = this.dragger.getTargetContainer();
        LayoutInterval[] layoutIntervalArray = layoutComponent != null ? (bl && layoutComponentArray.length > 0 ? layoutComponentArray[0].getParentRoots() : this.getActiveLayoutRoots(layoutComponent)) : null;
        this.dragger.setTargetContainer(layoutComponent, layoutIntervalArray);
        if (layoutComponent2 != layoutComponent) {
            this.updateDraggingVisibility(layoutComponent2, layoutComponentArray, bl, false);
            this.updateDraggingVisibility(layoutComponent, layoutComponentArray, bl, true);
        }
    }

    private void updateDraggingVisibility(LayoutComponent layoutComponent, LayoutComponent[] layoutComponentArray, boolean bl, boolean bl2) {
        if (layoutComponent != null) {
            LayoutInterval[] layoutIntervalArray = bl && layoutComponentArray.length > 0 ? layoutComponentArray[0].getParentRoots() : this.getActiveLayoutRoots(layoutComponent);
            for (LayoutComponent layoutComponent2 : layoutComponent.getSubcomponents()) {
                for (LayoutComponent layoutComponent3 : layoutComponentArray) {
                    if (layoutComponent3 != layoutComponent2) continue;
                    layoutComponent2 = null;
                    break;
                }
                if (layoutComponent2 == null || LayoutInterval.getRoot(layoutComponent2.getLayoutInterval(0)) == layoutIntervalArray[0]) continue;
                this.visualMapper.setComponentVisibility(layoutComponent2.getId(), !bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void endMoving(boolean bl) {
        block26: {
            if (!bl && this.dragger == null) {
                return;
            }
            if (this.logTestCode()) {
                if (bl) {
                    this.beforeMove.addAll(this.testCode0);
                    this.beforeMove.addAll(this.move1);
                    this.beforeMove.addAll(this.testCode);
                    this.beforeMove.addAll(this.move2);
                    this.testCode = this.beforeMove;
                }
                this.testCode.add("// > END MOVING");
                this.isMoving = false;
            }
            try {
                LayoutComponent layoutComponent = this.dragger.getTargetContainer();
                LayoutComponent[] layoutComponentArray = this.dragger.getMovingComponents();
                this.updateDraggingVisibility(layoutComponent, layoutComponentArray, this.dragger.isResizing(), false);
                if (!bl) break block26;
                if (layoutComponent != null) {
                    LayoutInterval[] layoutIntervalArray;
                    int n;
                    int n2;
                    Object object2;
                    boolean bl2;
                    boolean bl3 = bl2 = layoutComponentArray[0].getParent() == null;
                    if (layoutComponentArray.length > 1) {
                        if (bl2) {
                            object2 = this.dragger.getMovingSpace();
                            n2 = ((LayoutRegion)object2).positions[0][0];
                            int n3 = ((LayoutRegion)object2).positions[0][0];
                            LayoutRegion[] object = this.dragger.getMovingBounds();
                            HashMap<LayoutComponent, Rectangle> hashMap = new HashMap<LayoutComponent, Rectangle>();
                            for (n = 0; n < layoutComponentArray.length; ++n) {
                                Rectangle rectangle = object[n].toRectangle(new Rectangle());
                                rectangle.x -= n2;
                                rectangle.y -= n3;
                                hashMap.put(layoutComponentArray[n], rectangle);
                            }
                            layoutIntervalArray = LayoutModel.createIntervalsFromBounds(hashMap);
                        } else {
                            void var9_16;
                            object2 = new LayoutInterval[2];
                            HashMap<LayoutComponent, LayoutComponent> hashMap = new HashMap<LayoutComponent, LayoutComponent>();
                            LayoutRegion layoutRegion = new LayoutRegion();
                            for (LayoutComponent layoutComponent2 : layoutComponentArray) {
                                for (int i = 0; i < 2; ++i) {
                                    object2[i] = object2[i] == null ? layoutComponent2.getLayoutInterval(i) : LayoutInterval.getCommonParent((LayoutInterval)object2[i], layoutComponent2.getLayoutInterval(i));
                                }
                                hashMap.put(layoutComponent2, layoutComponent2);
                                layoutRegion.expand(layoutComponent2.getLayoutInterval(0).getCurrentSpace());
                            }
                            layoutIntervalArray = new LayoutInterval[2];
                            boolean i = false;
                            while (var9_16 < 2) {
                                layoutIntervalArray[var9_16] = this.restrictedCopy((LayoutInterval)object2[var9_16], hashMap, layoutRegion, (int)var9_16, null);
                                ++var9_16;
                            }
                            for (LayoutComponent layoutComponent3 : layoutComponentArray) {
                                this.layoutModel.removeComponent(layoutComponent3, false);
                            }
                        }
                    } else {
                        layoutIntervalArray = new LayoutInterval[2];
                        object2 = layoutComponentArray[0];
                        for (int i = 0; i < 2; ++i) {
                            layoutIntervalArray[i] = ((LayoutComponent)object2).getLayoutInterval(i);
                        }
                    }
                    if (bl2) {
                        object2 = this.dragger.getMovingBounds();
                        for (n2 = 0; n2 < layoutComponentArray.length; ++n2) {
                            LayoutComponent layoutComponent2 = layoutComponentArray[n2];
                            Dimension dimension = this.visualMapper.getComponentPreferredSize(layoutComponent2.getId());
                            for (int i = 0; i < 2; ++i) {
                                n = ((LayoutRegion)object2[n2]).size(i);
                                if (dimension != null && n == (i == 0 ? dimension.width : dimension.height)) continue;
                                layoutComponent2.getLayoutInterval(i).setPreferredSize(n);
                            }
                        }
                    }
                    this.addComponents(layoutComponentArray, layoutComponent, layoutIntervalArray, bl2);
                } else {
                    assert (this.dragger.isResizing());
                    this.modelListener.deactivate();
                    LayoutRegion layoutRegion = this.dragger.getMovingBounds()[0];
                    for (int i = 0; i < 2; ++i) {
                        layoutComponentArray[0].getLayoutInterval(i).setCurrentSpace(layoutRegion);
                    }
                    if (layoutComponentArray[0].isLayoutContainer()) {
                        this.imposeCurrentContainerSize(layoutComponentArray[0], this.dragger.getSizes(), true);
                    }
                }
                if (this.dragger.isResizing() && layoutComponentArray[0].isLayoutContainer()) {
                    this.updateDesignModifications(layoutComponentArray[0]);
                }
                this.visualStateUpToDate = false;
            }
            finally {
                this.dragger = null;
                if (this.logTestCode()) {
                    this.testCode.add("ld.endMoving(" + bl + ");");
                    this.testCode.add("// < END MOVING");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addComponents(LayoutComponent[] layoutComponentArray, LayoutComponent layoutComponent, LayoutInterval[] layoutIntervalArray, boolean bl) {
        try {
            LayoutFeeder layoutFeeder = new LayoutFeeder(this.operations, this.dragger, layoutIntervalArray);
            if (this.dragger.isResizing()) {
                assert (layoutComponentArray.length == 1);
                for (int i = 0; i < 2; ++i) {
                    LayoutInterval layoutInterval = layoutIntervalArray[i];
                    if (layoutInterval.getParent() == null || layoutInterval.getAlignment() == 2 || layoutInterval.getAlignment() == 3) continue;
                    this.layoutModel.removeInterval(layoutInterval);
                }
                for (LayoutComponent layoutComponent2 : layoutComponentArray) {
                    if (this.dragger.isResizing(0)) {
                        this.layoutModel.removeComponentFromLinkSizedGroup(layoutComponent2, 0);
                    }
                    if (!this.dragger.isResizing(1)) continue;
                    this.layoutModel.removeComponentFromLinkSizedGroup(layoutComponent2, 1);
                }
            } else {
                for (LayoutComponent layoutComponent2 : layoutComponentArray) {
                    if (layoutComponent2.getParent() == null) continue;
                    this.layoutModel.removeComponentAndIntervals(layoutComponent2, false);
                }
            }
            this.modelListener.deactivate();
            if (!this.dragger.isResizing()) {
                for (LayoutComponent layoutComponent2 : layoutComponentArray) {
                    this.layoutModel.addComponent(layoutComponent2, layoutComponent, -1);
                }
            }
            layoutFeeder.add();
            if (layoutFeeder.imposeSize) {
                this.imposeSize = true;
            }
            if (layoutFeeder.optimizeStructure) {
                this.optimizeStructure = true;
            }
            for (int i = 0; i < 2; ++i) {
                this.destroyGroupIfRedundant(layoutIntervalArray[i], layoutIntervalArray[i].getParent());
            }
            for (LayoutComponent layoutComponent2 : layoutComponentArray) {
                if ((bl || this.dragger.isResizing()) && layoutComponent2.isLayoutContainer()) {
                    this.imposeCurrentContainerSize(layoutComponentArray[0], this.dragger.getSizes(), true);
                    continue;
                }
                if (!this.dragger.isResizing()) continue;
                for (int i = 0; i < 2; ++i) {
                    if (!this.dragger.snappedToDefaultSize(i)) continue;
                    this.operations.resizeInterval(layoutComponent2.getLayoutInterval(i), -1);
                }
            }
            this.updateDesignModifications(layoutComponent);
        }
        finally {
            if (!this.modelListener.isActive()) {
                this.modelListener.activate();
            }
        }
    }

    private void addUnspecified(LayoutComponent[] layoutComponentArray, LayoutComponent layoutComponent, LayoutInterval[] layoutIntervalArray) {
        for (LayoutComponent layoutConstants : layoutComponentArray) {
            this.layoutModel.addComponent(layoutConstants, layoutComponent, -1);
        }
        LayoutConstants[] layoutConstantsArray = this.layoutModel.addNewLayoutRoots(layoutComponent);
        for (int i = 0; i < 2; ++i) {
            LayoutInterval layoutInterval = layoutIntervalArray[i];
            LayoutInterval layoutInterval2 = layoutInterval.isSequential() ? layoutInterval : new LayoutInterval(102);
            LayoutInterval layoutInterval3 = new LayoutInterval(101);
            boolean bl = LayoutInterval.wantResize(layoutInterval);
            if (!bl) {
                layoutInterval3.setSizes(0, 0, Short.MAX_VALUE);
            }
            layoutInterval2.add(layoutInterval3, 0);
            if (layoutInterval != layoutInterval2) {
                this.layoutModel.addInterval(layoutInterval, layoutInterval2, -1);
                this.layoutModel.setIntervalAlignment(layoutInterval, -1);
            }
            layoutInterval3 = new LayoutInterval(101);
            if (!bl) {
                layoutInterval3.setSizes(0, 0, Short.MAX_VALUE);
            }
            layoutInterval2.add(layoutInterval3, -1);
            this.layoutModel.addInterval(layoutInterval2, (LayoutInterval)layoutConstantsArray[i], -1);
        }
    }

    private void addToEmpty(LayoutComponent[] layoutComponentArray, LayoutComponent layoutComponent, LayoutInterval[] layoutIntervalArray) {
        assert (layoutComponent.getSubComponentCount() == 0);
        for (LayoutComponent layoutConstants : layoutComponentArray) {
            this.layoutModel.addComponent(layoutConstants, layoutComponent, -1);
        }
        LayoutConstants[] layoutConstantsArray = this.getActiveLayoutRoots(layoutComponent);
        for (int i = 0; i < 2; ++i) {
            LayoutConstants layoutConstants2 = layoutConstantsArray[i];
            assert (((LayoutInterval)layoutConstants2).isParallel());
            LayoutInterval layoutInterval = layoutIntervalArray[i];
            if (!layoutInterval.isParallel()) {
                this.layoutModel.addInterval(layoutInterval, (LayoutInterval)layoutConstants2, -1);
                continue;
            }
            while (layoutInterval.getSubIntervalCount() > 0) {
                this.layoutModel.addInterval(layoutInterval.remove(0), (LayoutInterval)layoutConstants2, -1);
            }
        }
    }

    private LayoutInterval restrictedCopy(LayoutInterval layoutInterval, Map<LayoutComponent, LayoutComponent> map, LayoutRegion layoutRegion, int n, List<Object> list) {
        boolean bl;
        boolean bl2 = bl = list == null;
        if (list == null) {
            list = new LinkedList<Object>();
        }
        if (layoutInterval.isGroup()) {
            int n2;
            LayoutInterval layoutInterval2;
            boolean bl3 = layoutInterval.isParallel();
            LayoutInterval layoutInterval3 = LayoutInterval.cloneInterval(layoutInterval, null);
            Iterator<Object> iterator = layoutInterval.getSubIntervals();
            int n3 = 0;
            boolean bl4 = false;
            int n4 = 0;
            int n5 = layoutInterval.getCurrentSpace().positions[n][0];
            while (iterator.hasNext()) {
                LayoutInterval layoutInterval4 = iterator.next();
                layoutInterval2 = this.restrictedCopy(layoutInterval4, map, layoutRegion, n, list);
                if (layoutInterval2 != null) {
                    if (!layoutInterval4.isEmptySpace()) {
                        if (bl4) {
                            n5 = Math.max(layoutRegion.positions[n][0], n5);
                            n2 = layoutInterval4.getCurrentSpace().positions[n][0] - n5;
                            this.integrateGap(layoutInterval3, n2, n4);
                            bl4 = false;
                        }
                        n5 = layoutInterval4.getCurrentSpace().positions[n][1];
                        n4 = layoutInterval3.getSubIntervalCount();
                    }
                    if (layoutInterval4.isComponent()) {
                        list.add(layoutInterval2);
                        list.add(layoutInterval3);
                        list.add(new Integer(layoutInterval2.getRawAlignment()));
                        list.add(new Integer(layoutInterval3.getSubIntervalCount() + n3));
                        ++n3;
                        continue;
                    }
                    this.layoutModel.addInterval(layoutInterval2, layoutInterval3, -1);
                    continue;
                }
                if (bl3) continue;
                bl4 = true;
            }
            if (bl4) {
                n5 = Math.max(layoutRegion.positions[n][0], n5);
                int n6 = Math.min(layoutRegion.positions[n][1], layoutInterval.getCurrentSpace().positions[n][1]);
                this.integrateGap(layoutInterval3, n6 - n5, n4);
            }
            if (layoutInterval3.getSubIntervalCount() + n3 > 0) {
                if (bl) {
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        LayoutInterval layoutInterval5 = (LayoutInterval)iterator.next();
                        layoutInterval2 = (LayoutInterval)iterator.next();
                        n2 = (Integer)iterator.next();
                        int n7 = (Integer)iterator.next();
                        if (layoutInterval5.getParent() != null) {
                            this.layoutModel.removeInterval(layoutInterval5);
                        }
                        this.layoutModel.setIntervalAlignment(layoutInterval5, n2);
                        this.layoutModel.addInterval(layoutInterval5, layoutInterval2, n7);
                    }
                    boolean bl5 = this.modelListener.isActive();
                    if (bl5) {
                        this.modelListener.deactivate();
                    }
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        layoutInterval2 = (LayoutInterval)iterator.next();
                        iterator.next();
                        iterator.next();
                        LayoutInterval layoutInterval6 = layoutInterval2.getParent();
                        while (layoutInterval2.getSubIntervalCount() == 1 && layoutInterval6 != null) {
                            LayoutInterval layoutInterval7 = layoutInterval2.getSubInterval(0);
                            this.layoutModel.removeInterval(layoutInterval7);
                            int n8 = layoutInterval2.getAlignment();
                            int n9 = this.layoutModel.removeInterval(layoutInterval2);
                            this.layoutModel.setIntervalAlignment(layoutInterval7, n8);
                            this.layoutModel.addInterval(layoutInterval7, layoutInterval6, n9);
                            layoutInterval2 = layoutInterval7;
                        }
                    }
                    n3 = 0;
                    if (bl5) {
                        this.modelListener.activate();
                    }
                }
                if (layoutInterval3.getSubIntervalCount() == 1 && n3 == 0) {
                    boolean bl6 = this.modelListener.isActive();
                    if (bl6) {
                        this.modelListener.deactivate();
                    }
                    layoutInterval2 = layoutInterval3.getSubInterval(0);
                    this.layoutModel.removeInterval(layoutInterval2);
                    this.layoutModel.setIntervalAlignment(layoutInterval2, layoutInterval3.getAlignment());
                    layoutInterval3 = layoutInterval3.isSequential() && layoutInterval2.isEmptySpace() ? null : layoutInterval2;
                    if (bl6) {
                        this.modelListener.activate();
                    }
                }
                return layoutInterval3;
            }
            return null;
        }
        if (layoutInterval.isComponent()) {
            LayoutComponent layoutComponent = map.get(layoutInterval.getComponent());
            if (layoutComponent != null) {
                if (layoutComponent != layoutInterval.getComponent()) {
                    layoutInterval = LayoutInterval.cloneInterval(layoutInterval, layoutComponent.getLayoutInterval(n));
                }
                return layoutInterval;
            }
            return null;
        }
        assert (layoutInterval.isEmptySpace());
        int[] nArray = this.emptySpaceBounds(layoutInterval, n);
        int n10 = layoutRegion.positions[n][0];
        int n11 = layoutRegion.positions[n][1];
        if (nArray[0] < n11 && nArray[1] > n10) {
            LayoutInterval layoutInterval8 = new LayoutInterval(101);
            layoutInterval8.setAttributes(layoutInterval.getAttributes());
            if (nArray[0] < n10 || nArray[1] > n11) {
                int n12 = layoutInterval.getMinimumSize();
                if (n12 >= 0) {
                    n12 = -2;
                }
                int n13 = Math.min(nArray[1], n11) - Math.max(nArray[0], n10);
                int n14 = layoutInterval.getMaximumSize();
                if (n14 >= 0) {
                    n14 = -2;
                }
                layoutInterval8.setSizes(n12, n13, n14);
            } else {
                layoutInterval8.setSizes(layoutInterval.getMinimumSize(), layoutInterval.getPreferredSize(), layoutInterval.getMaximumSize());
                layoutInterval8.setPaddingType(layoutInterval.getPaddingType());
            }
            return layoutInterval8;
        }
        return null;
    }

    private void integrateGap(LayoutInterval layoutInterval, int n, int n2) {
        while (layoutInterval.getSubIntervalCount() > n2 && layoutInterval.getSubInterval(layoutInterval.getSubIntervalCount() - 1).isEmptySpace()) {
            this.layoutModel.removeInterval(layoutInterval.getSubInterval(layoutInterval.getSubIntervalCount() - 1));
        }
        if (n > 0) {
            LayoutInterval layoutInterval2 = new LayoutInterval(101);
            layoutInterval2.setSize(n);
            this.layoutModel.addInterval(layoutInterval2, layoutInterval, -1);
        }
    }

    private int[] emptySpaceBounds(LayoutInterval layoutInterval, int n) {
        assert (layoutInterval.isEmptySpace());
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        int n2 = layoutInterval2.indexOf(layoutInterval);
        int n3 = n2 == 0 ? layoutInterval2.getCurrentSpace().positions[n][0] : layoutInterval2.getSubInterval((int)(n2 - 1)).getCurrentSpace().positions[n][1];
        int n4 = n2 + 1 == layoutInterval2.getSubIntervalCount() ? layoutInterval2.getCurrentSpace().positions[n][1] : layoutInterval2.getSubInterval((int)(n2 + 1)).getCurrentSpace().positions[n][0];
        return new int[]{n3, n4};
    }

    public void removeDraggedComponents() {
        if (this.dragger != null) {
            LayoutComponent[] layoutComponentArray = this.dragger.getMovingComponents();
            for (int i = 0; i < layoutComponentArray.length; ++i) {
                this.layoutModel.removeComponentAndIntervals(layoutComponentArray[i], !layoutComponentArray[i].isLayoutContainer());
            }
            this.endMoving(false);
        }
    }

    public void paintMoveFeedback(Graphics2D graphics2D) {
        if (this.dragger != null) {
            this.dragger.paintMoveFeedback(graphics2D);
        }
    }

    public void paintSelection(Graphics2D graphics2D, String string) {
        LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(string);
        if (layoutComponent != null && layoutComponent.getParent() != null) {
            this.paintSelection(graphics2D, layoutComponent, 0);
            this.paintSelection(graphics2D, layoutComponent, 1);
        }
    }

    private void paintSelection(Graphics2D graphics2D, LayoutComponent layoutComponent, int n) {
        int n2;
        int n3;
        int n4;
        LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(n);
        if (layoutComponent.isLinkSized(0) || layoutComponent.isLinkSized(1)) {
            this.paintLinks(graphics2D, layoutComponent);
        }
        if (layoutInterval.getAlignment() == 3) {
            LayoutInterval layoutInterval2 = layoutInterval.getParent();
            int n5 = n == 0 ? 1 : 0;
            LayoutRegion layoutRegion = layoutInterval2.getCurrentSpace();
            n4 = layoutRegion.positions[n][3];
            n3 = layoutRegion.positions[n5][0];
            n2 = layoutRegion.positions[n5][1];
            if (n3 != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE) {
                if (n == 0) {
                    graphics2D.drawLine(n4, n3, n4, n2);
                } else {
                    graphics2D.drawLine(n3, n4, n2, n4);
                }
            }
        }
        int n6 = -1;
        while (layoutInterval.getParent() != null) {
            int n7;
            LayoutInterval layoutInterval3 = layoutInterval.getParent();
            if (layoutInterval3.getType() == 102) {
                n7 = LayoutInterval.getEffectiveAlignment(layoutInterval);
                n4 = layoutInterval3.indexOf(layoutInterval);
                block0 : switch (n7) {
                    case 0: {
                        n3 = 0;
                        n2 = n4;
                        n6 = 0;
                        break;
                    }
                    case 1: {
                        n3 = n4 + 1;
                        n2 = layoutInterval3.getSubIntervalCount();
                        n6 = 1;
                        break;
                    }
                    default: {
                        switch (n6) {
                            case 0: {
                                n3 = 0;
                                n2 = n4;
                                break block0;
                            }
                            case 1: {
                                n3 = n4 + 1;
                                n2 = layoutInterval3.getSubIntervalCount();
                                break block0;
                            }
                        }
                        n3 = 0;
                        n2 = layoutInterval3.getSubIntervalCount();
                    }
                }
                for (int i = n3; i < n2; ++i) {
                    LayoutInterval layoutInterval4 = layoutInterval3.getSubInterval(i);
                    if (!layoutInterval4.isEmptySpace()) continue;
                    this.paintAlignment(graphics2D, layoutInterval4, n, LayoutInterval.getEffectiveAlignment(layoutInterval4));
                }
            } else {
                n7 = layoutInterval.getAlignment();
                if (!LayoutInterval.wantResizeInLayout(layoutInterval)) {
                    n6 = n7;
                }
                this.paintAlignment(graphics2D, layoutInterval, n, n6);
            }
            layoutInterval = layoutInterval.getParent();
        }
    }

    private void paintLinks(Graphics2D graphics2D, LayoutComponent layoutComponent) {
        if (layoutComponent.isLinkSized(0) && layoutComponent.isLinkSized(1)) {
            int n;
            Map<Integer, List<String>> map = this.layoutModel.getLinkSizeGroups(0);
            Map<Integer, List<String>> map2 = this.layoutModel.getLinkSizeGroups(1);
            Integer n2 = new Integer(layoutComponent.getLinkSizeId(0));
            Integer n3 = new Integer(layoutComponent.getLinkSizeId(1));
            List<String> list = map.get(n2);
            List<String> list2 = map2.get(n3);
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < list.size(); ++n) {
                hashSet.add(list.get(n));
            }
            for (n = 0; n < list2.size(); ++n) {
                hashSet.add(list2.get(n));
            }
            for (String string : hashSet) {
                LayoutComponent layoutComponent2 = this.layoutModel.getLayoutComponent(string);
                LayoutInterval layoutInterval = layoutComponent2.getLayoutInterval(0);
                LayoutRegion layoutRegion = layoutInterval.getCurrentSpace();
                Image image = null;
                if (list2.contains(string) && list.contains(string)) {
                    image = this.getLinkBadge(2);
                } else {
                    if (list.contains(layoutComponent2.getId())) {
                        image = this.getLinkBadge(0);
                    }
                    if (list2.contains(layoutComponent2.getId())) {
                        image = this.getLinkBadge(1);
                    }
                }
                int n4 = layoutRegion.positions[0][1] - layoutRegion.size(0) / 4 - image.getWidth(null) / 2;
                int n5 = layoutRegion.positions[1][0] - image.getHeight(null);
                graphics2D.drawImage(image, n4, n5, null);
            }
        } else {
            int n = layoutComponent.isLinkSized(0) ? 0 : 1;
            Map<Integer, List<String>> map = this.layoutModel.getLinkSizeGroups(n);
            Integer n6 = new Integer(layoutComponent.getLinkSizeId(n));
            List<String> list = map.get(n6);
            for (String string : list) {
                LayoutComponent layoutComponent3 = this.layoutModel.getLayoutComponent(string);
                LayoutInterval layoutInterval = layoutComponent3.getLayoutInterval(n);
                LayoutRegion layoutRegion = layoutInterval.getCurrentSpace();
                Image image = this.getLinkBadge(n);
                int n7 = layoutRegion.positions[0][1] - layoutRegion.size(0) / 4 - image.getWidth(null) / 2;
                int n8 = layoutRegion.positions[1][0] - image.getHeight(null);
                graphics2D.drawImage(image, n7, n8, null);
            }
        }
    }

    private Image getLinkBadge(int n) {
        if (n == 2) {
            if (this.linkBadgeBoth == null) {
                this.linkBadgeBoth = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/sameboth.png");
            }
            return this.linkBadgeBoth;
        }
        if (n == 0) {
            if (this.linkBadgeHorizontal == null) {
                this.linkBadgeHorizontal = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/samewidth.png");
            }
            return this.linkBadgeHorizontal;
        }
        if (n == 1) {
            if (this.linkBadgeVertical == null) {
                this.linkBadgeVertical = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/sameheight.png");
            }
            return this.linkBadgeVertical;
        }
        return null;
    }

    private void paintAlignment(Graphics2D graphics2D, LayoutInterval layoutInterval, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray;
        int n7;
        int n8;
        int n9;
        LayoutInterval layoutInterval2 = layoutInterval.getParent();
        boolean bl = layoutInterval2.isParallel() && layoutInterval2.getGroupAlignment() == 3;
        LayoutRegion layoutRegion = layoutInterval2.getCurrentSpace();
        int n10 = n9 = n == 0 ? 1 : 0;
        if (layoutInterval.isEmptySpace()) {
            boolean bl2;
            int[] nArray2;
            LayoutInterval layoutInterval3;
            n8 = layoutInterval2.indexOf(layoutInterval);
            if (n8 == 0) {
                n7 = layoutRegion.positions[n][bl ? 3 : 0];
                nArray = this.visualIntervalPosition(layoutInterval2, n9, 0);
                n6 = LayoutInterval.getFirstParent(layoutInterval, 103).getParent() != null ? 1 : 0;
            } else {
                layoutInterval3 = layoutInterval2.getSubInterval(n8 - 1);
                if (layoutInterval3.isParallel() && layoutInterval3.getGroupAlignment() == 3) {
                    n7 = layoutInterval3.getCurrentSpace().positions[n][3];
                } else {
                    if (layoutInterval3.isEmptySpace()) {
                        return;
                    }
                    n7 = layoutInterval3.getCurrentSpace().positions[n][1];
                }
                nArray = this.visualIntervalPosition(layoutInterval3, n9, 1);
                n6 = layoutInterval3.isGroup();
            }
            if (n8 + 1 == layoutInterval2.getSubIntervalCount()) {
                n5 = layoutRegion.positions[n][bl ? 3 : 1];
                nArray2 = this.visualIntervalPosition(layoutInterval2, n9, 1);
                bl2 = LayoutInterval.getFirstParent(layoutInterval, 103).getParent() != null;
            } else {
                layoutInterval3 = layoutInterval2.getSubInterval(n8 + 1);
                if (layoutInterval3.isParallel() && layoutInterval3.getGroupAlignment() == 3) {
                    n5 = layoutInterval3.getCurrentSpace().positions[n][3];
                } else {
                    if (layoutInterval3.isEmptySpace()) {
                        return;
                    }
                    n5 = layoutInterval3.getCurrentSpace().positions[n][0];
                }
                nArray2 = this.visualIntervalPosition(layoutInterval3, n9, 0);
                bl2 = layoutInterval3.isGroup();
            }
            if (n7 == Integer.MIN_VALUE || n5 == Integer.MIN_VALUE) {
                return;
            }
            n4 = Math.min(nArray[1], nArray2[1]);
            int n11 = Math.max(nArray[0], nArray2[0]);
            n3 = (n4 + n11) / 2;
            if (nArray[1] < nArray2[0] || nArray2[1] < nArray[0]) {
                if (n == 0) {
                    graphics2D.drawLine(n7, nArray[0], n7, n3);
                    graphics2D.drawLine(n7, nArray[0], n7, nArray[1]);
                    graphics2D.drawLine(n5, nArray2[0], n5, n3);
                    graphics2D.drawLine(n5, nArray2[0], n5, nArray2[1]);
                } else {
                    graphics2D.drawLine(nArray[0], n7, n3, n7);
                    graphics2D.drawLine(nArray[0], n7, nArray[1], n7);
                    graphics2D.drawLine(nArray2[0], n5, n3, n5);
                    graphics2D.drawLine(nArray2[0], n5, nArray2[1], n5);
                }
            } else if (n == 0) {
                if (n6 != 0) {
                    graphics2D.drawLine(n7, nArray[0], n7, nArray[1]);
                }
                if (bl2) {
                    graphics2D.drawLine(n5, nArray2[0], n5, nArray2[1]);
                }
            } else {
                if (n6 != 0) {
                    graphics2D.drawLine(nArray[0], n7, nArray[1], n7);
                }
                if (bl2) {
                    graphics2D.drawLine(nArray2[0], n5, nArray2[1], n5);
                }
            }
        } else {
            LayoutRegion layoutRegion2 = layoutInterval.getCurrentSpace();
            if (n2 == 0 || n2 == 1) {
                n7 = layoutRegion.positions[n][bl ? 3 : n2];
                n5 = layoutInterval.isParallel() && layoutInterval.getAlignment() == 3 ? layoutRegion2.positions[n][3] : layoutRegion2.positions[n][n2];
            } else {
                return;
            }
            if (n7 == Integer.MIN_VALUE || n5 == Integer.MIN_VALUE) {
                return;
            }
            nArray = this.visualIntervalPosition(layoutInterval2, n9, n2);
            n3 = (nArray[0] + nArray[1]) / 2;
            int n12 = layoutRegion.positions[n][0];
            n6 = layoutRegion.positions[n][1];
            if (layoutInterval2.getParent() != null) {
                if (n == 0) {
                    if (n2 == 0) {
                        graphics2D.drawLine(n12, nArray[0], n12, nArray[1]);
                    } else if (n2 == 1) {
                        graphics2D.drawLine(n6, nArray[0], n6, nArray[1]);
                    }
                } else if (n2 == 0) {
                    graphics2D.drawLine(nArray[0], n12, nArray[1], n12);
                } else if (n2 == 1) {
                    graphics2D.drawLine(nArray[0], n6, nArray[1], n6);
                }
            }
        }
        if (n5 - n7 > 1 && Math.abs(n3) <= Short.MAX_VALUE && Math.abs(n7) <= Short.MAX_VALUE && Math.abs(n5) <= Short.MAX_VALUE) {
            int n13;
            if (n2 == 0) {
                n8 = n7;
                n13 = 180;
            } else {
                n8 = n5;
                n13 = 0;
            }
            int n14 = Math.min(4, --n5 - n7);
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 1.0f}, 0.0f);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(basicStroke);
            if (n == 0) {
                graphics2D.drawLine(n7, n3, n5, n3);
                n13 += 90;
            } else {
                graphics2D.drawLine(n3, n7, n3, n5);
                n4 = n8;
                n8 = n3;
                n3 = n4;
            }
            graphics2D.setStroke(stroke);
            if (n2 == 0 || n2 == 1) {
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.fillArc(n8 - n14, n3 - n14, 2 * n14, 2 * n14, n13, 180);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }
    }

    private int[] visualIntervalPosition(LayoutInterval layoutInterval, int n, int n2) {
        Object object;
        int n3 = Short.MAX_VALUE;
        int n4 = Short.MIN_VALUE;
        if (layoutInterval.isParallel() && layoutInterval.getGroupAlignment() != 3) {
            object = layoutInterval.getSubIntervals();
            while (object.hasNext()) {
                int n5;
                int n6;
                int n7;
                LayoutInterval layoutInterval2 = (LayoutInterval)object.next();
                int n8 = n7 = n == 0 ? 1 : 0;
                if (LayoutInterval.isPlacedAtBorder(layoutInterval2, n7, n2)) {
                    Object object2;
                    if (layoutInterval2.isParallel()) {
                        object2 = this.visualIntervalPosition(layoutInterval2, n, n2);
                        n6 = object2[0];
                        n5 = object2[1];
                    } else if (!layoutInterval2.isEmptySpace()) {
                        object2 = layoutInterval2.getCurrentSpace();
                        n6 = object2.positions[n][0];
                        n5 = object2.positions[n][1];
                    } else {
                        n6 = n3;
                        n5 = n4;
                    }
                } else {
                    n6 = n3;
                    n5 = n4;
                }
                if (n3 > n6) {
                    n3 = n6;
                }
                if (n4 >= n5) continue;
                n4 = n5;
            }
        }
        if (!layoutInterval.isParallel() || n3 == Short.MAX_VALUE) {
            object = layoutInterval.getCurrentSpace();
            n3 = ((LayoutRegion)object).positions[n][0];
            n4 = ((LayoutRegion)object).positions[n][1];
        }
        return new int[]{n3, n4};
    }

    public void copyLayout(LayoutModel layoutModel, Map<String, String> map, String string) {
        LayoutComponent layoutComponent;
        Map.Entry<String, String> entry;
        LayoutComponent layoutComponent2;
        if (map.isEmpty()) {
            return;
        }
        if (layoutModel == null) {
            layoutModel = this.layoutModel;
        }
        if ((layoutComponent2 = layoutModel.getLayoutComponent((entry = map.entrySet().iterator().next()).getKey()).getParent()) != (layoutComponent = this.layoutModel.getLayoutComponent(string)) && layoutComponent2.getSubComponentCount() == map.size() && (layoutComponent == null || layoutComponent.getSubComponentCount() == 0)) {
            if (layoutModel != this.layoutModel || !entry.getKey().equals(entry.getValue())) {
                this.layoutModel.copyContainerLayout(layoutComponent2, map, layoutComponent);
            } else {
                this.layoutModel.moveContainerLayout(layoutComponent2, layoutComponent);
            }
        } else {
            HashMap<LayoutComponent, LayoutComponent> hashMap = new HashMap<LayoutComponent, LayoutComponent>();
            LayoutComponent[] layoutComponentArray = new LayoutComponent[map.size()];
            LayoutComponent[] layoutComponentArray2 = new LayoutComponent[map.size()];
            Rectangle[] rectangleArray = new Rectangle[map.size()];
            LayoutRegion layoutRegion = new LayoutRegion();
            LayoutInterval[] layoutIntervalArray = new LayoutInterval[2];
            int n = 0;
            for (Map.Entry<String, String> entry2 : map.entrySet()) {
                LayoutComponent[] layoutComponentArray3 = entry2.getKey();
                LayoutComponent layoutComponent3 = layoutModel.getLayoutComponent((String)layoutComponentArray3);
                String string2 = entry2.getValue();
                LayoutComponent layoutComponent4 = this.layoutModel.getLayoutComponent(string2);
                if (layoutComponent4 == null) {
                    layoutComponent4 = new LayoutComponent(string2, false);
                } else if (layoutComponent4.getParent() == layoutComponent) {
                    throw new IllegalArgumentException("The component is already placed in the target layout container");
                }
                hashMap.put(layoutComponent3, layoutComponent4);
                layoutComponentArray2[n] = layoutComponent4;
                LayoutRegion layoutRegion2 = layoutComponent3.getLayoutInterval(0).getCurrentSpace();
                layoutRegion.expand(layoutRegion2);
                rectangleArray[n] = layoutRegion2.toRectangle(new Rectangle());
                layoutComponentArray[n] = layoutComponent3;
                ++n;
                for (int i = 0; i < 2; ++i) {
                    layoutIntervalArray[i] = layoutIntervalArray[i] == null ? layoutComponent3.getLayoutInterval(i) : LayoutInterval.getCommonParent(layoutIntervalArray[i], layoutComponent3.getLayoutInterval(i));
                }
            }
            LayoutInterval[] layoutIntervalArray2 = new LayoutInterval[2];
            for (int i = 0; i < 2; ++i) {
                layoutIntervalArray2[i] = this.restrictedCopy(layoutIntervalArray[i], hashMap, layoutRegion, i, null);
            }
            int[] nArray = LayoutDesigner.getCopyShift(layoutComponentArray, layoutComponent, layoutRegion, layoutComponent2 == layoutComponent);
            if (nArray != null) {
                if (layoutComponentArray2.length > 1) {
                    for (LayoutComponent layoutComponent4 : layoutComponentArray2) {
                        if (layoutComponent4.getParent() == null) continue;
                        this.layoutModel.removeComponent(layoutComponent4, false);
                    }
                }
                this.prepareDragger(layoutComponentArray2, rectangleArray, new Point(0, 0), LayoutDragger.ALL_EDGES);
                this.dragger.setTargetContainer(layoutComponent, this.getTargetRootsForCopy(layoutComponent));
                this.dragger.move(nArray, false, false);
                this.addComponents(layoutComponentArray2, layoutComponent, layoutIntervalArray2, false);
                this.dragger = null;
            } else {
                for (LayoutComponent layoutComponent4 : layoutComponentArray2) {
                    if (layoutComponent4.getParent() == null) continue;
                    this.layoutModel.removeComponentAndIntervals(layoutComponent4, false);
                }
                this.addUnspecified(layoutComponentArray2, layoutComponent, layoutIntervalArray2);
            }
        }
        this.visualStateUpToDate = false;
    }

    public void copyLayoutFromOutside(Map<String, Rectangle> map, String string, boolean bl) {
        LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(string);
        if (layoutComponent.getSubComponentCount() > 0) {
            bl = true;
        }
        HashMap<LayoutComponent, Rectangle> hashMap = new HashMap<LayoutComponent, Rectangle>();
        LayoutComponent[] layoutComponentArray = new LayoutComponent[map.size()];
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        for (Map.Entry<String, Rectangle> entry : map.entrySet()) {
            String string2 = entry.getKey();
            LayoutComponent layoutComponent2 = this.layoutModel.getLayoutComponent(string2);
            if (layoutComponent2 == null) {
                layoutComponent2 = new LayoutComponent(string2, false);
            } else if (layoutComponent2.getParent() != null) {
                throw new IllegalArgumentException("Target component already exists and is placed in the layout");
            }
            Rectangle rectangle = new Rectangle((Rectangle)entry.getValue());
            hashMap.put(layoutComponent2, rectangle);
            layoutComponentArray[n3] = layoutComponent2;
            LayoutRegion layoutRegion = new LayoutRegion(rectangle, Integer.MIN_VALUE);
            Dimension dimension = this.visualMapper.getComponentPreferredSize(string2);
            for (int i = 0; i < 2; ++i) {
                int n4 = layoutRegion.size(i);
                if (dimension != null && n4 == (i == 0 ? dimension.width : dimension.height)) continue;
                layoutComponent2.getLayoutInterval(i).setPreferredSize(layoutRegion.size(i));
            }
            if (bl) {
                n = Math.min(n, layoutRegion.positions[0][0]);
                n2 = Math.min(n2, layoutRegion.positions[1][0]);
            }
            ++n3;
        }
        if (bl) {
            for (Map.Entry<String, Rectangle> entry : hashMap.values()) {
                ((Rectangle)((Object)entry)).x -= n;
                ((Rectangle)((Object)entry)).y -= n2;
            }
        }
        LayoutInterval[] layoutIntervalArray = LayoutModel.createIntervalsFromBounds(hashMap);
        if (bl) {
            this.addUnspecified(layoutComponentArray, layoutComponent, layoutIntervalArray);
        } else {
            this.addToEmpty(layoutComponentArray, layoutComponent, layoutIntervalArray);
        }
        this.visualStateUpToDate = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void duplicateLayout(String[] stringArray, String[] stringArray2, int n, int n2) {
        int n3;
        if (this.logTestCode()) {
            this.testCode.add("// > DUPLICATE");
            this.testCode.add("{");
            LayoutTestUtils.writeStringArray(this.testCode, "sourceIds", stringArray);
            LayoutTestUtils.writeStringArray(this.testCode, "targetIds", stringArray2);
            this.testCode.add("int dimension = " + n + ";");
            this.testCode.add("int direction = " + n2 + ";");
            this.testCode.add("ld.duplicateLayout(sourceIds, targetIds, dimension, direction);");
            this.testCode.add("}");
            this.testCode.add("// < DUPLICATE");
        }
        LayoutComponent[] layoutComponentArray = new LayoutComponent[stringArray.length];
        LayoutInterval[][] layoutIntervalArray = new LayoutInterval[2][stringArray.length];
        LayoutComponent[] layoutComponentArray2 = new LayoutComponent[stringArray2.length];
        HashMap<LayoutComponent, LayoutComponent> hashMap = new HashMap<LayoutComponent, LayoutComponent>();
        LayoutComponent layoutComponent = null;
        for (n3 = 0; n3 < layoutComponentArray.length; ++n3) {
            LayoutComponent layoutComponent2 = this.layoutModel.getLayoutComponent(stringArray[n3]);
            LayoutComponent layoutComponent3 = layoutComponent2.getParent();
            if (n3 == 0) {
                layoutComponent = layoutComponent3;
            } else if (layoutComponent3 != layoutComponent) {
                throw new IllegalArgumentException("Duplicated components must be in the same container.");
            }
            layoutComponentArray[n3] = layoutComponent2;
            LayoutComponent layoutComponent4 = this.layoutModel.getLayoutComponent(stringArray2[n3]);
            if (layoutComponent4 == null) {
                layoutComponent4 = new LayoutComponent(stringArray2[n3], false);
            } else if (layoutComponent4.getParent() != null) {
                throw new IllegalArgumentException("Target component already exists and is placed in the layout");
            }
            this.layoutModel.addComponent(layoutComponent4, layoutComponent, -1);
            hashMap.put(layoutComponent2, layoutComponent4);
            layoutComponentArray2[n3] = layoutComponent4;
            for (int i = 0; i < 2; ++i) {
                LayoutInterval layoutInterval;
                layoutIntervalArray[i][n3] = layoutInterval = layoutComponent2.getLayoutInterval(i);
            }
        }
        n3 = n < 0 ? LayoutDesigner.getSeqDuplicatingDimension(layoutComponentArray) : n;
        int n4 = n2 < 0 ? LayoutDesigner.getSeqDuplicatingDirection(layoutComponentArray, n3) : n2;
        int n5 = n3 ^ 1;
        try {
            this.modelListener.deactivate();
            this.duplicateSequentially(layoutIntervalArray[n3], hashMap, n3, n4);
            this.duplicateInParallel(layoutIntervalArray[n5], hashMap, n5);
            this.visualStateUpToDate = false;
            this.optimizeStructure = true;
            this.updateDesignModifications(layoutComponent);
        }
        finally {
            if (!this.modelListener.isActive()) {
                this.modelListener.activate();
            }
        }
    }

    private static int getSeqDuplicatingDimension(LayoutComponent[] layoutComponentArray) {
        return 1;
    }

    private static int getSeqDuplicatingDirection(LayoutComponent[] layoutComponentArray, int n) {
        return 1;
    }

    private void duplicateSequentially(LayoutInterval[] layoutIntervalArray, Map<LayoutComponent, LayoutComponent> map, int n, int n2) {
        LayoutConstants layoutConstants;
        HashSet<LayoutInterval> hashSet = new HashSet<LayoutInterval>();
        for (LayoutInterval layoutInterval4 : layoutIntervalArray) {
            LayoutInterval layoutInterval2;
            for (layoutInterval2 = layoutInterval4.getParent(); layoutInterval2 != null && !hashSet.contains(layoutInterval2); layoutInterval2 = layoutInterval2.getParent()) {
            }
            if (layoutInterval2 != null) continue;
            layoutInterval2 = layoutInterval4.getParent();
            while (layoutInterval2 != null) {
                if (LayoutDesigner.shouldDuplicateWholeGroup(layoutInterval2, layoutInterval4, layoutIntervalArray)) {
                    layoutInterval4 = layoutInterval2;
                    layoutInterval2 = layoutInterval4.getParent();
                    continue;
                }
                if (layoutInterval4.isGroup()) {
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        layoutConstants = (LayoutInterval)iterator.next();
                        if (!layoutInterval4.isParentOf((LayoutInterval)layoutConstants)) continue;
                        iterator.remove();
                    }
                }
                hashSet.add(layoutInterval4);
                break;
            }
            if (layoutInterval2 != null) continue;
            hashSet.clear();
            hashSet.add(layoutInterval4);
            break;
        }
        for (LayoutInterval layoutInterval : hashSet) {
            LayoutInterval layoutInterval3;
            LayoutInterval layoutInterval4;
            layoutInterval4 = layoutInterval.getParent();
            if (layoutInterval4 != null) {
                if (layoutInterval.isSequential()) {
                    layoutInterval3 = layoutInterval;
                } else if (layoutInterval4.isSequential()) {
                    layoutInterval3 = layoutInterval4;
                } else {
                    layoutInterval3 = new LayoutInterval(102);
                    this.layoutModel.addInterval(layoutInterval3, layoutInterval4, this.layoutModel.removeInterval(layoutInterval));
                    this.layoutModel.addInterval(layoutInterval, layoutInterval3, -1);
                }
            } else {
                LayoutInterval layoutInterval5 = new LayoutInterval(103);
                layoutInterval5.setGroupAlignment(layoutInterval.getGroupAlignment());
                while (layoutInterval.getSubIntervalCount() > 0) {
                    this.layoutModel.addInterval(this.layoutModel.removeInterval(layoutInterval, 0), layoutInterval5, -1);
                }
                layoutInterval3 = new LayoutInterval(102);
                this.layoutModel.addInterval(layoutInterval3, layoutInterval, -1);
                this.layoutModel.addInterval(layoutInterval5, layoutInterval3, -1);
            }
            int n3 = -1;
            boolean bl = hashSet.contains(layoutInterval3);
            layoutConstants = layoutInterval3.getParent().getCurrentSpace();
            for (int i = 0; i < layoutInterval3.getSubIntervalCount(); ++i) {
                boolean bl2;
                LayoutInterval layoutInterval6 = layoutInterval3.getSubInterval(i);
                boolean bl3 = !layoutInterval6.isEmptySpace() && (bl || hashSet.contains(layoutInterval6));
                boolean bl4 = bl2 = i + 1 == layoutInterval3.getSubIntervalCount();
                if (bl3 && n3 < 0) {
                    n3 = i;
                }
                if (n3 < 0 || (bl3 || layoutInterval6.isEmptySpace()) && !bl2) continue;
                int n4 = i - n3;
                if (bl2 && bl3) {
                    ++n4;
                } else if (layoutInterval3.getSubInterval(i - 1).isEmptySpace()) {
                    --n4;
                }
                if (n4 > 0) {
                    LayoutInterval layoutInterval7;
                    LayoutInterval layoutInterval8;
                    int n5;
                    for (n5 = n3; n5 < n3 + n4; ++n5) {
                        layoutInterval8 = layoutInterval3.getSubInterval(n5);
                        layoutInterval7 = this.restrictedCopy(layoutInterval8, map, (LayoutRegion)layoutConstants, n, null);
                        if (n2 == 0) {
                            this.layoutModel.addInterval(layoutInterval7, layoutInterval3, n3);
                            ++n3;
                            ++i;
                            ++n5;
                            continue;
                        }
                        this.layoutModel.addInterval(layoutInterval7, layoutInterval3, n5 + n4);
                        ++i;
                    }
                    layoutInterval8 = null;
                    if (n2 == 0) {
                        n5 = n3 + n4;
                        if (n5 < layoutInterval3.getSubIntervalCount()) {
                            layoutInterval8 = layoutInterval3.getSubInterval(n5);
                        }
                        n5 = n3;
                    } else {
                        n5 = n3 - 1;
                        if (n5 >= 0) {
                            layoutInterval8 = layoutInterval3.getSubInterval(n5);
                        }
                        n5 = n3 + n4;
                    }
                    layoutInterval7 = new LayoutInterval(101);
                    if (layoutInterval8 != null && layoutInterval8.isEmptySpace()) {
                        LayoutInterval.cloneInterval(layoutInterval8, layoutInterval7);
                    }
                    this.layoutModel.addInterval(layoutInterval7, layoutInterval3, n5);
                    ++i;
                }
                n3 = -1;
            }
        }
    }

    private static boolean shouldDuplicateWholeGroup(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, LayoutInterval[] layoutIntervalArray) {
        assert (layoutInterval.isGroup());
        Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            boolean bl;
            LayoutInterval layoutInterval3 = iterator.next();
            if (layoutInterval3 == layoutInterval2 || layoutInterval3.isEmptySpace()) continue;
            if (layoutInterval3.isGroup()) {
                bl = LayoutDesigner.shouldDuplicateWholeGroup(layoutInterval3, null, layoutIntervalArray);
            } else {
                assert (layoutInterval3.isComponent());
                bl = false;
                for (LayoutInterval layoutInterval4 : layoutIntervalArray) {
                    if (layoutInterval4 != layoutInterval3) continue;
                    bl = true;
                    break;
                }
            }
            if (bl && layoutInterval.isParallel()) {
                return true;
            }
            if (bl || !layoutInterval.isSequential()) continue;
            return false;
        }
        return layoutInterval.isSequential();
    }

    private void duplicateInParallel(LayoutInterval[] layoutIntervalArray, Map<LayoutComponent, LayoutComponent> map, int n) {
        HashMap<LayoutInterval, LayoutInterval> hashMap = new HashMap<LayoutInterval, LayoutInterval>();
        for (LayoutInterval layoutInterval : layoutIntervalArray) {
            hashMap.put(layoutInterval, map.get(layoutInterval.getComponent()).getLayoutInterval(n));
        }
        for (LayoutInterval layoutInterval : layoutIntervalArray) {
            LayoutInterval layoutInterval2 = (LayoutInterval)hashMap.get(layoutInterval);
            if (layoutInterval2 == null) continue;
            LayoutInterval layoutInterval3 = layoutInterval.getParent();
            if (layoutInterval3.isParallel()) {
                LayoutInterval.cloneInterval(layoutInterval, layoutInterval2);
                this.layoutModel.setIntervalAlignment(layoutInterval2, layoutInterval.getRawAlignment());
                this.layoutModel.addInterval(layoutInterval2, layoutInterval3, -1);
                continue;
            }
            int n2 = layoutInterval3.indexOf(layoutInterval);
            int n3 = LayoutDesigner.getDuplicationBoundary(layoutInterval3, n2, hashMap.keySet(), 0);
            int n4 = LayoutDesigner.getDuplicationBoundary(layoutInterval3, n2, hashMap.keySet(), 1);
            int n5 = LayoutUtils.getVisualPosition(layoutInterval3.getSubInterval(n3), n, 0);
            LayoutInterval layoutInterval4 = null;
            boolean bl = false;
            LayoutInterval layoutInterval5 = new LayoutInterval(102);
            for (int i = n3; i <= n4; ++i) {
                LayoutInterval layoutInterval6 = layoutInterval3.getSubInterval(i);
                layoutInterval2 = (LayoutInterval)hashMap.remove(layoutInterval6);
                if (layoutInterval2 != null) {
                    LayoutInterval layoutInterval7;
                    LayoutInterval.cloneInterval(layoutInterval6, layoutInterval2);
                    if (layoutInterval4 != null) {
                        layoutInterval7 = new LayoutInterval(101);
                        LayoutInterval.cloneInterval(layoutInterval4, layoutInterval7);
                        this.layoutModel.addInterval(layoutInterval7, layoutInterval5, -1);
                        layoutInterval4 = null;
                    } else if (bl) {
                        layoutInterval7 = new LayoutInterval(101);
                        int n6 = layoutInterval6.getCurrentSpace().positions[n][0];
                        layoutInterval7.setSize(n6 - n5);
                        this.layoutModel.addInterval(layoutInterval7, layoutInterval5, -1);
                        bl = false;
                    }
                    this.layoutModel.addInterval(layoutInterval2, layoutInterval5, -1);
                    n5 = layoutInterval6.getCurrentSpace().positions[n][1];
                    continue;
                }
                if (!layoutInterval6.isEmptySpace()) {
                    layoutInterval4 = null;
                    bl = true;
                    continue;
                }
                if (bl) continue;
                layoutInterval4 = layoutInterval6;
            }
            if (layoutInterval4 != null) {
                LayoutInterval layoutInterval8 = new LayoutInterval(101);
                LayoutInterval.cloneInterval(layoutInterval4, layoutInterval8);
                this.layoutModel.addInterval(layoutInterval8, layoutInterval5, -1);
            } else if (bl) {
                LayoutInterval layoutInterval9 = new LayoutInterval(101);
                int n7 = LayoutUtils.getVisualPosition(layoutInterval3.getSubInterval(n4), n, 1);
                layoutInterval9.setSize(n7 - n5);
                this.layoutModel.addInterval(layoutInterval9, layoutInterval5, -1);
            }
            this.operations.addParallelWithSequence(layoutInterval5, layoutInterval3, n3, n4, n);
        }
    }

    private static int getDuplicationBoundary(LayoutInterval layoutInterval, int n, Set<LayoutInterval> set, int n2) {
        LayoutInterval layoutInterval2;
        assert (layoutInterval.isSequential());
        int n3 = n2 == 0 ? -1 : 1;
        n += n3;
        while (n >= 0 && n < layoutInterval.getSubIntervalCount() && !(layoutInterval2 = layoutInterval.getSubInterval(n)).isParallel()) {
            n += n3;
        }
        return n - n3;
    }

    /*
     * WARNING - void declaration
     */
    public void encloseInContainer(String[] stringArray, String string) {
        int n;
        LayoutConstants[] layoutConstantsArray;
        LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(string);
        if (layoutComponent == null) {
            layoutComponent = new LayoutComponent(string, true);
        } else {
            if (layoutComponent.getParent() != null) {
                throw new IllegalArgumentException("Target container already exists and is placed in the layout");
            }
            if (layoutComponent.getSubComponentCount() > 0) {
                throw new IllegalArgumentException("Target container is not empty.");
            }
        }
        LayoutComponent layoutComponent2 = null;
        LayoutComponent[] layoutComponentArray = new LayoutComponent[stringArray.length];
        LayoutInterval[] layoutIntervalArray = new LayoutInterval[2];
        boolean[] blArray = new boolean[2];
        HashMap<LayoutComponent, LayoutComponent> hashMap = new HashMap<LayoutComponent, LayoutComponent>();
        LayoutRegion layoutRegion = new LayoutRegion();
        int n2 = 0;
        for (String object : stringArray) {
            LayoutComponent layoutInterval2 = this.layoutModel.getLayoutComponent(object);
            layoutComponentArray[n2++] = layoutInterval2;
            hashMap.put(layoutInterval2, layoutInterval2);
            if (layoutComponent2 == null) {
                layoutComponent2 = layoutInterval2.getParent();
            }
            LayoutRegion layoutRegion2 = layoutInterval2.getLayoutInterval(0).getCurrentSpace();
            for (int i = 0; i < 2; ++i) {
                layoutRegion.expand(layoutRegion2, i);
                layoutIntervalArray[i] = layoutIntervalArray[i] == null ? layoutInterval2.getLayoutInterval(i) : LayoutInterval.getCommonParent(layoutIntervalArray[i], layoutInterval2.getLayoutInterval(i));
            }
        }
        Object[] objectArray = new LayoutInterval[2];
        for (int i = 0; i < 2; ++i) {
            objectArray[i] = LayoutInterval.getRoot(layoutComponentArray[0].getLayoutInterval(i));
            blArray[i] = LayoutInterval.wantResize(layoutIntervalArray[i]);
        }
        if (layoutComponent.isLayoutContainer()) {
            void var15_26;
            layoutConstantsArray = new LayoutInterval[2];
            for (n = 0; n < 2; ++n) {
                LayoutInterval layoutInterval = layoutIntervalArray[n];
                if (layoutInterval.isComponent()) {
                    this.layoutModel.removeInterval(layoutInterval);
                    layoutConstantsArray[n] = layoutInterval;
                    continue;
                }
                layoutConstantsArray[n] = this.restrictedCopy(layoutInterval, hashMap, layoutRegion, n, null);
            }
            LayoutComponent[] layoutComponentArray2 = layoutComponentArray;
            int n3 = layoutComponentArray2.length;
            boolean bl = false;
            while (var15_26 < n3) {
                LayoutComponent layoutComponent3 = layoutComponentArray2[var15_26];
                this.layoutModel.removeComponent(layoutComponent3, false);
                this.layoutModel.addComponent(layoutComponent3, layoutComponent, -1);
                ++var15_26;
            }
            for (n = 0; n < 2; ++n) {
                void var15_28;
                LayoutInterval layoutInterval = layoutComponent.getDefaultLayoutRoot(n);
                int n4 = layoutInterval.getSubIntervalCount();
                while (var15_28 > 0) {
                    layoutInterval.remove((int)(var15_28 - true));
                    --var15_28;
                }
                assert (layoutInterval.isParallel());
                LayoutInterval layoutInterval2 = new LayoutInterval(102);
                layoutInterval2.add(new LayoutInterval(101), -1);
                this.layoutModel.addInterval((LayoutInterval)layoutConstantsArray[n], layoutInterval2, -1);
                layoutInterval2.add(new LayoutInterval(101), -1);
                this.layoutModel.addInterval(layoutInterval2, layoutInterval, -1);
            }
        } else {
            void var14_22;
            layoutConstantsArray = layoutComponentArray;
            n = layoutConstantsArray.length;
            boolean bl = false;
            while (var14_22 < n) {
                LayoutConstants layoutConstants;
                this.layoutModel.removeComponentAndIntervals((LayoutComponent)layoutConstants, !((LayoutComponent)(layoutConstants = layoutConstantsArray[var14_22])).isLayoutContainer());
                ++var14_22;
            }
        }
        layoutConstantsArray = new LayoutInterval[2];
        for (n = 0; n < 2; ++n) {
            LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(n);
            layoutConstantsArray[n] = layoutInterval;
            layoutInterval.setSizes(-2, -1, blArray[n] ? Short.MAX_VALUE : -2);
        }
        this.prepareDragger(new LayoutComponent[]{layoutComponent}, new Rectangle[]{layoutRegion.toRectangle(new Rectangle())}, new Point(0, 0), LayoutDragger.ALL_EDGES);
        this.dragger.setTargetContainer(layoutComponent2, (LayoutInterval[])objectArray);
        this.dragger.move(new int[]{10, 10}, true, false);
        this.dragger.move(new int[]{0, 0}, true, false);
        this.addComponents(new LayoutComponent[]{layoutComponent}, layoutComponent2, (LayoutInterval[])layoutConstantsArray, false);
        this.dragger = null;
        this.visualStateUpToDate = false;
    }

    public void addUnspecifiedComponent(String string, String string2, Dimension dimension, String string3) {
        LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(string3);
        LayoutComponent layoutComponent2 = this.layoutModel.getLayoutComponent(string);
        if (layoutComponent2 == null) {
            layoutComponent2 = new LayoutComponent(string, false);
        } else if (layoutComponent2.getParent() != null) {
            if (layoutComponent2.getParent() != layoutComponent && string.equals(string2)) {
                this.layoutModel.removeComponentAndIntervals(layoutComponent2, false);
            } else {
                throw new IllegalArgumentException("Target component already exists and is placed in the layout");
            }
        }
        LayoutComponent layoutComponent3 = this.layoutModel.getLayoutComponent(string2);
        LayoutInterval[] layoutIntervalArray = new LayoutInterval[2];
        if (layoutComponent3 != null) {
            for (int i = 0; i < 2; ++i) {
                LayoutInterval layoutInterval = layoutComponent3.getLayoutInterval(i);
                layoutIntervalArray[i] = LayoutInterval.cloneInterval(layoutInterval, layoutComponent2.getLayoutInterval(i));
            }
        } else {
            Dimension dimension2 = dimension != null ? this.visualMapper.getComponentPreferredSize(string) : null;
            for (int i = 0; i < 2; ++i) {
                int n;
                LayoutInterval layoutInterval;
                layoutIntervalArray[i] = layoutInterval = layoutComponent2.getLayoutInterval(i);
                if (dimension2 == null) continue;
                int n2 = i == 0 ? dimension.width : dimension.height;
                int n3 = n = i == 0 ? dimension2.width : dimension2.height;
                if (n2 == n) continue;
                layoutInterval.setPreferredSize(n2);
            }
        }
        this.addUnspecified(new LayoutComponent[]{layoutComponent2}, layoutComponent, layoutIntervalArray);
        this.visualStateUpToDate = false;
    }

    public void addUnspecifiedComponent(LayoutComponent layoutComponent, String string) {
        if (layoutComponent.getParent() != null) {
            throw new IllegalArgumentException("The component already exists and is placed in the layout");
        }
        LayoutComponent layoutComponent2 = this.layoutModel.getLayoutComponent(string);
        if (layoutComponent2 == null) {
            this.layoutModel.addRootComponent(layoutComponent);
        } else {
            LayoutInterval[] layoutIntervalArray = new LayoutInterval[2];
            for (int i = 0; i < 2; ++i) {
                layoutIntervalArray[i] = layoutComponent.getLayoutInterval(i);
            }
            this.addUnspecified(new LayoutComponent[]{layoutComponent}, layoutComponent2, layoutIntervalArray);
            this.visualStateUpToDate = false;
        }
    }

    private LayoutInterval[] getTargetRootsForCopy(LayoutComponent layoutComponent) {
        LayoutInterval[] layoutIntervalArray = this.layoutModel.addNewLayoutRoots(layoutComponent);
        LayoutRegion layoutRegion = LayoutDesigner.getContainerSpace(layoutComponent);
        for (int i = 0; i < 2; ++i) {
            layoutIntervalArray[i].setCurrentSpace(layoutRegion);
        }
        return layoutIntervalArray;
    }

    private static int[] getCopyShift(LayoutComponent[] layoutComponentArray, LayoutComponent layoutComponent, LayoutRegion layoutRegion, boolean bl) {
        LayoutRegion layoutRegion2 = LayoutDesigner.getContainerSpace(layoutComponent);
        if (!layoutRegion.isSet() || !layoutRegion2.isSet()) {
            return null;
        }
        int[] nArray = new int[2];
        if (bl) {
            for (int i = 0; i < 2; ++i) {
                nArray[i] = LayoutDesigner.suggestCopyShift(layoutComponentArray, i);
            }
            if (nArray[0] == 0 && nArray[1] == 0) {
                nArray[1] = 10;
                nArray[0] = 10;
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                nArray[i] = (layoutRegion2.size(i) - layoutRegion.size(i)) / 2 - layoutRegion.positions[i][0] + layoutRegion2.positions[i][0];
            }
        }
        return nArray;
    }

    private static int suggestCopyShift(LayoutComponent[] layoutComponentArray, int n) {
        if (!LayoutDesigner.isAnyComponentSnappedToRoot(layoutComponentArray, n, 1)) {
            return 10;
        }
        if (!LayoutDesigner.isAnyComponentSnappedToRoot(layoutComponentArray, n, 0)) {
            return -10;
        }
        return 0;
    }

    private static boolean isAnyComponentSnappedToRoot(LayoutComponent[] layoutComponentArray, int n, int n2) {
        LayoutInterval layoutInterval = null;
        for (LayoutComponent layoutComponent : layoutComponentArray) {
            LayoutInterval layoutInterval2 = layoutComponent.getLayoutInterval(n);
            if (layoutInterval == null) {
                layoutInterval = LayoutInterval.getRoot(layoutInterval2);
            }
            if (!LayoutInterval.isPlacedAtBorder(layoutInterval2, layoutInterval, n, n2) && !LayoutDesigner.isSnappedNextToInParent(layoutInterval2, layoutInterval, n, n2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSnappedNextToInParent(LayoutInterval layoutInterval, LayoutInterval layoutInterval2, int n, int n2) {
        LayoutInterval layoutInterval3;
        LayoutInterval layoutInterval4 = LayoutInterval.getNeighbor(layoutInterval, n2, false, true, false);
        return layoutInterval4 != null && LayoutInterval.isFixedDefaultPadding(layoutInterval4) && layoutInterval2.isParentOf(layoutInterval4) && ((layoutInterval3 = LayoutInterval.getDirectNeighbor(layoutInterval4, n2 ^ 1, true)) == layoutInterval || LayoutInterval.isPlacedAtBorder(layoutInterval, layoutInterval3, n, n2)) && LayoutInterval.getNeighbor(layoutInterval4, n2, true, true, false) == null && LayoutInterval.isPlacedAtBorder(layoutInterval4.getParent(), layoutInterval2, n, n2);
    }

    private static LayoutRegion getContainerSpace(LayoutComponent layoutComponent) {
        return layoutComponent.getDefaultLayoutRoot(0).getCurrentSpace();
    }

    private LayoutInterval[] getActiveLayoutRoots(LayoutComponent layoutComponent) {
        return layoutComponent.getLayoutRoots().get(0);
    }

    private void layoutChanged(LayoutEvent layoutEvent) {
        LayoutEvent.Interval interval;
        LayoutInterval layoutInterval;
        LayoutComponent layoutComponent;
        if (layoutEvent.getType() == 4 && (layoutComponent = (layoutInterval = (interval = (LayoutEvent.Interval)layoutEvent).getInterval()).getComponent()) != null) {
            int n = -1;
            for (int i = 0; i < 2; ++i) {
                if (layoutComponent.getLayoutInterval(i) != layoutInterval) continue;
                n = i;
                break;
            }
            assert (n > -1);
            LayoutInterval layoutInterval2 = LayoutInterval.getRoot(interval.getParentInterval());
            this.intervalRemoved(interval.getParentInterval(), interval.getIndex(), true, LayoutInterval.wantResize(layoutInterval), n);
            LayoutComponent layoutComponent2 = layoutComponent.getParent();
            if (layoutComponent2 != null && layoutInterval2.getSubIntervalCount() == 0) {
                if (layoutInterval2 == this.getActiveLayoutRoots(layoutComponent2)[n]) {
                    if (layoutComponent2.getLayoutRootCount() == 2 && (this.dragger == null || this.dragger.getTargetContainer() != layoutComponent2)) {
                        this.layoutModel.removeLayoutRoots(layoutComponent2, layoutInterval2);
                    } else {
                        this.propEmptyContainer(layoutInterval2, n);
                    }
                } else if (this.dragger == null || !this.dragger.isResizing()) {
                    this.layoutModel.removeLayoutRoots(layoutComponent2, layoutInterval2);
                }
            }
        }
    }

    private boolean isComponentResizable(LayoutComponent layoutComponent, int n) {
        boolean[] blArray = layoutComponent.getResizability();
        if (blArray == null) {
            blArray = this.visualMapper.getComponentResizability(layoutComponent.getId(), new boolean[2]);
            layoutComponent.setResizability(blArray);
        }
        return blArray[n];
    }

    public void adjustComponentAlignment(LayoutComponent layoutComponent, int n, int n2) {
        LayoutInterval layoutInterval;
        if (this.logTestCode()) {
            this.testCode.add("// > ADJUST COMPONENT ALIGNMENT");
            this.testCode.add("{");
            this.testCode.add("LayoutComponent comp = model.getLayoutComponent(\"" + layoutComponent.getId() + "\");");
            this.testCode.add("int dimension = " + n);
            this.testCode.add("int alignment = " + n2);
            this.testCode.add("ld.adjustComponentAlignment(comp, dimension, alignment);");
            this.testCode.add("}");
        }
        this.modelListener.deactivate();
        LayoutInterval layoutInterval2 = layoutComponent.getLayoutInterval(n);
        for (layoutInterval = layoutInterval2.getParent(); layoutInterval != null; layoutInterval = layoutInterval.getParent()) {
            if (LayoutInterval.canResize(layoutInterval)) continue;
            layoutInterval2 = layoutInterval;
        }
        assert (!LayoutInterval.wantResize(layoutInterval2));
        boolean bl = false;
        for (layoutInterval = layoutInterval2.getParent(); layoutInterval != null; layoutInterval = layoutInterval.getParent()) {
            int n3;
            int n4;
            int n5;
            if (layoutInterval.isParallel()) {
                if (LayoutInterval.wantResize(layoutInterval) && !LayoutInterval.wantResize(layoutInterval2)) {
                    n5 = layoutInterval2.getAlignment();
                    if (n5 != n2) {
                        n4 = LayoutInterval.getIntervalCurrentSize(layoutInterval, n) - LayoutInterval.getIntervalCurrentSize(layoutInterval2, n);
                        if (n4 > 0) {
                            if (!layoutInterval2.isSequential()) {
                                LayoutInterval layoutInterval3 = new LayoutInterval(102);
                                this.layoutModel.setIntervalAlignment(layoutInterval2, -1);
                                int n6 = this.layoutModel.removeInterval(layoutInterval2);
                                this.layoutModel.addInterval(layoutInterval2, layoutInterval3, -1);
                                this.layoutModel.addInterval(layoutInterval3, layoutInterval, n6);
                                layoutInterval2 = layoutInterval3;
                            }
                            n3 = n5 == 0 ? -1 : 0;
                            LayoutInterval layoutInterval4 = new LayoutInterval(101);
                            layoutInterval4.setSize(n4);
                            this.layoutModel.addInterval(layoutInterval4, layoutInterval2, n3);
                        }
                        this.layoutModel.setIntervalAlignment(layoutInterval2, n2);
                    }
                    bl = true;
                }
            } else {
                n5 = 1;
                n4 = 0;
                for (n3 = 0; n3 < layoutInterval.getSubIntervalCount(); ++n3) {
                    LayoutInterval layoutInterval5 = layoutInterval.getSubInterval(n3);
                    if (layoutInterval5 == layoutInterval2) {
                        n5 = 0;
                        continue;
                    }
                    if (!LayoutInterval.wantResize(layoutInterval5) || (n5 == 0 || n2 != 0) && (n5 != 0 || n2 != 1)) continue;
                    assert (layoutInterval5.isEmptySpace());
                    this.setIntervalResizing(layoutInterval5, false);
                    if (layoutInterval5.getPreferredSize() == 0) {
                        this.layoutModel.removeInterval(layoutInterval5);
                        --n3;
                    }
                    n4 = 1;
                }
                if (!bl && n4 != 0) {
                    LayoutInterval layoutInterval6;
                    n3 = 0;
                    int n7 = layoutInterval.indexOf(layoutInterval2);
                    if (n2 == 0) {
                        if (layoutInterval.getSubIntervalCount() <= n7 + 1) {
                            n3 = 1;
                            n7 = -1;
                        } else if ((layoutInterval6 = layoutInterval.getSubInterval(++n7)).isEmptySpace()) {
                            this.setIntervalResizing(layoutInterval6, true);
                        } else {
                            n3 = 1;
                        }
                    } else {
                        assert (n2 == 1);
                        if (n7 == 0) {
                            n3 = 1;
                        } else {
                            layoutInterval6 = layoutInterval.getSubInterval(n7 - 1);
                            if (layoutInterval6.isEmptySpace()) {
                                this.setIntervalResizing(layoutInterval6, true);
                            } else {
                                n3 = 1;
                            }
                        }
                    }
                    if (n3 != 0) {
                        layoutInterval6 = new LayoutInterval(101);
                        this.setIntervalResizing(layoutInterval6, true);
                        this.layoutModel.setIntervalSize(layoutInterval6, 0, 0, layoutInterval6.getMaximumSize());
                        this.layoutModel.addInterval(layoutInterval6, layoutInterval, n7);
                    }
                    bl = true;
                }
            }
            layoutInterval2 = layoutInterval;
        }
        this.updateDesignModifications(layoutInterval2, n);
        this.modelListener.activate();
        this.visualStateUpToDate = false;
        if (this.logTestCode()) {
            this.testCode.add("// < ADJUST COMPONENT ALIGNMENT");
        }
    }

    public int[] getAdjustableComponentAlignment(LayoutComponent layoutComponent, int n) {
        int n2;
        if (layoutComponent == null) {
            return new int[]{-1, 0};
        }
        LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(n);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        if (LayoutInterval.wantResize(layoutInterval)) {
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = false;
        }
        for (LayoutInterval layoutInterval2 = layoutInterval.getParent(); layoutInterval2 != null; layoutInterval2 = layoutInterval2.getParent()) {
            block10: {
                block11: {
                    block12: {
                        block9: {
                            if (LayoutInterval.canResize(layoutInterval2)) break block9;
                            bl4 = true;
                            bl3 = true;
                            bl2 = true;
                            bl = true;
                            break block10;
                        }
                        if (!layoutInterval2.isParallel()) break block11;
                        if (!LayoutInterval.wantResize(layoutInterval2) || LayoutInterval.wantResize(layoutInterval)) break block10;
                        n2 = layoutInterval.getAlignment();
                        if (n2 != 0) break block12;
                        bl2 = false;
                        break block10;
                    }
                    if (n2 != 1) break block10;
                    bl = false;
                    break block10;
                }
                n2 = 1;
                Iterator<LayoutInterval> iterator = layoutInterval2.getSubIntervals();
                while (iterator.hasNext()) {
                    LayoutInterval layoutInterval3 = iterator.next();
                    if (layoutInterval3 == layoutInterval) {
                        n2 = 0;
                        continue;
                    }
                    if (!LayoutInterval.wantResize(layoutInterval3)) continue;
                    boolean bl5 = layoutInterval3.isEmptySpace();
                    if (n2 != 0) {
                        bl = false;
                        if (bl5) continue;
                        bl3 = false;
                        continue;
                    }
                    bl2 = false;
                    if (bl5) continue;
                    bl4 = false;
                }
            }
            layoutInterval = layoutInterval2;
        }
        n2 = (bl3 ? 1 : 0) + (bl4 ? 2 : 0);
        if (bl && bl2) {
            if (0 == layoutInterval.getGroupAlignment()) {
                bl2 = false;
            } else {
                bl = false;
            }
        }
        int n3 = bl ? 0 : (bl2 ? 1 : -1);
        return new int[]{n3, n2};
    }

    public boolean isComponentResizing(LayoutComponent layoutComponent, int n) {
        LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(n);
        boolean bl = layoutInterval.hasAttribute(1);
        return bl ? false : LayoutInterval.wantResizeInLayout(layoutInterval);
    }

    private int prefSizeOfInterval(LayoutInterval layoutInterval) {
        int n;
        block11: {
            int n2 = -1;
            if (layoutInterval.isComponent()) {
                LayoutComponent layoutComponent = layoutInterval.getComponent();
                int n3 = n2 = layoutInterval == layoutComponent.getLayoutInterval(0) ? 0 : 1;
                if (layoutComponent.isLinkSized(n2)) {
                    Collection collection = this.layoutModel.getLinkSizeGroups(n2).get(new Integer(layoutComponent.getLinkSizeId(n2)));
                    Iterator iterator = collection.iterator();
                    int n4 = 0;
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        LayoutComponent layoutComponent2 = this.layoutModel.getLayoutComponent(string);
                        LayoutInterval layoutInterval2 = layoutComponent2.getLayoutInterval(n2);
                        int n5 = layoutInterval2.getPreferredSize();
                        if (n5 == -1) {
                            Dimension dimension = this.visualMapper.getComponentPreferredSize(string);
                            n5 = n2 == 0 ? dimension.width : dimension.height;
                        }
                        n4 = Math.max(n5, n4);
                    }
                    return n4;
                }
            }
            if ((n = layoutInterval.getPreferredSize()) != -1) break block11;
            if (layoutInterval.isComponent()) {
                LayoutComponent layoutComponent = layoutInterval.getComponent();
                Dimension dimension = this.visualMapper.getComponentPreferredSize(layoutComponent.getId());
                return n2 == 0 ? dimension.width : dimension.height;
            }
            if (layoutInterval.isEmptySpace()) {
                return this.sizeOfEmptySpace(layoutInterval);
            }
            assert (layoutInterval.isGroup());
            n = 0;
            Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
            if (layoutInterval.isSequential()) {
                while (iterator.hasNext()) {
                    LayoutInterval layoutInterval3 = iterator.next();
                    n += this.prefSizeOfInterval(layoutInterval3);
                }
            } else {
                while (iterator.hasNext()) {
                    LayoutInterval layoutInterval4 = iterator.next();
                    n = Math.max(n, this.prefSizeOfInterval(layoutInterval4));
                }
            }
        }
        return n;
    }

    private int sizeOfEmptySpace(LayoutInterval layoutInterval) {
        return LayoutUtils.getSizeOfDefaultGap(layoutInterval, this.visualMapper);
    }

    public void setComponentResizing(LayoutComponent layoutComponent, int n, boolean bl) {
        int n2;
        int n3;
        Object object;
        if (this.logTestCode()) {
            this.testCode.add("// > SET COMPONENT RESIZING");
            this.testCode.add("{");
            this.testCode.add("LayoutComponent comp = lm.getLayoutComponent(\"" + layoutComponent.getId() + "\");");
            this.testCode.add("int dimension = " + n + ";");
            this.testCode.add("boolean resizing = " + bl + ";");
            this.testCode.add("ld.setComponentResizing(comp, dimension, resizing);");
            this.testCode.add("}");
        }
        this.modelListener.deactivate();
        LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(n);
        if (bl && layoutComponent.isLinkSized(n)) {
            object = this.layoutModel.getLinkSizeGroups(n).get(new Integer(layoutComponent.getLinkSizeId(n)));
            Object object2 = object.size() == 2 ? object : Collections.singletonList(layoutComponent.getId());
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                LayoutComponent layoutComponent2 = this.layoutModel.getLayoutComponent(string);
                LayoutInterval layoutInterval2 = layoutComponent2.getLayoutInterval(n);
                Dimension dimension = this.visualMapper.getComponentPreferredSize(string);
                int n4 = n == 0 ? dimension.width : dimension.height;
                int n5 = layoutInterval2.getCurrentSpace().size(n);
                if (n5 == n4) {
                    n5 = -1;
                }
                this.layoutModel.setIntervalSize(layoutInterval2, layoutInterval2.getMinimumSize(), n5, layoutInterval2.getMaximumSize());
            }
        }
        object = layoutInterval.getParent();
        boolean bl2 = layoutInterval.hasAttribute(1);
        boolean bl3 = layoutInterval.hasAttribute(2);
        if (bl2 || bl3) {
            this.switchFillAttribute(layoutInterval, bl);
        } else {
            this.setIntervalResizing(layoutInterval, bl);
        }
        int n6 = 0;
        if (!bl && (n6 = (n3 = LayoutInterval.getIntervalCurrentSize(layoutInterval, n)) - (n2 = this.prefSizeOfInterval(layoutInterval))) != 0) {
            this.layoutModel.setIntervalSize(layoutInterval, layoutInterval.getMinimumSize(), n3, layoutInterval.getMaximumSize());
        }
        Object object3 = layoutInterval;
        for (Object object4 = object; object4 != null; object4 = ((LayoutInterval)object4).getParent()) {
            int n7;
            LayoutInterval layoutInterval3;
            int n8;
            LayoutInterval layoutInterval4;
            int n9;
            if (((LayoutInterval)object4).isParallel() && bl) {
                int n10;
                n9 = LayoutInterval.getIntervalCurrentSize(object4, n);
                if (n9 != (n10 = LayoutInterval.getIntervalCurrentSize((LayoutInterval)object3, n))) {
                    int n11;
                    Object object5 = object3;
                    layoutInterval4 = new LayoutInterval(101);
                    layoutInterval4.setSize(n9 - n10);
                    int n12 = ((LayoutInterval)object3).getAlignment();
                    int n13 = n8 = n12 == 0 ? -1 : 0;
                    if (((LayoutInterval)object3).isSequential()) {
                        n11 = n12 == 0 ? ((LayoutInterval)object3).getSubIntervalCount() - 1 : 0;
                        layoutInterval3 = ((LayoutInterval)object3).getSubInterval(n11);
                        if (layoutInterval3.isEmptySpace()) {
                            n7 = LayoutInterval.getIntervalCurrentSize(layoutInterval3, n);
                            this.layoutModel.removeInterval(layoutInterval3);
                            layoutInterval4.setSize(n9 - n10 + n7);
                        }
                    } else {
                        object5 = new LayoutInterval(102);
                        this.layoutModel.setIntervalAlignment((LayoutInterval)object3, -1);
                        ((LayoutInterval)object5).setAlignment(n12);
                        n11 = this.layoutModel.removeInterval((LayoutInterval)object3);
                        this.layoutModel.addInterval((LayoutInterval)object3, (LayoutInterval)object5, -1);
                        this.layoutModel.addInterval((LayoutInterval)object5, (LayoutInterval)object4, n11);
                    }
                    this.layoutModel.addInterval(layoutInterval4, (LayoutInterval)object5, n8);
                    ((LayoutInterval)object5).getCurrentSpace().set(n, ((LayoutInterval)object4).getCurrentSpace());
                }
            } else if (((LayoutInterval)object4).isSequential()) {
                n9 = object == object4 ? 1 : 0;
                LinkedList<LayoutInterval> linkedList = new LinkedList<LayoutInterval>();
                int n14 = n9 != 0 ? LayoutInterval.getEffectiveAlignment(layoutInterval) : 0;
                layoutInterval4 = null;
                LayoutInterval layoutInterval5 = null;
                n8 = 0;
                Iterator<LayoutInterval> iterator = ((LayoutInterval)object4).getSubIntervals();
                while (iterator.hasNext()) {
                    layoutInterval3 = iterator.next();
                    if (layoutInterval3 == layoutInterval) {
                        n8 = 1;
                    }
                    if (layoutInterval3.isEmptySpace()) {
                        int n15;
                        if (bl) {
                            this.setIntervalResizing(layoutInterval3, false);
                            n7 = LayoutInterval.getIntervalCurrentSize(layoutInterval3, n);
                            if (n7 == (n15 = this.prefSizeOfInterval(layoutInterval3))) continue;
                            this.layoutModel.setIntervalSize(layoutInterval3, layoutInterval3.getMinimumSize(), n7, layoutInterval3.getMaximumSize());
                            n6 += n7 - n15;
                            continue;
                        }
                        if (n9 == 0) continue;
                        n7 = layoutInterval3.hasAttribute(2);
                        int n16 = n15 = layoutInterval3.getPreferredSize() != -1 ? 1 : 0;
                        if (n7 != 0) {
                            layoutInterval5 = layoutInterval3;
                        } else if (layoutInterval5 == null || !layoutInterval5.hasAttribute(2)) {
                            if (n15 != 0) {
                                layoutInterval5 = layoutInterval3;
                            } else if (n8 != 0 && (layoutInterval5 == null || layoutInterval5.getPreferredSize() == -1)) {
                                layoutInterval5 = layoutInterval3;
                            }
                        }
                        if (layoutInterval4 == null && n8 == 0) {
                            layoutInterval4 = layoutInterval3;
                            continue;
                        }
                        if ((n7 == 0 || layoutInterval4 != null && layoutInterval4.hasAttribute(2)) && (n15 == 0 || layoutInterval4 != null && (layoutInterval4.hasAttribute(2) || layoutInterval4.getPreferredSize() != -1))) continue;
                        layoutInterval4 = layoutInterval3;
                        continue;
                    }
                    if (layoutInterval3.getMaximumSize() != Short.MAX_VALUE) continue;
                    linkedList.add(layoutInterval3);
                }
                if (linkedList.size() > 0) {
                    iterator = linkedList.iterator();
                    n6 = (LayoutInterval.getIntervalCurrentSize((LayoutInterval)object4, n) - this.prefSizeOfInterval((LayoutInterval)object4) + n6) / linkedList.size();
                    while (iterator.hasNext()) {
                        layoutInterval3 = iterator.next();
                        if (layoutInterval3.isGroup()) continue;
                        if (layoutInterval3 == layoutInterval) {
                            if (n6 == 0) continue;
                            n7 = this.prefSizeOfInterval(layoutInterval3);
                            this.layoutModel.setIntervalSize(layoutInterval3, layoutInterval3.getMinimumSize(), Math.max(0, n7 - n6), layoutInterval3.getMaximumSize());
                            continue;
                        }
                        n7 = LayoutInterval.getIntervalCurrentSize(layoutInterval3, n);
                        this.layoutModel.setIntervalSize(layoutInterval3, layoutInterval3.getMinimumSize(), Math.max(0, n7 - n6), layoutInterval3.getMaximumSize());
                    }
                }
                if (n9 != 0) {
                    if (!LayoutInterval.wantResize((LayoutInterval)object4)) {
                        layoutInterval3 = null;
                        if (n14 == 1 && layoutInterval4 != null) {
                            layoutInterval3 = layoutInterval4;
                            this.setIntervalResizing(layoutInterval4, !bl);
                            this.layoutModel.changeIntervalAttribute(layoutInterval4, 1, true);
                        }
                        if (n14 == 0 && layoutInterval5 != null) {
                            layoutInterval3 = layoutInterval5;
                            this.setIntervalResizing(layoutInterval5, !bl);
                            this.layoutModel.changeIntervalAttribute(layoutInterval5, 1, true);
                        }
                        if (layoutInterval3 != null && n6 != 0 && layoutInterval3.getPreferredSize() != -1) {
                            this.layoutModel.setIntervalSize(layoutInterval3, layoutInterval3.getMinimumSize(), Math.max(0, layoutInterval3.getPreferredSize() - n6), layoutInterval3.getMaximumSize());
                        }
                    }
                    object = ((LayoutInterval)object4).getParent();
                }
            }
            object3 = object4;
        }
        if (bl) {
            this.layoutModel.unsetSameSize(Collections.singletonList(layoutComponent.getId()), n);
        }
        this.modelListener.activate();
        if (bl) {
            while (object != null) {
                if (!LayoutInterval.canResize(object)) {
                    this.operations.enableGroupResizing((LayoutInterval)object);
                }
                object = ((LayoutInterval)object).getParent();
            }
        } else {
            while (object != null && this.fillResizable((LayoutInterval)object)) {
                this.operations.suppressGroupResizing((LayoutInterval)object);
                object = ((LayoutInterval)object).getParent();
            }
        }
        this.updateDesignModifications(layoutComponent.getParent());
        this.visualStateUpToDate = false;
        if (this.logTestCode()) {
            this.testCode.add("// < SET COMPONENT RESIZING");
        }
    }

    private boolean fillResizable(LayoutInterval layoutInterval) {
        if (!LayoutInterval.canResize(layoutInterval)) {
            return false;
        }
        if (layoutInterval.isGroup()) {
            boolean bl = true;
            Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
            while (iterator.hasNext()) {
                LayoutInterval layoutInterval2 = iterator.next();
                if (!LayoutInterval.wantResize(layoutInterval2) || this.fillResizable(layoutInterval2)) continue;
                bl = false;
                break;
            }
            return bl;
        }
        return layoutInterval.hasAttribute(1);
    }

    public boolean canAlign(Collection<String> collection) {
        if (collection != null && collection.size() > 1) {
            LayoutInterval layoutInterval = null;
            for (String string : collection) {
                LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(string);
                if (layoutComponent == null || layoutComponent.getParent() == null) {
                    return false;
                }
                LayoutInterval layoutInterval2 = LayoutInterval.getRoot(layoutComponent.getLayoutInterval(0));
                if (layoutInterval == null) {
                    layoutInterval = layoutInterval2;
                    continue;
                }
                if (layoutInterval2 == layoutInterval) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void align(Collection collection, boolean bl, int n, int n2) {
        if (this.logTestCode()) {
            this.testCode.add("// > ALIGN");
            this.testCode.add("{");
            LayoutTestUtils.writeCollection(this.testCode, "componentIds", collection);
            this.testCode.add("boolean closed = " + bl + ";");
            this.testCode.add("int dimension = " + n + ";");
            this.testCode.add("int alignment = " + n2 + ";");
            this.testCode.add("ld.align(componentIds, closed, dimension, alignment);");
            this.testCode.add("}");
        }
        LayoutInterval[] layoutIntervalArray = new LayoutInterval[collection.size()];
        int n3 = 0;
        for (String string : collection) {
            LayoutComponent layoutComponent = this.layoutModel.getLayoutComponent(string);
            layoutIntervalArray[n3++] = layoutComponent.getLayoutInterval(n);
        }
        this.modelListener.deactivate();
        try {
            new LayoutAligner(this, this.layoutModel, this.operations).alignIntervals(layoutIntervalArray, bl, n, n2);
        }
        finally {
            this.modelListener.activate();
        }
        this.requireStructureOptimization();
        if (this.logTestCode()) {
            this.testCode.add("// < ALIGN");
        }
    }

    private void destroyRedundantGroups(Set<LayoutComponent> set) {
        Iterator iterator = this.layoutModel.getAllComponents();
        while (iterator.hasNext()) {
            LayoutComponent layoutComponent = (LayoutComponent)iterator.next();
            if (!layoutComponent.isLayoutContainer()) continue;
            boolean bl = false;
            for (LayoutInterval[] layoutIntervalArray : layoutComponent.getLayoutRoots()) {
                for (int i = 0; i < 2; ++i) {
                    bl = this.destroyRedundantGroups(layoutIntervalArray[i]) || bl;
                }
            }
            if (!bl) continue;
            set.add(layoutComponent);
        }
    }

    private boolean destroyRedundantGroups(LayoutInterval layoutInterval) {
        boolean bl = false;
        for (int i = layoutInterval.getSubIntervalCount() - 1; i >= 0; --i) {
            LayoutInterval layoutInterval2;
            if (i >= layoutInterval.getSubIntervalCount() || !(layoutInterval2 = layoutInterval.getSubInterval(i)).isGroup()) continue;
            this.destroyRedundantGroups(layoutInterval2);
            this.destroyGroupIfRedundant(layoutInterval2, layoutInterval);
            bl |= layoutInterval2.getParent() == null;
        }
        return bl;
    }

    void destroyGroupIfRedundant(LayoutInterval layoutInterval, LayoutInterval layoutInterval2) {
        if (layoutInterval == null || !layoutInterval.isGroup() || layoutInterval == layoutInterval2) {
            return;
        }
        LayoutInterval layoutInterval3 = layoutInterval.getParent();
        if (layoutInterval3 == null) {
            return;
        }
        if (LayoutInterval.getCount(layoutInterval, Integer.MAX_VALUE, true) == 0) {
            this.takeOutInterval(layoutInterval, layoutInterval2);
            return;
        }
        if (this.operations.dissolveRedundantGroup(layoutInterval)) {
            this.destroyGroupIfRedundant(layoutInterval3, layoutInterval2);
        }
    }

    void takeOutInterval(LayoutInterval layoutInterval, LayoutInterval layoutInterval2) {
        LayoutInterval layoutInterval3 = layoutInterval.getParent();
        int n = layoutInterval3.indexOf(layoutInterval);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(layoutInterval);
        if (layoutInterval3.isSequential()) {
            Object object;
            if (n > 0 && ((LayoutInterval)(object = layoutInterval3.getSubInterval(n - 1))).isEmptySpace()) {
                linkedList.add(object);
            }
            if (n + 1 < layoutInterval3.getSubIntervalCount() && ((LayoutInterval)(object = layoutInterval3.getSubInterval(n + 1))).isEmptySpace()) {
                linkedList.add(object);
            }
            if (linkedList.size() == 3 && layoutInterval3.getSubIntervalCount() > 3) {
                object = new LayoutInterval(101);
                if (layoutInterval.isComponent() && layoutInterval.getComponent().getLayoutInterval(1) == layoutInterval) {
                    int n2 = LayoutInterval.getEffectiveAlignment(layoutInterval);
                    int n3 = 0;
                    for (int i = 0; i < 3; ++i) {
                        n3 += LayoutInterval.getIntervalCurrentSize((LayoutInterval)linkedList.get(i), 1);
                    }
                    ((LayoutInterval)object).setSizes(-1, n3, n2 == 1 ? Short.MAX_VALUE : -2);
                }
                this.layoutModel.addInterval((LayoutInterval)object, layoutInterval3, n);
            }
        }
        for (LayoutInterval layoutInterval4 : linkedList) {
            this.layoutModel.removeInterval(layoutInterval4);
        }
        this.destroyGroupIfRedundant(layoutInterval3, layoutInterval2);
    }

    void createRemainderGroup(List list, LayoutInterval layoutInterval, int n, int n2, int n3, int n4) {
        Object object;
        int n5;
        Object object22;
        assert (layoutInterval.isSequential() && (n2 == 0 || n2 == 1));
        if (n2 == 1) {
            ++n;
        }
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        for (int i = list.size() - 1; i >= 0; --i) {
            object22 = (List)list.get(i);
            if (object22.size() != 2) continue;
            n5 = (Integer)object22.get(0);
            object = (LayoutInterval)object22.get(1);
            if (((LayoutInterval)object).isEmptySpace()) {
                if (object3 == null || ((LayoutInterval)object).getMaximumSize() > ((LayoutInterval)object3).getMaximumSize()) {
                    object3 = object;
                }
                if (LayoutDesigner.isFixedPadding((LayoutInterval)object)) {
                    if (n5 == 0) {
                        object4 = object;
                        bl3 = false;
                    } else if (n5 == 1) {
                        object5 = object;
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                    bl3 = false;
                }
                list.remove(i);
                continue;
            }
            bl = false;
        }
        if (list.size() == 1) {
            List list2 = (List)list.get(0);
            object22 = list2.iterator();
            object22.next();
            do {
                LayoutInterval layoutInterval2 = (LayoutInterval)object22.next();
                this.layoutModel.addInterval(layoutInterval2, layoutInterval, n++);
            } while (object22.hasNext());
            return;
        }
        for (Object object22 : list) {
            if (object22.size() == 2) continue;
            bl = false;
            n5 = 1;
            object = object22.iterator();
            object.next();
            do {
                LayoutInterval layoutInterval3 = (LayoutInterval)object.next();
                if (n5 != 0) {
                    n5 = 0;
                    if (LayoutDesigner.isFixedPadding(layoutInterval3)) {
                        object4 = layoutInterval3;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                if (object.hasNext()) continue;
                if (LayoutDesigner.isFixedPadding(layoutInterval3)) {
                    object5 = layoutInterval3;
                    continue;
                }
                bl3 = false;
            } while (object.hasNext());
        }
        if (bl) {
            this.operations.insertGapIntoSequence((LayoutInterval)object3, layoutInterval, n, n4);
            return;
        }
        LayoutInterval layoutInterval4 = new LayoutInterval(103);
        if (n2 == n3) {
            layoutInterval4.setMinimumSize(-2);
            layoutInterval4.setMaximumSize(-2);
        }
        for (List list3 : list) {
            if (bl2) {
                list3.remove(1);
            }
            if (bl3) {
                list3.remove(list3.size() - 1);
            }
            if (list3.size() == 2) {
                int n6 = (Integer)list3.get(0);
                object = (LayoutInterval)list3.get(1);
                if (n6 == 0 || n6 == 1) {
                    this.layoutModel.setIntervalAlignment((LayoutInterval)object, n6);
                }
            } else {
                object = new LayoutInterval(102);
                Iterator iterator = list3.iterator();
                int n7 = (Integer)iterator.next();
                if (n7 == 0 || n7 == 1) {
                    ((LayoutInterval)object).setAlignment(n7);
                }
                do {
                    LayoutInterval layoutInterval5 = (LayoutInterval)iterator.next();
                    this.layoutModel.addInterval(layoutInterval5, (LayoutInterval)object, -1);
                } while (iterator.hasNext());
            }
            this.layoutModel.addInterval((LayoutInterval)object, layoutInterval4, -1);
        }
        if (bl2) {
            this.layoutModel.addInterval((LayoutInterval)object4, layoutInterval, n++);
        }
        this.layoutModel.addInterval(layoutInterval4, layoutInterval, n++);
        if (bl3) {
            this.layoutModel.addInterval((LayoutInterval)object5, layoutInterval, n);
        }
    }

    static boolean isFixedPadding(LayoutInterval layoutInterval) {
        return !(!layoutInterval.isEmptySpace() || layoutInterval.getMinimumSize() != -1 && layoutInterval.getMinimumSize() != -2 || layoutInterval.getPreferredSize() != -1 || layoutInterval.getMaximumSize() != -1 && layoutInterval.getMaximumSize() != -2);
    }

    private int optimizeGaps(LayoutInterval layoutInterval, int n, boolean bl) {
        int n2;
        LayoutInterval layoutInterval2;
        int n3;
        assert (layoutInterval.isParallel());
        if (bl) {
            for (n3 = 0; n3 < layoutInterval.getSubIntervalCount(); ++n3) {
                layoutInterval2 = layoutInterval.getSubInterval(n3);
                if (layoutInterval2.isParallel()) {
                    this.optimizeGaps(layoutInterval2, n, bl);
                    continue;
                }
                if (!layoutInterval2.isSequential()) continue;
                for (int i = 0; i < layoutInterval2.getSubIntervalCount(); ++i) {
                    LayoutInterval layoutInterval3 = layoutInterval2.getSubInterval(i);
                    if (!layoutInterval3.isParallel() || (n2 = this.optimizeGaps(layoutInterval3, n, bl)) < 0) continue;
                    i = n2;
                }
            }
        }
        if (layoutInterval.getGroupAlignment() == 3) {
            return -1;
        }
        n3 = LayoutInterval.getCount(layoutInterval, Integer.MAX_VALUE, true);
        if (n3 <= 1) {
            if (layoutInterval.getParent() == null) {
                if (layoutInterval.getSubIntervalCount() > 1) {
                    for (int i = layoutInterval.getSubIntervalCount() - 1; i >= 0; --i) {
                        if (!layoutInterval.getSubInterval(i).isEmptySpace()) continue;
                        this.layoutModel.removeInterval(layoutInterval, i);
                        break;
                    }
                } else if (layoutInterval.getSubIntervalCount() == 0) {
                    this.propEmptyContainer(layoutInterval, n);
                }
            } else {
                assert (n3 == 1);
                assert (layoutInterval.getSubIntervalCount() == 1);
                layoutInterval2 = layoutInterval.getSubInterval(0);
                this.layoutModel.removeInterval(layoutInterval2);
                this.layoutModel.setIntervalAlignment(layoutInterval2, layoutInterval.getAlignment());
                LayoutInterval layoutInterval4 = layoutInterval.getParent();
                int n4 = this.layoutModel.removeInterval(layoutInterval);
                if (layoutInterval4.isSequential() && layoutInterval2.isSequential()) {
                    for (n2 = layoutInterval2.getSubIntervalCount() - 1; n2 >= 0; --n2) {
                        LayoutInterval layoutInterval5 = layoutInterval2.getSubInterval(n2);
                        this.layoutModel.removeInterval(layoutInterval5);
                        this.layoutModel.addInterval(layoutInterval5, layoutInterval4, n4);
                    }
                    this.eliminateConsecutiveGaps(layoutInterval4, 0, n);
                } else {
                    this.layoutModel.addInterval(layoutInterval2, layoutInterval4, n4);
                }
            }
            return -1;
        }
        return this.operations.optimizeGaps(layoutInterval, n);
    }

    void setIntervalResizing(LayoutInterval layoutInterval, boolean bl) {
        this.switchFillAttribute(layoutInterval, bl);
        this.layoutModel.setIntervalSize(layoutInterval, bl ? -1 : -2, layoutInterval.getPreferredSize(), bl ? Short.MAX_VALUE : -2);
    }

    private void switchFillAttribute(LayoutInterval layoutInterval, boolean bl) {
        if (bl) {
            if (layoutInterval.hasAttribute(1)) {
                this.layoutModel.changeIntervalAttribute(layoutInterval, 2, true);
                this.layoutModel.changeIntervalAttribute(layoutInterval, 1, false);
            }
        } else if (layoutInterval.hasAttribute(2)) {
            this.layoutModel.changeIntervalAttribute(layoutInterval, 2, false);
            this.layoutModel.changeIntervalAttribute(layoutInterval, 1, true);
        }
    }

    public void setDefaultSize(String string) {
        LayoutComponent layoutComponent;
        if (this.logTestCode()) {
            this.testCode.add("// > SET DEFAULT SIZE");
            this.testCode.add("{");
            this.testCode.add("String compId = \"${" + string + "}\";");
            this.testCode.add("ld.setDefaultSize(compId);");
            this.testCode.add("}");
        }
        if ((layoutComponent = this.layoutModel.getLayoutComponent(string)) != null) {
            this.setDefaultSize(layoutComponent);
        }
        if (this.logTestCode()) {
            this.testCode.add("// < SET DEFAULT SIZE");
        }
    }

    private void setDefaultSize(LayoutComponent layoutComponent) {
        this.imposeSize = true;
        if (layoutComponent.isLayoutContainer()) {
            for (LayoutComponent layoutIntervalArray : layoutComponent.getSubcomponents()) {
                if (!layoutIntervalArray.isLayoutContainer()) continue;
                this.setDefaultSize(layoutIntervalArray);
            }
            for (LayoutInterval[] layoutIntervalArray : layoutComponent.getLayoutRoots()) {
                for (int i = 0; i < 2; ++i) {
                    this.setDefaultSizeInContainer(layoutIntervalArray[i]);
                }
            }
            this.updateDesignModifications(layoutComponent);
        } else {
            this.operations.resizeInterval(layoutComponent.getLayoutInterval(0), -1);
            this.operations.resizeInterval(layoutComponent.getLayoutInterval(1), -1);
        }
    }

    private void setDefaultSizeInContainer(LayoutInterval layoutInterval) {
        if (!layoutInterval.isGroup()) {
            if (LayoutInterval.canResize(layoutInterval)) {
                this.operations.resizeInterval(layoutInterval, layoutInterval.getMinimumSize() != -2 ? layoutInterval.getMinimumSize() : -1);
                layoutInterval.setAttribute(256);
            }
        } else {
            Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
            while (iterator.hasNext()) {
                this.setDefaultSizeInContainer(iterator.next());
            }
        }
    }

    private void updateDesignModifications(LayoutComponent layoutComponent) {
        if (this.imposeSize || this.optimizeStructure) {
            LayoutInterval[] layoutIntervalArray = this.getActiveLayoutRoots(layoutComponent);
            for (int i = 0; i < 2; ++i) {
                LayoutDesigner.cleanDesignAttrs(layoutIntervalArray[i]);
            }
        } else {
            LayoutInterval[] layoutIntervalArray = this.getActiveLayoutRoots(layoutComponent);
            for (int i = 0; i < 2; ++i) {
                this.updateDesignModifications(layoutIntervalArray[i], i);
            }
        }
    }

    private void updateDesignModifications(LayoutInterval layoutInterval, int n) {
        LayoutDesigner.cleanDesignAttrs(layoutInterval);
        this.findContainerResizingGap(layoutInterval, n);
    }

    private static void cleanDesignAttrs(LayoutInterval layoutInterval) {
        layoutInterval.unsetAttribute(220);
        int n = layoutInterval.getSubIntervalCount();
        for (int i = 0; i < n; ++i) {
            LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(i);
            if (layoutInterval2.isGroup()) {
                LayoutDesigner.cleanDesignAttrs(layoutInterval2);
                continue;
            }
            layoutInterval2.unsetAttribute(220);
        }
    }

    private void findContainerResizingGap(LayoutInterval layoutInterval, int n) {
        LayoutInterval layoutInterval2;
        if (!LayoutInterval.wantResize(layoutInterval) && LayoutInterval.getIntervalCurrentSize(layoutInterval, n) != this.prefSizeOfInterval(layoutInterval)) {
            return;
        }
        int n2 = 1;
        LayoutInterval layoutInterval3 = LayoutDesigner.findContainerResizingGap(layoutInterval, n, n2);
        if (layoutInterval3 == null) {
            n2 = 0;
            layoutInterval3 = LayoutDesigner.findContainerResizingGap(layoutInterval, n, n2);
            if (layoutInterval3 == null && (layoutInterval3 = LayoutDesigner.findContainerResizingGap(layoutInterval, n, n2 = -1)) == null) {
                return;
            }
        } else if (!LayoutInterval.canResize(layoutInterval3)) {
            layoutInterval2 = LayoutDesigner.findContainerResizingGap(layoutInterval, n, 0);
            if (layoutInterval2 != null && LayoutInterval.canResize(layoutInterval2)) {
                layoutInterval3 = layoutInterval2;
                n2 = 0;
            } else {
                layoutInterval2 = LayoutDesigner.findContainerResizingGap(layoutInterval, n, -1);
                if (layoutInterval2 != null && LayoutInterval.canResize(layoutInterval2)) {
                    layoutInterval3 = layoutInterval2;
                    n2 = -1;
                }
            }
        }
        layoutInterval3.setAttribute(12);
        layoutInterval2 = layoutInterval3;
        LayoutInterval layoutInterval4 = layoutInterval3.getParent();
        do {
            LayoutInterval layoutInterval5;
            Iterator<LayoutInterval> iterator;
            if (layoutInterval4.isSequential()) {
                iterator = layoutInterval4.getSubIntervals();
                while (iterator.hasNext()) {
                    layoutInterval5 = iterator.next();
                    if (layoutInterval5 == layoutInterval2) continue;
                    layoutInterval5.setAttribute(16);
                }
                continue;
            }
            iterator = layoutInterval4.getSubIntervals();
            while (iterator.hasNext()) {
                layoutInterval5 = iterator.next();
                if (layoutInterval5 == layoutInterval2) continue;
                assert (layoutInterval5.isSequential());
                if (layoutInterval5.isSequential()) {
                    int n3 = layoutInterval5.getSubIntervalCount();
                    for (int i = 0; i < n3; ++i) {
                        LayoutInterval layoutInterval6 = layoutInterval5.getSubInterval(i);
                        if ((i == 0 && n2 == 0 || i + 1 == n3 && n2 == 1) && LayoutDesigner.canBeContainerResizingGap(layoutInterval6)) {
                            layoutInterval6.setAttribute(8);
                            continue;
                        }
                        layoutInterval6.setAttribute(16);
                    }
                    continue;
                }
                layoutInterval5.setAttribute(16);
            }
        } while ((layoutInterval4 = (layoutInterval2 = layoutInterval4).getParent()) != null);
    }

    private static LayoutInterval findContainerResizingGap(LayoutInterval layoutInterval, int n, int n2) {
        assert (layoutInterval.isParallel());
        LayoutInterval layoutInterval2 = null;
        int n3 = Integer.MAX_VALUE;
        Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            LayoutInterval layoutInterval3;
            LayoutInterval layoutInterval4 = iterator.next();
            if (!layoutInterval4.isSequential()) {
                return null;
            }
            int n4 = layoutInterval4.getSubIntervalCount();
            if (n2 == 0 || n2 == 1) {
                LayoutInterval layoutInterval5 = layoutInterval4.getSubInterval(n2 == 0 ? 0 : n4 - 1);
                layoutInterval3 = LayoutDesigner.canBeContainerResizingGap(layoutInterval5) && (LayoutInterval.wantResize(layoutInterval4) || LayoutInterval.getEffectiveAlignment(layoutInterval5) == (n2 ^ 1)) ? layoutInterval5 : (layoutInterval5.isParallel() ? LayoutDesigner.findContainerResizingGap(layoutInterval5, n, n2) : null);
                if (layoutInterval3 == null) {
                    return null;
                }
                LayoutInterval layoutInterval6 = LayoutInterval.getDirectNeighbor(layoutInterval3, n2 ^ 1, true);
                if (layoutInterval6 == null) continue;
                int n5 = layoutInterval6.getCurrentSpace().positions[n][n2];
                int n6 = layoutInterval.getCurrentSpace().positions[n][n2];
                int n7 = Math.abs(n6 - n5);
                if (layoutInterval2 != null && n7 >= n3) continue;
                layoutInterval2 = layoutInterval3;
                n3 = n7;
                continue;
            }
            for (int i = n4 - 2; i > 0; --i) {
                layoutInterval3 = layoutInterval4.getSubInterval(i);
                if (!LayoutDesigner.canBeContainerResizingGap(layoutInterval3) || !LayoutInterval.canResize(layoutInterval3)) continue;
                return layoutInterval.getSubIntervalCount() == 1 ? layoutInterval3 : null;
            }
            return null;
        }
        return layoutInterval2;
    }

    private static boolean canBeContainerResizingGap(LayoutInterval layoutInterval) {
        return layoutInterval.isEmptySpace() && (layoutInterval.getPreferredSize() != -1 || layoutInterval.getMaximumSize() >= Short.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    private boolean imposeCurrentContainerSize(LayoutComponent layoutComponent, LayoutDragger.SizeDef[] sizeDefArray, boolean bl) {
        Object object2;
        assert (layoutComponent.isLayoutContainer());
        Rectangle rectangle = this.visualMapper.getContainerInterior(layoutComponent.getId());
        if (rectangle == null) {
            return false;
        }
        layoutComponent.setCurrentInterior(rectangle);
        if (layoutComponent.getParent() != null) {
            object2 = this.visualMapper.getComponentBounds(layoutComponent.getId());
            layoutComponent.setCurrentBounds((Rectangle)object2, this.visualMapper.getBaselinePosition(layoutComponent.getId(), ((Rectangle)object2).width, ((Rectangle)object2).height));
        }
        for (LayoutComponent object3 : layoutComponent.getSubcomponents()) {
            Rectangle rectangle2 = this.visualMapper.getComponentBounds(object3.getId());
            object3.setCurrentBounds(rectangle2, this.visualMapper.getBaselinePosition(object3.getId(), rectangle2.width, rectangle2.height));
            if (object3.isLayoutContainer()) {
                if (!bl) continue;
                this.imposeCurrentContainerSize(object3, null, true);
                continue;
            }
            this.imposeCurrentComponentSize(object3);
        }
        object2 = null;
        Object var6_7 = null;
        for (int i = 0; i < 2; ++i) {
            void var6_8;
            int n;
            LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(i);
            int n2 = layoutInterval.getCurrentSpace().size(i);
            LayoutInterval layoutInterval2 = this.getActiveLayoutRoots(layoutComponent)[i];
            for (LayoutInterval[] layoutIntervalArray : layoutComponent.getLayoutRoots()) {
                boolean bl2;
                LayoutInterval layoutInterval3 = layoutIntervalArray[i];
                boolean bl3 = bl2 = layoutInterval3.getSubIntervalCount() == 0;
                if (layoutInterval3 == layoutInterval2) {
                    if (bl2) {
                        this.propEmptyContainer(layoutInterval3, i);
                    } else if (sizeDefArray != null && sizeDefArray[i] != null) {
                        int n3;
                        LayoutInterval layoutInterval4 = sizeDefArray[i].getResizingGap();
                        if (layoutInterval4 != null) {
                            n3 = sizeDefArray[i].getResizingGapSize(n2);
                            if (n3 == 0) {
                                LayoutInterval layoutInterval5;
                                LayoutInterval layoutInterval6 = layoutInterval4.getParent();
                                assert (layoutInterval6.isSequential());
                                int n4 = this.layoutModel.removeInterval(layoutInterval4);
                                assert (n4 == 0 || n4 == layoutInterval6.getSubIntervalCount());
                                if (layoutInterval6.getSubIntervalCount() == 1) {
                                    layoutInterval5 = this.layoutModel.removeInterval(layoutInterval6, 0);
                                    this.operations.addContent(layoutInterval5, layoutInterval6.getParent(), this.layoutModel.removeInterval(layoutInterval6));
                                } else if (LayoutInterval.canResize(layoutInterval4) && !LayoutInterval.wantResize(layoutInterval3) && (layoutInterval5 = layoutInterval6.getSubInterval(n4 = n4 == 0 ? layoutInterval6.getSubIntervalCount() - 1 : 0)).isEmptySpace()) {
                                    this.layoutModel.setIntervalSize(layoutInterval5, -1, layoutInterval5.getPreferredSize(), Short.MAX_VALUE);
                                }
                            } else {
                                this.operations.resizeInterval(layoutInterval4, n3);
                                if (n3 == -1 && LayoutInterval.canResize(layoutInterval4)) {
                                    layoutInterval4.setMaximumSize(-2);
                                    boolean bl4 = LayoutInterval.wantResize(layoutInterval3);
                                    layoutInterval4.setMaximumSize(Short.MAX_VALUE);
                                    if (bl4) {
                                        this.layoutModel.setIntervalSize(layoutInterval4, -1, -1, -2);
                                    }
                                }
                            }
                        } else if (!LayoutInterval.wantResize(layoutInterval3)) {
                            n3 = this.computeMinimumDesignSize(layoutInterval3);
                            int n5 = layoutInterval3.getCurrentSpace().size(i) - n3;
                            if (n5 > 0) {
                                LayoutInterval layoutInterval7 = new LayoutInterval(101);
                                layoutInterval7.setSizes(-1, n5, Short.MAX_VALUE);
                                this.operations.insertGap(layoutInterval7, layoutInterval3, n3, i, 1);
                            }
                        }
                    }
                }
                if (bl2) continue;
                this.updateLayoutStructure(layoutInterval3, i, true);
            }
            if (layoutComponent.getParent() == null) continue;
            if (object2 == null) {
                object2 = this.visualMapper.getComponentMinimumSize(layoutComponent.getId());
                Dimension dimension = this.visualMapper.getComponentPreferredSize(layoutComponent.getId());
            }
            int n6 = n = i == 0 ? ((Dimension)object2).width : ((Dimension)object2).height;
            boolean bl5 = this.visualMapper.hasExplicitPreferredSize(layoutComponent.getId()) && n2 != (i == 0 ? var6_8.width : var6_8.height) || n2 < n || n2 > n && !LayoutInterval.wantResize(layoutInterval2);
            this.operations.resizeInterval(layoutInterval, bl5 ? n2 : -1);
        }
        return true;
    }

    private void imposeCurrentComponentSize(LayoutComponent layoutComponent) {
        Dimension dimension = this.visualMapper.getComponentPreferredSize(layoutComponent.getId());
        for (int i = 0; i < 2; ++i) {
            LayoutInterval layoutInterval = layoutComponent.getLayoutInterval(i);
            int n = layoutInterval.getPreferredSize();
            if (!layoutInterval.hasAttribute(256) && LayoutInterval.wantResizeInLayout(layoutInterval) && n != 0) {
                int n2;
                int n3 = layoutInterval.getCurrentSpace().size(i);
                int n4 = n2 = i == 0 ? dimension.width : dimension.height;
                if (n == -1) {
                    n = n2;
                }
                if (n != n3) {
                    this.operations.resizeInterval(layoutInterval, n3 != n2 ? n3 : -1);
                }
            }
            layoutInterval.unsetAttribute(256);
        }
    }

    private void imposeCurrentGapSize(LayoutInterval layoutInterval, int n, int n2) {
        int n3 = -1;
        int n4 = layoutInterval.getMinimumSize();
        int n5 = layoutInterval.getPreferredSize();
        if (n5 == -1) {
            if (!LayoutInterval.wantResizeInLayout(layoutInterval)) {
                return;
            }
            n5 = n3 = LayoutUtils.getSizeOfDefaultGap(layoutInterval, this.visualMapper);
        } else if (n5 < 0) {
            n5 = n3 = LayoutUtils.getSizeOfDefaultGap(layoutInterval, this.visualMapper);
        }
        if (n != n5) {
            if (n4 == -1) {
                if (n3 < 0) {
                    n3 = LayoutUtils.getSizeOfDefaultGap(layoutInterval, this.visualMapper);
                }
                n4 = n3;
            } else if (n4 == -2) {
                n4 = n5;
            }
            if (n < n4) {
                n = n4;
            }
            this.operations.resizeInterval(layoutInterval, n == n3 ? -1 : n);
        }
    }

    private void propEmptyContainer(LayoutInterval layoutInterval, int n) {
        assert (layoutInterval.getParent() == null && layoutInterval.getSubIntervalCount() == 0);
        LayoutInterval layoutInterval2 = new LayoutInterval(101);
        layoutInterval2.setSizes(0, layoutInterval.getCurrentSpace().size(n), Short.MAX_VALUE);
        this.layoutModel.addInterval(layoutInterval2, layoutInterval, 0);
    }

    private int computeMinimumDesignSize(LayoutInterval layoutInterval) {
        int n;
        block7: {
            block6: {
                n = 0;
                if (!layoutInterval.isSingle()) break block6;
                int n2 = layoutInterval.getMinimumSize(true);
                int n3 = n = n2 == -2 ? layoutInterval.getPreferredSize(true) : n2;
                if (n != -1) break block7;
                if (layoutInterval.isComponent()) {
                    LayoutComponent layoutComponent = layoutInterval.getComponent();
                    Dimension dimension = n2 == -2 ? this.visualMapper.getComponentPreferredSize(layoutComponent.getId()) : this.visualMapper.getComponentMinimumSize(layoutComponent.getId());
                    n = layoutInterval == layoutComponent.getLayoutInterval(0) ? dimension.width : dimension.height;
                } else {
                    n = LayoutUtils.getSizeOfDefaultGap(layoutInterval, this.visualMapper);
                }
                break block7;
            }
            if (layoutInterval.isSequential()) {
                int n4 = layoutInterval.getSubIntervalCount();
                for (int i = 0; i < n4; ++i) {
                    n += this.computeMinimumDesignSize(layoutInterval.getSubInterval(i));
                }
            } else {
                int n5 = layoutInterval.getSubIntervalCount();
                for (int i = 0; i < n5; ++i) {
                    n = Math.max(n, this.computeMinimumDesignSize(layoutInterval.getSubInterval(i)));
                }
            }
        }
        return n;
    }

    private void intervalRemoved(LayoutInterval layoutInterval, int n, boolean bl, boolean bl2, int n2) {
        if (layoutInterval.isSequential()) {
            LayoutInterval layoutInterval2;
            LayoutInterval layoutInterval3;
            LayoutInterval layoutInterval4;
            LayoutInterval layoutInterval5;
            LayoutInterval layoutInterval6;
            if (n > 0) {
                layoutInterval6 = layoutInterval.getSubInterval(n - 1);
                if (layoutInterval6.isEmptySpace()) {
                    layoutInterval5 = layoutInterval6;
                    this.layoutModel.removeInterval(layoutInterval6);
                    layoutInterval4 = --n > 0 ? layoutInterval.getSubInterval(n - 1) : null;
                } else {
                    layoutInterval5 = null;
                    layoutInterval4 = layoutInterval6;
                }
            } else {
                layoutInterval5 = null;
                layoutInterval4 = null;
            }
            if (n < layoutInterval.getSubIntervalCount()) {
                layoutInterval3 = layoutInterval.getSubInterval(n);
                if (layoutInterval3.isEmptySpace()) {
                    layoutInterval6 = layoutInterval3;
                    this.layoutModel.removeInterval(layoutInterval3);
                    layoutInterval2 = n < layoutInterval.getSubIntervalCount() ? layoutInterval.getSubInterval(n) : null;
                } else {
                    layoutInterval6 = null;
                    layoutInterval2 = layoutInterval3;
                }
            } else {
                layoutInterval6 = null;
                layoutInterval2 = null;
            }
            if (!bl2 && (layoutInterval5 != null && LayoutInterval.canResize(layoutInterval5) || layoutInterval6 != null && LayoutInterval.canResize(layoutInterval6))) {
                bl2 = true;
            }
            layoutInterval3 = layoutInterval.getParent();
            if (layoutInterval.getSubIntervalCount() == 0) {
                int n3 = this.layoutModel.removeInterval(layoutInterval);
                if (layoutInterval3.getParent() != null) {
                    this.intervalRemoved(layoutInterval3, n3, false, bl2, n2);
                }
            } else {
                boolean bl3 = LayoutInterval.contentWantResize(layoutInterval);
                if (bl2 && !bl3) {
                    if (layoutInterval4 == null && layoutInterval.getAlignment() == 0) {
                        this.layoutModel.setIntervalAlignment(layoutInterval, 1);
                    }
                    if (layoutInterval2 == null && layoutInterval.getAlignment() == 1) {
                        this.layoutModel.setIntervalAlignment(layoutInterval, 0);
                    }
                }
                int n4 = LayoutRegion.distance((layoutInterval4 != null ? layoutInterval4 : layoutInterval).getCurrentSpace(), (layoutInterval2 != null ? layoutInterval2 : layoutInterval).getCurrentSpace(), n2, layoutInterval4 != null ? 1 : 0, layoutInterval2 != null ? 0 : 1);
                if (layoutInterval4 != null && layoutInterval2 != null || layoutInterval3.getParent() == null || layoutInterval4 != null && LayoutInterval.getEffectiveAlignment(layoutInterval4, 1) == 1 || layoutInterval2 != null && LayoutInterval.getEffectiveAlignment(layoutInterval2, 0) == 0) {
                    int n5;
                    int n6;
                    if (bl2 && !bl3) {
                        n6 = -1;
                        n5 = Short.MAX_VALUE;
                    } else {
                        n5 = -2;
                        n6 = -2;
                    }
                    LayoutInterval layoutInterval7 = new LayoutInterval(101);
                    layoutInterval7.setSizes(n6, n4, n5);
                    this.layoutModel.addInterval(layoutInterval7, layoutInterval, n);
                } else {
                    if (layoutInterval.getSubIntervalCount() == 1) {
                        LayoutInterval layoutInterval8 = this.layoutModel.removeInterval(layoutInterval, 0);
                        this.layoutModel.addInterval(layoutInterval8, layoutInterval3, this.layoutModel.removeInterval(layoutInterval));
                        this.layoutModel.setIntervalAlignment(layoutInterval8, layoutInterval.getRawAlignment());
                    } else {
                        int n7 = (layoutInterval2 != null && layoutInterval4 == null ? layoutInterval2 : layoutInterval).getCurrentSpace().positions[n2][0];
                        int n8 = (layoutInterval4 != null && layoutInterval2 == null ? layoutInterval4 : layoutInterval).getCurrentSpace().positions[n2][1];
                        layoutInterval.getCurrentSpace().set(n2, n7, n8);
                    }
                    this.maintainSize(layoutInterval3, bl2 || bl3, n2, layoutInterval, layoutInterval.getCurrentSpace().size(n2) - n4);
                }
                if (bl2 && !bl3) {
                    this.operations.enableGroupResizing(layoutInterval3);
                }
            }
        } else {
            if (layoutInterval.getParent() == null) {
                return;
            }
            assert (layoutInterval.isParallel() && layoutInterval.getSubIntervalCount() > 0);
            int n9 = layoutInterval.getGroupAlignment();
            if (bl) {
                if (n9 == 0 || n9 == 1) {
                    this.maintainSize(layoutInterval, bl2, n2, null, 0);
                } else {
                    this.preventParallelCollapse(layoutInterval, n2);
                }
            }
            if (layoutInterval.getSubIntervalCount() == 1 && layoutInterval.getParent() != null) {
                LayoutInterval layoutInterval9 = layoutInterval.getSubInterval(0);
                this.layoutModel.removeInterval(layoutInterval9);
                this.layoutModel.setIntervalAlignment(layoutInterval9, layoutInterval.getAlignment());
                if (LayoutInterval.wantResize(layoutInterval9) && !LayoutInterval.canResize(layoutInterval)) {
                    if (layoutInterval9.isGroup()) {
                        this.operations.suppressGroupResizing(layoutInterval9);
                    } else {
                        this.layoutModel.setIntervalSize(layoutInterval9, -2, layoutInterval9.getPreferredSize(), -2);
                    }
                }
                LayoutInterval layoutInterval10 = layoutInterval.getParent();
                int n10 = this.layoutModel.removeInterval(layoutInterval);
                this.operations.addContent(layoutInterval9, layoutInterval10, n10);
                if (layoutInterval9.isSequential() && layoutInterval10.isSequential()) {
                    this.eliminateConsecutiveGaps(layoutInterval10, n10, n2);
                }
            } else if (bl2 && !LayoutInterval.contentWantResize(layoutInterval)) {
                this.operations.enableGroupResizing(layoutInterval);
            }
        }
    }

    private void eliminateConsecutiveGaps(LayoutInterval layoutInterval, int n, int n2) {
        assert (layoutInterval.isSequential());
        if (n > 0) {
            --n;
        }
        while (n < layoutInterval.getSubIntervalCount() - 1) {
            LayoutInterval layoutInterval2 = layoutInterval.getSubInterval(n);
            LayoutInterval layoutInterval3 = layoutInterval.getSubInterval(n + 1);
            if (layoutInterval2.isEmptySpace() && layoutInterval3.isEmptySpace()) {
                LayoutRegion layoutRegion;
                int n3;
                LayoutRegion layoutRegion2;
                int n4;
                if (n > 0) {
                    n4 = 1;
                    layoutRegion2 = layoutInterval.getSubInterval(n - 1).getCurrentSpace();
                } else {
                    n4 = 0;
                    layoutRegion2 = layoutInterval.getCurrentSpace();
                }
                if (n + 2 < layoutInterval.getSubIntervalCount()) {
                    n3 = 0;
                    layoutRegion = layoutInterval.getSubInterval(n + 2).getCurrentSpace();
                } else {
                    n3 = 1;
                    layoutRegion = layoutInterval.getCurrentSpace();
                }
                this.operations.eatGap(layoutInterval2, layoutInterval3, LayoutRegion.distance(layoutRegion2, layoutRegion, n2, n4, n3));
                continue;
            }
            ++n;
        }
    }

    private void maintainSize(LayoutInterval layoutInterval, boolean bl, int n, LayoutInterval layoutInterval2, int n2) {
        int n3;
        int n4;
        assert (layoutInterval.isParallel());
        int n5 = layoutInterval.getCurrentSpace().size(n);
        int[] nArray = layoutInterval.getCurrentSpace().positions[n];
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MIN_VALUE;
        Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            int n9;
            LayoutInterval layoutInterval3 = iterator.next();
            int n10 = layoutInterval3.getAlignment();
            if (layoutInterval3 != layoutInterval2) {
                n4 = layoutInterval3.getCurrentSpace().size(n);
                if (n4 >= n5) {
                    return;
                }
                if (n4 > n8) {
                    n8 = n4;
                }
                n3 = LayoutUtils.getOutermostComponent((LayoutInterval)layoutInterval3, (int)n, (int)0).getCurrentSpace().positions[n][0];
                n9 = LayoutUtils.getOutermostComponent((LayoutInterval)layoutInterval3, (int)n, (int)1).getCurrentSpace().positions[n][1];
            } else {
                if (n2 > n8) {
                    n8 = n2;
                }
                if (n10 == 0) {
                    n3 = nArray[0];
                    n9 = nArray[0] + n2;
                } else {
                    n3 = nArray[1] - n2;
                    n9 = nArray[1];
                }
            }
            if (n3 < n6) {
                n6 = n3;
            }
            if (n9 > n7) {
                n7 = n9;
            }
            if (n10 == 0) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        if (bl2 && bl3) {
            this.optimizeGaps(layoutInterval, n, false);
        } else {
            if (!LayoutInterval.canResize(layoutInterval)) {
                bl = false;
            }
            boolean bl4 = LayoutInterval.wantResize(layoutInterval);
            LayoutInterval layoutInterval4 = layoutInterval.getParent();
            if (layoutInterval4 != null && layoutInterval4.isParallel() && layoutInterval.getAlignment() == (bl2 ? 0 : 1)) {
                this.maintainSize(layoutInterval4, bl && !bl4, n, layoutInterval, n8);
                if (bl2) {
                    nArray[1] = n7;
                }
                if (bl3) {
                    nArray[0] = n6;
                }
                nArray[2] = (nArray[0] + nArray[0]) / 2;
            } else {
                int n11;
                n3 = n5 - n8;
                assert (n3 > 0);
                LayoutInterval layoutInterval5 = new LayoutInterval(101);
                if (!bl4 && (bl || layoutInterval4 == null)) {
                    n4 = -1;
                    n11 = Short.MAX_VALUE;
                } else {
                    n11 = -2;
                    n4 = -2;
                }
                layoutInterval5.setSizes(n4, n3, n11);
                this.operations.insertGap(layoutInterval5, layoutInterval, bl2 ? n7 : n6, n, bl2 ? 1 : 0);
                if (bl2) {
                    nArray[1] = n7;
                }
                if (bl3) {
                    nArray[0] = n6;
                }
                nArray[2] = (nArray[0] + nArray[0]) / 2;
                if (layoutInterval4 != null) {
                    if (layoutInterval4.isSequential()) {
                        layoutInterval4 = layoutInterval4.getParent();
                    }
                    this.optimizeGaps(layoutInterval4, n, false);
                }
            }
        }
    }

    private void preventParallelCollapse(LayoutInterval layoutInterval, int n) {
        Object object;
        assert (layoutInterval.getGroupAlignment() == 2 || layoutInterval.getGroupAlignment() == 3);
        LayoutRegion layoutRegion = layoutInterval.getCurrentSpace();
        LayoutRegion layoutRegion2 = new LayoutRegion();
        Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            object = iterator.next();
            layoutRegion2.expand(((LayoutInterval)object).getCurrentSpace(), n);
        }
        if (layoutRegion2.size(n) < layoutRegion.size(n)) {
            LayoutInterval layoutInterval2;
            LayoutInterval layoutInterval3;
            object = null;
            ArrayList<LayoutInterval> arrayList = null;
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MAX_VALUE;
            boolean bl = false;
            for (layoutInterval3 = layoutInterval.getParent(); layoutInterval3 != null; layoutInterval3 = layoutInterval3.getParent()) {
                if (!layoutInterval3.isParallel()) continue;
                if (layoutInterval3.getGroupAlignment() == 2 || layoutInterval3.getGroupAlignment() == 3) break;
                iterator = layoutInterval3.getSubIntervals();
                while (iterator.hasNext()) {
                    LayoutRegion layoutRegion3;
                    layoutInterval2 = iterator.next();
                    if (layoutInterval2 == layoutInterval || layoutInterval2.isParentOf(layoutInterval) || !LayoutRegion.overlap(layoutRegion3 = layoutInterval2.getCurrentSpace(), layoutRegion, n ^ 1, 0) || !LayoutRegion.overlap(layoutRegion3, layoutRegion, n, 0) || LayoutRegion.overlap(layoutRegion3, layoutRegion2, n, 0)) continue;
                    int n4 = LayoutRegion.distance(layoutRegion3, layoutRegion2, n, 1, 0);
                    if (n4 >= 0) {
                        if (object == null) {
                            object = new ArrayList();
                        }
                        object.add(layoutInterval2);
                        if (n4 >= n2) continue;
                        n2 = n4;
                        continue;
                    }
                    n4 = LayoutRegion.distance(layoutRegion2, layoutRegion3, n, 1, 0);
                    if (arrayList == null) {
                        arrayList = new ArrayList<LayoutInterval>();
                    }
                    arrayList.add(layoutInterval2);
                    if (n4 >= n3) continue;
                    n3 = n4;
                }
                boolean bl2 = bl = object != null && !object.isEmpty() || arrayList != null && !arrayList.isEmpty();
                if (bl) break;
            }
            if (bl) {
                LayoutInterval layoutInterval4;
                LayoutInterval layoutInterval5;
                LayoutInterval layoutInterval6;
                int n5;
                assert (layoutInterval3.isParallel());
                layoutInterval2 = null;
                if (layoutInterval.getParent().isParallel()) {
                    layoutInterval3 = layoutInterval.getParent();
                    n5 = this.layoutModel.removeInterval(layoutInterval);
                    layoutInterval2 = new LayoutInterval(102);
                    layoutInterval2.setAlignment(layoutInterval.getAlignment());
                    this.layoutModel.setIntervalAlignment(layoutInterval, -1);
                    this.layoutModel.addInterval(layoutInterval2, layoutInterval3, n5);
                    this.layoutModel.addInterval(layoutInterval, layoutInterval2, -1);
                } else {
                    n5 = 0;
                    LayoutInterval layoutInterval7 = layoutInterval;
                    do {
                        layoutInterval6 = layoutInterval7;
                        if (!(layoutInterval7 = layoutInterval7.getParent()).isSequential()) continue;
                        n5 = layoutInterval7.indexOf(layoutInterval6);
                        layoutInterval2 = layoutInterval7;
                        break;
                    } while (layoutInterval7 != layoutInterval3);
                    if (object != null && !object.isEmpty()) {
                        layoutInterval6 = null;
                        while (n5 > 0) {
                            layoutInterval5 = this.layoutModel.removeInterval(layoutInterval2, 0);
                            if (layoutInterval5.isEmptySpace() && --n5 <= 0) continue;
                            if (layoutInterval6 == null) {
                                layoutInterval6 = new LayoutInterval(102);
                                object.add(layoutInterval6);
                            }
                            this.layoutModel.addInterval(layoutInterval5, layoutInterval6, -1);
                        }
                    }
                    if (arrayList != null && !arrayList.isEmpty()) {
                        layoutInterval6 = null;
                        while (n5 + 1 < layoutInterval2.getSubIntervalCount()) {
                            layoutInterval5 = this.layoutModel.removeInterval(layoutInterval2, layoutInterval2.getSubIntervalCount() - 1);
                            if (layoutInterval5.isEmptySpace() && n5 + 1 >= layoutInterval2.getSubIntervalCount()) continue;
                            if (layoutInterval6 == null) {
                                layoutInterval6 = new LayoutInterval(102);
                                arrayList.add(layoutInterval6);
                            }
                            this.layoutModel.addInterval(layoutInterval5, layoutInterval6, 0);
                        }
                    }
                }
                LayoutInterval layoutInterval8 = this.createIntervalFromList((List<LayoutInterval>)object, 0);
                if (layoutInterval8 != null) {
                    LayoutInterval layoutInterval9 = new LayoutInterval(101);
                    layoutInterval9.setSizes(n2, n2, n2);
                    this.layoutModel.addInterval(layoutInterval9, layoutInterval2, 0);
                    this.layoutModel.setIntervalAlignment(layoutInterval8, -1);
                    this.operations.addContent(layoutInterval8, layoutInterval2, 0);
                }
                if ((layoutInterval4 = this.createIntervalFromList((List<LayoutInterval>)arrayList, 1)) != null) {
                    layoutInterval6 = new LayoutInterval(101);
                    layoutInterval6.setSizes(n3, n3, n3);
                    this.layoutModel.addInterval(layoutInterval6, layoutInterval2, -1);
                    this.layoutModel.setIntervalAlignment(layoutInterval4, -1);
                    this.operations.addContent(layoutInterval4, layoutInterval2, -1);
                }
                if (layoutInterval3.getSubIntervalCount() == 1 && layoutInterval3.getParent() != null) {
                    layoutInterval6 = layoutInterval3.getSubInterval(0);
                    this.layoutModel.removeInterval(layoutInterval6);
                    this.layoutModel.setIntervalAlignment(layoutInterval6, layoutInterval3.getAlignment());
                    layoutInterval5 = layoutInterval3.getParent();
                    int n6 = this.layoutModel.removeInterval(layoutInterval3);
                    this.operations.addContent(layoutInterval6, layoutInterval5, n6);
                    if (layoutInterval6.isSequential() && layoutInterval5.isSequential()) {
                        this.eliminateConsecutiveGaps(layoutInterval5, n6, n);
                    }
                }
            }
        }
    }

    private LayoutInterval createIntervalFromList(List<LayoutInterval> list, int n) {
        LayoutInterval layoutInterval = null;
        if (list != null && !list.isEmpty()) {
            if (list.size() == 1) {
                LayoutInterval layoutInterval2 = list.get(0);
                if (layoutInterval2.getParent() != null) {
                    this.layoutModel.removeInterval(layoutInterval2);
                }
                layoutInterval = layoutInterval2;
            } else {
                layoutInterval = new LayoutInterval(103);
                layoutInterval.setGroupAlignment(n);
                for (LayoutInterval layoutInterval3 : list) {
                    if (layoutInterval3.getParent() != null) {
                        this.layoutModel.removeInterval(layoutInterval3);
                    }
                    this.layoutModel.addInterval(layoutInterval3, layoutInterval, -1);
                }
            }
        }
        return layoutInterval;
    }

    public String[] positionCode() {
        return this.dragger != null ? this.dragger.positionCode() : new String[2];
    }

    public int getModelCounter() {
        return this.modelCounter;
    }

    public void setModelCounter(int n) {
        this.modelCounter = n;
    }

    public static boolean testMode() {
        return Boolean.getBoolean(TEST_SWITCH);
    }

    public boolean logTestCode() {
        return this.modelCounter > -1 && Boolean.getBoolean(TEST_SWITCH);
    }

    class Listener
    implements LayoutModel.Listener {
        private boolean active = false;

        Listener() {
        }

        @Override
        public void layoutChanged(LayoutEvent layoutEvent) {
            if (!LayoutDesigner.this.layoutModel.isUndoRedoInProgress()) {
                this.deactivate();
                LayoutDesigner.this.layoutChanged(layoutEvent);
                this.activate();
            }
        }

        void activate() {
            LayoutDesigner.this.layoutModel.addListener(this);
            this.active = true;
        }

        void deactivate() {
            LayoutDesigner.this.layoutModel.removeListener(this);
            this.active = false;
        }

        boolean isActive() {
            return this.active;
        }
    }
}

