/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.reader;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.cnd.dwarfdump.FileMagic;
import org.netbeans.modules.cnd.dwarfdump.Magic;
import org.netbeans.modules.cnd.dwarfdump.elf.ElfHeader;
import org.netbeans.modules.cnd.dwarfdump.elf.SectionHeader;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.dwarfdump.reader.ByteStreamReader;
import org.netbeans.modules.cnd.dwarfdump.reader.LoadCommand;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.section.StringTableSection;
import org.netbeans.modules.cnd.dwarfdump.trace.TraceDwarf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElfReader
extends ByteStreamReader {
    private boolean isCoffFormat;
    private boolean isMachoFormat;
    private ElfHeader elfHeader = null;
    private SectionHeader[] sectionHeadersTable;
    private ElfSection[] sections = null;
    private HashMap<String, Integer> sectionsMap = new HashMap();
    private StringTableSection stringTableSection = null;
    private long shiftIvArchive = 0L;
    private long lengthIvArchive = 0L;
    private List<String> linkedObjectFiles = new ArrayList<String>();

    public ElfReader(String fname, RandomAccessFile reader, Magic magic, long shift, long length) throws IOException {
        super(fname, reader);
        Integer idx;
        this.shiftIvArchive = shift;
        this.lengthIvArchive = length;
        if (!this.readHeader(magic)) {
            return;
        }
        this.readProgramHeaderTable();
        this.readSectionHeaderTable();
        this.sections = new ElfSection[this.sectionHeadersTable.length];
        if (!this.isCoffFormat) {
            int elfStringTableIdx = this.elfHeader.getELFStringTableSectionIndex();
            this.stringTableSection = new StringTableSection(this, elfStringTableIdx);
            this.sections[elfStringTableIdx] = this.stringTableSection;
        }
        for (int i = 0; i < this.sections.length; ++i) {
            this.sectionsMap.put(this.getSectionName(i), i);
        }
        if (this.isCoffFormat && (idx = this.sectionsMap.get(".debug_str")) != null) {
            this.sections[idx.intValue()] = this.stringTableSection;
        }
    }

    public final String getSectionName(int sectionIdx) {
        if (!this.isCoffFormat && !this.isMachoFormat) {
            if (this.stringTableSection == null) {
                return ".shstrtab";
            }
            long nameOffset = this.sectionHeadersTable[sectionIdx].sh_name;
            return this.stringTableSection.getString(nameOffset);
        }
        return this.sectionHeadersTable[sectionIdx].getSectionName();
    }

    public final boolean readHeader(Magic magic) throws WrongFileFormatException, IOException {
        this.elfHeader = new ElfHeader();
        this.seek(this.shiftIvArchive);
        byte[] bytes = new byte[16];
        this.read(bytes);
        switch (magic) {
            case Elf: {
                this.readElfHeader(bytes);
                return true;
            }
            case Coff: {
                this.readCoffHeader(this.shiftIvArchive);
                return true;
            }
            case Exe: {
                this.readPeHeader(true);
                return true;
            }
            case Pe: {
                this.readPeHeader(false);
                return true;
            }
            case Macho: {
                return this.readMachoHeader();
            }
        }
        throw new WrongFileFormatException("Not an ELF/PE/COFF/MACH-O file");
    }

    private void readElfHeader(byte[] bytes) throws IOException {
        this.elfHeader.elfClass = bytes[4];
        this.elfHeader.elfData = bytes[5];
        this.elfHeader.elfVersion = bytes[6];
        this.elfHeader.elfOs = bytes[7];
        this.elfHeader.elfAbi = bytes[8];
        this.setDataEncoding(this.elfHeader.elfData);
        this.setFileClass(this.elfHeader.elfClass);
        this.elfHeader.e_type = this.readShort();
        this.elfHeader.e_machine = this.readShort();
        this.elfHeader.e_version = this.readInt();
        this.elfHeader.e_entry = this.read3264() + this.shiftIvArchive;
        this.elfHeader.e_phoff = this.read3264() + this.shiftIvArchive;
        this.elfHeader.e_shoff = this.read3264() + this.shiftIvArchive;
        this.elfHeader.e_flags = this.readInt();
        this.elfHeader.e_ehsize = this.readShort();
        this.elfHeader.e_phentsize = this.readShort();
        this.elfHeader.e_phnum = this.readShort();
        this.elfHeader.e_shentsize = this.readShort();
        this.elfHeader.e_shnum = this.readShort();
        this.elfHeader.e_shstrndx = this.readShort();
    }

    private void readPeHeader(boolean isExe) throws IOException {
        this.elfHeader.elfData = 1;
        this.elfHeader.elfClass = 1;
        this.setDataEncoding(this.elfHeader.elfData);
        this.setFileClass(this.elfHeader.elfClass);
        int peOffset = 0;
        if (isExe) {
            this.seek(60L);
            peOffset = this.readInt();
            this.seek(peOffset);
            byte[] bytes = new byte[4];
            this.read(bytes);
            if (!FileMagic.isPeMagic(bytes)) {
                throw new WrongFileFormatException("Not an PE/COFF file");
            }
        }
        this.readCoffHeader(peOffset + 4);
    }

    private void readCoffHeader(long shift) throws IOException {
        this.isCoffFormat = true;
        this.seek(2L + shift);
        this.elfHeader.elfData = 1;
        this.elfHeader.elfClass = 1;
        this.setDataEncoding(this.elfHeader.elfData);
        this.setFileClass(this.elfHeader.elfClass);
        this.elfHeader.e_shnum = this.readShort();
        this.readInt();
        long symbolTableOffset = this.shiftIvArchive + (long)this.readInt();
        int symbolTableEntries = this.readInt();
        long stringTableOffset = symbolTableOffset + (long)(symbolTableEntries * 18);
        int stringTableLength = (int)(this.shiftIvArchive + this.lengthIvArchive - stringTableOffset);
        short optionalHeaderSize = this.readShort();
        this.readShort();
        if (optionalHeaderSize > 0) {
            this.skipBytes(optionalHeaderSize);
        }
        this.elfHeader.e_shoff = this.getFilePointer();
        long pointer = this.getFilePointer();
        this.seek(stringTableOffset);
        byte[] strings = new byte[stringTableLength];
        this.read(strings);
        this.stringTableSection = new StringTableSection(this, strings);
        this.seek(pointer);
    }

    private boolean readMachoHeader() throws IOException {
        this.isMachoFormat = true;
        this.elfHeader.elfData = 1;
        this.elfHeader.elfClass = 1;
        this.setDataEncoding(this.elfHeader.elfData);
        this.setFileClass(this.elfHeader.elfClass);
        this.seek(this.shiftIvArchive);
        boolean is64 = this.readByte() == -49;
        this.seek(this.shiftIvArchive + 16L);
        int ncmds = this.readInt();
        this.readInt();
        this.readInt();
        if (is64) {
            this.skipBytes(4);
        }
        ArrayList<SectionHeader> headers = new ArrayList<SectionHeader>();
        for (int j = 0; j < ncmds; ++j) {
            int cmd = this.readInt();
            int cmdSize = this.readInt();
            if (TraceDwarf.TRACED) {
                System.out.println("Load command: " + (Object)((Object)LoadCommand.valueOf(cmd)) + " (" + cmd + ")");
            }
            if (LoadCommand.LC_SEGMENT.is(cmd) || LoadCommand.LC_SEGMENT_64.is(cmd)) {
                this.skipBytes(16);
                if (is64) {
                    this.readLong();
                    this.readLong();
                    this.readLong();
                    this.readLong();
                } else {
                    this.readInt();
                    this.readInt();
                    this.readInt();
                    this.readInt();
                }
                this.readInt();
                this.readInt();
                int nSects = this.readInt();
                this.readInt();
                for (int i = 0; i < nSects; ++i) {
                    SectionHeader h = this.readMachoSection(is64);
                    if (h == null) continue;
                    headers.add(h);
                }
                continue;
            }
            if (LoadCommand.LC_SYMTAB.is(cmd)) {
                this.readInt();
                this.readInt();
                long strOffset = (long)this.readInt() + this.shiftIvArchive;
                int strSize = this.readInt();
                long pointer = this.getFilePointer();
                this.seek(strOffset);
                byte[] strings = new byte[strSize];
                this.read(strings);
                this.stringTableSection = new StringTableSection(this, strings);
                this.seek(pointer);
                continue;
            }
            this.skipBytes(cmdSize - 8);
        }
        if (TraceDwarf.TRACED && this.stringTableSection != null) {
            this.stringTableSection.dump(System.out);
        }
        if (headers.isEmpty() || this.stringTableSection == null) {
            if (this.isThereAnyLinkedObjectFiles(this.stringTableSection)) {
                return false;
            }
            throw new WrongFileFormatException("Dwarf section not found in Mach-O file");
        }
        this.stringTableSection = null;
        this.sectionHeadersTable = new SectionHeader[headers.size()];
        for (int i = 0; i < headers.size(); ++i) {
            this.sectionHeadersTable[i] = (SectionHeader)headers.get(i);
        }
        this.elfHeader.e_shstrndx = (short)(headers.size() - 1);
        return true;
    }

    private boolean isThereAnyLinkedObjectFiles(StringTableSection stringTableSection) {
        String string;
        if (stringTableSection == null) {
            return false;
        }
        for (int offset = 1; offset < stringTableSection.getStringTable().length; offset += string.length() + 1) {
            string = stringTableSection.getString(offset);
            if (string.length() <= 2 || !".o".equals(string.substring(string.length() - 2))) continue;
            this.linkedObjectFiles.add(string);
        }
        return this.linkedObjectFiles.size() > 0;
    }

    public List<String> getLinkedObjectFiles() {
        return this.linkedObjectFiles;
    }

    private SectionHeader readMachoSection(boolean is64) throws IOException {
        long size;
        byte[] sectName = new byte[16];
        this.read(sectName);
        String section = this.getName(sectName, 0);
        byte[] segName = new byte[16];
        this.read(segName);
        String segment = this.getName(segName, 0);
        if (is64) {
            this.readLong();
            size = this.readLong();
        } else {
            this.readInt();
            size = this.readInt();
        }
        long offset = (long)this.readInt() + this.shiftIvArchive;
        this.readInt();
        this.readInt();
        this.readInt();
        int segFlags = this.readInt();
        this.readInt();
        this.readInt();
        if (is64) {
            this.readInt();
        }
        if ("__DWARF".equals(segment)) {
            SectionHeader h = new SectionHeader();
            if (section.startsWith("__debug")) {
                section = "." + section.substring(2);
            }
            h.name = section;
            h.sh_size = size;
            h.sh_offset = offset;
            h.sh_flags = segFlags;
            return h;
        }
        if (TraceDwarf.TRACED) {
            System.out.println("Segment,Section: " + segment + "," + section);
        }
        return null;
    }

    private String getName(byte[] stringtable, int offset) {
        StringBuilder str = new StringBuilder();
        for (int i = offset; i < stringtable.length && stringtable[i] != 0; ++i) {
            str.append((char)stringtable[i]);
        }
        return str.toString();
    }

    private void readProgramHeaderTable() {
    }

    private void readSectionHeaderTable() throws IOException {
        long sectionHeaderOffset = this.elfHeader.getSectionHeaderOffset();
        if (sectionHeaderOffset > 0L) {
            this.seek(sectionHeaderOffset);
            int sectionsNum = this.elfHeader.getNumberOfSectionHeaders();
            this.sectionHeadersTable = new SectionHeader[sectionsNum];
            for (int i = 0; i < sectionsNum; ++i) {
                this.sectionHeadersTable[i] = this.isCoffFormat ? this.readCoffSectionHeader() : this.readSectionHeader();
            }
        }
    }

    private SectionHeader readSectionHeader() throws IOException {
        SectionHeader h = new SectionHeader();
        h.sh_name = this.readInt();
        h.sh_type = this.readInt();
        h.sh_flags = this.read3264();
        h.sh_addr = this.read3264();
        h.sh_offset = this.read3264() + this.shiftIvArchive;
        h.sh_size = this.read3264();
        h.sh_link = this.readInt();
        h.sh_info = this.readInt();
        h.sh_addralign = this.read3264();
        h.sh_entsize = this.read3264();
        return h;
    }

    private SectionHeader readCoffSectionHeader() throws IOException {
        SectionHeader h = new SectionHeader();
        byte[] bytes = new byte[8];
        this.read(bytes);
        String name = null;
        if (bytes[0] == 47) {
            byte c;
            int length = 0;
            for (int j = 1; j < 8 && (c = bytes[j]) >= 48; ++j) {
                length *= 10;
                length += c - 48;
            }
            name = this.stringTableSection.getString(length);
        } else {
            name = this.getName(bytes, 0);
        }
        h.name = name;
        this.readInt();
        this.readInt();
        h.sh_size = this.readInt();
        h.sh_offset = this.shiftIvArchive + (long)this.readInt();
        this.readInt();
        this.readInt();
        this.readShort();
        this.readShort();
        h.sh_flags = this.readInt();
        return h;
    }

    public ElfSection getSection(String sectionName) {
        Integer sectionIdx = this.sectionsMap.get(sectionName);
        if (sectionIdx == null) {
            return null;
        }
        if (this.sections[sectionIdx] == null) {
            this.sections[sectionIdx.intValue()] = this.initSection(sectionIdx, sectionName);
        }
        return this.sections[sectionIdx];
    }

    ElfSection initSection(Integer sectionIdx, String sectionName) {
        return null;
    }

    public SectionHeader getSectionHeader(int sectionIdx) {
        return this.sectionHeadersTable[sectionIdx];
    }
}

