/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jrubyparser.ISourcePositionHolder;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.CommentNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.InvisibleNode;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements ISourcePositionHolder {
    static final List<Node> EMPTY_LIST = new ArrayList<Node>();
    public static final List<CommentNode> EMPTY_COMMENT_LIST = new ArrayList<CommentNode>();
    private SourcePosition position;

    public Node(SourcePosition position) {
        assert (position != null);
        this.position = position;
    }

    @Override
    public SourcePosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(SourcePosition position) {
        this.position = position;
    }

    public abstract Object accept(NodeVisitor var1);

    public abstract List<Node> childNodes();

    protected static List<Node> createList(Node ... nodes) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node node : nodes) {
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(60);
        builder.append("(").append(this.getNodeName());
        if (this instanceof INameNode) {
            builder.append(":").append(((INameNode)((Object)this)).getName());
        }
        for (Node child : this.childNodes()) {
            builder.append(", ").append(child);
        }
        builder.append(")");
        return builder.toString();
    }

    protected String getNodeName() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(46);
        String nodeType = name.substring(i + 1);
        return nodeType;
    }

    public void addComment(CommentNode comment) {
        Collection<CommentNode> comments = this.position.getComments();
        if (comments == null) {
            comments = new ArrayList<CommentNode>();
            this.position.setComments(comments);
        }
        comments.add(comment);
    }

    public void addComments(Collection<CommentNode> moreComments) {
        Collection<CommentNode> comments = this.position.getComments();
        if (comments == EMPTY_COMMENT_LIST) {
            comments = new ArrayList<CommentNode>();
            this.position.setComments(comments);
        }
        comments.addAll(moreComments);
    }

    public Collection<CommentNode> getComments() {
        return this.position.getComments();
    }

    public boolean hasComments() {
        return this.getComments() != EMPTY_COMMENT_LIST;
    }

    public SourcePosition getPositionIncludingComments() {
        if (!this.hasComments()) {
            return this.position;
        }
        String fileName = this.position.getFile();
        int startOffset = this.position.getStartOffset();
        int endOffset = this.position.getEndOffset();
        int startLine = this.position.getStartLine();
        int endLine = this.position.getEndLine();
        SourcePosition commentIncludingPos = new SourcePosition(fileName, startLine, endLine, startOffset, endOffset);
        for (CommentNode comment : this.getComments()) {
            commentIncludingPos = SourcePosition.combinePosition(commentIncludingPos, comment.getPosition());
        }
        return commentIncludingPos;
    }

    public boolean isInvisible() {
        return this instanceof InvisibleNode;
    }

    public abstract NodeType getNodeType();
}

