/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.SecurityTableModel;
import org.openide.util.NbBundle;

public class MappingsTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Resource"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_File"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Jar"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Package"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Class")};
    private static final String[] attrNames = new String[]{"Resource", "File", "Jar", "Package", "Class"};
    private SessionFactory sessionFactory;

    public MappingsTableModel(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.sessionFactory == null) {
            return null;
        }
        String string = this.sessionFactory.getAttributeValue("Mapping", n, attrNames[n2]);
        return string;
    }

    @Override
    public int getRowCount() {
        if (this.sessionFactory == null) {
            return 0;
        }
        return this.sessionFactory.sizeMapping();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void addRow(String[] stringArray) {
        int n = this.sessionFactory.addMapping(true);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            this.sessionFactory.setAttributeValue("Mapping", n, attrNames[i], stringArray[i]);
        }
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void editRow(int n, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.sessionFactory.setAttributeValue("Mapping", n, attrNames[i], stringArray[i]);
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void removeRow(int n) {
        this.sessionFactory.removeMapping(n);
        this.fireTableRowsDeleted(n, n);
    }
}

