/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;
import org.netbeans.modules.db.dataview.table.ResultSetTableCellEditor;
import org.openide.windows.WindowManager;

class StringTableCellEditor
extends ResultSetTableCellEditor
implements TableCellEditor,
ActionListener {
    private JXButton customEditorButton = new JXButton("...");
    private int row;
    private int column;

    public StringTableCellEditor(JTextField textField) {
        super(textField);
        this.customEditorButton.addActionListener((ActionListener)this);
        this.customEditorButton.setFocusable(false);
        this.customEditorButton.setFocusPainted(false);
        this.customEditorButton.setMargin(new Insets(0, 0, 0, 0));
        this.customEditorButton.setPreferredSize(new Dimension(20, 10));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        final JComponent c = (JComponent)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.setEditable(column, c);
        JXPanel panel = new JXPanel(new BorderLayout()){

            public void addNotify() {
                super.addNotify();
                c.requestFocus();
            }

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                InputMap map = c.getInputMap(condition);
                ActionMap am = c.getActionMap();
                if (map != null && am != null && this.isEnabled()) {
                    Action action;
                    Object binding = map.get(ks);
                    Action action2 = action = binding == null ? null : am.get(binding);
                    if (action != null) {
                        return SwingUtilities.notifyAction(action, ks, e, c, e.getModifiers());
                    }
                }
                return false;
            }
        };
        panel.add((Component)c);
        if (isGtk) {
            c.setBorder(BorderFactory.createEmptyBorder());
        }
        panel.add((Component)this.customEditorButton, (Object)"East");
        panel.revalidate();
        panel.repaint();
        this.row = row;
        this.column = column;
        return panel;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        assert (this.table != null);
        super.cancelCellEditing();
        this.editCell(this.table, this.row, this.column);
    }

    protected void editCell(JTable table, int row, int column) {
        JTextArea textArea = new JTextArea(10, 50);
        Object value = table.getValueAt(row, column);
        if (value != null) {
            textArea.setText((String)value);
            textArea.setCaretPosition(0);
            textArea.setEditable(this.editable);
        }
        JScrollPane pane = new JScrollPane(textArea);
        Frame parent = WindowManager.getDefault().getMainWindow();
        if (this.editable) {
            int result = JOptionPane.showOptionDialog(parent, pane, table.getColumnName(column), 2, -1, null, null, null);
            if (result == 0) {
                table.setValueAt(textArea.getText(), row, column);
            }
        } else {
            JOptionPane.showMessageDialog(parent, pane, table.getColumnName(column), -1, null);
        }
    }
}

