/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.options.MercurialOptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class MercurialPanel
extends JPanel {
    private final MercurialOptionsPanelController controller;
    private final DocumentListener listener;
    private String initialUserName;
    final JButton addButton = new JButton();
    final JTextField annotationTextField = new JTextField();
    private JCheckBox backupOnRevertModifications;
    private JCheckBox cbAskBeforeCommitAfterMerge;
    private JCheckBox cbInternalMergeToolEnabled;
    private JCheckBox cbOpenOutputWindow;
    final JCheckBox excludeNewFiles = new JCheckBox();
    final JButton execPathBrowseButton = new JButton();
    final JTextField executablePathTextField = new JTextField();
    private JLabel exportFilename;
    final JButton exportFilenameBrowseButton = new JButton();
    final JTextField exportFilenameTextField = new JTextField();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextPane jTextPane1;
    final JButton manageButton = new JButton();
    final JTextField userNameTextField = new JTextField();

    MercurialPanel(MercurialOptionsPanelController controller) {
        this.controller = controller;
        this.listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MercurialPanel.this.nameChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MercurialPanel.this.nameChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MercurialPanel.this.nameChange();
            }
        };
        this.initComponents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.userNameTextField.getDocument().addDocumentListener(this.listener);
    }

    @Override
    public void removeNotify() {
        this.userNameTextField.getDocument().removeDocumentListener(this.listener);
        super.removeNotify();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.exportFilename = new JLabel();
        this.backupOnRevertModifications = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextPane1 = new JTextPane();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.cbOpenOutputWindow = new JCheckBox();
        this.cbAskBeforeCommitAfterMerge = new JCheckBox();
        this.cbInternalMergeToolEnabled = new JCheckBox();
        this.jLabel1.setLabelFor(this.userNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.executablePathTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.execPathBrowseButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.browseButton.text"));
        this.exportFilename.setLabelFor(this.exportFilenameTextField);
        Mnemonics.setLocalizedText((JLabel)this.exportFilename, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.ExportFilename.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.exportFilenameBrowseButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.browseButton2.text"));
        this.backupOnRevertModifications.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.backupOnRevertModifications, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jCheckBox1.text"));
        this.backupOnRevertModifications.setBorder(null);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel5.text"));
        this.jLabel3.setLabelFor(this.annotationTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.addButton.text"));
        this.annotationTextField.setText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.annotationTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel6.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.manageButton.text"));
        this.jTextPane1.setBackground(this.jLabel1.getBackground());
        this.jTextPane1.setText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jTextPane1.text"));
        this.cbOpenOutputWindow.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbOpenOutputWindow, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbOpenOutputWindow.text"));
        this.cbOpenOutputWindow.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_cbOpenOutputWindow"));
        this.cbOpenOutputWindow.setBorder(null);
        this.cbAskBeforeCommitAfterMerge.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbAskBeforeCommitAfterMerge, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbAskBeforeCommitAfterMerge.text"));
        this.cbAskBeforeCommitAfterMerge.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbAskBeforeCommitAfterMerge.toolTipText"));
        this.cbAskBeforeCommitAfterMerge.setBorder(null);
        this.cbInternalMergeToolEnabled.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbInternalMergeToolEnabled, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbInternalMergeToolEnabled.text"));
        this.cbInternalMergeToolEnabled.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbInternalMergeToolEnabled.toolTipText"));
        this.cbInternalMergeToolEnabled.setBorder(null);
        Mnemonics.setLocalizedText((AbstractButton)this.excludeNewFiles, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.excludeNewFiles.text"));
        this.excludeNewFiles.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.excludeNewFiles.toolTipText"));
        this.excludeNewFiles.setBorder(null);
        this.excludeNewFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MercurialPanel.this.excludeNewFilesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.jSeparator2, -1, 329, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jSeparator1, -1, 308, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.exportFilename)).add(30, 30, 30).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.exportFilenameTextField, -1, 161, Short.MAX_VALUE).add(1, (Component)this.userNameTextField, -1, 161, Short.MAX_VALUE).add(1, (Component)this.executablePathTextField, -1, 161, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.exportFilenameBrowseButton).add((Component)this.execPathBrowseButton))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextPane1, -1, 298, Short.MAX_VALUE).addPreferredGap(0)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.annotationTextField, -1, 240, Short.MAX_VALUE).add(2, 2, 2))).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.addButton, -1, -1, Short.MAX_VALUE).add(2, (Component)this.manageButton, -1, -1, Short.MAX_VALUE)))).add(0, 0, 0)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backupOnRevertModifications).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbOpenOutputWindow).addPreferredGap(0, 171, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbAskBeforeCommitAfterMerge).addPreferredGap(0, 160, -2))).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.cbInternalMergeToolEnabled).addContainerGap(135, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.excludeNewFiles).addContainerGap(60, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.userNameTextField, -2, -1, -2)).add(8, 8, 8).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.executablePathTextField, -2, -1, -2).add((Component)this.execPathBrowseButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.exportFilename).add((Component)this.exportFilenameTextField, -2, -1, -2).add((Component)this.exportFilenameBrowseButton)).add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel5).add((Component)this.jSeparator1, -2, -1, -2)).add(8, 8, 8).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.annotationTextField, -2, -1, -2).add((Component)this.addButton)).add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel6).add((Component)this.jSeparator2, -2, 11, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.manageButton).add((Component)this.jTextPane1, -2, -1, -2)).addPreferredGap(0).add((Component)this.backupOnRevertModifications).addPreferredGap(1).add((Component)this.cbOpenOutputWindow).addPreferredGap(1).add((Component)this.cbAskBeforeCommitAfterMerge).addPreferredGap(1).add((Component)this.cbInternalMergeToolEnabled).addPreferredGap(1).add((Component)this.excludeNewFiles).addContainerGap(23, Short.MAX_VALUE)));
        this.userNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_userNameTextField"));
        this.executablePathTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_executablePathTextField"));
        this.execPathBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_execPathBrowseButton"));
        this.exportFilenameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_exportFileNameTextField"));
        this.exportFilenameBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_exportFilenameBrowseButton"));
        this.backupOnRevertModifications.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_backupOnRevertModifications"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_addButton"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_manageButton"));
        this.cbOpenOutputWindow.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_cbOpenOutputWindow"));
    }

    private void excludeNewFilesActionPerformed(ActionEvent evt) {
    }

    private void nameChange() {
        this.controller.changed();
    }

    void load() {
        this.initialUserName = HgModuleConfig.getDefault().getSysUserName();
        this.userNameTextField.setText(this.initialUserName);
        this.executablePathTextField.setText(HgModuleConfig.getDefault().getExecutableBinaryPath());
        this.exportFilenameTextField.setText(HgModuleConfig.getDefault().getExportFilename());
        this.annotationTextField.setText(HgModuleConfig.getDefault().getAnnotationFormat());
        this.backupOnRevertModifications.setSelected(HgModuleConfig.getDefault().getBackupOnRevertModifications());
        this.cbOpenOutputWindow.setSelected(HgModuleConfig.getDefault().getAutoOpenOutput());
        this.cbAskBeforeCommitAfterMerge.setSelected(HgModuleConfig.getDefault().getConfirmCommitAfterMerge());
        this.cbInternalMergeToolEnabled.setSelected(HgModuleConfig.getDefault().isInternalMergeToolEnabled());
        this.excludeNewFiles.setSelected(HgModuleConfig.getDefault().getExludeNewFiles());
    }

    void store() {
        if (!this.initialUserName.equals(this.userNameTextField.getText())) {
            try {
                HgModuleConfig.getDefault().setUserName(this.userNameTextField.getText());
            }
            catch (IOException ex) {
                HgModuleConfig.notifyParsingError();
            }
        }
        HgModuleConfig.getDefault().setExecutableBinaryPath(this.executablePathTextField.getText());
        Mercurial.getInstance().asyncInit();
        HgModuleConfig.getDefault().setExportFilename(this.exportFilenameTextField.getText());
        HgModuleConfig.getDefault().setAnnotationFormat(this.annotationTextField.getText());
        HgModuleConfig.getDefault().setBackupOnRevertModifications(this.backupOnRevertModifications.isSelected());
        HgModuleConfig.getDefault().setAutoOpenOutput(this.cbOpenOutputWindow.isSelected());
        HgModuleConfig.getDefault().setConfirmCommitAfterMerge(this.cbAskBeforeCommitAfterMerge.isSelected());
        HgModuleConfig.getDefault().setInternalMergeToolEnabled(this.cbInternalMergeToolEnabled.isSelected());
        HgModuleConfig.getDefault().setExcludeNewFiles(this.excludeNewFiles.isSelected());
    }

    boolean valid() {
        String username = this.userNameTextField.getText();
        Boolean valid = HgModuleConfig.getDefault().isUserNameValid(username);
        if (!valid.booleanValue()) {
            return false;
        }
        String execpath = this.executablePathTextField.getText();
        valid = HgModuleConfig.getDefault().isExecPathValid(execpath);
        return valid;
    }
}

