/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.CommandBuffer;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbLogger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.debugger.gdb.proxy.MICommand;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GdbProxyEngine {
    private static final int MIN_TOKEN = 100;
    private PrintStream toGdb;
    private final GdbDebugger debugger;
    private final GdbProxy gdbProxy;
    private final MICommand[] commandList = new MICommand[20];
    private int nextCommandPos = 0;
    private int nextToken = 100;
    private int currentToken = 100;
    private boolean active;
    private RequestProcessor.Task gdbReader = null;
    private final NativeProcess proc;
    private volatile boolean killed = false;
    private final RequestProcessor sendQueue = new RequestProcessor("sendQueue");
    private final boolean timerOn = Boolean.getBoolean("gdb.proxy.timer");
    private static final Logger log = Logger.getLogger("gdb.gdbproxy.logger");
    private final boolean inferiorTty;
    public static final boolean ENGINE_PTY = Boolean.getBoolean("gdb.engine.pty");
    private static final String TIME_PREFIX = ",time=";

    public GdbProxyEngine(final GdbDebugger debugger, GdbProxy gdbProxy, List<String> debuggerCommand, MacroMap debuggerEnvironment, String workingDirectory, String tty, String cspath) throws IOException {
        boolean bl = this.inferiorTty = tty != null;
        if (this.inferiorTty) {
            debuggerCommand.add("-tty");
            debuggerCommand.add(tty);
        }
        this.debugger = debugger;
        this.gdbProxy = gdbProxy;
        this.active = true;
        this.getLogger().logMessage("Debugger Command: " + debuggerCommand);
        this.getLogger().logMessage("Env: " + debuggerEnvironment);
        this.getLogger().logMessage("workingDirectory: " + workingDirectory);
        this.getLogger().logMessage("NB version: " + System.getProperty("netbeans.buildnumber"));
        this.getLogger().logMessage("================================================");
        ExecutionEnvironment execEnv = debugger.getHostExecutionEnvironment();
        String[] args = debuggerCommand.subList(1, debuggerCommand.size()).toArray(new String[debuggerCommand.size() - 1]);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
        npb.setExecutable(debuggerCommand.get(0)).setArguments(args);
        npb.setWorkingDirectory(workingDirectory);
        MacroMap environment = npb.getEnvironment();
        if (debuggerEnvironment != null) {
            environment.putAll(debuggerEnvironment);
        }
        if (execEnv.isLocal()) {
            String pathname = Path.getPathName();
            environment.appendPathVariable(pathname, cspath);
        }
        if (ENGINE_PTY) {
            npb.setUsePty(true);
        }
        this.proc = npb.call();
        this.toGdb = this.toGdbWriter(this.proc.getInputStream(), this.proc.getOutputStream(), execEnv.isRemote());
        new RequestProcessor("GdbReaperThread").post(new Runnable(){

            @Override
            public void run() {
                try {
                    int rc = GdbProxyEngine.this.proc.waitFor();
                    if (rc == 0) {
                        debugger.finish(false);
                    } else if (!GdbProxyEngine.this.killed) {
                        GdbProxyEngine.this.unexpectedGdbExit(rc);
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void kill() {
        this.killed = true;
        this.proc.destroy();
    }

    public boolean isInferiorTty() {
        return this.inferiorTty;
    }

    public void interrupt() {
        char[] ctrlC = new char[]{'\u0003'};
        this.toGdb.println(ctrlC);
    }

    private void unexpectedGdbExit(int rc) {
        String msg = rc < 0 ? NbBundle.getMessage(GdbDebugger.class, (String)"ERR_UnexpectedGdbExit") : NbBundle.getMessage(GdbDebugger.class, (String)"ERR_UnexpectedGdbExitRC", (Object)rc);
        NotifyDescriptor nd = new NotifyDescriptor((Object)msg, NbBundle.getMessage(GdbDebugger.class, (String)"TITLE_UnexpectedGdbFailure"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
        this.debugger.finish(false);
    }

    private static PrintStream getPrintStream(OutputStream os, boolean remote) {
        if (remote) {
            try {
                return new PrintStream(os, true, ProcessUtils.getRemoteCharSet());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new PrintStream(os, true);
    }

    private PrintStream toGdbWriter(InputStream is, OutputStream os, boolean remote) {
        PrintStream togdb = GdbProxyEngine.getPrintStream(os, remote);
        final BufferedReader fromGdb = ProcessUtils.getReader((InputStream)is, (boolean)remote);
        this.gdbReader = new RequestProcessor("GdbReaderRP").post(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = fromGdb.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        try {
                            GdbProxyEngine.this.processMessage(line);
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "Exception in processMessage", e);
                        }
                    }
                }
                catch (IOException ioe) {
                    log.log(Level.WARNING, "IOException in gdbReader", ioe);
                }
            }
        });
        return togdb;
    }

    public void finish() {
        if (this.gdbReader != null) {
            this.gdbReader.cancel();
        }
    }

    private synchronized int nextToken() {
        return this.nextToken++;
    }

    int sendCommand(String cmd) {
        MICommand command = this.createMICommand(cmd);
        this.sendCommand(command);
        return command.getToken();
    }

    private void sendCommand(int token, String cmd) {
        this.sendCommand(new MICommandImpl(token, cmd));
    }

    private void sendCommand(final MICommand command) {
        if (this.active) {
            this.sendQueue.post(new Runnable(){

                @Override
                public void run() {
                    if (command.getText().charAt(0) != '-') {
                        GdbProxyEngine.this.addCommand(command);
                    }
                    String fullcmd = Integer.toString(command.getToken()) + command.getText();
                    GdbProxyEngine.this.gdbProxy.getLogger().logMessage(CommandBuffer.addTimePrefix(GdbProxyEngine.this.timerOn, fullcmd));
                    GdbProxyEngine.this.toGdb.println(fullcmd);
                }
            });
        }
    }

    CommandBuffer sendCommandEx(String cmd) {
        return this.sendCommandEx(cmd, true);
    }

    CommandBuffer sendCommandEx(String cmd, boolean waitForCompletion) {
        int token = this.nextToken();
        CommandBuffer cb = new CommandBuffer(this.gdbProxy, token);
        this.gdbProxy.putCB(token, cb);
        this.sendCommand(token, cmd);
        if (waitForCompletion) {
            if (this.debugger.getState() != GdbDebugger.State.RUNNING) {
                cb.waitForCompletion();
            } else {
                cb.error("Waitin while in running state");
                this.gdbProxy.removeCB(token);
            }
        }
        return cb;
    }

    void sendConsoleCommand(String cmd) {
        int token = this.nextToken() + 10000;
        this.sendCommand(token, cmd);
    }

    void stopSending() {
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommand(MICommand command) {
        MICommand[] mICommandArray = this.commandList;
        synchronized (this.commandList) {
            this.commandList[this.nextCommandPos] = command;
            if (++this.nextCommandPos >= this.commandList.length) {
                this.nextCommandPos = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void processMessage(String msg) {
        if (msg.equals("(gdb)")) {
            return;
        }
        int token = GdbProxyEngine.getToken(msg);
        if (token < 0) {
            token = this.getCurrentToken(msg);
            if (token != -1) {
                this.gdbProxy.getLogger().logMessage(CommandBuffer.addTimePrefix(this.timerOn, token) + msg);
            } else {
                this.gdbProxy.getLogger().logMessage(CommandBuffer.addTimePrefix(this.timerOn, msg));
            }
        } else {
            this.gdbProxy.getLogger().logMessage(CommandBuffer.addTimePrefix(this.timerOn, msg));
        }
        msg = GdbProxyEngine.stripToken(msg);
        msg = this.stripTiming(msg);
        if (msg.length() == 0) {
            log.warning("Empty message received from gdb");
            return;
        }
        switch (msg.charAt(0)) {
            case '^': {
                if (token == this.currentToken && msg.equals("^done")) {
                    this.currentToken = -1;
                }
                this.debugger.resultRecord(token, msg);
                break;
            }
            case '*': {
                this.debugger.execAsyncOutput(token, msg);
                break;
            }
            case '+': {
                this.debugger.statusAsyncOutput(token, msg);
                break;
            }
            case '=': {
                this.debugger.notifyAsyncOutput(token, msg);
                break;
            }
            case '~': {
                this.debugger.consoleStreamOutput(token, msg.substring(2, msg.length() - 1));
                break;
            }
            case '@': {
                this.debugger.targetStreamOutput(msg);
                break;
            }
            case '&': {
                this.debugger.logStreamOutput(msg);
                break;
            }
            default: {
                this.debugger.output(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getCurrentToken(String msg) {
        if (msg.charAt(0) != '&') return this.currentToken;
        msg = msg.substring(2, msg.length() - 1).replace("\\n", "");
        MICommand[] mICommandArray = this.commandList;
        synchronized (this.commandList) {
            int i = this.nextCommandPos - 1;
            while (true) {
                if (i < 0) {
                    i = this.commandList.length - 1;
                }
                if (i == this.nextCommandPos) return this.currentToken;
                MICommand command = this.commandList[i];
                if (command != null && command.getText().equals(msg)) {
                    this.commandList[i] = null;
                    this.currentToken = command.getToken();
                    break;
                }
                --i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.currentToken;
        }
    }

    private static int getFirstNonDigit(String msg) {
        for (int i = 0; i < msg.length(); ++i) {
            if (Character.isDigit(msg.charAt(i))) continue;
            return i;
        }
        return 0;
    }

    private static int getToken(String msg) {
        int i = GdbProxyEngine.getFirstNonDigit(msg);
        if (i > 0) {
            return Integer.parseInt(msg.substring(0, i));
        }
        return -1;
    }

    private static String stripToken(String msg) {
        char ch;
        int i = GdbProxyEngine.getFirstNonDigit(msg);
        char c = ch = i < msg.length() ? msg.charAt(i) : (char)'\u0000';
        if ((ch == '^' || ch == '*' || ch == '+' || ch == '=') && ch != '\u0000') {
            return msg.substring(i);
        }
        return msg;
    }

    private String stripTiming(String msg) {
        int pos = msg.indexOf(TIME_PREFIX);
        if (pos != -1) {
            int endPos = GdbUtils.findMatchingCurly(msg, pos + TIME_PREFIX.length());
            if (endPos != -1) {
                return msg.substring(0, pos) + msg.substring(endPos + 1);
            }
            log.warning("Matching curly not found in timing info: " + msg);
        }
        return msg;
    }

    private GdbLogger getLogger() {
        return this.gdbProxy.getLogger();
    }

    MICommand createMICommand(String cmd) {
        return new MICommandImpl(this.nextToken(), cmd);
    }

    private class MICommandImpl
    implements MICommand {
        private final int token;
        private final String cmd;
        private boolean sent = false;

        public MICommandImpl(int token, String cmd) {
            this.token = token;
            this.cmd = cmd;
        }

        @Override
        public String getText() {
            return this.cmd;
        }

        @Override
        public int getToken() {
            return this.token;
        }

        @Override
        public synchronized void send() {
            assert (!this.sent) : "sending command " + this + " twice";
            GdbProxyEngine.this.sendCommand(this);
            this.sent = true;
        }

        public boolean equals(Object o) {
            if (o instanceof MICommand) {
                return this.getToken() == ((MICommand)o).getToken();
            }
            return false;
        }

        public int hashCode() {
            return this.getToken();
        }

        public String toString() {
            return this.token + this.cmd;
        }
    }
}

