/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class BreakpointsTreeModelFilter
implements TreeModelFilter {
    private static Logger logger = Logger.getLogger(BreakpointsTreeModelFilter.class.getName());
    static Map MAX_LINES = new WeakHashMap();
    private static boolean verbose = System.getProperty("netbeans.debugger.show_hidden_breakpoints") != null;

    public Object getRoot(TreeModel treeModel) {
        return treeModel.getRoot();
    }

    public Object[] getChildren(TreeModel treeModel, Object object, int n, int n2) throws UnknownTypeException {
        Object object2;
        Object object3;
        int n3;
        if (n2 - n <= 0) {
            logger.fine("getChildren(" + n + ", " + n2 + "): RETURNING an empty array.");
            return new Object[0];
        }
        Object[] objectArray = treeModel.getChildren(object, n, n2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n4 = objectArray.length;
        int n5 = n2 - n;
        HashMap<LineBreakpoint, Integer> hashMap = new HashMap<LineBreakpoint, Integer>();
        for (n3 = 0; n3 < n4; ++n3) {
            if (!verbose && objectArray[n3] instanceof JPDABreakpoint && ((JPDABreakpoint)objectArray[n3]).isHidden() || --n >= 0) continue;
            arrayList.add(objectArray[n3]);
            if (objectArray[n3] instanceof LineBreakpoint) {
                object3 = (LineBreakpoint)objectArray[n3];
                object2 = EditorContextBridge.getFileName(object3);
                int n6 = object3.getLineNumber();
                Integer n7 = (Integer)hashMap.get(object2);
                if (n7 != null) {
                    n6 = Math.max(n6, n7);
                }
                n7 = new Integer(n6);
                hashMap.put((LineBreakpoint)object2, n7);
            }
            if (--n5 == 0) break;
        }
        for (n3 = arrayList.size() - 1; n3 >= 0; --n3) {
            object3 = arrayList.get(n3);
            if (!(object3 instanceof LineBreakpoint)) continue;
            object2 = (LineBreakpoint)object3;
            MAX_LINES.put(object2, hashMap.get(EditorContextBridge.getFileName(object2)));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getChildren(" + n + ", " + n2 + "): Original Breakpoints: " + Arrays.asList(objectArray) + ";  RETURNING: " + arrayList);
        }
        return arrayList.toArray();
    }

    public int getChildrenCount(TreeModel treeModel, Object object) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean isLeaf(TreeModel treeModel, Object object) throws UnknownTypeException {
        return treeModel.isLeaf(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }
}

