/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.transform;

import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.transform.STRTransformImpl;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMSTRTransform
extends TransformService {
    private STRTransformParameterSpec params;
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");
    public static final String WSSE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String WSU = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";

    public void init(TransformParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            throw new InvalidAlgorithmParameterException("params are required");
        }
        this.params = (STRTransformParameterSpec)params;
    }

    public void init(XMLStructure params, XMLCryptoContext xMLCryptoContext) throws InvalidAlgorithmParameterException {
        DOMStructure domParams = (DOMStructure)params;
        try {
            this.unmarshalParams(domParams.getNode(), xMLCryptoContext);
        }
        catch (MarshalException me) {
            throw new InvalidAlgorithmParameterException(me.getMessage());
        }
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public void marshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        Node pn = ((DOMStructure)parent).getNode();
        Document ownerDoc = XMLUtil.getOwnerDocument(pn);
        String prefix = null;
        String dsPrefix = null;
        if (context != null) {
            prefix = context.getNamespacePrefix(WSSE, "wsse");
            dsPrefix = context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", context.getDefaultNamespacePrefix());
        }
        Element transformParamElem = XMLUtil.createElement(ownerDoc, "TransformationParameters", WSSE, prefix);
        CanonicalizationMethod cm = this.params.getCanonicalizationMethod();
        Element c14nElem = XMLUtil.createElement(ownerDoc, "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        c14nElem.setAttributeNS(null, "Algorithm", cm.getAlgorithm());
        C14NMethodParameterSpec cs = (C14NMethodParameterSpec)cm.getParameterSpec();
        if (cs != null) {
            TransformService cmSpi = null;
            try {
                cmSpi = TransformService.getInstance(cm.getAlgorithm(), "DOM");
                cmSpi.init(cs);
                cmSpi.marshalParams(new DOMStructure(c14nElem), context);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "WSS1321.str_marshal.transform.error", e);
                throw new MarshalException(e);
            }
        }
        transformParamElem.appendChild(c14nElem);
        pn.appendChild(transformParamElem);
    }

    public Data transform(Data data, XMLCryptoContext xc) throws TransformException {
        OutputStream outputStream = null;
        new STRTransformImpl();
        return STRTransformImpl.transform(data, xc, outputStream);
    }

    public Data transform(Data data, XMLCryptoContext xc, OutputStream outputStream) throws TransformException {
        new STRTransformImpl();
        return STRTransformImpl.transform(data, xc, outputStream);
    }

    public void unmarshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException, InvalidAlgorithmParameterException {
        Element transformElem = (Element)((DOMStructure)parent).getNode();
        Element tpElem = XMLUtil.getFirstChildElement(transformElem);
        this.unmarshalParams(tpElem, context);
    }

    private void unmarshalParams(Node tpElem, XMLCryptoContext context) throws MarshalException, InvalidAlgorithmParameterException {
        NodeList nl;
        Element c14nElem = null;
        c14nElem = tpElem.getNodeType() == 9 ? (Element)((Document)tpElem).getFirstChild() : XMLUtil.getFirstChildElement(tpElem);
        if (!"CanonicalizationMethod".equals(c14nElem.getLocalName()) && (nl = c14nElem.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod")).getLength() > 0) {
            c14nElem = (Element)nl.item(0);
        }
        if (c14nElem == null) {
            throw new InvalidAlgorithmParameterException("Cannont find CanonicalizationMethod in TransformationParameters element");
        }
        String c14nAlg = c14nElem.getAttributeNodeNS(null, "Algorithm").getValue();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "C14 Algo=" + c14nAlg);
        }
        Object cs = null;
        Element paramsElem = XMLUtil.getFirstChildElement(c14nElem);
        TransformService cmSpi = null;
        try {
            cmSpi = TransformService.getInstance(c14nAlg, "DOM");
            if (paramsElem != null) {
                cmSpi.init(new DOMStructure(paramsElem), context);
            }
            STRC14NMethod cm = new STRC14NMethod(cmSpi);
            this.params = new STRTransformParameterSpec(cm);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "WSS1320.str_un.transform.error", e);
            throw new MarshalException(e);
        }
    }

    public boolean isFeatureSupported(String str) {
        return false;
    }

    public static class STRTransformParameterSpec
    implements TransformParameterSpec {
        private CanonicalizationMethod c14nMethod;

        public STRTransformParameterSpec(CanonicalizationMethod c14nMethod) {
            this.c14nMethod = c14nMethod;
        }

        public CanonicalizationMethod getCanonicalizationMethod() {
            return this.c14nMethod;
        }
    }

    private static class STRC14NMethod
    implements CanonicalizationMethod {
        private TransformService cmSpi;

        STRC14NMethod(TransformService cmSpi) {
            this.cmSpi = cmSpi;
        }

        public String getAlgorithm() {
            return this.cmSpi.getAlgorithm();
        }

        public AlgorithmParameterSpec getParameterSpec() {
            return this.cmSpi.getParameterSpec();
        }

        public boolean isFeatureSupported(String feature) {
            return false;
        }

        public Data transform(Data data, XMLCryptoContext context) throws TransformException {
            return this.cmSpi.transform(data, context);
        }

        public Data transform(Data data, XMLCryptoContext context, OutputStream os) throws TransformException {
            return this.cmSpi.transform(data, context, os);
        }
    }
}

