/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server.glassfish;

import com.sun.appserv.server.LifecycleEvent;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.istack.NotNull;
import com.sun.xml.ws.transport.tcp.grizzly.GrizzlyTCPConnector;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import com.sun.xml.ws.transport.tcp.server.WSTCPConnector;
import com.sun.xml.ws.transport.tcp.server.WSTCPDelegate;
import com.sun.xml.ws.transport.tcp.server.WSTCPModule;
import com.sun.xml.ws.transport.tcp.server.glassfish.AppServWSRegistry;
import com.sun.xml.ws.transport.tcp.server.glassfish.WSTCPAdapterRegistryImpl;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSTCPLifeCycleModule
extends WSTCPModule
implements LifecycleListener {
    private WSTCPConnector connector;
    private WSTCPDelegate delegate;
    private Properties properties;

    public void handleEvent(@NotNull LifecycleEvent lifecycleEvent) throws ServerLifecycleException {
        int eventType = lifecycleEvent.getEventType();
        if (eventType == 0) {
            WSTCPModule.setInstance(this);
            logger.log(Level.FINE, "WSTCPLifeCycleModule.INIT_EVENT");
            this.properties = (Properties)lifecycleEvent.getData();
        } else if (eventType == 1) {
            logger.log(Level.FINE, "WSTCPLifeCycleModule.STARTUP_EVENT");
            this.delegate = new WSTCPDelegate();
        } else if (eventType == 2) {
            logger.log(Level.FINE, "WSTCPLifeCycleModule.READY_EVENT");
            try {
                AppServWSRegistry.getInstance();
                this.delegate.setCustomWSRegistry(WSTCPAdapterRegistryImpl.getInstance());
                this.connector = new GrizzlyTCPConnector(this.delegate, this.properties);
                this.connector.listen();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        } else if (eventType == 3) {
            logger.log(Level.FINE, "WSTCPLifeCycleModule.SHUTDOWN_EVENT");
            WSTCPModule.setInstance(null);
            if (this.delegate != null) {
                this.delegate.destroy();
            }
            if (this.connector != null) {
                this.connector.close();
            }
        }
    }

    @Override
    public void register(@NotNull String contextPath, @NotNull List<TCPAdapter> adapters) {
        this.delegate.registerAdapters(contextPath, adapters);
    }

    @Override
    public void free(@NotNull String contextPath, @NotNull List<TCPAdapter> adapters) {
        this.delegate.freeAdapters(contextPath, adapters);
    }

    @Override
    public int getPort() {
        if (this.connector != null) {
            return this.connector.getPort();
        }
        return -1;
    }
}

