/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.server.manager.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.identity.server.manager.api.ServerInstance;
import org.netbeans.modules.identity.server.manager.api.ServerManager;
import org.netbeans.modules.identity.server.manager.ui.EditDialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerConfigEditorPanel
extends JPanel
implements EditDialogDescriptor.Panel {
    private static final int MAX_PORT = 65535;
    private static final int MIN_PORT = 0;
    private final List listeners = new ArrayList();
    private ServerInstance instance;
    private JLabel contextRootLabel;
    private JTextField contextRootTF;
    private JLabel hostLabel;
    private JTextField hostTF;
    private JLabel passwordLabel;
    private JPasswordField passwordTF;
    private JLabel portLabel;
    private JTextField portTF;
    private JLabel usernameLabel;
    private JTextField usernameTF;

    public ServerConfigEditorPanel(ServerInstance serverInstance) {
        this.initComponents();
        this.instance = serverInstance;
        this.init();
    }

    @Override
    public JComponent[] getEditableComponents() {
        return new JTextField[]{this.hostTF, this.portTF, this.contextRootTF, this.usernameTF, this.passwordTF};
    }

    public void init() {
        this.hostTF.setText(this.instance.getHost());
        this.portTF.setText(this.instance.getPort());
        this.contextRootTF.setText(this.instance.getContextRoot());
        this.usernameTF.setText(this.instance.getUserName());
        this.passwordTF.setText(this.instance.getPassword());
        this.hostTF.setEditable(false);
    }

    public String checkValues() {
        String string = this.hostTF.getText();
        if (string == null || string.trim().length() == 0) {
            return NbBundle.getMessage(ServerConfigEditorPanel.class, (String)"MSG_EnterHost");
        }
        if (string.split("\\s").length > 1) {
            return NbBundle.getMessage(ServerConfigEditorPanel.class, (String)"MSG_InvalidHost");
        }
        String string2 = this.portTF.getText();
        if (string2 == null || string2.trim().length() == 0) {
            return NbBundle.getMessage(ServerConfigEditorPanel.class, (String)"MSG_EnterPort");
        }
        try {
            int n = Integer.parseInt(string2.trim());
            if (n < 0 || n > 65535) {
                return NbBundle.getMessage(ServerConfigEditorPanel.class, (String)"MSG_InvalidPort");
            }
        }
        catch (NumberFormatException numberFormatException) {
            return NbBundle.getMessage(ServerConfigEditorPanel.class, (String)"MSG_InvalidPort");
        }
        String string3 = this.contextRootTF.getText();
        if (string3 == null || string3.trim().length() == 0) {
            return NbBundle.getMessage(ServerConfigEditorPanel.class, (String)"MSG_EnterContextRoot");
        }
        String string4 = this.usernameTF.getText();
        if (string4 == null || string4.trim().length() == 0) {
            return NbBundle.getMessage(ServerConfigEditorPanel.class, (String)"MSG_EnterUsername");
        }
        String string5 = new String(this.passwordTF.getPassword());
        if (string5 == null || string5.trim().length() == 0) {
            return NbBundle.getMessage(ServerConfigEditorPanel.class, (String)"MSG_EnterPassword");
        }
        return null;
    }

    public void updateInstance() {
        boolean bl = false;
        String string = this.hostTF.getText().trim();
        if (!this.instance.getHost().equals(string)) {
            bl = true;
            this.instance.setHost(string);
        }
        string = this.portTF.getText().trim();
        if (!this.instance.getPort().equals(string)) {
            bl = true;
            this.instance.setPort(string);
        }
        string = this.contextRootTF.getText().trim();
        if (!this.instance.getContextRoot().equals(string)) {
            bl = true;
            this.instance.setContextRoot(string);
        }
        string = this.usernameTF.getText().trim();
        if (!this.instance.getUserName().equals(string)) {
            bl = true;
            this.instance.setUserName(string);
        }
        if (!this.instance.getPassword().equals(this.passwordTF.getPassword())) {
            bl = true;
            this.instance.setPassword(new String(this.passwordTF.getPassword()));
        }
        if (bl) {
            try {
                ServerManager.getDefault().writeInstanceToFile(this.instance);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.hostTF = new JTextField();
        this.portLabel = new JLabel();
        this.portTF = new JTextField();
        this.usernameLabel = new JLabel();
        this.usernameTF = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordTF = new JPasswordField();
        this.contextRootLabel = new JLabel();
        this.contextRootTF = new JTextField();
        this.hostLabel.setLabelFor(this.hostTF);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/identity/server/manager/ui/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)resourceBundle.getString("LBL_Host"));
        this.portLabel.setLabelFor(this.portTF);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)resourceBundle.getString("LBL_Port"));
        this.usernameLabel.setLabelFor(this.usernameTF);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)resourceBundle.getString("LBL_AdminUserName"));
        this.passwordLabel.setLabelFor(this.passwordTF);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)resourceBundle.getString("LBL_AdminPassword"));
        this.contextRootLabel.setLabelFor(this.contextRootTF);
        Mnemonics.setLocalizedText((JLabel)this.contextRootLabel, (String)resourceBundle.getString("LBL_ContextRoot"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.hostLabel).add(53, 53, 53).add((Component)this.hostTF, -1, 301, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.portLabel).add(55, 55, 55).add((Component)this.portTF, -1, 301, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.contextRootLabel).addPreferredGap(0).add((Component)this.contextRootTF, -1, 301, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.usernameLabel).add(20, 20, 20).add((Component)this.usernameTF, -1, 301, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.passwordLabel).add(23, 23, 23).add((Component)this.passwordTF, -1, 301, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.hostLabel).add((Component)this.hostTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.portLabel).add((Component)this.portTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.contextRootLabel).add((Component)this.contextRootTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.usernameLabel).add((Component)this.usernameTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.passwordLabel).add((Component)this.passwordTF, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

