/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.server.manager.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.server.manager.api.ServerManager;

public class ServerInstance
implements Serializable {
    public static final String PROP_ID = "id";
    public static final String PROP_HOST = "host";
    public static final String PROP_PORT = "port";
    public static final String PROP_CONTEXT_ROOT = "contextRoot";
    public static final String PROP_USERNAME = "userName";
    public static final String PROP_PASSWORD = "password";
    public static final String LOCAL_HOST = "localhost";
    private String id;
    private String host;
    private String port;
    private String contextRoot;
    private String userName;
    private String password;
    private ServerProperties properties;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public String getID() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    void setID(String string) {
        this.id = string;
    }

    public void setHost(String string) {
        String string2 = this.host;
        this.host = string;
        this.propertySupport.firePropertyChange(PROP_HOST, string2, this.host);
    }

    public void setPort(String string) {
        String string2 = this.port;
        this.port = string;
        this.propertySupport.firePropertyChange(PROP_PORT, string2, this.host);
    }

    public void setContextRoot(String string) {
        String string2 = this.contextRoot;
        this.contextRoot = string;
        this.propertySupport.firePropertyChange(PROP_CONTEXT_ROOT, string2, this.contextRoot);
    }

    public void setUserName(String string) {
        String string2 = this.userName;
        this.userName = string;
        this.propertySupport.firePropertyChange(PROP_USERNAME, string2, this.userName);
    }

    public void setPassword(String string) {
        String string2 = this.password;
        this.password = string;
        this.propertySupport.firePropertyChange(PROP_PASSWORD, string2, this.password);
    }

    public boolean isLocal() {
        return this.getHost().equals(LOCAL_HOST);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public ServerProperties getServerProperties() {
        if (this.properties == null) {
            this.properties = ServerProperties.getInstance((String)this.getID());
        }
        this.properties.setProperty("com.iplanet.am.server.host", this.host);
        this.properties.setProperty("com.iplanet.am.server.port", this.port);
        this.properties.setProperty("org.netbeans.modules.identity.profile.api.configurator.contextroot", this.contextRoot);
        this.properties.setProperty("com.sun.identity.agents.app.username", this.userName);
        this.properties.setProperty("com.iplanet.am.service.password", this.password);
        return this.properties;
    }

    public String getAdminURL() {
        return this.getServerProperties().getProperty("org.netbeans.modules.identity.profile.api.configurator.amconsoleurl");
    }

    public void remove() {
        ServerManager.getDefault().removeServerInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(this.getServerProperties().getProperty("org.netbeans.modules.identity.profile.api.configurator.isaliveurl"));
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            if (httpURLConnection.getResponseCode() == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return false;
    }

    public String toString() {
        return "ServerInstance: id = " + this.id + " host = " + this.host + " port = " + this.port + " contextRoot = " + this.contextRoot + " userName = " + this.userName + " password = " + this.password;
    }
}

