/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.spi.debugger.ContextProvider;

public final class Session
implements ContextProvider {
    public static final String PROP_CURRENT_LANGUAGE = "currentLanguage";
    public static final String PROP_SUPPORTED_LANGUAGES = "supportedLanguages";
    private String name;
    private String locationName;
    private DebuggerEngine currentDebuggerEngine;
    private String currentLanguage;
    private String[] languages;
    private DebuggerEngine[] engines;
    private PropertyChangeSupport pcs;
    private Lookup lookup;
    Lookup privateLookup;
    private Map<DebuggerEngine, Lookup> enginesLookups = new HashMap<DebuggerEngine, Lookup>();

    Session(String name, String locationName, String id, Object[] services, Lookup diLookup) {
        this.name = name;
        this.locationName = locationName;
        this.languages = new String[0];
        this.engines = new DebuggerEngine[0];
        this.pcs = new PropertyChangeSupport(this);
        Object[] s = new Object[services.length + 1];
        System.arraycopy(services, 0, s, 0, services.length);
        s[s.length - 1] = this;
        this.privateLookup = new Lookup.Compound(new Lookup.Instance(s), new Lookup.MetaInf(id));
        this.lookup = new Lookup.Compound(diLookup, this.privateLookup);
    }

    public String getName() {
        return this.name;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public DebuggerEngine getCurrentEngine() {
        return this.currentDebuggerEngine;
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public String[] getSupportedLanguages() {
        return this.languages;
    }

    @Override
    public <T> List<? extends T> lookup(String folder, Class<T> service) {
        return this.lookup.lookup(folder, service);
    }

    @Override
    public <T> T lookupFirst(String folder, Class<T> service) {
        return this.lookup.lookupFirst(folder, service);
    }

    public void kill() {
        DebuggerEngine[] enginesToKill;
        for (DebuggerEngine e : enginesToKill = this.engines) {
            e.getActionsManager().postAction(ActionsManager.ACTION_KILL);
        }
    }

    public synchronized DebuggerEngine getEngineForLanguage(String language) {
        int k = this.languages.length;
        for (int i = 0; i < k; ++i) {
            if (!this.languages[i].equals(language)) continue;
            return this.engines[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentLanguage(String language) {
        int i;
        int k;
        String oldL = null;
        Session session = this;
        synchronized (session) {
            if (language.equals(this.currentLanguage)) {
                return;
            }
            k = this.languages.length;
            for (i = 0; i < k; ++i) {
                if (!language.equals(this.languages[i])) continue;
                oldL = this.currentLanguage;
                this.currentLanguage = language;
                this.currentDebuggerEngine = this.engines[i];
                break;
            }
        }
        if (i < k) {
            this.pcs.firePropertyChange(PROP_CURRENT_LANGUAGE, oldL, language);
        }
    }

    Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLanguage(String language, DebuggerEngine engine) {
        String[] oldL;
        String[] newLanguages;
        boolean fireCurrentLanguage = false;
        Session session = this;
        synchronized (session) {
            int k = this.languages.length;
            for (int i = 0; i < k; ++i) {
                if (!language.equals(this.languages[i])) continue;
                this.engines[i] = engine;
                return;
            }
            newLanguages = new String[this.languages.length + 1];
            DebuggerEngine[] newEngines = new DebuggerEngine[this.engines.length + 1];
            System.arraycopy(this.languages, 0, newLanguages, 0, this.languages.length);
            System.arraycopy(this.engines, 0, newEngines, 0, this.engines.length);
            newLanguages[this.languages.length] = language;
            newEngines[this.engines.length] = engine;
            oldL = this.languages;
            this.languages = newLanguages;
            this.engines = newEngines;
            if (!this.enginesLookups.containsKey(engine)) {
                Lookup.Compound newCompoundLookup = new Lookup.Compound(this.lookup, engine.getPrivateLookup());
                this.lookup = newCompoundLookup;
                this.enginesLookups.put(engine, engine.getPrivateLookup());
            }
            if (this.currentLanguage == null) {
                this.currentLanguage = language;
                this.currentDebuggerEngine = engine;
                fireCurrentLanguage = true;
            }
        }
        DebuggerManager.getDebuggerManager().addEngine(engine);
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, oldL, newLanguages);
        if (fireCurrentLanguage) {
            this.pcs.firePropertyChange(PROP_CURRENT_LANGUAGE, null, language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEngine(DebuggerEngine engine) {
        String[] oldL;
        String[] newL;
        String oldCurrentL = null;
        String newCurrentL = null;
        Session session = this;
        synchronized (session) {
            int i;
            if (this.engines.length == 0) {
                return;
            }
            int k = this.engines.length;
            int t = 0;
            for (i = 0; i < k; ++i) {
                if (!engine.equals(this.engines[i])) continue;
                ++t;
            }
            if (t == 0) {
                return;
            }
            newL = new String[k - t];
            DebuggerEngine[] newE = new DebuggerEngine[k - t];
            int j = 0;
            for (i = 0; i < k; ++i) {
                if (!engine.equals(this.engines[i])) {
                    newL[j] = this.languages[i];
                    newE[j] = this.engines[i];
                    ++j;
                    continue;
                }
                if (!this.languages[i].equals(this.currentLanguage)) continue;
                oldCurrentL = this.currentLanguage;
                this.currentLanguage = i > 0 ? this.languages[0] : (i < k - 1 ? this.languages[i + 1] : null);
                newCurrentL = this.currentLanguage;
            }
            this.removeFromLookup(this.enginesLookups.remove(engine));
            oldL = this.languages;
            this.languages = newL;
            this.engines = newE;
        }
        DebuggerManager.getDebuggerManager().removeEngine(engine);
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, oldL, newL);
        if (oldCurrentL != newCurrentL) {
            this.pcs.firePropertyChange(PROP_CURRENT_LANGUAGE, oldCurrentL, newCurrentL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLanguage(String language, DebuggerEngine engine) {
        String[] oldL;
        String[] newLanguages;
        Session session = this;
        synchronized (session) {
            int i;
            int k = this.languages.length;
            for (i = 0; i < k; ++i) {
                if (!language.equals(this.languages[i])) continue;
                if (this.engines[i] == engine) break;
                throw new IllegalArgumentException();
            }
            if (i >= k) {
                return;
            }
            newLanguages = new String[k - 1];
            DebuggerEngine[] newEngines = new DebuggerEngine[k - 1];
            if (i > 0) {
                System.arraycopy(this.languages, 0, newLanguages, 0, i);
                System.arraycopy(this.engines, 0, newEngines, 0, i);
            }
            System.arraycopy(this.languages, i + 1, newLanguages, i, k - i - 1);
            System.arraycopy(this.engines, i + 1, newEngines, i, k - i - 1);
            oldL = this.languages;
            this.languages = newLanguages;
            this.engines = newEngines;
            k = this.engines.length;
            for (i = 0; i < k; ++i) {
                if (this.engines[i] != engine) continue;
                engine = null;
                break;
            }
        }
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, oldL, newLanguages);
        if (engine != null) {
            DebuggerManager.getDebuggerManager().removeEngine(engine);
        }
    }

    private void removeFromLookup(Lookup engineLookup) {
        boolean[] wasRemovedPtr = new boolean[]{false};
        Lookup newLookup = this.removeFromLookup(this.lookup, engineLookup, wasRemovedPtr);
        if (wasRemovedPtr[0]) {
            this.lookup = newLookup;
        }
    }

    private Lookup removeFromLookup(Lookup lookup, Lookup engineLookup, boolean[] wasRemovedPtr) {
        if (engineLookup == null || !(lookup instanceof Lookup.Compound)) {
            return lookup;
        }
        Lookup.Compound cl = (Lookup.Compound)lookup;
        if (cl.l2 == engineLookup) {
            wasRemovedPtr[0] = true;
            return (Lookup)cl.l1;
        }
        if (!(cl.l1 instanceof Lookup) || !(cl.l2 instanceof Lookup)) {
            return lookup;
        }
        Lookup l1 = this.removeFromLookup((Lookup)cl.l1, engineLookup, wasRemovedPtr);
        Lookup l2 = this.removeFromLookup((Lookup)cl.l2, engineLookup, wasRemovedPtr);
        if (wasRemovedPtr[0]) {
            return new Lookup.Compound(l1, l2);
        }
        return lookup;
    }

    public String toString() {
        return "" + this.getClass().getName() + " " + this.getLocationName() + ":" + this.getName();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }
}

