/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class StreamUtil {
    private static final int BUFFER_SIZE = 2048;

    private StreamUtil() {
    }

    public static String asString(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[2048];
        int read = -1;
        do {
            if ((read = br.read(buffer)) == -1) continue;
            sb.append(buffer, 0, read);
        } while (read != -1);
        br.close();
        return sb.toString();
    }

    public static Iterator<String> asLines(InputStream is) throws IOException {
        return new LineIterator(is);
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        byte[] buffer = new byte[2048];
        int read = -1;
        do {
            if ((read = bis.read(buffer)) == -1) continue;
            bos.write(buffer, 0, read);
        } while (read != -1);
        bos.flush();
        bos.close();
        bis.close();
    }

    public static OutputStream nullOutputStream() {
        return new NullOutputStream();
    }

    public static Writer nullWriter() {
        return new OutputStreamWriter(new NullOutputStream());
    }

    private static class LineIterator
    implements Iterator<String> {
        private String line;
        private InputStream is;
        private BufferedReader br;

        public LineIterator(InputStream is) throws IOException {
            this.is = is;
            this.br = new BufferedReader(new InputStreamReader(is));
            this.line = this.getNextLine();
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public String next() {
            if (this.line == null) {
                throw new NoSuchElementException();
            }
            String oldLine = this.line;
            try {
                this.line = this.getNextLine();
                if (this.line == null) {
                    this.is.close();
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            return oldLine;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        private String getNextLine() throws IOException {
            return this.br.readLine();
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

