/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.commons.patterns.Filter;
import org.codeviation.commons.utils.StreamUtil;

public final class FileUtil {
    public static Factory<URL, File> TO_URL = new UrlFactory();
    public static Factory<String, File> TO_STRING = new StringFactory();
    public static Factory<InputStream, File> TO_INPUT_STREAM = new InputStreamFactory();
    public static Factory<OutputStream, File> TO_OUTPUT_STREAM = new OutputStreamFactory();

    private FileUtil() {
    }

    public static String asString(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        int size = (int)f.length();
        byte[] bbuf = new byte[size];
        int read = fis.read(bbuf);
        if (read < size) {
            fis.close();
            throw new IOException("Could not read whole file" + f + " read " + read + " instead of " + size);
        }
        fis.close();
        return new String(bbuf, 0, size);
    }

    public static Iterator<String> asLines(File f) throws FileNotFoundException, IOException {
        return StreamUtil.asLines(new FileInputStream(f));
    }

    public static void copy(File src, File dest) throws IOException {
        FileInputStream is = new FileInputStream(src);
        FileOutputStream os = new FileOutputStream(dest);
        StreamUtil.copy(is, os);
        ((InputStream)is).close();
        os.flush();
        os.close();
    }

    public static void fromString(File f, String ... strings) throws FileNotFoundException, IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
        for (String s : strings) {
            ((OutputStream)os).write(s.getBytes());
        }
        ((OutputStream)os).close();
    }

    public static void fromLines(File f, String ... strings) throws FileNotFoundException, IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
        for (String s : strings) {
            ((OutputStream)os).write(s.getBytes());
            ((OutputStream)os).write(10);
        }
        ((OutputStream)os).close();
    }

    public static boolean delete(File what) {
        File[] files;
        boolean result = true;
        if (what.isDirectory() && (files = what.listFiles()) != null && files.length != 0) {
            for (File f : files) {
                result = result ? FileUtil.delete(f) : false;
            }
        }
        result = result ? what.delete() : false;
        return result;
    }

    public static Factory<File, String> fileFactory(File root) {
        return new FileFactory(root, null);
    }

    public static Factory<File, String> fileFactory(File root, Filter<File> filter) {
        return new FileFactory(root, filter);
    }

    public static File file(File parent, String ... pathElements) {
        return new File(parent, FileUtil.path(File.separatorChar, pathElements));
    }

    public static void assureDirectory(File directory) throws IOException {
        if (!directory.isDirectory() && !directory.mkdirs()) {
            throw new IOException("Can't create directory : " + directory.getAbsolutePath());
        }
    }

    public static String path(String ... pathElements) {
        return FileUtil.path(File.pathSeparatorChar, pathElements);
    }

    public static String path(char separator, String ... pathElements) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pathElements.length; ++i) {
            sb.append(pathElements[i]);
            if (i == pathElements.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static File resolve(String parent, String path) {
        return FileUtil.resolve(new File(parent), path == null ? null : new File(path));
    }

    public static File resolve(File parent, String path) {
        return FileUtil.resolve(parent, path == null ? null : new File(path));
    }

    public static File resolve(File parent, File path) {
        if (path == null) {
            return parent;
        }
        if (path.isAbsolute()) {
            return path;
        }
        return new File(parent, path.getPath());
    }

    public static String nameNoExt(String name) {
        if (name == null) {
            return null;
        }
        int ild = name.indexOf(46);
        if (ild == -1) {
            return name;
        }
        return name.substring(0, ild);
    }

    public static String extensions(String name) {
        if (name == null) {
            return null;
        }
        int ild = name.indexOf(46);
        if (ild == -1) {
            return "";
        }
        return name.substring(ild + 1, name.length());
    }

    public static String extension(String name) {
        if (name == null) {
            return null;
        }
        int ild = name.lastIndexOf(46);
        if (ild == -1) {
            return "";
        }
        return name.substring(ild + 1, name.length());
    }

    public static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    private static class InputStreamFactory
    implements Factory<InputStream, File> {
        private InputStreamFactory() {
        }

        @Override
        public InputStream create(File file) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private static class OutputStreamFactory
    implements Factory<OutputStream, File> {
        private OutputStreamFactory() {
        }

        @Override
        public OutputStream create(File file) {
            try {
                return new FileOutputStream(file);
            }
            catch (FileNotFoundException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private static class StringFactory
    implements Factory<String, File> {
        private StringFactory() {
        }

        @Override
        public String create(File file) {
            try {
                return FileUtil.asString(file);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private static class UrlFactory
    implements Factory<URL, File> {
        private UrlFactory() {
        }

        @Override
        public URL create(File file) {
            try {
                return FileUtil.toURL(file);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private static class FileFactory
    implements Factory<File, String> {
        private File root;
        private Filter<File> filter;

        public FileFactory(File root, Filter<File> filter) {
            this.root = root;
            this.filter = filter;
        }

        @Override
        public File create(String param) {
            File r = this.root == null ? new File(param) : new File(this.root, param);
            if (this.filter == null) {
                return r;
            }
            return this.filter.accept(r) ? r : null;
        }
    }
}

