/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import org.jruby.nb.RubyModule;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Binding;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.BlockBody;
import org.jruby.nb.runtime.BlockCallback;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class CallBlock
extends BlockBody {
    private final Arity arity;
    private final BlockCallback callback;
    private final RubyModule imClass;
    private final ThreadContext context;

    public static Block newCallClosure(IRubyObject self, RubyModule imClass, Arity arity, BlockCallback callback, ThreadContext context) {
        Binding binding = new Binding(self, context.getCurrentFrame(), Visibility.PUBLIC, context.getRubyClass(), context.getCurrentScope());
        CallBlock body = new CallBlock(imClass, arity, callback, context);
        return new Block(body, binding);
    }

    private CallBlock(RubyModule imClass, Arity arity, BlockCallback callback, ThreadContext context) {
        super(3);
        this.arity = arity;
        this.callback = callback;
        this.imClass = imClass;
        this.context = context;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args, Binding binding, Block.Type type) {
        return this.callback.call(context, args, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value, Binding binding, Block.Type type) {
        return this.callback.call(context, new IRubyObject[]{value}, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue, Binding binding, Block.Type type) {
        return this.callback.call(context, new IRubyObject[]{value}, Block.NULL_BLOCK);
    }

    @Override
    public StaticScope getStaticScope() {
        throw new RuntimeException("CallBlock does not have a static scope; this should not be called");
    }

    @Override
    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), Visibility.PUBLIC, binding.getKlass(), binding.getDynamicScope());
        return new Block(this, binding);
    }

    @Override
    public Arity arity() {
        return this.arity;
    }
}

