/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.java.addons;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyString;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.javasupport.JavaArray;
import org.jruby.nb.javasupport.JavaClass;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ArrayJavaAddons {
    @JRubyMethod
    public static IRubyObject copy_data(ThreadContext context, IRubyObject rubyArray, IRubyObject javaArray, IRubyObject fillValue) {
        int i;
        int rubyLength;
        JavaArray javaArrayJavaObj = (JavaArray)javaArray.dataGetStruct();
        Object fillJavaObject = null;
        int javaLength = (int)javaArrayJavaObj.length().getLongValue();
        Class targetType = javaArrayJavaObj.getComponentType();
        JavaUtil.RubyConverter converter = JavaUtil.getArrayConverter(targetType);
        if (!fillValue.isNil()) {
            fillJavaObject = converter.convert(context, fillValue);
        }
        RubyArray array = null;
        if (rubyArray instanceof RubyArray) {
            array = (RubyArray)rubyArray;
            rubyLength = ((RubyArray)rubyArray).getLength();
        } else {
            rubyLength = 0;
            fillJavaObject = converter.convert(context, rubyArray);
        }
        for (i = 0; i < rubyLength && i < javaLength; ++i) {
            javaArrayJavaObj.setWithExceptionHandling(i, converter.convert(context, array.entry(i)));
        }
        if (i < javaLength && fillJavaObject != null) {
            javaArrayJavaObj.fillWithExceptionHandling(i, javaLength, fillJavaObject);
        }
        return javaArray;
    }

    @JRubyMethod
    public static IRubyObject copy_data_simple(ThreadContext context, IRubyObject from, IRubyObject to) {
        JavaArray javaArray = (JavaArray)to.dataGetStruct();
        RubyArray rubyArray = (RubyArray)from;
        ArrayJavaAddons.copyDataToJavaArray(context, rubyArray, javaArray);
        return to;
    }

    @JRubyMethod(frame=true)
    public static IRubyObject to_java(ThreadContext context, IRubyObject fromArray) {
        return context.getRuntime().getJavaSupport().getObjectJavaClass().javaArrayFromRubyArray(context, fromArray);
    }

    @JRubyMethod(frame=true)
    public static IRubyObject to_java(ThreadContext context, IRubyObject fromArray, IRubyObject type) {
        if (type.isNil()) {
            return ArrayJavaAddons.to_java(context, fromArray);
        }
        Ruby runtime = context.getRuntime();
        JavaClass targetType = ArrayJavaAddons.getTargetType(context, runtime, type);
        return targetType.javaArrayFromRubyArray(context, fromArray);
    }

    private static JavaClass getTargetType(ThreadContext context, Ruby runtime, IRubyObject type) {
        JavaClass targetType;
        if (type instanceof RubyString || type instanceof RubySymbol) {
            targetType = runtime.getJavaSupport().getNameClassMap().get(type.asJavaString());
            if (targetType == null) {
                targetType = JavaClass.forNameVerbose(runtime, type.asJavaString());
            }
        } else if (type instanceof RubyModule && type.respondsTo("java_class")) {
            targetType = (JavaClass)RuntimeHelpers.invoke(context, type, "java_class");
        } else {
            throw runtime.newTypeError("unable to convert array to type: " + type);
        }
        return targetType;
    }

    public static void copyDataToJavaArray(ThreadContext context, RubyArray rubyArray, JavaArray javaArray) {
        int javaLength = (int)javaArray.length().getLongValue();
        Class targetType = javaArray.getComponentType();
        JavaUtil.RubyConverter converter = JavaUtil.getArrayConverter(targetType);
        int rubyLength = rubyArray.getLength();
        for (int i = 0; i < rubyLength && i < javaLength; ++i) {
            javaArray.setWithExceptionHandling(i, converter.convert(context, rubyArray.entry(i)));
        }
    }

    public static void copyDataToJavaArray(ThreadContext context, RubyArray rubyArray, int src, JavaArray javaArray, int dest, int length) {
        Class targetType = javaArray.getComponentType();
        JavaUtil.RubyConverter converter = JavaUtil.getArrayConverter(targetType);
        int destLength = (int)javaArray.length().getLongValue();
        int srcLength = rubyArray.getLength();
        for (int i = 0; src + i < srcLength && dest + i < destLength && i < length; ++i) {
            javaArray.setWithExceptionHandling(dest + i, converter.convert(context, rubyArray.entry(src + i)));
        }
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject maybeArray) {
        Ruby runtime = context.getRuntime();
        if (!(maybeArray instanceof RubyArray)) {
            return runtime.newEmptyArray();
        }
        RubyArray rubyArray = (RubyArray)maybeArray;
        RubyArray dims = runtime.newEmptyArray();
        return ArrayJavaAddons.dimsRecurse(context, rubyArray, dims, 0);
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject maybeArray, IRubyObject dims) {
        Ruby runtime = context.getRuntime();
        if (!(maybeArray instanceof RubyArray)) {
            return runtime.newEmptyArray();
        }
        assert (dims instanceof RubyArray);
        RubyArray rubyArray = (RubyArray)maybeArray;
        return ArrayJavaAddons.dimsRecurse(context, rubyArray, (RubyArray)dims, 0);
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject maybeArray, IRubyObject dims, IRubyObject index) {
        Ruby runtime = context.getRuntime();
        if (!(maybeArray instanceof RubyArray)) {
            return runtime.newEmptyArray();
        }
        assert (dims instanceof RubyArray);
        assert (index instanceof RubyFixnum);
        RubyArray rubyArray = (RubyArray)maybeArray;
        return ArrayJavaAddons.dimsRecurse(context, rubyArray, (RubyArray)dims, (int)((RubyFixnum)index).getLongValue());
    }

    private static RubyArray dimsRecurse(ThreadContext context, RubyArray rubyArray, RubyArray dims, int index) {
        Ruby runtime = context.getRuntime();
        while (dims.size() <= index) {
            dims.append(RubyFixnum.zero(runtime));
        }
        if ((long)rubyArray.size() > ((RubyFixnum)dims.eltInternal(index)).getLongValue()) {
            dims.eltInternalSet(index, RubyFixnum.newFixnum(runtime, rubyArray.size()));
        }
        for (int i = 0; i < rubyArray.size(); ++i) {
            if (!(rubyArray.eltInternal(i) instanceof RubyArray)) continue;
            ArrayJavaAddons.dimsRecurse(context, (RubyArray)rubyArray.eltInternal(i), dims, 1);
        }
        return dims;
    }
}

