/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.ArgsNode;
import org.jruby.nb.ast.ListNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.executable.Script;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.internal.runtime.JumpTarget;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.internal.runtime.methods.MethodArgs;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public final class DefaultMethod
extends DynamicMethod
implements JumpTarget,
MethodArgs {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private int callCount = 0;
    private Script jitCompiledScript;
    private int requiredArgsCount;
    private int maxArgsCount;
    private int restArg;
    private boolean hasOptArgs;
    private CallConfiguration jitCallConfig;
    private ISourcePosition position;

    public DefaultMethod(RubyModule implementationClass, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.requiredArgsCount = argsNode.getRequiredArgsCount();
        this.maxArgsCount = argsNode.getRestArg() >= 0 ? -1 : argsNode.getRequiredArgsCount() + argsNode.getOptionalArgsCount();
        this.restArg = argsNode.getRestArg();
        this.hasOptArgs = argsNode.getOptArgs() != null;
        this.position = position;
        assert (argsNode != null);
    }

    public int getCallCount() {
        return this.callCount;
    }

    public int incrementCallCount() {
        return ++this.callCount;
    }

    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    public Script getJITCompilerScript() {
        return this.jitCompiledScript;
    }

    public void setJITCompiledScript(Script jitCompiledScript) {
        this.jitCompiledScript = jitCompiledScript;
    }

    public CallConfiguration getJITCallConfig() {
        return this.jitCallConfig;
    }

    public void setJITCallConfig(CallConfiguration jitCallConfig) {
        this.jitCallConfig = jitCallConfig;
    }

    public Node getBodyNode() {
        return this.body;
    }

    @Override
    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        assert (args != null);
        Ruby runtime = context.getRuntime();
        if (this.callCount >= 0) {
            runtime.getJITCompiler().tryJIT(this, context, name);
        }
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            return this.retryJITCall(context, runtime, self, name, args, block);
        }
        return this.interpretedCall(context, runtime, self, clazz, name, args, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject retryJITCall(ThreadContext context, Ruby runtime, IRubyObject self, String name, IRubyObject[] args, Block block) {
        try {
            this.jitPre(context, self, name, block, args.length);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, args, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        finally {
            this.jitPost(runtime, context, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject interpretedCall(ThreadContext context, Ruby runtime, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        try {
            this.preInterpret(context, name, self, block, runtime, args);
            IRubyObject iRubyObject = this.body.interpret(runtime, context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        finally {
            this.postInterpret(runtime, context, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, Block.NULL_BLOCK, args.length);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, args, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, args, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, Block.NULL_BLOCK, 0);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, Block block) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, block, 0);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, IRubyObject.NULL_ARRAY, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, Block.NULL_BLOCK, 1);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, Block block) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, block, 1);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0}, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, Block.NULL_BLOCK, 2);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, block, 2);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1}, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, Block.NULL_BLOCK, 3);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, arg2, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1, arg2}, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        Ruby runtime = context.getRuntime();
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitPre(context, self, name, block, 3);
                IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, arg2, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject = this.handleReturn(context, rj);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject = this.handleRedo(runtime);
                return iRubyObject;
            }
            finally {
                this.jitPost(runtime, context, name);
            }
        }
        return this.call(context, self, clazz, name, new IRubyObject[]{arg0, arg1, arg2}, block);
    }

    private int assignOptArgs(IRubyObject[] args, Ruby runtime, ThreadContext context, IRubyObject self, int givenArgsCount) {
        int i;
        ListNode optArgs = this.argsNode.getOptArgs();
        int j = 0;
        for (i = this.requiredArgsCount; i < args.length && j < optArgs.size(); ++i, ++j) {
            optArgs.get(j).assign(runtime, context, self, args[i], Block.NULL_BLOCK, true);
            ++givenArgsCount;
        }
        i = 0;
        while (j < optArgs.size()) {
            optArgs.get(j).interpret(runtime, context, self, Block.NULL_BLOCK);
            ++i;
            ++j;
        }
        return givenArgsCount;
    }

    private void interpretArgs(Ruby runtime, IRubyObject[] args, ThreadContext context, IRubyObject self, Block block) {
        this.checkArgCount(runtime, args.length);
        this.prepareArguments(context, runtime, self, args);
        if (this.argsNode.getBlockArgNode() != null) {
            this.processBlockArg(context, block);
        }
    }

    private void jitPre(ThreadContext context, IRubyObject self, String name, Block block, int argsLength) {
        this.jitCallConfig.pre(context, self, this.getImplementationClass(), name, block, this.staticScope, this);
        this.getArity().checkArity(context.getRuntime(), argsLength);
    }

    private void jitPost(Ruby runtime, ThreadContext context, String name) {
        if (runtime.hasEventHooks()) {
            this.traceReturn(context, runtime, name);
        }
        this.jitCallConfig.post(context);
    }

    private void postInterpret(Ruby runtime, ThreadContext context, String name) {
        if (runtime.hasEventHooks()) {
            this.traceReturn(context, runtime, name);
        }
        context.postMethodFrameAndScope();
    }

    private void preInterpret(ThreadContext context, String name, IRubyObject self, Block block, Ruby runtime, IRubyObject[] args) {
        context.preMethodFrameAndScope(this.getImplementationClass(), name, self, block, this.staticScope);
        if (runtime.hasEventHooks()) {
            this.traceCall(context, runtime, name);
        }
        this.interpretArgs(runtime, args, context, self, block);
    }

    private void processBlockArg(ThreadContext context, Block block) {
        context.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), RuntimeHelpers.processBlockArgument(context.getRuntime(), block), 0);
    }

    private void checkArgCount(Ruby runtime, int argsLength) {
        Arity.checkArgumentCount(runtime, argsLength, this.requiredArgsCount, this.maxArgsCount);
    }

    private void prepareArguments(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject[] args) {
        if (this.requiredArgsCount > 0) {
            context.getCurrentScope().setArgValues(args, this.requiredArgsCount);
        }
        if (this.hasOptArgs || this.restArg != -1) {
            this.prepareOptOrRestArgs(context, runtime, self, args);
        }
    }

    private void prepareOptOrRestArgs(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject[] args) {
        int givenArgsCount = this.interpretOptArgs(context, runtime, self, args);
        this.interpretRestArg(context, runtime, args, givenArgsCount);
    }

    private int interpretOptArgs(ThreadContext context, Ruby runtime, IRubyObject self, IRubyObject[] args) {
        if (this.hasOptArgs) {
            return this.assignOptArgs(args, runtime, context, self, this.requiredArgsCount);
        }
        return this.requiredArgsCount;
    }

    private void interpretRestArg(ThreadContext context, Ruby runtime, IRubyObject[] args, int givenArgsCount) {
        if (this.restArg >= 0) {
            RubyArray array = RubyArray.newArrayNoCopy(runtime, args, givenArgsCount);
            context.getCurrentScope().setValue(this.restArg, array, 0);
        }
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    private void traceReturn(ThreadContext context, Ruby runtime, String name) {
        runtime.callEventHooks(context, RubyEvent.RETURN, context.getFile(), context.getLine(), name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, String name) {
        runtime.callEventHooks(context, RubyEvent.CALL, this.position.getFile(), this.position.getStartLine(), name, this.getImplementationClass());
    }

    @Override
    public Arity getArity() {
        return this.argsNode.getArity();
    }

    @Override
    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.position);
    }
}

