/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.ArrayNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class OpElementAsgnNode
extends Node {
    private final Node receiverNode;
    private final Node argsNode;
    private final Node valueNode;
    public final CallSite callAdapter;
    public final CallSite elementAdapter;
    public final CallSite elementAsgnAdapter;

    public OpElementAsgnNode(ISourcePosition position, Node receiverNode, String operatorName, Node argsNode, Node valueNode) {
        super(position, NodeType.OPELEMENTASGNNODE);
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        this.valueNode = valueNode;
        this.callAdapter = MethodIndex.getCallSite(operatorName);
        this.elementAdapter = MethodIndex.getFunctionalCallSite("[]");
        this.elementAsgnAdapter = MethodIndex.getFunctionalCallSite("[]=");
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitOpElementAsgnNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public String getOperatorName() {
        return this.callAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
        IRubyObject[] args = ASTInterpreter.setupArgs(runtime, context, this.argsNode, self, aBlock);
        IRubyObject value = this.elementAdapter.call(context, receiver, args);
        if (this.getOperatorName() == "||") {
            if (value.isTrue()) {
                return value;
            }
            value = this.valueNode.interpret(runtime, context, self, aBlock);
        } else if (this.getOperatorName() == "&&") {
            if (!value.isTrue()) {
                return value;
            }
            value = this.valueNode.interpret(runtime, context, self, aBlock);
        } else {
            value = this.callAdapter.call(context, value, this.valueNode.interpret(runtime, context, self, aBlock));
        }
        IRubyObject[] expandedArgs = new IRubyObject[args.length + 1];
        System.arraycopy(args, 0, expandedArgs, 0, args.length);
        expandedArgs[expandedArgs.length - 1] = value;
        this.elementAsgnAdapter.call(context, receiver, expandedArgs);
        return value;
    }
}

