/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.util.HashMap;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArgsFile;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyHash;
import org.jruby.nb.RubyIO;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyRegexp;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.environment.OSEnvironment;
import org.jruby.nb.environment.OSEnvironmentReaderExcepton;
import org.jruby.nb.internal.runtime.ValueAccessor;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.Constants;
import org.jruby.nb.runtime.GlobalVariable;
import org.jruby.nb.runtime.ReadonlyGlobalVariable;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.KCode;
import org.jruby.nb.util.io.STDIO;

public class RubyGlobal {
    public static void createGlobals(ThreadContext context, Ruby runtime) {
        runtime.defineGlobalConstant("TOPLEVEL_BINDING", runtime.newBinding());
        runtime.defineGlobalConstant("TRUE", runtime.getTrue());
        runtime.defineGlobalConstant("FALSE", runtime.getFalse());
        runtime.defineGlobalConstant("NIL", runtime.getNil());
        RubyArray argvArray = runtime.newArray();
        String[] argv = runtime.getInstanceConfig().getArgv();
        for (int i = 0; i < argv.length; ++i) {
            argvArray.append(RubyString.newString(runtime, argv[i].getBytes()));
        }
        runtime.defineGlobalConstant("ARGV", argvArray);
        runtime.getGlobalVariables().defineReadonly("$*", new ValueAccessor(argvArray));
        ValueAccessor d = new ValueAccessor(runtime.newString(runtime.getInstanceConfig().displayedFileName()));
        runtime.getGlobalVariables().define("$PROGRAM_NAME", d);
        runtime.getGlobalVariables().define("$0", d);
        IRubyObject version = runtime.newString(Constants.RUBY_VERSION).freeze(context);
        IRubyObject release = runtime.newString(Constants.COMPILE_DATE).freeze(context);
        IRubyObject platform = runtime.newString("java").freeze(context);
        IRubyObject engine = runtime.newString("jruby").freeze(context);
        runtime.defineGlobalConstant("RUBY_VERSION", version);
        runtime.defineGlobalConstant("RUBY_PATCHLEVEL", runtime.newString(Constants.RUBY_PATCHLEVEL).freeze(context));
        runtime.defineGlobalConstant("RUBY_RELEASE_DATE", release);
        runtime.defineGlobalConstant("RUBY_PLATFORM", platform);
        runtime.defineGlobalConstant("RUBY_ENGINE", engine);
        runtime.defineGlobalConstant("VERSION", version);
        runtime.defineGlobalConstant("RELEASE_DATE", release);
        runtime.defineGlobalConstant("PLATFORM", platform);
        IRubyObject jrubyVersion = runtime.newString(Constants.VERSION).freeze(context);
        runtime.defineGlobalConstant("JRUBY_VERSION", jrubyVersion);
        KCodeGlobalVariable kcodeGV = new KCodeGlobalVariable(runtime, "$KCODE", runtime.newString("NONE"));
        runtime.defineVariable(kcodeGV);
        runtime.defineVariable(new GlobalVariable.Copy(runtime, "$-K", kcodeGV));
        IRubyObject defaultRS = runtime.newString(runtime.getInstanceConfig().getRecordSeparator()).freeze(context);
        StringGlobalVariable rs = new StringGlobalVariable(runtime, "$/", defaultRS);
        runtime.defineVariable(rs);
        runtime.setRecordSeparatorVar(rs);
        runtime.getGlobalVariables().setDefaultSeparator(defaultRS);
        runtime.defineVariable(new StringGlobalVariable(runtime, "$\\", runtime.getNil()));
        runtime.defineVariable(new StringGlobalVariable(runtime, "$,", runtime.getNil()));
        runtime.defineVariable(new LineNumberGlobalVariable(runtime, "$.", RubyFixnum.one(runtime)));
        runtime.defineVariable(new LastlineGlobalVariable(runtime, "$_"));
        runtime.defineVariable(new LastExitStatusVariable(runtime, "$?"));
        runtime.defineVariable(new ErrorInfoGlobalVariable(runtime, "$!", runtime.getNil()));
        runtime.defineVariable(new NonEffectiveGlobalVariable(runtime, "$=", runtime.getFalse()));
        if (runtime.getInstanceConfig().getInputFieldSeparator() == null) {
            runtime.defineVariable(new GlobalVariable(runtime, "$;", runtime.getNil()));
        } else {
            runtime.defineVariable(new GlobalVariable(runtime, "$;", RubyRegexp.newRegexp(runtime, runtime.getInstanceConfig().getInputFieldSeparator(), 0)));
        }
        Boolean verbose = runtime.getInstanceConfig().getVerbose();
        IRubyObject verboseValue = null;
        verboseValue = verbose == null ? runtime.getNil() : (verbose == Boolean.TRUE ? runtime.getTrue() : runtime.getFalse());
        runtime.defineVariable(new VerboseGlobalVariable(runtime, "$VERBOSE", verboseValue));
        RubyBoolean debug = runtime.newBoolean(runtime.getInstanceConfig().isDebug());
        runtime.defineVariable(new DebugGlobalVariable(runtime, "$DEBUG", debug));
        runtime.defineVariable(new DebugGlobalVariable(runtime, "$-d", debug));
        runtime.defineVariable(new SafeGlobalVariable(runtime, "$SAFE"));
        runtime.defineVariable(new BacktraceGlobalVariable(runtime, "$@"));
        RubyIO stdin = new RubyIO(runtime, STDIO.IN);
        RubyIO stdout = new RubyIO(runtime, STDIO.OUT);
        RubyIO stderr = new RubyIO(runtime, STDIO.ERR);
        runtime.defineVariable(new InputGlobalVariable(runtime, "$stdin", stdin));
        runtime.defineVariable(new OutputGlobalVariable(runtime, "$stdout", stdout));
        runtime.getGlobalVariables().alias("$>", "$stdout");
        runtime.getGlobalVariables().alias("$defout", "$stdout");
        runtime.defineVariable(new OutputGlobalVariable(runtime, "$stderr", stderr));
        runtime.getGlobalVariables().alias("$deferr", "$stderr");
        runtime.defineGlobalConstant("STDIN", stdin);
        runtime.defineGlobalConstant("STDOUT", stdout);
        runtime.defineGlobalConstant("STDERR", stderr);
        runtime.defineVariable(new LoadedFeatures(runtime, "$\""));
        runtime.defineVariable(new LoadedFeatures(runtime, "$LOADED_FEATURES"));
        runtime.defineVariable(new LoadPath(runtime, "$:"));
        runtime.defineVariable(new LoadPath(runtime, "$-I"));
        runtime.defineVariable(new LoadPath(runtime, "$LOAD_PATH"));
        runtime.defineVariable(new MatchMatchGlobalVariable(runtime, "$&"));
        runtime.defineVariable(new PreMatchGlobalVariable(runtime, "$`"));
        runtime.defineVariable(new PostMatchGlobalVariable(runtime, "$'"));
        runtime.defineVariable(new LastMatchGlobalVariable(runtime, "$+"));
        runtime.defineVariable(new BackRefGlobalVariable(runtime, "$~"));
        runtime.getGlobalVariables().defineReadonly("$$", new ValueAccessor(runtime.newFixnum(runtime.getPosix().getpid())));
        RubyGlobal.defineGlobalEnvConstants(runtime);
        if (runtime.getGlobalVariables().get("$*").isNil()) {
            runtime.getGlobalVariables().defineReadonly("$*", new ValueAccessor(runtime.newArray()));
        }
        runtime.getGlobalVariables().defineReadonly("$-p", new ValueAccessor(runtime.getInstanceConfig().isAssumePrinting() ? runtime.getTrue() : runtime.getNil()));
        runtime.getGlobalVariables().defineReadonly("$-n", new ValueAccessor(runtime.getInstanceConfig().isAssumeLoop() ? runtime.getTrue() : runtime.getNil()));
        runtime.getGlobalVariables().defineReadonly("$-a", new ValueAccessor(runtime.getInstanceConfig().isSplit() ? runtime.getTrue() : runtime.getNil()));
        runtime.getGlobalVariables().defineReadonly("$-l", new ValueAccessor(runtime.getInstanceConfig().isProcessLineEnds() ? runtime.getTrue() : runtime.getNil()));
        RubyArgsFile.initArgsFile(runtime);
    }

    private static void defineGlobalEnvConstants(Ruby runtime) {
        HashMap environmentVariableMap = null;
        OSEnvironment environment = new OSEnvironment();
        try {
            environmentVariableMap = environment.getEnvironmentVariableMap(runtime);
        }
        catch (OSEnvironmentReaderExcepton e) {
            runtime.getWarnings().warn(IRubyWarnings.ID.MISCELLANEOUS, e.getMessage(), new Object[0]);
        }
        if (environmentVariableMap == null) {
            environmentVariableMap = new HashMap();
        }
        StringOnlyRubyHash h1 = new StringOnlyRubyHash(runtime, environmentVariableMap, runtime.getNil());
        h1.getSingletonClass().defineAnnotatedMethods(StringOnlyRubyHash.class);
        runtime.defineGlobalConstant("ENV", h1);
        Map systemProps = environment.getSystemPropertiesMap(runtime);
        runtime.defineGlobalConstant("ENV_JAVA", new StringOnlyRubyHash(runtime, systemProps, runtime.getNil()));
    }

    private static class LoadedFeatures
    extends ReadonlyGlobalVariable {
        public LoadedFeatures(Ruby runtime, String name) {
            super(runtime, name, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadedFeatures();
        }
    }

    private static class LoadPath
    extends ReadonlyGlobalVariable {
        public LoadPath(Ruby runtime, String name) {
            super(runtime, name, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadPath();
        }
    }

    private static class OutputGlobalVariable
    extends GlobalVariable {
        public OutputGlobalVariable(Ruby runtime, String name, IRubyObject value) {
            super(runtime, name, value);
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            if (value == this.get()) {
                return value;
            }
            if (value instanceof RubyIO) {
                RubyIO io = (RubyIO)value;
                io.getHandler().setSync(true);
            }
            if (!value.respondsTo("write")) {
                throw this.runtime.newTypeError(this.name() + " must have write method, " + value.getType().getName() + " given");
            }
            return super.set(value);
        }
    }

    private static class InputGlobalVariable
    extends GlobalVariable {
        public InputGlobalVariable(Ruby runtime, String name, IRubyObject value) {
            super(runtime, name, value);
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            if (value == this.get()) {
                return value;
            }
            return super.set(value);
        }
    }

    private static class LastlineGlobalVariable
    extends GlobalVariable {
        public LastlineGlobalVariable(Ruby runtime, String name) {
            super(runtime, name, null);
        }

        @Override
        public IRubyObject get() {
            return RuntimeHelpers.getLastLine(this.runtime, this.runtime.getCurrentContext());
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            RuntimeHelpers.setLastLine(this.runtime, this.runtime.getCurrentContext(), value);
            return value;
        }
    }

    private static class BacktraceGlobalVariable
    extends GlobalVariable {
        public BacktraceGlobalVariable(Ruby runtime, String name) {
            super(runtime, name, null);
        }

        @Override
        public IRubyObject get() {
            IRubyObject backtrace;
            IRubyObject errorInfo = this.runtime.getGlobalVariables().get("$!");
            IRubyObject iRubyObject = backtrace = errorInfo.isNil() ? this.runtime.getNil() : errorInfo.callMethod(errorInfo.getRuntime().getCurrentContext(), "backtrace");
            if (!(backtrace instanceof RubyArray)) {
                backtrace = this.runtime.getNil();
            }
            return backtrace;
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            if (this.runtime.getGlobalVariables().get("$!").isNil()) {
                throw this.runtime.newArgumentError("$! not set.");
            }
            this.runtime.getGlobalVariables().get("$!").callMethod(value.getRuntime().getCurrentContext(), "set_backtrace", value);
            return value;
        }
    }

    private static class DebugGlobalVariable
    extends GlobalVariable {
        public DebugGlobalVariable(Ruby runtime, String name, IRubyObject initialValue) {
            super(runtime, name, initialValue);
            this.set(initialValue);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getDebug();
        }

        @Override
        public IRubyObject set(IRubyObject newValue) {
            if (newValue.isNil()) {
                this.runtime.setDebug(newValue);
            } else {
                this.runtime.setDebug(this.runtime.newBoolean(newValue.isTrue()));
            }
            return newValue;
        }
    }

    private static class VerboseGlobalVariable
    extends GlobalVariable {
        public VerboseGlobalVariable(Ruby runtime, String name, IRubyObject initialValue) {
            super(runtime, name, initialValue);
            this.set(initialValue);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getVerbose();
        }

        @Override
        public IRubyObject set(IRubyObject newValue) {
            if (newValue.isNil()) {
                this.runtime.setVerbose(newValue);
            } else {
                this.runtime.setVerbose(this.runtime.newBoolean(newValue.isTrue()));
            }
            return newValue;
        }
    }

    private static class SafeGlobalVariable
    extends GlobalVariable {
        public SafeGlobalVariable(Ruby runtime, String name) {
            super(runtime, name, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.newFixnum(this.runtime.getSafeLevel());
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.SAFE_NOT_SUPPORTED, "SAFE levels are not supported in JRuby", new Object[0]);
            return RubyFixnum.newFixnum(this.runtime, this.runtime.getSafeLevel());
        }
    }

    public static class KCodeGlobalVariable
    extends GlobalVariable {
        public KCodeGlobalVariable(Ruby runtime, String name, IRubyObject value) {
            super(runtime, name, value);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getKCode().kcode(this.runtime);
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            this.runtime.setKCode(KCode.create(this.runtime, value.convertToString().toString()));
            return value;
        }
    }

    public static class StringGlobalVariable
    extends GlobalVariable {
        public StringGlobalVariable(Ruby runtime, String name, IRubyObject value) {
            super(runtime, name, value);
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            if (!value.isNil() && !(value instanceof RubyString)) {
                throw this.runtime.newTypeError("value of " + this.name() + " must be a String");
            }
            return super.set(value);
        }
    }

    private static class ErrorInfoGlobalVariable
    extends GlobalVariable {
        public ErrorInfoGlobalVariable(Ruby runtime, String name, IRubyObject value) {
            super(runtime, name, null);
            this.set(value);
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            if (!(value.isNil() || this.runtime.getException().isInstance(value) || JavaUtil.isJavaObject(value) && JavaUtil.unwrapJavaObject(value) instanceof Exception)) {
                throw this.runtime.newTypeError("assigning non-exception to $!");
            }
            return this.runtime.getCurrentContext().setErrorInfo(value);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getCurrentContext().getErrorInfo();
        }
    }

    private static class LineNumberGlobalVariable
    extends GlobalVariable {
        public LineNumberGlobalVariable(Ruby runtime, String name, RubyFixnum value) {
            super(runtime, name, value);
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            RubyArgsFile.setCurrentLineNumber(this.runtime.getGlobalVariables().get("$<"), RubyNumeric.fix2int(value));
            return super.set(value);
        }
    }

    private static class BackRefGlobalVariable
    extends GlobalVariable {
        public BackRefGlobalVariable(Ruby runtime, String name) {
            super(runtime, name, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            return RuntimeHelpers.getBackref(this.runtime, this.runtime.getCurrentContext());
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            RuntimeHelpers.setBackref(this.runtime, this.runtime.getCurrentContext(), value);
            return value;
        }
    }

    private static class LastMatchGlobalVariable
    extends GlobalVariable {
        public LastMatchGlobalVariable(Ruby runtime, String name) {
            super(runtime, name, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.match_last(this.runtime.getCurrentContext().getCurrentFrame().getBackRef());
        }
    }

    private static class PostMatchGlobalVariable
    extends GlobalVariable {
        public PostMatchGlobalVariable(Ruby runtime, String name) {
            super(runtime, name, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.match_post(this.runtime.getCurrentContext().getCurrentFrame().getBackRef());
        }
    }

    private static class PreMatchGlobalVariable
    extends GlobalVariable {
        public PreMatchGlobalVariable(Ruby runtime, String name) {
            super(runtime, name, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.match_pre(this.runtime.getCurrentContext().getCurrentFrame().getBackRef());
        }
    }

    private static class MatchMatchGlobalVariable
    extends GlobalVariable {
        public MatchMatchGlobalVariable(Ruby runtime, String name) {
            super(runtime, name, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.last_match(this.runtime.getCurrentContext().getCurrentFrame().getBackRef());
        }
    }

    private static class LastExitStatusVariable
    extends GlobalVariable {
        public LastExitStatusVariable(Ruby runtime, String name) {
            super(runtime, name, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            IRubyObject lastExitStatus = this.runtime.getCurrentContext().getLastExitStatus();
            return lastExitStatus == null ? this.runtime.getNil() : lastExitStatus;
        }

        @Override
        public IRubyObject set(IRubyObject lastExitStatus) {
            this.runtime.getCurrentContext().setLastExitStatus(lastExitStatus);
            return lastExitStatus;
        }
    }

    private static class NonEffectiveGlobalVariable
    extends GlobalVariable {
        public NonEffectiveGlobalVariable(Ruby runtime, String name, IRubyObject value) {
            super(runtime, name, value);
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective; ignored", this.name);
            return value;
        }

        @Override
        public IRubyObject get() {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective", this.name);
            return this.runtime.getFalse();
        }
    }

    public static class StringOnlyRubyHash
    extends RubyHash {
        public StringOnlyRubyHash(Ruby runtime, Map valueMap, IRubyObject defaultValue) {
            super(runtime, valueMap, defaultValue);
        }

        @Override
        public RubyHash to_hash() {
            Ruby runtime = this.getRuntime();
            RubyHash hash = RubyHash.newHash(runtime);
            hash.replace(runtime.getCurrentContext(), this);
            return hash;
        }

        @Override
        public IRubyObject op_aref(ThreadContext context, IRubyObject key) {
            return super.op_aref(context, key.convertToString());
        }

        @Override
        public IRubyObject op_aset(ThreadContext context, IRubyObject key, IRubyObject value) {
            if (!key.respondsTo("to_str")) {
                throw this.getRuntime().newTypeError("can't convert " + key.getMetaClass() + " into String");
            }
            if (!value.respondsTo("to_str") && !value.isNil()) {
                throw this.getRuntime().newTypeError("can't convert " + value.getMetaClass() + " into String");
            }
            if (value.isNil()) {
                return super.delete(context, key, Block.NULL_BLOCK);
            }
            return super.op_aset(context, RuntimeHelpers.invoke(context, key, "to_str"), value.isNil() ? this.getRuntime().getNil() : RuntimeHelpers.invoke(context, value, "to_str"));
        }

        @Override
        @JRubyMethod
        public IRubyObject to_s() {
            return this.getRuntime().newString("ENV");
        }
    }
}

