/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.jruby.nb.JRubyService;
import org.jruby.nb.Main;

public class JRubyServer
extends JRubyService {
    private JRubyService.Configuration conf;
    private boolean stillStarting = true;

    private JRubyServer(String[] args) throws Exception {
        this.conf = new JRubyService.Configuration(args[0]);
        if (this.conf.isDebug()) {
            System.err.println("Starting server with port " + this.conf.getPort() + " and key " + this.conf.getKey());
        }
        ServerSocket server = new ServerSocket();
        server.bind(new InetSocketAddress(InetAddress.getLocalHost(), this.conf.getPort()));
        while (true) {
            Thread t1 = new Thread(new Handler(server.accept()));
            t1.setDaemon(true);
            t1.start();
        }
    }

    protected static String[] intoCommandArguments(String str) {
        ArrayList<String> args = new ArrayList<String>();
        boolean inSingle = false;
        int contentStart = -1;
        int j = str.length();
        for (int i = 0; i < j; ++i) {
            if (str.charAt(i) == ' ' && !inSingle && contentStart != -1) {
                args.add(str.substring(contentStart, i));
                contentStart = -1;
                continue;
            }
            if (str.charAt(i) == ' ') continue;
            if (str.charAt(i) == '\'' && !inSingle) {
                inSingle = true;
                contentStart = i + 1;
                continue;
            }
            if (str.charAt(i) == '\'') {
                inSingle = false;
                args.add(str.substring(contentStart, i));
                contentStart = -1;
                continue;
            }
            if (contentStart != -1) continue;
            contentStart = i;
        }
        if (contentStart != -1) {
            args.add(str.substring(contentStart));
        }
        return args.toArray(new String[0]);
    }

    public static void main(String[] args) throws Exception {
        new JRubyServer(args);
    }

    private class Handler
    implements Runnable {
        private Socket socket;

        public Handler(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                String[] cmds;
                BufferedReader rr = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                String command = rr.readLine();
                rr.close();
                this.socket.close();
                this.socket = null;
                if (JRubyServer.this.conf.isDebug()) {
                    System.err.println("Got command: " + command);
                }
                if ((cmds = command.split(" ", 3))[1].equals(JRubyServer.this.conf.getKey())) {
                    if (cmds[0].equals("TERM")) {
                        if (JRubyServer.this.conf.isDebug()) {
                            System.err.println("Terminating hard");
                        }
                        System.exit(0);
                    } else if (cmds[0].equals("NO_MORE")) {
                        if (JRubyServer.this.conf.isDebug()) {
                            System.err.println("Accepting no more START");
                        }
                        JRubyServer.this.stillStarting = false;
                    } else if (cmds[0].equals("START")) {
                        if (JRubyServer.this.stillStarting) {
                            if (JRubyServer.this.conf.isDebug()) {
                                System.err.println("Doing START on command " + cmds[2]);
                            }
                            new Main().run(JRubyServer.intoCommandArguments(cmds[2].trim()));
                        } else if (JRubyServer.this.conf.isDebug()) {
                            System.err.println("Not doing START anymore, invalid command");
                        }
                    } else if (JRubyServer.this.conf.isDebug()) {
                        System.err.println("Unrecognized command");
                    }
                } else if (JRubyServer.this.conf.isDebug()) {
                    System.err.println("Invalid key");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

