/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.options.CodeStyle;
import org.openide.util.Exceptions;

public class Formatter
implements org.netbeans.modules.csl.api.Formatter {
    private boolean isGspDocument;
    private CodeStyle codeStyle;
    private int rightMarginOverride = -1;

    public Formatter() {
        this.codeStyle = null;
    }

    public Formatter(CodeStyle codeStyle, int rightMarginOverride) {
        assert (codeStyle != null);
        this.codeStyle = codeStyle;
        this.rightMarginOverride = rightMarginOverride;
    }

    public boolean needsParserResult() {
        return false;
    }

    public void reindent(Context context) {
        if (this.codeStyle != null) {
            this.reindent(context, null, true);
        } else {
            Formatter f = new Formatter(CodeStyle.get(context.document()), -1);
            f.reindent(context, null, true);
        }
    }

    public void reformat(Context context, ParserResult compilationInfo) {
        if (this.codeStyle != null) {
            this.reindent(context, compilationInfo, false);
        } else {
            Formatter f = new Formatter(CodeStyle.get(context.document()), -1);
            f.reindent(context, compilationInfo, false);
        }
    }

    public int indentSize() {
        if (this.codeStyle != null) {
            return this.codeStyle.getIndentSize();
        }
        return CodeStyle.get((Document)null).getIndentSize();
    }

    public int hangingIndentSize() {
        if (this.codeStyle != null) {
            return this.codeStyle.getContinuationIndentSize();
        }
        return CodeStyle.get((Document)null).getContinuationIndentSize();
    }

    private int getFormatStableStart(BaseDocument doc, int offset) {
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(doc, offset);
        if (ts == null) {
            return 0;
        }
        ts.move(offset);
        if (!ts.movePrevious()) {
            return 0;
        }
        do {
            Token token;
            TokenId id;
            if ((id = (token = ts.token()).id()) != GroovyTokenId.LITERAL_class) continue;
            return ts.offset();
        } while (ts.movePrevious());
        return ts.offset();
    }

    private int getTokenBalanceDelta(TokenId id, Token<? extends GroovyTokenId> token, BaseDocument doc, TokenSequence<? extends GroovyTokenId> ts, boolean includeKeywords) {
        if (id == GroovyTokenId.IDENTIFIER) {
            if (token.length() == 1) {
                char c = token.text().charAt(0);
                if (c == '[') {
                    return 1;
                }
                if (c == ']') {
                    return -1;
                }
            }
        } else {
            if (id == GroovyTokenId.LPAREN || id == GroovyTokenId.LBRACKET || id == GroovyTokenId.LBRACE) {
                return 1;
            }
            if (id == GroovyTokenId.RPAREN || id == GroovyTokenId.RBRACKET || id == GroovyTokenId.RBRACE) {
                return -1;
            }
            if (includeKeywords) {
                if (LexUtilities.isBeginToken(id, doc, ts)) {
                    return 1;
                }
                if (id == GroovyTokenId.RBRACE) {
                    return -1;
                }
            }
        }
        return 0;
    }

    private int getTokenBalance(BaseDocument doc, int begin, int end, boolean includeKeywords) {
        int balance = 0;
        if (this.isGspDocument) {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence t = th.tokenSequence();
            if (t == null) {
                return 0;
            }
            t.move(begin);
            if (!t.moveNext()) {
                return 0;
            }
            do {
                Token groovyToken;
                Token token;
                TokenId id;
                if (!(id = (token = t.token()).id()).primaryCategory().equals("groovy")) continue;
                TokenSequence ts = t.embedded(GroovyTokenId.language());
                ts.move(begin);
                ts.moveNext();
                while ((groovyToken = ts.token()) != null) {
                    TokenId groovyId = groovyToken.id();
                    balance += this.getTokenBalanceDelta(groovyId, (Token<? extends GroovyTokenId>)groovyToken, doc, (TokenSequence<? extends GroovyTokenId>)ts, includeKeywords);
                    if (ts.moveNext() && ts.offset() < end) continue;
                }
            } while (t.moveNext() && t.offset() < end);
        } else {
            TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(doc, begin);
            if (ts == null) {
                return 0;
            }
            ts.move(begin);
            if (!ts.moveNext()) {
                return 0;
            }
            do {
                Token token = ts.token();
                TokenId id = token.id();
                balance += this.getTokenBalanceDelta(id, (Token<? extends GroovyTokenId>)token, doc, ts, includeKeywords);
            } while (ts.moveNext() && ts.offset() < end);
        }
        return balance;
    }

    private boolean isJavaDocComment(BaseDocument doc, int offset, int endOfLine) throws BadLocationException {
        String text;
        TokenId id;
        Token<? extends GroovyTokenId> token;
        int pos = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        return pos != -1 && (token = LexUtilities.getToken(doc, pos)) != null && (id = token.id()) == GroovyTokenId.BLOCK_COMMENT && (text = doc.getText(offset, endOfLine - offset)).trim().startsWith("*");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInLiteral(BaseDocument doc, int offset) throws BadLocationException {
        TokenId id;
        int pos = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        if (pos != -1) {
            Token<? extends GroovyTokenId> token = LexUtilities.getToken(doc, pos);
            if (token == null) return true;
            TokenId id2 = token.id();
            if (id2 == GroovyTokenId.STRING_LITERAL || id2 == GroovyTokenId.DOCUMENTATION || id2 == GroovyTokenId.QUOTED_STRING_LITERAL || id2 == GroovyTokenId.REGEXP_LITERAL) {
                return true;
            }
            if (id2 != GroovyTokenId.STRING_END && id2 != GroovyTokenId.QUOTED_STRING_END) return false;
            TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(doc, pos);
            ts.move(pos);
            OffsetRange range = LexUtilities.findHeredocBegin(ts, token);
            if (range == OffsetRange.NONE) return false;
            String text = doc.getText(range.getStart(), range.getLength());
            return !text.startsWith("<<-");
        }
        Token<? extends GroovyTokenId> token = LexUtilities.getToken(doc, offset);
        if (token == null || (id = token.id()) != GroovyTokenId.STRING_LITERAL && id != GroovyTokenId.DOCUMENTATION && id != GroovyTokenId.QUOTED_STRING_LITERAL && id != GroovyTokenId.REGEXP_LITERAL) return false;
        return true;
    }

    private Token<? extends GroovyTokenId> getFirstToken(BaseDocument doc, int offset) throws BadLocationException {
        int lineBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        if (lineBegin != -1) {
            if (this.isGspDocument) {
                TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(doc, lineBegin);
                if (ts != null) {
                    ts.moveNext();
                    Token token = ts.token();
                    while (token != null && token.id() == GroovyTokenId.WHITESPACE) {
                        if (!ts.moveNext()) {
                            return null;
                        }
                        token = ts.token();
                    }
                    return token;
                }
            } else {
                return LexUtilities.getToken(doc, lineBegin);
            }
        }
        return null;
    }

    private boolean isEndIndent(BaseDocument doc, int offset) throws BadLocationException {
        int lineBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        if (lineBegin != -1) {
            Token<? extends GroovyTokenId> token = this.getFirstToken(doc, offset);
            if (token == null) {
                return false;
            }
            TokenId id = token.id();
            return LexUtilities.isIndentToken(id) && !LexUtilities.isBeginToken(id, doc, offset) || id == GroovyTokenId.RBRACE || id == GroovyTokenId.RBRACKET || id == GroovyTokenId.RPAREN;
        }
        return false;
    }

    private boolean isLineContinued(BaseDocument doc, int offset, int bracketBalance) throws BadLocationException {
        if ((offset = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)offset)) == -1) {
            return false;
        }
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(doc, offset);
        if (ts == null) {
            return false;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        Token<? extends GroovyTokenId> token = ts.token();
        if (token != null) {
            String text;
            boolean isContinuationOperator;
            TokenId id = token.id();
            boolean bl = isContinuationOperator = id == GroovyTokenId.NONUNARY_OP || id == GroovyTokenId.DOT;
            if (ts.offset() == offset && token.length() > 1 && ((Object)token.text()).toString().startsWith("\\")) {
                isContinuationOperator = true;
            }
            if (token.length() == 1 && id == GroovyTokenId.IDENTIFIER && ((Object)token.text()).toString().equals(",") && bracketBalance == 0) {
                isContinuationOperator = true;
            }
            if (isContinuationOperator) {
                token = LexUtilities.getToken(doc, Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset));
                return token == null || (id = token.id()) != GroovyTokenId.LBRACE && (id != GroovyTokenId.ANY_KEYWORD || !((Object)token.text()).toString().equals("alias"));
            }
            if (id == GroovyTokenId.ANY_KEYWORD && ("or".equals(text = ((Object)token.text()).toString()) || "and".equals(text))) {
                return true;
            }
        }
        return false;
    }

    private void reindent(final Context context, ParserResult info, final boolean indentOnly) {
        assert (this.codeStyle != null);
        Document document = context.document();
        final int endOffset = Math.min(context.endOffset(), document.getLength());
        this.isGspDocument = false;
        try {
            int startOffset;
            final BaseDocument doc = (BaseDocument)document;
            final int lineStart = startOffset = Utilities.getRowStart((BaseDocument)doc, (int)context.startOffset());
            int initialOffset = 0;
            int initialIndent = 0;
            if (startOffset > 0) {
                int prevOffset = Utilities.getRowStart((BaseDocument)doc, (int)(startOffset - 1));
                initialOffset = this.getFormatStableStart(doc, prevOffset);
                initialIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)initialOffset);
            }
            final ArrayList<Integer> offsets = new ArrayList<Integer>();
            final ArrayList<Integer> indents = new ArrayList<Integer>();
            boolean indentEmptyLines = startOffset != 0 || endOffset != doc.getLength();
            boolean includeEnd = endOffset == doc.getLength() || indentOnly;
            this.computeIndents(doc, initialIndent, initialOffset, endOffset, info, offsets, indents, indentEmptyLines, includeEnd, indentOnly);
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        assert (indents.size() == offsets.size());
                        for (int i = indents.size() - 1; i >= 0; --i) {
                            int currentIndent;
                            int indent = (Integer)indents.get(i);
                            int lineBegin = (Integer)offsets.get(i);
                            if (lineBegin < lineStart) break;
                            if (lineBegin == lineStart && i > 0) {
                                int prevOffset = (Integer)offsets.get(i - 1);
                                int prevIndent = (Integer)indents.get(i - 1);
                                int actualPrevIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)prevOffset);
                                if (actualPrevIndent != prevIndent && !Utilities.isRowEmpty((BaseDocument)doc, (int)prevOffset) && !Utilities.isRowWhite((BaseDocument)doc, (int)prevOffset) && (indent = actualPrevIndent + (indent - prevIndent)) < 0) {
                                    indent = 0;
                                }
                            }
                            if ((currentIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)lineBegin)) == indent) continue;
                            context.modifyIndent(lineBegin, indent);
                        }
                        if (!indentOnly && Formatter.this.codeStyle.reformatComments()) {
                            Formatter.this.reformatComments(doc, startOffset, endOffset);
                        }
                    }
                    catch (BadLocationException ble) {
                        Exceptions.printStackTrace((Throwable)ble);
                    }
                }
            });
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
    }

    public void computeIndents(BaseDocument doc, int initialIndent, int startOffset, int endOffset, ParserResult info, List<Integer> offsets, List<Integer> indents, boolean indentEmptyLines, boolean includeEnd, boolean indentOnly) {
        try {
            int offset = Utilities.getRowStart((BaseDocument)doc, (int)startOffset);
            int end = endOffset;
            int indentSize = this.codeStyle.getIndentSize();
            int hangingIndentSize = this.codeStyle.getContinuationIndentSize();
            int balance = 0;
            int bracketBalance = 0;
            boolean continued = false;
            boolean indentHtml = false;
            if (this.isGspDocument) {
                indentHtml = this.codeStyle.indentHtml();
            }
            while (!includeEnd && offset < end || includeEnd && offset <= end) {
                int lineBegin;
                int endOfLine;
                int indent;
                int hangingIndent;
                int n = hangingIndent = continued ? hangingIndentSize : 0;
                if (this.isGspDocument && !indentOnly) {
                    initialIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                }
                if (this.isInLiteral(doc, offset)) {
                    indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                    if (this.isGspDocument && indentHtml && balance > 0) {
                        indent += balance * indentSize;
                    }
                } else {
                    indent = this.isEndIndent(doc, offset) ? (balance - 1) * indentSize + hangingIndent + initialIndent : balance * indentSize + hangingIndent + initialIndent;
                }
                if (this.isJavaDocComment(doc, offset, endOfLine = Utilities.getRowEnd((BaseDocument)doc, (int)offset) + 1)) {
                    ++indent;
                }
                if (indent < 0) {
                    indent = 0;
                }
                if ((lineBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset)) != -1 || indentEmptyLines) {
                    indents.add(indent);
                    offsets.add(offset);
                }
                if (lineBegin != -1) {
                    balance += this.getTokenBalance(doc, lineBegin, endOfLine, true);
                    continued = this.isLineContinued(doc, offset, bracketBalance += this.getTokenBalance(doc, lineBegin, endOfLine, false));
                }
                offset = endOfLine;
            }
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
    }

    void reformatComments(BaseDocument doc, int start, int end) {
        int rightMargin = this.rightMarginOverride != -1 ? this.rightMarginOverride : this.codeStyle.getRightMargin();
    }
}

