/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ParserController;

public class ParserControllerProxy {
    private static final Logger LOGGER = Logger.getLogger(ParserControllerProxy.class.getName());
    private final JspCompilationContext ctxt;
    private final Compiler compiler;
    private final ParserController pc;
    boolean isXml;
    String sourceEnc;
    private static Method getJarFileM;
    private static Method resolveFileNameM;
    private static Method getJspConfigPageEncodingM;
    private static Method determineSyntaxAndEncodingM;
    private static Field isXmlF;
    private static Field sourceEncF;

    public ParserControllerProxy(JspCompilationContext ctxt, Compiler compiler) {
        this.ctxt = ctxt;
        this.compiler = compiler;
        this.pc = new ParserController(ctxt, compiler);
    }

    public static void initMethodsAndFields() {
        try {
            getJarFileM = ParserController.class.getDeclaredMethod("getJarFile", URL.class);
            getJarFileM.setAccessible(true);
            resolveFileNameM = ParserController.class.getDeclaredMethod("resolveFileName", String.class);
            resolveFileNameM.setAccessible(true);
            getJspConfigPageEncodingM = ParserController.class.getDeclaredMethod("getJspConfigPageEncoding", String.class);
            getJspConfigPageEncodingM.setAccessible(true);
            determineSyntaxAndEncodingM = ParserController.class.getDeclaredMethod("determineSyntaxAndEncoding", String.class, JarFile.class, String.class);
            determineSyntaxAndEncodingM.setAccessible(true);
            isXmlF = ParserController.class.getDeclaredField("isXml");
            isXmlF.setAccessible(true);
            sourceEncF = ParserController.class.getDeclaredField("sourceEnc");
            sourceEncF.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (NoSuchFieldException e) {
            LOGGER.log(Level.INFO, null, e);
        }
    }

    public void extractSyntaxAndEncoding(String inFileName) throws FileNotFoundException, JasperException, IOException {
        this.extractSyntaxAndEncoding(inFileName, this.ctxt.getTagFileJarUrl());
    }

    private void extractSyntaxAndEncoding(String inFileName, URL jarFileUrl) throws FileNotFoundException, JasperException, IOException {
        try {
            JarFile jarFile = (JarFile)getJarFileM.invoke((Object)this.pc, jarFileUrl);
            String absFileName = (String)resolveFileNameM.invoke((Object)this.pc, inFileName);
            String jspConfigPageEnc = (String)getJspConfigPageEncodingM.invoke((Object)this.pc, absFileName);
            determineSyntaxAndEncodingM.invoke((Object)this.pc, absFileName, jarFile, jspConfigPageEnc);
            this.isXml = (Boolean)isXmlF.get(this.pc);
            this.sourceEnc = (String)sourceEncF.get(this.pc);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.INFO, null, e);
            throw new JasperException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable r = e.getTargetException();
            if (r instanceof RuntimeException) {
                throw (RuntimeException)r;
            }
            if (r instanceof FileNotFoundException) {
                throw (FileNotFoundException)r;
            }
            if (r instanceof JasperException) {
                throw (JasperException)r;
            }
            if (r instanceof IOException) {
                throw (IOException)r;
            }
            LOGGER.log(Level.INFO, null, e);
            throw new JasperException((Throwable)e);
        }
    }

    static {
        ParserControllerProxy.initMethodsAndFields();
    }
}

